/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.IGangliaMetadataMessage;
import com.bigdata.ganglia.ITimestampMetricValue;
import java.util.concurrent.TimeUnit;

public class TimestampMetricValue
implements ITimestampMetricValue {
    private final IGangliaMetadataMessage decl;
    private Object value;
    private volatile long timestamp = 0L;

    public TimestampMetricValue(IGangliaMetadataMessage decl) {
        if (decl == null) {
            throw new IllegalArgumentException();
        }
        this.decl = decl;
    }

    @Override
    public IGangliaMetadataMessage getMetadata() {
        return this.decl;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void resetTimestamp() {
        this.timestamp = 0L;
    }

    @Override
    public int getAge() {
        if (this.timestamp == 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.timestamp);
    }

    @Override
    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized boolean setValue(Object newValue) {
        boolean changed;
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        boolean isNumeric = this.decl.getMetricType().isNumeric();
        if (isNumeric && !(newValue instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + newValue + " (" + newValue.getClass() + ")");
        }
        Object translatedValue = this.decl.translateValue(newValue);
        if (translatedValue == null) {
            throw new IllegalArgumentException();
        }
        if (isNumeric && !(translatedValue instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + translatedValue + " (" + translatedValue.getClass() + ")");
        }
        Object oldValue = this.value;
        this.value = isNumeric ? translatedValue : translatedValue.toString();
        boolean bl = changed = oldValue == null || this.decl.isChanged(oldValue, newValue);
        return changed || this.getAge() >= this.decl.getTMax() / 2;
    }

    public void update() {
        this.timestamp = System.currentTimeMillis();
    }

    public int priority() {
        if (this.timestamp == 0L) {
            return Integer.MIN_VALUE;
        }
        int age = this.getAge();
        int priority = this.decl.getTMax() - age;
        return priority;
    }

    public String toString() {
        return this.getClass().getName() + "{age=" + this.getAge() + ",value=" + this.getValue() + ",decl=" + this.getMetadata() + "}";
    }
}

