/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.crs.Geographic2DCRS;
import org.cts.crs.ProjectedCRS;
import org.cts.crs.VerticalCRS;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.VerticalDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationFactory;
import org.cts.op.CoordinateOperationNotFoundException;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.CoordinateSwitch;
import org.cts.op.Identity;
import org.cts.op.IterativeTransformation;
import org.cts.op.LoadMemorizeCoordinate;
import org.cts.op.MemorizeCoordinate;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.OppositeCoordinate;
import org.cts.op.UnitConversion;
import org.cts.op.transformation.Altitude2EllipsoidalHeight;
import org.cts.units.Unit;

public class CompoundCRS
extends GeodeticCRS {
    private GeodeticCRS horizontalCRS;
    private VerticalCRS verticalCRS;

    public CompoundCRS(Identifier identifier, GeodeticCRS horizontalCRS, VerticalCRS verticalCRS) throws CRSException {
        super(identifier, horizontalCRS.getDatum(), new CoordinateSystem(new Axis[]{horizontalCRS.getCoordinateSystem().getAxis(0), horizontalCRS.getCoordinateSystem().getAxis(1), verticalCRS.getCoordinateSystem().getAxis(0)}, new Unit[]{horizontalCRS.getCoordinateSystem().getUnit(0), horizontalCRS.getCoordinateSystem().getUnit(1), verticalCRS.getCoordinateSystem().getUnit(0)}));
        if (!(horizontalCRS instanceof ProjectedCRS) && !(horizontalCRS instanceof Geographic2DCRS)) {
            throw new CRSException("The horizontalCRS must be a ProjectedCRS or a Geographic2DCRS. The " + horizontalCRS.getClass() + " cannot be used as horizontalCRS.");
        }
        this.horizontalCRS = horizontalCRS;
        this.verticalCRS = verticalCRS;
    }

    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.COMPOUND;
    }

    public GeodeticCRS getHorizontalCRS() {
        return this.horizontalCRS;
    }

    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public CoordinateOperation toGeographicCoordinateConverter() throws NonInvertibleOperationException, CoordinateOperationNotFoundException {
        List<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        for (int i = 0; i < 3; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.DOWN) continue;
            ops.add(new OppositeCoordinate(i));
        }
        if (this.horizontalCRS instanceof Geographic2DCRS) {
            if (this.getCoordinateSystem().getUnit(0) != Unit.RADIAN || this.getCoordinateSystem().getUnit(2) != Unit.METER) {
                ops.add(UnitConversion.createUnitConverter(this.getCoordinateSystem().getUnit(0), Unit.RADIAN, this.getCoordinateSystem().getUnit(2), Unit.METER));
            }
            if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
                ops.add(CoordinateSwitch.SWITCH_LAT_LON);
            }
        } else {
            if (this.getCoordinateSystem().getUnit(0) != Unit.METER || this.getCoordinateSystem().getUnit(2) != Unit.METER) {
                ops.add(UnitConversion.createUnitConverter(this.getCoordinateSystem().getUnit(0), Unit.METER, this.getCoordinateSystem().getUnit(2), Unit.METER));
            }
            if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.NORTH || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.SOUTH) {
                ops.add(CoordinateSwitch.SWITCH_LAT_LON);
            }
            ops.add(this.horizontalCRS.getProjection().inverse());
        }
        if (this.verticalCRS.getDatum().getType().equals((Object)VerticalDatum.Type.ELLIPSOIDAL) && this.horizontalCRS.getDatum().getEllipsoid().equals(this.verticalCRS.getDatum().getEllipsoid())) {
            ops = CoordinateOperationSequence.cleverAdd(ops, Identity.IDENTITY);
        } else {
            if (this.verticalCRS.getDatum().getType().equals((Object)VerticalDatum.Type.ELLIPSOIDAL)) {
                throw new CoordinateOperationNotFoundException("Incompatible horizontal and vertical datum for this CRS : " + this);
            }
            if (this.verticalCRS.getDatum().getAltiToEllpsHeight() instanceof Altitude2EllipsoidalHeight) {
                Altitude2EllipsoidalHeight z_transfo = (Altitude2EllipsoidalHeight)this.verticalCRS.getDatum().getAltiToEllpsHeight();
                if (this.horizontalCRS.getDatum().equals(z_transfo.getAssociatedDatum())) {
                    ops = CoordinateOperationSequence.cleverAdd(ops, UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE, Unit.METER, Unit.METER));
                    ops.add(z_transfo);
                    ops.add(UnitConversion.createUnitConverter(Unit.DEGREE, Unit.RADIAN, Unit.METER, Unit.METER));
                } else {
                    ops.add(MemorizeCoordinate.memoXYZ);
                    Set<CoordinateOperation> h_datum_tf = this.horizontalCRS.getDatum().getGeographicTransformations(z_transfo.getAssociatedDatum());
                    if (h_datum_tf.isEmpty()) {
                        throw new CoordinateOperationNotFoundException(this.horizontalCRS.getDatum(), z_transfo.getAssociatedDatum());
                    }
                    CoordinateOperation h_op = CoordinateOperationFactory.getMostPrecise(h_datum_tf);
                    ops.add(h_op);
                    ops.add(UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE, Unit.METER, Unit.METER));
                    ops.add(LoadMemorizeCoordinate.loadZ);
                    ops.add(MemorizeCoordinate.memoZ);
                    ops.add(z_transfo);
                    ops.add(UnitConversion.createUnitConverter(Unit.DEGREE, Unit.RADIAN, Unit.METER, Unit.METER));
                    ops.add(h_op.inverse());
                    CoordinateOperationSequence seq = new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), new CoordinateSwitch(4, 5), new CoordinateSwitch(3, 4), LoadMemorizeCoordinate.loadY, LoadMemorizeCoordinate.loadX, MemorizeCoordinate.memoXY, new CoordinateSwitch(3, 4), new CoordinateSwitch(4, 5), h_op, UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE, Unit.METER, Unit.METER), LoadMemorizeCoordinate.loadZ, MemorizeCoordinate.memoZ, z_transfo, UnitConversion.createUnitConverter(Unit.DEGREE, Unit.RADIAN, Unit.METER, Unit.METER), h_op.inverse());
                    try {
                        ops.add(new IterativeTransformation(seq, new int[]{3, 4}, new int[]{0, 1}, new double[]{1.0E-11, 1.0E-11}, 6));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ops.add(LoadMemorizeCoordinate.loadY);
                    ops.add(LoadMemorizeCoordinate.loadY);
                    ops.add(LoadMemorizeCoordinate.loadX);
                }
            } else {
                throw new CoordinateOperationNotFoundException("Unknown vertical datum type for this CRS : " + this);
            }
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public CoordinateOperation fromGeographicCoordinateConverter() throws NonInvertibleOperationException, CoordinateOperationNotFoundException {
        List<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        if (this.verticalCRS.getDatum().getType().equals((Object)VerticalDatum.Type.ELLIPSOIDAL) && this.horizontalCRS.getDatum().getEllipsoid().equals(this.verticalCRS.getDatum().getEllipsoid())) {
            ops.add(Identity.IDENTITY);
        } else {
            if (this.verticalCRS.getDatum().getType().equals((Object)VerticalDatum.Type.ELLIPSOIDAL)) {
                throw new CoordinateOperationNotFoundException("Incompatible horizontal and vertical datum for this CRS : " + this);
            }
            if (this.verticalCRS.getDatum().getAltiToEllpsHeight() instanceof Altitude2EllipsoidalHeight) {
                Altitude2EllipsoidalHeight z_transfo = (Altitude2EllipsoidalHeight)this.verticalCRS.getDatum().getAltiToEllpsHeight();
                ops.add(MemorizeCoordinate.memoXY);
                if (this.horizontalCRS.getDatum().equals(z_transfo.getAssociatedDatum())) {
                    ops.add(UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE, Unit.METER, Unit.METER));
                    ops.add(z_transfo.inverse());
                    ops.add(LoadMemorizeCoordinate.loadY);
                    ops.add(LoadMemorizeCoordinate.loadX);
                } else {
                    Set<CoordinateOperation> h_datum_tf = this.horizontalCRS.getDatum().getGeographicTransformations(z_transfo.getAssociatedDatum());
                    if (h_datum_tf.isEmpty()) {
                        throw new CoordinateOperationNotFoundException(this.horizontalCRS.getDatum(), z_transfo.getAssociatedDatum());
                    }
                    CoordinateOperation h_op = CoordinateOperationFactory.getMostPrecise(h_datum_tf);
                    ops.add(h_op);
                    ops.add(UnitConversion.createUnitConverter(Unit.RADIAN, Unit.DEGREE, Unit.METER, Unit.METER));
                    ops.add(z_transfo.inverse());
                    ops.add(LoadMemorizeCoordinate.loadY);
                    ops.add(LoadMemorizeCoordinate.loadX);
                }
            } else {
                throw new CoordinateOperationNotFoundException("Unknown vertical datum type for this CRS : " + this.getVerticalCRS());
            }
        }
        if (this.horizontalCRS instanceof Geographic2DCRS) {
            if (this.getCoordinateSystem().getUnit(0) != Unit.RADIAN || this.getCoordinateSystem().getUnit(2) != Unit.METER) {
                ops = CoordinateOperationSequence.cleverAdd(ops, UnitConversion.createUnitConverter(Unit.RADIAN, this.getCoordinateSystem().getUnit(0), Unit.METER, this.getCoordinateSystem().getUnit(2)));
            }
            if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
                ops = CoordinateOperationSequence.cleverAdd(ops, CoordinateSwitch.SWITCH_LAT_LON);
            }
        } else {
            ops.add(this.horizontalCRS.getProjection());
            if (this.getCoordinateSystem().getUnit(0) != Unit.METER || this.getCoordinateSystem().getUnit(2) != Unit.METER) {
                ops = CoordinateOperationSequence.cleverAdd(ops, UnitConversion.createUnitConverter(Unit.METER, this.getCoordinateSystem().getUnit(0), Unit.METER, this.getCoordinateSystem().getUnit(2)));
            }
            if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.NORTH || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.SOUTH) {
                ops = CoordinateOperationSequence.cleverAdd(ops, CoordinateSwitch.SWITCH_LAT_LON);
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.DOWN) continue;
            ops = CoordinateOperationSequence.cleverAdd(ops, new OppositeCoordinate(i));
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("COMPD_CS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getHorizontalCRS().toWKT());
        w.append(',');
        w.append(this.getVerticalCRS().toWKT());
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier());
        }
        w.append(']');
        return w.toString();
    }

    public String toString() {
        return "[" + this.getAuthorityName() + ":" + this.getAuthorityKey() + "] " + this.getName() + " (" + this.getShortName() + ")";
    }
}

