/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

public class FreeDiskVariable
extends VariableBase {
    public FreeDiskVariable(Variable.Type type) {
        super(type);
    }

    @Override
    public Object convertVal(Object val) {
        Number value = (Number)super.validate("freedisk", val, false);
        if (value != null) {
            value = value.doubleValue() / 1024.0 / 1024.0 / 1024.0;
        }
        return value;
    }

    @Override
    public Object computeValue(Policy.Session session, Condition condition, String collection, String shard, String node) {
        if (condition.computedType == ComputedType.PERCENT) {
            Row r = session.getNode(node);
            if (r == null) {
                return 0.0;
            }
            return ComputedType.PERCENT.compute(r.getVal(Variable.Type.TOTALDISK.tagName), condition);
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)condition.computedType));
    }

    @Override
    public int compareViolation(Violation v1, Violation v2) {
        return Double.compare(v1.getViolatingReplicas().stream().mapToDouble(v -> v.delta == null ? 0.0 : v.delta).max().orElse(0.0), v2.getViolatingReplicas().stream().mapToDouble(v3 -> v3.delta == null ? 0.0 : v3.delta).max().orElse(0.0));
    }

    @Override
    public void getSuggestions(Suggestion.Ctx ctx) {
        if (ctx.violation == null) {
            return;
        }
        if (ctx.violation.replicaCountDelta > 0.0) {
            List matchingNodes = ctx.session.matrix.stream().filter(row -> ctx.violation.getViolatingReplicas().stream().anyMatch(p -> row.node.equals(p.replicaInfo.getNode()))).sorted(Comparator.comparing(r -> (Double)r.getVal("freedisk", 0.0))).collect(Collectors.toList());
            block0: for (Row node : matchingNodes) {
                ArrayList replicas = new ArrayList();
                node.forEachReplica(replicas::add);
                replicas.sort((r1, r2) -> {
                    Long s1 = Clause.parseLong(Variable.Type.CORE_IDX.tagName, r1.getVariables().get(Variable.Type.CORE_IDX.tagName));
                    Long s2 = Clause.parseLong(Variable.Type.CORE_IDX.tagName, r2.getVariables().get(Variable.Type.CORE_IDX.tagName));
                    if (s1 != null && s2 != null) {
                        return s1.compareTo(s2);
                    }
                    return 0;
                });
                double currentDelta = ctx.violation.getClause().tag.delta(node.getVal("freedisk"));
                for (ReplicaInfo replica : replicas) {
                    if (currentDelta < 1.0) continue block0;
                    if (replica.getVariables().get(Variable.Type.CORE_IDX.tagName) == null) continue;
                    Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(replica.getCollection(), replica.getShard())).hint(Suggester.Hint.SRC_NODE, node.node).forceOperation(true);
                    if (ctx.addSuggestion(suggester) == null) continue block0;
                    currentDelta -= (double)Clause.parseLong(Variable.Type.CORE_IDX.tagName, replica.getVariable(Variable.Type.CORE_IDX.tagName)).longValue();
                }
            }
        } else if (ctx.violation.replicaCountDelta < 0.0) {
            Suggestion.suggestNegativeViolations(ctx, shards -> this.getSortedShards(ctx, (Set<String>)shards));
        }
    }

    private List<String> getSortedShards(Suggestion.Ctx ctx, Set<String> shardSet) {
        return shardSet.stream().map(shard1 -> {
            AtomicReference result = new AtomicReference();
            for (Row node : ctx.session.matrix) {
                node.forEachShard(ctx.violation.coll, (s, ri) -> {
                    Number sz;
                    if (result.get() != null) {
                        return;
                    }
                    if (s.equals(shard1) && ri.size() > 0 && (sz = (Number)((ReplicaInfo)ri.get(0)).getVariable(Variable.Type.CORE_IDX.tagName)) != null) {
                        result.set(new Pair<String, Long>((String)shard1, sz.longValue()));
                    }
                });
            }
            return result.get() == null ? new Pair<String, Long>((String)shard1, 0L) : (Pair)result.get();
        }).sorted(Comparator.comparingLong(Pair::second)).map(Pair::first).collect(Collectors.toList());
    }

    @Override
    public void projectAddReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> ops, boolean strictMode) {
        for (Row row : cell.getRow().session.matrix) {
            row.forEachReplica(replicaInfo -> {
                if (ri != replicaInfo && ri.getCollection().equals(replicaInfo.getCollection()) && ri.getShard().equals(replicaInfo.getShard()) && ri.getVariable(Variable.Type.CORE_IDX.tagName) == null && replicaInfo.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
                    ri.getVariables().put(Variable.Type.CORE_IDX.tagName, this.validate(Variable.Type.CORE_IDX.tagName, replicaInfo.getVariable(Variable.Type.CORE_IDX.tagName), false));
                }
            });
        }
        Double idxSize = (Double)this.validate(Variable.Type.CORE_IDX.tagName, ri.getVariable(Variable.Type.CORE_IDX.tagName), false);
        if (idxSize == null) {
            return;
        }
        Double currFreeDisk = cell.val == null ? 0.0 : (Double)cell.val;
        cell.val = currFreeDisk - idxSize;
    }

    @Override
    public void projectRemoveReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector) {
        Double idxSize = (Double)this.validate(Variable.Type.CORE_IDX.tagName, ri.getVariable(Variable.Type.CORE_IDX.tagName), false);
        if (idxSize == null) {
            return;
        }
        Double currFreeDisk = cell.val == null ? 0.0 : (Double)cell.val;
        cell.val = currFreeDisk + idxSize;
    }
}

