/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.semanticweb.owlapi.metrics.DoubleValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.Searcher;

public class AverageAssertedNamedSuperclassCount
extends DoubleValuedMetric {
    public AverageAssertedNamedSuperclassCount(OWLOntology o) {
        super(o);
    }

    @Override
    public String getName() {
        return "Average number of named superclasses";
    }

    @Override
    public Double recomputeMetric() {
        AtomicInteger total = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        HashSet processedClasses = new HashSet();
        this.getOntologies().forEach(ont -> ont.classesInSignature().filter(processedClasses::add).forEach(cls -> this.processClass(total, count, (OWLOntology)ont, (OWLClass)cls)));
        return (double)total.get() / (double)count.get();
    }

    protected void processClass(AtomicInteger total, AtomicInteger count, OWLOntology ont, OWLClass cls) {
        count.incrementAndGet();
        int sup = (int)Searcher.sup((Stream)ont.subClassAxiomsForSubClass(cls), OWLClassExpression.class).filter(c -> !c.isAnonymous()).count();
        if (sup == 0) {
            total.incrementAndGet();
        } else {
            total.addAndGet(sup);
        }
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }
}

