/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class JustificationMap {
    private final Set<OWLAxiom> axioms;
    private final Set<OWLAxiom> rootAxioms = new HashSet<OWLAxiom>();
    private final Set<OWLAxiom> usedAxioms = new HashSet<OWLAxiom>();
    private final Multimap<OWLAxiom, OWLAxiom> map = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final Multimap<OWLEntity, OWLAxiom> axiomsByLHS = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final OWLClassExpression desc;

    public JustificationMap(OWLClassExpression desc, Set<OWLAxiom> axioms) {
        this.axioms = (Set)OWLAPIPreconditions.checkNotNull(axioms, (String)"axioms cannot be null");
        this.desc = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null");
        this.createMap();
    }

    private void createMap() {
        for (OWLAxiom ax : this.axioms) {
            OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
            ax.accept((OWLAxiomVisitor)extractor);
            HashSet lhscollected = new HashSet();
            OWLEntityCollector lhsCollector = new OWLEntityCollector(lhscollected);
            extractor.getLHS().forEach(l -> {
                Collection cfr_ignored_0 = (Collection)l.accept((OWLObjectVisitorEx)lhsCollector);
            });
            lhscollected.forEach(l -> this.axiomsByLHS.put(l, (Object)ax));
        }
        this.buildChildren(this.desc);
    }

    protected Stream<OWLAxiom> getAxiomsByLHS(OWLEntity lhs) {
        return this.axiomsByLHS.get((Object)lhs).stream();
    }

    private void buildChildren(OWLClassExpression seed) {
        List result = OWLAPIStreamUtils.asList(seed.signature().flatMap(this::getAxiomsByLHS));
        this.usedAxioms.addAll(result);
        this.rootAxioms.addAll(result);
        this.buildChildren(result);
    }

    private void buildChildren(Collection<OWLAxiom> axiomSet) {
        ArrayList<Set<OWLAxiom>> axiomChildren = new ArrayList<Set<OWLAxiom>>();
        for (OWLAxiom ax : axiomSet) {
            Set<OWLAxiom> children = this.build(ax);
            children.forEach(a -> this.map.put(a, (Object)ax));
            axiomChildren.add(children);
        }
        axiomChildren.forEach(this::buildChildren);
    }

    private Set<OWLAxiom> build(OWLAxiom parentAxiom) {
        this.usedAxioms.add(parentAxiom);
        OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
        parentAxiom.accept((OWLAxiomVisitor)extractor);
        return OWLAPIStreamUtils.asUnorderedSet(extractor.getRHS().stream().flatMap(o -> o.signature()).flatMap(this::getAxiomsByLHS).filter(this.usedAxioms::add));
    }

    public Set<OWLAxiom> getRootAxioms() {
        return this.rootAxioms;
    }

    public Collection<OWLAxiom> getChildAxioms(OWLAxiom ax) {
        return this.map.get((Object)ax);
    }

    private static class OWLAxiomPartExtractor
    implements OWLAxiomVisitor {
        private final Set<OWLObject> rhs = new HashSet<OWLObject>();
        private final Set<OWLObject> lhs = new HashSet<OWLObject>();

        OWLAxiomPartExtractor() {
        }

        public Set<OWLObject> getRHS() {
            return this.rhs;
        }

        public Set<OWLObject> getLHS() {
            return this.lhs;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperClass());
            this.lhs.add((OWLObject)axiom.getSubClass());
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getObject());
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add((OWLObject)axiom.getSubject());
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.classExpressions());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.classExpressions());
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add(axiom.getProperty());
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.rhs.add(axiom.getDomain());
            this.lhs.add(axiom.getProperty());
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.properties());
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add((OWLObject)axiom.getSubject());
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.individuals());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.individuals());
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.properties());
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.properties());
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.rhs.add(axiom.getRange());
            this.lhs.add(axiom.getProperty());
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add((OWLObject)axiom.getSubject());
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
            this.lhs.add((OWLObject)axiom.getSubProperty());
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.classExpressions());
            this.rhs.add((OWLObject)axiom.getOWLClass());
            this.lhs.add((OWLObject)axiom.getOWLClass());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.classExpressions());
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.rhs.add(axiom.getRange());
            this.lhs.add(axiom.getProperty());
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.properties());
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getClassExpression());
            this.lhs.add((OWLObject)axiom.getIndividual());
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.classExpressions());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.classExpressions());
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
            this.lhs.add((OWLObject)axiom.getSubject());
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add(axiom.getProperty());
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.individuals());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.individuals());
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
            this.lhs.addAll(axiom.getPropertyChain());
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, (Stream)axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, (Stream)axiom.properties());
        }
    }
}

