/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.core.Assignment;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.DeleteDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.InsertDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class TimeSeriesSparql {
    private StoreClientInterface kbClient;
    public static final String ns_ontology = "https://github.com/cambridge-cares/TheWorldAvatar/blob/main/JPS_Ontology/ontology/ontotimeseries/OntoTimeSeries.owl#";
    public static final String ns_kb = "http://www.theworldavatar.com/kb/ontotimeseries/";
    private static final Prefix prefix_ontology = SparqlBuilder.prefix("ts", Rdf.iri("https://github.com/cambridge-cares/TheWorldAvatar/blob/main/JPS_Ontology/ontology/ontotimeseries/OntoTimeSeries.owl#"));
    private static final Prefix prefix_kb = SparqlBuilder.prefix("kb", Rdf.iri("http://www.theworldavatar.com/kb/ontotimeseries/"));
    private static final Iri TimeSeries = prefix_ontology.iri("TimeSeries");
    private static final Iri hasTimeSeries = prefix_ontology.iri("hasTimeSeries");
    private static final Iri hasRDB = prefix_ontology.iri("hasRDB");
    private static final Iri hasTimeUnit = prefix_ontology.iri("hasTimeUnit");
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesSparql(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    public void setKBClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    protected void loadSparqlConfigs(String filepath) throws IOException {
        block8: {
            File file = new File(filepath);
            if (!file.exists()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "No properties file found at specified filepath: " + filepath);
            }
            try (FileInputStream input = new FileInputStream(file);){
                Properties prop = new Properties();
                prop.load(input);
                if (!prop.containsKey("sparql.query.endpoint")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.query.endpoint=<sparql_endpoint>\" ");
                }
                this.kbClient.setQueryEndpoint(prop.getProperty("sparql.query.endpoint"));
                if (prop.containsKey("sparql.update.endpoint")) {
                    this.kbClient.setUpdateEndpoint(prop.getProperty("sparql.update.endpoint"));
                    break block8;
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.update.endpoint=<sparql_endpoint>\" ");
            }
        }
    }

    public boolean checkTimeSeriesExists(String timeSeriesIRI) {
        String query = String.format("ask {<%s> a <%s>}", timeSeriesIRI, "https://github.com/cambridge-cares/TheWorldAvatar/blob/main/JPS_Ontology/ontology/ontotimeseries/OntoTimeSeries.owl#TimeSeries");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", dataIRI, "https://github.com/cambridge-cares/TheWorldAvatar/blob/main/JPS_Ontology/ontology/ontotimeseries/OntoTimeSeries.owl#hasTimeSeries");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", tsIRI, "https://github.com/cambridge-cares/TheWorldAvatar/blob/main/JPS_Ontology/ontology/ontotimeseries/OntoTimeSeries.owl#hasTimeUnit");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    protected void initTS(String timeSeriesIRI, List<String> dataIRI, String dbURL, String timeUnit) {
        if (!Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(timeSeriesIRI).matches()) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series IRI does not have valid IRI format");
        }
        Iri tsIRI = Rdf.iri(timeSeriesIRI);
        if (this.checkTimeSeriesExists(timeSeriesIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series " + timeSeriesIRI + " already in the Knowledge Graph");
        }
        for (String iri : dataIRI) {
            String ts = this.getTimeSeries(iri);
            if (ts == null) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + iri + " is already attached to time series " + ts);
        }
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(prefix_ontology, prefix_kb);
        modify.insert(tsIRI.isA(TimeSeries));
        modify.insert(tsIRI.has((RdfPredicate)hasRDB, Rdf.literalOf(dbURL)));
        for (String data : dataIRI) {
            TriplePattern ts_tp = Rdf.iri(data).has((RdfPredicate)hasTimeSeries, tsIRI);
            modify.insert(ts_tp);
        }
        if (timeUnit != null) {
            modify.insert(tsIRI.has((RdfPredicate)hasTimeUnit, Rdf.literalOf(timeUnit)));
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    void bulkInitTS(List<String> tsIRIs, List<List<String>> dataIRIs, String rdbURL, List<String> timeUnit) {
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(prefix_ontology, prefix_kb);
        for (int i = 0; i < tsIRIs.size(); ++i) {
            Iri ts = Rdf.iri(tsIRIs.get(i));
            modify.insert(ts.isA(TimeSeries));
            modify.insert(ts.has((RdfPredicate)hasRDB, Rdf.literalOf(rdbURL)));
            for (String data : dataIRIs.get(i)) {
                modify.insert(Rdf.iri(data).has((RdfPredicate)hasTimeSeries, ts));
            }
            if (timeUnit == null || timeUnit.get(i) == null) continue;
            modify.insert(ts.has((RdfPredicate)hasTimeUnit, Rdf.literalOf(timeUnit.get(i))));
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    public int countTS() {
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        String queryKey = "numtimeseries";
        Variable ts = query.var();
        Variable numtimeseries = SparqlBuilder.var(queryKey);
        TriplePattern querypattern = ts.isA(TimeSeries);
        Assignment count = Expressions.count(ts).as(numtimeseries);
        query.prefix(prefix_ontology);
        query.select(count).where(querypattern);
        this.kbClient.setQuery(query.getQueryString());
        return this.kbClient.executeQuery().getJSONObject(0).getInt(queryKey);
    }

    protected void insertTimeSeriesAssociation(String dataIRI, String tsIRI) {
        String ts = this.getTimeSeries(dataIRI);
        if (ts != null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + dataIRI + " is already attached to time series " + ts);
        }
        if (!this.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series " + tsIRI + " does not exists in the Knowledge Graph");
        }
        InsertDataQuery insert = Queries.INSERT_DATA(Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI)));
        insert.prefix(prefix_ontology);
        this.kbClient.executeUpdate(insert.getQueryString());
    }

    protected void removeTimeSeriesAssociation(String dataIRI) {
        String tsIRI = this.getTimeSeries(dataIRI);
        if (tsIRI != null) {
            List<String> data = this.getAssociatedData(tsIRI);
            if (data.size() == 1) {
                this.removeTimeSeries(tsIRI);
            } else {
                DeleteDataQuery delete = Queries.DELETE_DATA(Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI)));
                delete.prefix(prefix_ontology);
                this.kbClient.executeUpdate(delete.getQueryString());
            }
        }
    }

    protected void removeTimeSeries(String tsIRI) {
        if (this.checkTimeSeriesExists(tsIRI)) {
            SubSelect sub = GraphPatterns.select(new Projectable[0]);
            Variable predicate1 = SparqlBuilder.var("a");
            Variable predicate2 = SparqlBuilder.var("b");
            Variable subject = SparqlBuilder.var("c");
            Variable object = SparqlBuilder.var("d");
            TriplePattern delete_tp1 = Rdf.iri(tsIRI).has((RdfPredicate)predicate1, object);
            TriplePattern delete_tp2 = subject.has((RdfPredicate)predicate2, Rdf.iri(tsIRI));
            sub.select(predicate1, predicate2, subject, object).where(delete_tp1, delete_tp2);
            ModifyQuery modify = Queries.MODIFY();
            modify.delete(delete_tp1, delete_tp2).where(sub);
            this.kbClient.setQuery(modify.getQueryString());
            this.kbClient.executeUpdate();
        }
    }

    protected void removeAllTimeSeries() {
        SubSelect sub = GraphPatterns.select(new Projectable[0]);
        Variable predicate1 = sub.var();
        Variable predicate2 = sub.var();
        Variable subject = sub.var();
        Variable object = sub.var();
        Variable timeseries = sub.var();
        TriplePattern delete_tp1 = timeseries.has((RdfPredicate)predicate1, object);
        TriplePattern delete_tp2 = subject.has((RdfPredicate)predicate2, timeseries);
        ModifyQuery modify = Queries.MODIFY();
        modify.delete(delete_tp1, delete_tp2).where(timeseries.isA(TimeSeries), delete_tp1, delete_tp2).prefix(prefix_ontology);
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    public String getTimeSeries(String dataIRI) {
        String result = null;
        if (this.checkDataHasTimeSeries(dataIRI)) {
            String queryString = "tsIRI";
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            Variable tsIRI = SparqlBuilder.var(queryString);
            TriplePattern queryPattern = Rdf.iri(dataIRI).has((RdfPredicate)hasTimeSeries, tsIRI);
            ((SelectQuery)query.select(tsIRI).where(queryPattern)).prefix(prefix_ontology);
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getDbUrl(String tsIRI) {
        String result = null;
        if (this.checkTimeSeriesExists(tsIRI)) {
            String queryString = "dbURL";
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            Variable dbURL = SparqlBuilder.var(queryString);
            TriplePattern queryPattern = Rdf.iri(tsIRI).has((RdfPredicate)hasRDB, dbURL);
            ((SelectQuery)query.select(dbURL).where(queryPattern)).prefix(prefix_ontology);
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getTimeUnit(String tsIRI) {
        String result = null;
        if (this.checkTimeSeriesExists(tsIRI) && this.checkTimeUnitExists(tsIRI)) {
            String queryString = "timeUnit";
            SelectQuery query = Queries.SELECT(new Projectable[0]);
            Variable timeUnit = SparqlBuilder.var(queryString);
            TriplePattern queryPattern = Rdf.iri(tsIRI).has((RdfPredicate)hasTimeUnit, timeUnit);
            ((SelectQuery)query.select(timeUnit).where(queryPattern)).prefix(prefix_ontology);
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public List<String> getAssociatedData(String tsIRI) {
        String queryString = "dataIRI";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable data = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = data.has((RdfPredicate)hasTimeSeries, Rdf.iri(tsIRI));
        ((SelectQuery)query.select(data).where(queryPattern)).prefix(prefix_ontology);
        return this.getInstances(query, queryString);
    }

    public List<String> getAllTimeSeries() {
        String queryString = "ts";
        SelectQuery query = Queries.SELECT(new Projectable[0]);
        Variable ts = SparqlBuilder.var(queryString);
        TriplePattern queryPattern = ts.isA(TimeSeries);
        ((SelectQuery)query.select(ts).where(queryPattern)).prefix(prefix_ontology);
        return this.getInstances(query, queryString);
    }

    private List<String> getInstances(SelectQuery instanceSelectQuery, String placeholder) {
        this.kbClient.setQuery(instanceSelectQuery.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        ArrayList<String> instanceIRIs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            instanceIRIs.add(queryResult.getJSONObject(i).getString(placeholder));
        }
        return instanceIRIs;
    }
}

