/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class TimeSeries<T> {
    private final List<T> times;
    private final Map<String, List<?>> values;

    public TimeSeries(List<T> times, List<String> dataIRI, List<List<?>> values) {
        this.times = times;
        this.values = new HashMap();
        if (dataIRI.size() == 0) {
            throw new JPSRuntimeException("TimeSeries: No data IRI has been provided.");
        }
        if (dataIRI.size() != values.size()) {
            throw new JPSRuntimeException("TimeSeries: Length of data IRI is different from provided data.");
        }
        for (List<?> v : values) {
            if (v.size() == times.size()) continue;
            throw new JPSRuntimeException("TimeSeries: Number of time steps does not match number of values for all series.");
        }
        for (int i = 0; i < dataIRI.size(); ++i) {
            this.values.put(dataIRI.get(i), values.get(i));
        }
    }

    public List<T> getTimes() {
        return this.times;
    }

    public List<Double> getValuesAsDouble(String dataIRI) {
        List<?> v = this.getValues(dataIRI);
        if (v == null) {
            return null;
        }
        try {
            return v.stream().map(value -> value == null ? null : Double.valueOf(((Number)value).doubleValue())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new JPSRuntimeException("TimeSeries: Values for provided dataIRI are not castable to \"Number\"");
        }
    }

    public List<Integer> getValuesAsInteger(String dataIRI) {
        List<?> v = this.getValues(dataIRI);
        if (v == null) {
            return null;
        }
        try {
            return v.stream().map(value -> value == null ? null : Integer.valueOf(((Number)value).intValue())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new JPSRuntimeException("TimeSeries: Values for provided dataIRI are not castable to \"Number\"");
        }
    }

    public List<String> getValuesAsString(String dataIRI) {
        return this.values.get(dataIRI).stream().map(value -> value == null ? null : value.toString()).collect(Collectors.toList());
    }

    public List<?> getValues(String dataIRI) {
        return this.values.get(dataIRI);
    }

    public List<String> getDataIRIs() {
        Set<String> keys = this.values.keySet();
        return new ArrayList<String>(keys);
    }
}

