/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.slurm.job;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.slurm.job.JobStatistics;
import uk.ac.cam.cares.jps.base.slurm.job.Property;
import uk.ac.cam.cares.jps.base.slurm.job.SlurmJobException;
import uk.ac.cam.cares.jps.base.slurm.job.Status;
import uk.ac.cam.cares.jps.base.slurm.job.Utils;
import uk.ac.cam.cares.jps.base.slurm.job.Workspace;
import uk.ac.cam.cares.jps.base.slurm.job.configuration.SlurmJobProperty;

public class JobSubmission {
    private Logger LOGGER = LogManager.getLogger(JobSubmission.class);
    private String hpcAddress;
    private String agentClass;
    private File workspaceDirectory;
    private String workspaceName;
    private String workspaceParentPath;
    boolean isAuthenticated;
    public SlurmJobProperty slurmJobProperty = new SlurmJobProperty();
    static Session session;
    static JSch jsch;
    static int scheduledIteration;
    static Set<String> jobsRunning;

    public String getHpcAddress() {
        return this.hpcAddress;
    }

    public void setHpcAddress(String hpcAddress) {
        this.hpcAddress = hpcAddress;
    }

    public String getAgentClass() {
        return this.agentClass;
    }

    public void setAgentClass(String agentClass) {
        this.agentClass = agentClass;
    }

    public File getWorkspaceDirectory() {
        return this.workspaceDirectory;
    }

    public void setWorkspaceDirectory(File workspaceDirectory) {
        this.workspaceDirectory = workspaceDirectory;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public static void main(String[] args) throws SlurmJobException {
    }

    public String getWorkspaceParentPath() {
        return this.workspaceParentPath;
    }

    public void setWorkspaceParentPath(String workspaceParentPath) {
        this.workspaceParentPath = workspaceParentPath;
    }

    public JobSubmission(String agentClass, String hpcAddress) {
        this.agentClass = agentClass;
        this.hpcAddress = hpcAddress;
        this.workspaceDirectory = Workspace.getWorkspace(Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName(), agentClass);
        this.workspaceParentPath = Property.JOB_WORKSPACE_PARENT_DIR.getPropertyName();
    }

    public String setUpJob(String jsonInput, File slurmScript, File input, long timeStamp) throws IOException, SlurmJobException {
        String message = this.setUpJobOnAgentMachine(jsonInput, slurmScript, input, timeStamp);
        return message;
    }

    public String setUpJob(String jsonInput, File slurmScript, File input, File executable, long timeStamp) throws IOException, SlurmJobException {
        String message = this.setUpJobOnAgentMachine(jsonInput, slurmScript, input, executable, timeStamp);
        JSONObject obj = new JSONObject();
        obj.put("message", message);
        return obj.toString();
    }

    private String setUpJobOnAgentMachine(String jsonString, File slurmScript, File input, long timeStamp) throws IOException, SlurmJobException {
        Workspace workspace = new Workspace();
        if (this.workspaceDirectory == null) {
            return Status.JOB_SETUP_ERROR.getName();
        }
        return this.setUpSlurmJob(workspace, this.workspaceDirectory, jsonString, slurmScript, input, timeStamp);
    }

    private String setUpJobOnAgentMachine(String jsonString, File slurmScript, File input, File executable, long timeStamp) throws IOException, SlurmJobException {
        Workspace workspace = new Workspace();
        if (this.workspaceDirectory == null) {
            return Status.JOB_SETUP_ERROR.getName();
        }
        return this.setUpSlurmJob(workspace, this.workspaceDirectory, jsonString, slurmScript, input, executable, timeStamp);
    }

    private String setUpSlurmJob(Workspace ws, File workspaceFolder, String jsonString, File slurmScript, File input, long timeStamp) throws IOException, SlurmJobException {
        File jobFolder = ws.createJobFolder(workspaceFolder.getAbsolutePath(), this.getHpcAddress(), timeStamp);
        if (this.createAllFileInJobFolder(ws, workspaceFolder, jobFolder, jsonString, slurmScript, input) == null) {
            return null;
        }
        return jobFolder.getName();
    }

    private String setUpSlurmJob(Workspace ws, File workspaceFolder, String jsonString, File slurmScript, File input, File executable, long timeStamp) throws IOException, SlurmJobException {
        File jobFolder = ws.createJobFolder(workspaceFolder.getAbsolutePath(), this.getHpcAddress(), timeStamp);
        if (this.createAllFileInJobFolder(ws, workspaceFolder, jobFolder, jsonString, slurmScript, input, executable) == null) {
            return null;
        }
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    private String createAllFileInJobFolder(Workspace ws, File workspaceFolder, File jobFolder, String jsonString, File slurmScript, File input) throws IOException, SlurmJobException {
        String inputFileMsg = ws.createInputFile(ws.getInputFilePath(jobFolder, this.getHpcAddress(), ws.getInputFileExtension(input)), input);
        if (inputFileMsg == null) {
            return Status.JOB_SETUP_INPUT_FILE_ERROR.getName();
        }
        String statusFileMsg = ws.createStatusFile(workspaceFolder, ws.getStatusFilePath(jobFolder), this.getHpcAddress());
        if (statusFileMsg == null) {
            return null;
        }
        String jsonInputFileMsg = ws.createJSONInputFile(workspaceFolder, ws.getJSONInputFilePath(jobFolder), jsonString);
        if (jsonInputFileMsg == null) {
            return null;
        }
        String scriptFileMsg = ws.copyFile(slurmScript.getAbsolutePath(), jobFolder.getAbsolutePath().concat(File.separator).concat(slurmScript.getName()));
        if (scriptFileMsg == null) {
            return null;
        }
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    private String createAllFileInJobFolder(Workspace ws, File workspaceFolder, File jobFolder, String jsonString, File slurmScript, File input, File executable) throws IOException, SlurmJobException {
        String inputFileMsg = ws.createInputFile(ws.getInputFilePath(jobFolder, this.getHpcAddress(), ws.getInputFileExtension(input)), input);
        if (inputFileMsg == null) {
            return Status.JOB_SETUP_INPUT_FILE_ERROR.getName();
        }
        String statusFileMsg = ws.createStatusFile(workspaceFolder, ws.getStatusFilePath(jobFolder), this.getHpcAddress());
        if (statusFileMsg == null) {
            return null;
        }
        String jsonInputFileMsg = ws.createJSONInputFile(workspaceFolder, ws.getJSONInputFilePath(jobFolder), jsonString);
        if (jsonInputFileMsg == null) {
            return null;
        }
        String scriptFileMsg = ws.copyFile(slurmScript.getAbsolutePath(), jobFolder.getAbsolutePath().concat(File.separator).concat(slurmScript.getName()));
        if (scriptFileMsg == null) {
            return null;
        }
        String executableFileMsg = ws.copyFile(executable.getAbsolutePath(), jobFolder.getAbsolutePath().concat(File.separator).concat(executable.getName()));
        if (executableFileMsg == null) {
            return null;
        }
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    public String produceStatistics(String input) throws IOException, SlurmJobException {
        System.out.println("Received a request to send statistics.\n");
        this.LOGGER.info("Received a request to send statistics.\n");
        return "";
    }

    public String showStatistics() throws IOException, SlurmJobException {
        System.out.println("Received a request to show statistics.\n");
        this.LOGGER.info("Received a request to show statistics.\n");
        return "";
    }

    public JSONObject getStatistics(String input) throws IOException {
        JSONObject obj = new JSONObject(input);
        String formatAccepts = obj.optString("format");
        if (formatAccepts != null && formatAccepts.toLowerCase().contains("json")) {
            JobStatistics jobStatistics = new JobStatistics(this.workspaceDirectory);
            obj = new JSONObject();
            obj.put("Number of jobs currently running", jobStatistics.getJobsRunning());
            obj.put("Number of jobs successfully completed", jobStatistics.getJobsCompleted());
            obj.put("Number of jobs completing", jobStatistics.getJobsCompleting());
            obj.put("Number of jobs failed", jobStatistics.getJobsFailed());
            obj.put("Number of jobs pending", jobStatistics.getJobsPending());
            obj.put("Number of jobs preempted", jobStatistics.getJobsPreempted());
            obj.put("Number of jobs suspended", jobStatistics.getJobsSuspended());
            obj.put("Number of jobs stopped", jobStatistics.getJobsStopped());
            obj.put("Number of jobs terminated with an error", jobStatistics.getJobsErrorTerminated());
            obj.put("Number of jobs to start", jobStatistics.getJobsNotStarted());
            obj.put("Total number of jobs submitted", jobStatistics.getJobsSubmitted());
        }
        return obj;
    }

    public String getStatistics() throws IOException {
        JobStatistics jobStatistics = new JobStatistics(this.workspaceDirectory);
        String statistics = jobStatistics.getHTMLHeader();
        statistics = statistics + "<body>";
        statistics = statistics.concat(jobStatistics.getBodydivStart());
        statistics = statistics + "<center>";
        String headerText = "Statistics about jobs submitted to this agent are shown in the table below.<p>";
        statistics = statistics.concat(jobStatistics.getStatisticsTableHeader(headerText, "Property", "Value", "50%"));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs currently running", jobStatistics.getJobsRunning() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs successfully completed", jobStatistics.getJobsCompleted() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs completing", jobStatistics.getJobsCompleting() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs failed", jobStatistics.getJobsFailed() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs pending", jobStatistics.getJobsPending() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs preempted", jobStatistics.getJobsPreempted() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs suspended", jobStatistics.getJobsSuspended() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs stopped", jobStatistics.getJobsStopped() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs terminated with an error", jobStatistics.getJobsErrorTerminated() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("Number of jobs to start", jobStatistics.getJobsNotStarted() + ""));
        statistics = statistics.concat(jobStatistics.getStatisticsTableRow("<i>Total number of jobs submitted</i>", jobStatistics.getJobsSubmitted() + ""));
        statistics = statistics + "</table>";
        statistics = statistics + "</center>";
        statistics = statistics + "</body>";
        statistics = statistics + "</html>";
        return statistics;
    }

    public void monitorJobs() throws SlurmJobException {
        block15: {
            try {
                if (!this.hostAvailabilityCheck(this.getHpcAddress(), 22)) {
                    System.out.println("The agent cannot connect to the HPC server with address " + this.getHpcAddress());
                    session = null;
                    return;
                }
                if (session == null || ++scheduledIteration % 10 == 0) {
                    if (session != null && session.isConnected()) {
                        session.disconnect();
                    }
                    System.out.println("Initialising a session.");
                    session = jsch.getSession(this.slurmJobProperty.getHpcServerLoginUserName(), this.getHpcAddress(), 22);
                    String pwd = this.slurmJobProperty.getHpcServerLoginUserPassword();
                    session.setPassword(pwd);
                    try {
                        PageantConnector con = new PageantConnector();
                        RemoteIdentityRepository irepo = new RemoteIdentityRepository(con);
                        jsch.setIdentityRepository(irepo);
                        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
                    }
                    catch (AgentProxyException e) {
                        session.setConfig("PreferredAuthentications", "password");
                    }
                    session.setConfig("StrictHostKeyChecking", "no");
                    session.connect();
                    scheduledIteration = 0;
                }
                if (!this.workspaceDirectory.isDirectory()) break block15;
                File[] jobFolders = this.workspaceDirectory.listFiles();
                this.updateRunningJobSet(jobFolders, jobsRunning);
                for (File jobFolder : jobFolders) {
                    if (Utils.isJobCompleted(jobFolder, this.slurmJobProperty)) continue;
                    if (Utils.isJobRunning(jobFolder)) {
                        if (!this.updateRunningJobsStatus(jobFolder) || !jobsRunning.contains(jobFolder.getName())) continue;
                        jobsRunning.remove(jobFolder.getName());
                        continue;
                    }
                    if (!Utils.isJobNotStarted(jobFolder) || jobsRunning.contains(jobFolder.getName())) continue;
                    if (jobsRunning.size() >= this.slurmJobProperty.getMaxNumberOfHPCJobs()) break;
                    try {
                        boolean flag = this.runNotStartedJob(jobFolder);
                        if (flag) {
                            jobsRunning.add(jobFolder.getName());
                            continue;
                        }
                        break;
                    }
                    catch (Exception e) {
                        this.LOGGER.info(e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                session = null;
                throw new SlurmJobException(e.getMessage());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                session = null;
                throw new SlurmJobException(e.getMessage());
            }
            catch (SftpException e) {
                e.printStackTrace();
                session = null;
                throw new SlurmJobException(e.getMessage());
            }
            catch (JSchException e) {
                e.printStackTrace();
                session = null;
                throw new SlurmJobException(e.getMessage());
            }
        }
    }

    private void updateRunningJobSet(File[] jobFolders, Set<String> jobsRunning) throws IOException {
        for (File jobFolder : jobFolders) {
            if (!new File(jobFolder.getAbsolutePath().concat(File.separator).concat(Status.STATUS_FILE.getName())).exists()) {
                this.LOGGER.info("SlurmJobAPI: job status file is not found, so the job folder with ID " + jobFolder.getName() + " is being moved to the failed job folder.");
                System.out.println("SlurmJobAPI: job status file is not found, so the job folder with ID " + jobFolder.getName() + " is being moved to the failed job folder.");
                try {
                    Utils.moveToFailedJobsFolder(jobFolder, this.slurmJobProperty);
                }
                catch (Exception e) {
                    this.LOGGER.info("SlurmJobAPI: failed to move the job folder with ID " + jobFolder.getName() + " to the failed job folder.");
                    System.out.println("SlurmJobAPI: failed to move the job folder with ID " + jobFolder.getName() + " to the failed job folder.");
                }
                continue;
            }
            try {
                if (!Utils.isJobRunning(jobFolder)) continue;
                jobsRunning.add(jobFolder.getName());
            }
            catch (Exception e) {
                this.LOGGER.info("SlurmJobAPI: failed to check the status of the job with ID " + jobFolder.getName() + " while checking if it was running.");
                System.out.println("SlurmJobAPI: failed to check the status of the job with ID " + jobFolder.getName() + " while checking if it was running.");
            }
        }
    }

    private boolean runNotStartedJob(File jobFolder) throws SftpException, JSchException, IOException, UnknownHostException, InterruptedException {
        int countNumberOfFilesSetInProperties = 0;
        if (this.slurmJobProperty.getSlurmScriptFileName() == null || this.slurmJobProperty.getSlurmScriptFileName().isEmpty()) {
            throw new IOException("SlurmJobAPI: Slurm script file name and extension are not provided.");
        }
        ++countNumberOfFilesSetInProperties;
        if (this.slurmJobProperty.getInputFileName() == null || this.slurmJobProperty.getInputFileName().isEmpty()) {
            throw new IOException("SlurmJobAPI: input file name is not provided.");
        }
        ++countNumberOfFilesSetInProperties;
        if (this.slurmJobProperty.getInputFileExtension() == null || this.slurmJobProperty.getInputFileExtension().isEmpty()) {
            throw new IOException("SlurmJobAPI: input file extension is not provided.");
        }
        if (this.slurmJobProperty.getJsonInputFileName() == null || this.slurmJobProperty.getJsonInputFileName().isEmpty()) {
            throw new IOException("SlurmJobAPI: JSON input file name is not provided.");
        }
        ++countNumberOfFilesSetInProperties;
        if (this.slurmJobProperty.getJsonFileExtension() == null || this.slurmJobProperty.getJsonFileExtension().isEmpty()) {
            throw new IOException("SlurmJobAPI: JSON file extension is not provided.");
        }
        if (this.slurmJobProperty.getExecutableFile() != null && !this.slurmJobProperty.getExecutableFile().isEmpty()) {
            ++countNumberOfFilesSetInProperties;
        }
        int countNumberOfFilesInJobFolder = 0;
        for (File file : jobFolder.listFiles()) {
            if (file.getName().equalsIgnoreCase(this.slurmJobProperty.getSlurmScriptFileName())) {
                ++countNumberOfFilesInJobFolder;
            }
            if (file.getName().endsWith(this.slurmJobProperty.getInputFileExtension())) {
                ++countNumberOfFilesInJobFolder;
            }
            if (file.getName().equalsIgnoreCase(this.slurmJobProperty.getJsonInputFileName().concat(this.slurmJobProperty.getJsonFileExtension()))) {
                ++countNumberOfFilesInJobFolder;
            }
            if (file.getName().equalsIgnoreCase(Status.STATUS_FILE.getName())) {
                ++countNumberOfFilesInJobFolder;
            }
            if (this.slurmJobProperty.getExecutableFile() == null || !file.getName().equalsIgnoreCase(this.slurmJobProperty.getExecutableFile())) continue;
            ++countNumberOfFilesInJobFolder;
        }
        try {
            System.out.println("countNumberOfFilesInJobFolder:" + countNumberOfFilesInJobFolder);
            System.out.println("countNumberOfFilesSetInProperties:" + countNumberOfFilesSetInProperties);
            if (countNumberOfFilesSetInProperties < 3 || countNumberOfFilesSetInProperties + 1 != countNumberOfFilesInJobFolder) {
                this.LOGGER.info("SlurmJobAPI: all mandatory files are not found, so the job folder with ID " + jobFolder.getName() + " is deleted.");
                System.out.println("SlurmJobAPI: all mandatory files are not found, so the job folder with ID " + jobFolder.getName() + " is deleted.");
                Utils.moveToFailedJobsFolder(jobFolder, this.slurmJobProperty);
                return false;
            }
        }
        catch (Exception e) {
            this.LOGGER.info("SlurmJobAPI: all mandatory files are not found and an attempt to move the job folder with ID " + jobFolder.getName() + " to the failed job folder is not successful.");
            System.out.println("SlurmJobAPI: all mandatory files are not found and an attempt to move the job folder with ID " + jobFolder.getName() + " to the failed job folder is not successful.");
        }
        try {
            this.startJob(jobFolder.getName(), Arrays.asList(jobFolder.listFiles()));
        }
        catch (Exception e) {
            this.LOGGER.info("SlurmJobAPI: the Slurm Job with ID " + jobFolder.getName() + " could not be started.");
            System.out.println("SlurmJobAPI: the Slurm Job with ID " + jobFolder.getName() + " could not be started.");
            return false;
        }
        return true;
    }

    private void startJob(String job, List<File> jobFiles) throws SftpException, JSchException, IOException, UnknownHostException, InterruptedException {
        String jobFolderOnHPC = this.createJobFolder(job = job.replace(this.getHpcAddress(), Utils.getMachineAddress()));
        if (jobFolderOnHPC != null) {
            this.uploadFiles(jobFolderOnHPC, jobFiles);
        }
    }

    private void uploadFiles(String jobFolderOnHPC, List<File> jobFiles) throws SftpException, JSchException, IOException, UnknownHostException, InterruptedException {
        String replacedInputFileName = "";
        String statusFileAbsolutePath = "";
        String jobId = "";
        for (File jobFile : jobFiles) {
            if (jobFile.getAbsolutePath().endsWith(this.slurmJobProperty.getInputFileExtension())) {
                replacedInputFileName = this.getInputFileNameReplaced(jobFile.getAbsolutePath());
                String inputFileNameOnHPC = jobFolderOnHPC.concat("/").concat(replacedInputFileName);
                this.uploadFile(jobFile.getAbsolutePath(), inputFileNameOnHPC);
                this.replaceFileContent(jobFolderOnHPC, inputFileNameOnHPC);
            } else if (!jobFile.getAbsolutePath().endsWith(Property.STATUS_FILE_NAME.getPropertyName())) {
                if (jobFile.getAbsolutePath().endsWith(".sh")) {
                    Utils.translateLineEndingIntoUnix(new File(jobFile.getAbsolutePath()));
                }
                this.uploadFile(jobFile.getAbsolutePath(), jobFolderOnHPC);
            }
            if (!jobFile.getAbsolutePath().endsWith(Property.STATUS_FILE_NAME.getPropertyName())) continue;
            statusFileAbsolutePath = jobFile.getAbsolutePath();
        }
        jobId = this.runSlurmJob(jobFolderOnHPC, replacedInputFileName);
        if (!jobId.isEmpty()) {
            Utils.addJobId(statusFileAbsolutePath, jobId);
        }
    }

    private String runSlurmJob(String jobFolderOnHPC, String inputFile) throws JSchException, IOException {
        inputFile = inputFile.replace(this.slurmJobProperty.getInputFileExtension(), "");
        String command = "cd ".concat(jobFolderOnHPC).concat(" && ").concat("sbatch --job-name=").concat(inputFile).concat(" ").concat(Property.SLURM_SCRIPT_FILE_NAME.getPropertyName());
        return this.runSlurmJob(command);
    }

    private String runSlurmJob(String command) throws JSchException, IOException {
        ArrayList<String> outputs = this.executeCommand(command);
        if (outputs == null) {
            return null;
        }
        String jobId = this.getJobId(outputs);
        System.out.println("Job id:" + jobId);
        return jobId;
    }

    private void replaceFileContent(String jobFolderOnHPC, String replacedJobFileName) throws JSchException, IOException, UnknownHostException {
        String command = "cd ".concat(jobFolderOnHPC).concat(" && ").concat("sed -i 's/").concat(this.getHpcAddress()).concat("/").concat(Utils.getMachineAddress()).concat("/g' ").concat(replacedJobFileName);
        this.executeCommand(command);
    }

    private String getInputFileNameReplaced(String inputFile) throws UnknownHostException {
        String[] tokens = inputFile.contains("/") ? inputFile.split("/") : inputFile.split("\\\\");
        return tokens[tokens.length - 1].replace(this.getHpcAddress(), Utils.getMachineAddress());
    }

    private String createJobFolder(String job) throws JSchException, IOException {
        String command = "mkdir /home/".concat(this.slurmJobProperty.getHpcServerLoginUserName()).concat("/").concat(this.workspaceDirectory.getName());
        this.executeCommand(command);
        command = "mkdir /home/".concat(this.slurmJobProperty.getHpcServerLoginUserName()).concat("/").concat(this.workspaceDirectory.getName()).concat("/").concat(job);
        this.executeCommand(command);
        return "/home/".concat(this.slurmJobProperty.getHpcServerLoginUserName()).concat("/").concat(this.workspaceDirectory.getName()).concat("/").concat(job);
    }

    private boolean updateRunningJobsStatus(File jobFolder) throws JSchException, SftpException, IOException, InterruptedException {
        boolean status = false;
        try {
            File statusFile = Utils.getStatusFile(jobFolder);
            status = this.updateRunningJobsStatus(jobFolder.getName(), statusFile);
        }
        catch (Exception e) {
            this.LOGGER.info("SlurmJobAPI: failed to update the status of the job with ID " + jobFolder.getName() + " while checking if it was still running.");
        }
        return status;
    }

    private boolean updateRunningJobsStatus(String runningJob, File statusFile) throws JSchException, SftpException, IOException, InterruptedException {
        if (statusFile != null && !this.isJobRunning(statusFile)) {
            if (this.slurmJobProperty.getOutputFileExtension().trim().toLowerCase().equals(".log")) {
                if (this.outputFileExist(Utils.getLogFilePathOnHPC(runningJob, this.slurmJobProperty.getHpcServerLoginUserName(), this.workspaceDirectory, this.getHpcAddress()))) {
                    try {
                        this.downloadFile(Utils.getLogFilePathOnHPC(runningJob, this.slurmJobProperty.getHpcServerLoginUserName(), this.workspaceDirectory, this.getHpcAddress()), Utils.getJobOutputFilePathOnAgentPC(runningJob, this.workspaceDirectory, runningJob, Status.EXTENSION_LOG_FILE.getName()));
                        this.updateStatusForErrorTermination(statusFile, Utils.getJobOutputFilePathOnAgentPC(runningJob, this.workspaceDirectory, runningJob, Status.EXTENSION_LOG_FILE.getName()));
                    }
                    catch (Exception e) {
                        Utils.modifyStatus(statusFile.getAbsolutePath(), Status.JOB_LOG_MSG_ERROR_TERMINATION.getName());
                    }
                } else {
                    Utils.modifyStatus(statusFile.getAbsolutePath(), Status.JOB_LOG_MSG_ERROR_TERMINATION.getName());
                }
            } else if (this.outputFileExist(Utils.getOutputFilePathOnHPC(runningJob, this.slurmJobProperty.getHpcServerLoginUserName(), this.workspaceDirectory, this.getHpcAddress(), this.slurmJobProperty.getOutputFileName().concat(this.slurmJobProperty.getOutputFileExtension())))) {
                try {
                    this.downloadFile(Utils.getOutputFilePathOnHPC(runningJob, this.slurmJobProperty.getHpcServerLoginUserName(), this.workspaceDirectory, this.getHpcAddress(), this.slurmJobProperty.getOutputFileName().concat(this.slurmJobProperty.getOutputFileExtension())), Utils.getJobOutputFilePathOnAgentPC(runningJob, this.workspaceDirectory, this.slurmJobProperty.getOutputFileName(), this.slurmJobProperty.getOutputFileExtension()));
                }
                catch (Exception e) {
                    Utils.modifyStatus(statusFile.getAbsolutePath(), Status.JOB_LOG_MSG_ERROR_TERMINATION.getName());
                }
            } else {
                Utils.modifyStatus(statusFile.getAbsolutePath(), Status.JOB_LOG_MSG_ERROR_TERMINATION.getName());
            }
            this.deleteJobOnHPC(Utils.getJobFolderPathOnHPC(runningJob, this.slurmJobProperty.getHpcServerLoginUserName(), this.workspaceDirectory, this.getHpcAddress()));
            return true;
        }
        return false;
    }

    private boolean outputFileExist(String fileAbsoultePath) throws JSchException, IOException {
        String command = "[ -f " + fileAbsoultePath + " ] && echo " + Status.JOB_OUTPUT_FILE_EXIST_MESSAGE.getName();
        ArrayList<String> outputs = this.executeCommand(command);
        return outputs != null && outputs.size() > 0 && outputs.contains(Status.JOB_OUTPUT_FILE_EXIST_MESSAGE.getName());
    }

    private void updateStatusForErrorTermination(File statusFile, String jobFolderPathOnAgentPC) throws IOException {
        if (Utils.isErrorTermination(jobFolderPathOnAgentPC)) {
            Utils.modifyStatus(statusFile.getAbsolutePath(), Status.JOB_LOG_MSG_ERROR_TERMINATION.getName());
        }
    }

    private boolean isJobRunning(File statusFile) throws JSchException, IOException, InterruptedException {
        String jobId = Utils.getJobId(statusFile.getAbsolutePath());
        if (jobId == null) {
            return false;
        }
        boolean isJobRunning = this.isJobRunning(jobId, statusFile);
        if (isJobRunning) {
            return true;
        }
        Utils.modifyStatus(statusFile.getAbsolutePath(), Status.STATUS_JOB_COMPLETED.getName());
        return false;
    }

    private boolean isJobRunning(String jobId, File statusFile) throws JSchException, IOException, InterruptedException {
        String command = "squeue -j " + jobId;
        ArrayList<String> outputs = this.executeCommand(command);
        boolean jobRunning = this.isJobRunning(outputs, statusFile);
        return jobRunning;
    }

    private boolean isJobRunning(ArrayList<String> outputs, File statusFile) throws IOException {
        if (outputs != null && outputs.size() <= 1) {
            return false;
        }
        if (outputs != null) {
            String[] headers = outputs.get(0).split("\\s+");
            String[] values = outputs.get(1).split("\\s+");
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].toLowerCase().equals("st") && values.length <= i) continue;
            }
        }
        return true;
    }

    private String getJobId(ArrayList<String> outputs) {
        for (String output : outputs) {
            String[] tokens;
            if (!output.contains("Submitted batch job") || (tokens = output.split(" ")).length < 4) continue;
            return tokens[3].trim();
        }
        return null;
    }

    private void deleteJobOnHPC(String jobFolder) throws JSchException, IOException, InterruptedException {
        String command = "rm -r " + jobFolder;
        this.executeCommand(command);
    }

    public ArrayList<String> readCommandOutput(BufferedReader br) throws IOException {
        String line;
        if (br == null) {
            throw new IOException("The reader is not initialised.");
        }
        ArrayList<String> outputs = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            outputs.add(line);
        }
        br.close();
        return outputs;
    }

    public void displayArray(ArrayList<String> list) {
        for (String item : list) {
            System.out.println(item);
        }
    }

    public void uploadFile(String src, String dest) throws JSchException, SftpException {
        System.out.println("Establishing a channel to transfer " + src + " to " + dest);
        ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
        sftpChannel.connect();
        sftpChannel.put(src, dest);
        sftpChannel.disconnect();
        System.out.println("Closing the channel.");
    }

    public void downloadFile(String src, String dest) throws JSchException, SftpException {
        System.out.println("Establishing a channel to transfer " + src + " to " + dest);
        ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
        sftpChannel.connect();
        sftpChannel.get(src, dest);
        sftpChannel.disconnect();
        System.out.println("Closing the channel.");
    }

    public void deleteFolderOrFile(String folderOrFileName) throws JSchException, SftpException, IOException {
        this.executeCommand("rm -r " + folderOrFileName);
    }

    public ArrayList<String> executeCommand(String Command2) throws JSchException, IOException {
        ArrayList<String> outputs = null;
        System.out.println("Establishing a channel to perform the following command:" + Command2);
        Channel execChannel = session.openChannel("exec");
        ((ChannelExec)execChannel).setCommand(Command2);
        execChannel.setInputStream(null);
        ((ChannelExec)execChannel).setErrStream(System.err);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(execChannel.getInputStream()));
        execChannel.connect();
        outputs = this.readCommandOutput(stdInput);
        execChannel.disconnect();
        System.out.println("Closing the channel.");
        return outputs;
    }

    public boolean hostAvailabilityCheck(String server, int port) throws IOException {
        boolean available = true;
        try {
            Socket dummy = new Socket(server, port);
            dummy.close();
        }
        catch (IllegalArgumentException | UnknownHostException e) {
            available = false;
        }
        return available;
    }

    static {
        jsch = new JSch();
        scheduledIteration = 0;
        jobsRunning = new HashSet<String>();
    }
}

