/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.scenario;

import java.net.URI;
import org.apache.http.client.methods.HttpGet;
import org.json.JSONObject;
import org.json.JSONStringer;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.query.AccessAgentCaller;
import uk.ac.cam.cares.jps.base.query.ResourcePathConverter;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;
import uk.ac.cam.cares.jps.base.scenario.ScenarioHelper;

public class ScenarioClient {
    public String call(String scenarioNameOrUrl, String scenarioAgentOperation, String jsonInputParams) {
        JSONObject jo = new JSONObject(jsonInputParams);
        jo.put("scenarioagentoperation", scenarioAgentOperation);
        String json = jo.toString();
        if (scenarioNameOrUrl.startsWith("http")) {
            String url = scenarioNameOrUrl + "/call";
            return AgentCaller.executeGetWithURLAndJSON(url, json);
        }
        String path = ScenarioHelper.getScenarioPath(scenarioNameOrUrl) + "/call";
        return AgentCaller.executeGetWithJsonParameter(path, json);
    }

    public String mockedOperation(String scenarioNameOrUrl, String shortOperationName, String jsonInputParams) {
        JSONObject jo = new JSONObject(jsonInputParams);
        String json = jo.toString();
        if (scenarioNameOrUrl.startsWith("http")) {
            String url = scenarioNameOrUrl + shortOperationName;
            return AgentCaller.executeGetWithURLAndJSON(url, json);
        }
        String path = ScenarioHelper.getScenarioPath(scenarioNameOrUrl) + shortOperationName;
        return AgentCaller.executeGetWithJsonParameter(path, json);
    }

    public String read(String scenarioNameOrUrl, String resourceUrl) {
        String json = new JSONStringer().object().key("scenarioresource").value(resourceUrl).endObject().toString();
        if (scenarioNameOrUrl.startsWith("http")) {
            String url = scenarioNameOrUrl + "/read";
            return AgentCaller.executeGetWithURLAndJSON(url, json);
        }
        String path = ScenarioHelper.getScenarioPath(scenarioNameOrUrl) + "/read";
        return AgentCaller.executeGetWithJsonParameter(path, json);
    }

    public String setOptionCopyOnRead(String scenarioNameOrUrl, boolean value) {
        return this.option(scenarioNameOrUrl, "copyonread", value);
    }

    private String option(String scenarioNameOrUrl, String key, Object value) {
        String json = new JSONStringer().object().key(key).value(value).endObject().toString();
        if (scenarioNameOrUrl.startsWith("http")) {
            String url = scenarioNameOrUrl + "/option";
            return AgentCaller.executeGetWithURLAndJSON(url, json);
        }
        String path = ScenarioHelper.getScenarioPath(scenarioNameOrUrl) + "/option";
        return AgentCaller.executeGetWithJsonParameter(path, json);
    }

    public URI getReadUrl(String scenarioUrl, String resourceUrl) {
        Object[] a = ScenarioClient.createRequestUrl(null, resourceUrl, false);
        String requestUrl = (String)a[0];
        JSONObject joparams = (JSONObject)a[1];
        HttpGet get = Http.get(requestUrl, null, joparams);
        return get.getURI();
    }

    public String query(String scenarioUrl, String resourceUrl, String sparqlQuery) {
        String json = new JSONStringer().object().key("scenarioresource").value(resourceUrl).key("sparqlquery").value(sparqlQuery).endObject().toString();
        String url = scenarioUrl + "/query";
        return AgentCaller.executeGetWithURLAndJSON(url, json);
    }

    public static Object[] createRequestUrl(String datasetUrl, String targetUrl, boolean targetHasSparqlAbility) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        String requestUrl = null;
        if (datasetUrl != null && datasetUrl.isEmpty()) {
            datasetUrl = null;
        }
        if (scenarioUrl != null || datasetUrl != null || targetHasSparqlAbility) {
            String resource;
            JSONObject joparams = null;
            if (scenarioUrl != null) {
                joparams = new JSONObject();
                resource = AccessAgentCaller.cutHashFragment(targetUrl);
                joparams.put("scenarioresource", resource);
                if (datasetUrl != null) {
                    if (targetUrl == null) {
                        joparams.put("scenarioresource", datasetUrl);
                    } else {
                        joparams.put("dataset", datasetUrl);
                    }
                }
                requestUrl = scenarioUrl;
            } else if (datasetUrl != null) {
                joparams = new JSONObject();
                resource = AccessAgentCaller.cutHashFragment(targetUrl);
                joparams.put("scenarioresource", resource);
                requestUrl = datasetUrl;
            } else {
                requestUrl = AccessAgentCaller.cutHashFragment(targetUrl);
            }
            requestUrl = ResourcePathConverter.convert(requestUrl);
            Object[] a = new Object[]{requestUrl, joparams};
            return a;
        }
        return null;
    }
}

