/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.jena.arq.querybuilder.ConstructBuilder;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class LocalStoreClient
implements StoreClientInterface {
    private static Logger LOGGER = LogManager.getLogger(LocalStoreClient.class);
    protected Dataset dataset;
    protected RDFConnection conn;
    protected String query;

    public LocalStoreClient() {
        this.init();
        LOGGER.info("LocalStoreClient instantiated.");
    }

    public LocalStoreClient(String query) {
        this.init();
        this.query = query;
        LOGGER.info("LocalStoreClient instantiated with query.");
    }

    protected void init() {
        this.dataset = DatasetFactory.create();
        this.conn = RDFConnectionFactory.connect(this.dataset);
    }

    public boolean isConnected() {
        return !this.conn.isClosed();
    }

    public boolean isEmpty() {
        if (!this.isConnected()) {
            return true;
        }
        return this.dataset.isEmpty();
    }

    @Override
    public int executeUpdate() {
        LOGGER.info("SPARQL update with query variable.");
        return this.executeUpdate(this.query);
    }

    @Override
    public int executeUpdate(String update) {
        try {
            LOGGER.info("Executing SPARQL update.");
            this.conn.begin(TxnType.WRITE);
            this.conn.update(update);
            this.conn.commit();
        }
        finally {
            this.conn.end();
        }
        return 0;
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        LOGGER.info("SPARQL update with argument.");
        return this.executeUpdate(update.toString());
    }

    @Override
    public String execute() {
        LOGGER.info("SPARQL query with query variable.");
        return this.execute(this.query);
    }

    @Override
    public String execute(String query) {
        LOGGER.info("SPARQL query with query as argument.");
        JSONArray result = this.executeQuery(query);
        return result.toString();
    }

    @Override
    public JSONArray executeQuery(String sparql) {
        LOGGER.info("SPARQL query with query as argument.");
        ResultSet results = this.performExecuteQuery(sparql);
        return this.convert(results);
    }

    @Override
    public JSONArray executeQuery() {
        LOGGER.info("SPARQL query with query variable.");
        return this.executeQuery(this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet performExecuteQuery(String sparql) {
        try {
            ResultSet results;
            LOGGER.info("Executing SPARQL query.");
            this.conn.begin(TxnType.READ);
            QueryExecution queryExec = this.conn.query(sparql);
            ResultSet resultSet = results = queryExec.execSelect();
            return resultSet;
        }
        finally {
            this.conn.end();
        }
    }

    protected JSONArray convert(ResultSet resultSet) {
        JSONArray json = new JSONArray();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            JSONObject obj = new JSONObject();
            Iterator<String> it = qs.varNames();
            while (it.hasNext()) {
                String var = it.next();
                RDFNode node = qs.get(var);
                if (node.isLiteral()) {
                    obj.put(var, node.asLiteral().getValue());
                    continue;
                }
                obj.put(var, node);
            }
            json.put(obj);
        }
        return json;
    }

    @Override
    public Model executeConstruct(Query sparql) {
        return this.executeConstruct(sparql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model executeConstruct(String sparql) {
        try {
            Model results;
            LOGGER.info("Executing SPARQL construct query.");
            this.conn.begin(TxnType.READ);
            QueryExecution queryExec = this.conn.query(sparql);
            Model model = results = queryExec.execConstruct();
            return model;
        }
        finally {
            this.conn.end();
        }
    }

    @Override
    public String get(String resourceUrl, String accept) {
        LOGGER.info("Executing GET resourceURL=" + resourceUrl);
        Var varS = Var.alloc("s");
        Var varP = Var.alloc("p");
        Var varO = Var.alloc("o");
        ConstructBuilder builder = new ConstructBuilder().addConstruct(varS, varP, varO);
        if (resourceUrl == null) {
            builder.addWhere(varS, varP, varO);
        } else {
            String graphURI = "<" + resourceUrl + ">";
            builder.addGraph(graphURI, varS, varP, varO);
        }
        Model model = this.executeConstruct(builder.build());
        Lang syntax = accept != null ? RDFLanguages.contentTypeToLang(accept) : Lang.RDFXML;
        LOGGER.info("GET accept lang=" + syntax.toString());
        StringWriter out = new StringWriter();
        model.write(out, syntax.getName());
        return out.toString();
    }

    @Override
    public void insert(String graphName, String content, String contentType) {
        LOGGER.info("Executing INSERT graph=" + graphName + " , contentType=" + contentType);
        Model model = ModelFactory.createDefaultModel();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        if (contentType == null) {
            LOGGER.info("Assuming default content type RDF/XML");
            model.read(in, null);
        } else {
            Lang syntax = RDFLanguages.contentTypeToLang(contentType);
            LOGGER.debug("Content type: " + syntax.getName());
            model.read(in, null, syntax.getName());
        }
        UpdateBuilder builder = new UpdateBuilder();
        if (graphName == null) {
            LOGGER.debug("Create insert for default graph");
            builder.addInsert(model);
        } else {
            LOGGER.debug("Create insert for namde graph: " + graphName);
            String graphURI = "<" + graphName + ">";
            builder.addInsert((Object)graphURI, model);
        }
        this.executeUpdate(builder.buildRequest());
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getQueryEndpoint() {
        return null;
    }

    @Override
    public String setQueryEndpoint(String queryEndpoint) {
        return null;
    }

    @Override
    public String getUpdateEndpoint() {
        return null;
    }

    @Override
    public String setUpdateEndpoint(String updateEndpoint) {
        return null;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public void setUser(String userName) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String password) {
    }
}

