/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.scenario.BucketHelper;
import uk.ac.cam.cares.jps.base.scenario.JenaReadHook;
import uk.ac.cam.cares.jps.base.scenario.ScenarioClient;

public class JenaHelper {
    public static OntModel createModel(String path) {
        String scenarioUrl;
        if (path.startsWith("http") && !BucketHelper.isBaseScenario(scenarioUrl = BucketHelper.getScenarioUrl())) {
            path = new ScenarioClient().getReadUrl(scenarioUrl, path).toString();
        }
        OntModel result = JenaHelper.createModel();
        JenaHelper.read(path, result);
        return result;
    }

    public static OntModel createModel() {
        JenaReadHook.prepareReadHook();
        return ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
    }

    public static void read(String path, OntModel model) {
        try {
            URL url = new URL(path);
            JenaHelper.readFromUrl(url, model);
            return;
        }
        catch (MalformedURLException url) {
            File file = new File(path);
            if (file.isFile()) {
                JenaHelper.readFromFile(file, model);
            } else {
                for (File current : file.listFiles()) {
                    JenaHelper.readFromFile(current, model);
                }
            }
            return;
        }
    }

    public static void readFromUrl(URL url, OntModel model) {
        try {
            InputStream is = url.openStream();
            JenaHelper.read(is, model);
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static void readFromFile(File owlFile, OntModel model) {
        try {
            if (owlFile.isFile() && owlFile.getName().endsWith(".owl")) {
                FileInputStream is = new FileInputStream(owlFile);
                JenaHelper.read(is, model);
            }
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static void readFromString(String s, OntModel model) {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        JenaHelper.read(is, model);
    }

    public static void read(InputStream is, OntModel model) {
        try {
            model.read(is, null);
            is.close();
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static ResultSet query(OntModel model, String sparql) {
        Query query = QueryFactory.create(sparql);
        QueryExecution queryExec = QueryExecutionFactory.create(query, (Model)model);
        ResultSet rs = queryExec.execSelect();
        ResultSetRewindable results = ResultSetFactory.copyResults(rs);
        return results;
    }

    public static ResultSet queryFile(String file, String sparql) {
        OntModel model = JenaHelper.createModel();
        JenaHelper.readFromFile(new File(file), model);
        ResultSet resultSet = JenaHelper.query(model, sparql);
        return resultSet;
    }

    public static ResultSet queryUrl(String url, String sparql) {
        OntModel model = JenaHelper.createModel();
        try {
            JenaHelper.readFromUrl(new URL(url), model);
        }
        catch (MalformedURLException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        ResultSet resultSet = JenaHelper.query(model, sparql);
        return resultSet;
    }

    public static ResultSet queryInputStream(InputStream is, String sparql) {
        OntModel model = JenaHelper.createModel();
        JenaHelper.read(is, model);
        ResultSet resultSet = JenaHelper.query(model, sparql);
        return resultSet;
    }

    public static void writeAsFile(Model model, String path) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        model.write(fos, "RDF/XML-ABBREV");
    }

    public static String writeToString(Model model) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        model.write(os, "RDF/XML-ABBREV");
        return new String(os.toByteArray());
    }
}

