/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final NumberFormat FORMAT_DOUBLE = new DecimalFormat("#,##0.00");
    private static final NumberFormat FORMAT_LONG = new DecimalFormat("#,###");
    private static final Runtime RUNTIME = Runtime.getRuntime();

    private Util() {
    }

    public static String format(double d) {
        StringBuffer s = new StringBuffer();
        return FORMAT_DOUBLE.format(d, s, new FieldPosition(0)).toString();
    }

    public static String format(long l) {
        StringBuffer s = new StringBuffer();
        return FORMAT_LONG.format(l, s, new FieldPosition(0)).toString();
    }

    public static String formatSize(long l) {
        if (l >= 1000000000000L) {
            return Util.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Util.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Util.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Util.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Util.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Util.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Util.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Util.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static boolean log4JIsConfigured() {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public static void ensureLog4JIsConfigured(Class<?> klass) {
        Util.ensureLog4JIsConfigured(klass, Level.INFO);
    }

    public static void ensureLog4JIsConfigured(Class<?> klass, Level level) {
        if (!Util.log4JIsConfigured()) {
            System.err.println("WARNING: " + (klass != null ? klass.getSimpleName() + " is" : "We are") + " autoconfiguring Log4J (level: " + level + "). You should configure Log4J properly instead.");
            BasicConfigurator.configure();
            LogManager.getRootLogger().setLevel(level);
        }
    }

    public static void ensureLog4JIsConfigured() {
        Util.ensureLog4JIsConfigured(null, Level.INFO);
    }

    public static void ensureLog4JIsConfigured(Level level) {
        Util.ensureLog4JIsConfigured(null, level);
    }

    public static Logger getLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass);
        return logger;
    }

    public static Logger getDebugLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Util.ensureLog4JIsConfigured(klass, Level.DEBUG);
        return logger;
    }

    public static boolean memoryIsLow() {
        return Util.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Util.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }
}

