/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.Iterator;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.arq.querybuilder.rewriters.ExprRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementFind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;

public class ElementRewriter
extends AbstractRewriter<Element>
implements ElementVisitor {
    public ElementRewriter(Map<Var, Node> values) {
        super(values);
    }

    public void visit(ElementTriplesBlock el) {
        ElementTriplesBlock newBlock = new ElementTriplesBlock();
        Iterator tIter = el.patternElts();
        while (tIter.hasNext()) {
            newBlock.addTriple(this.rewrite((Triple)tIter.next()));
        }
        this.push(newBlock);
    }

    public void visit(ElementPathBlock el) {
        ElementPathBlock newBlock = new ElementPathBlock();
        Iterator tIter = el.patternElts();
        while (tIter.hasNext()) {
            newBlock.addTriplePath(this.rewrite((TriplePath)tIter.next()));
        }
        this.push(newBlock);
    }

    public void visit(ElementFilter el) {
        ExprRewriter exprRewriter = new ExprRewriter(this.values);
        el.getExpr().visit((ExprVisitor)exprRewriter);
        this.push(new ElementFilter((Expr)exprRewriter.getResult()));
    }

    public void visit(ElementAssign el) {
        Node n = this.changeNode((Node)el.getVar());
        if (n.equals((Object)el.getVar())) {
            ExprRewriter exprRewriter = new ExprRewriter(this.values);
            el.getExpr().visit((ExprVisitor)exprRewriter);
            this.push(new ElementAssign(el.getVar(), (Expr)exprRewriter.getResult()));
        } else {
            this.push(new ElementTriplesBlock());
        }
    }

    public void visit(ElementBind el) {
        Node n = this.changeNode((Node)el.getVar());
        if (n.equals((Object)el.getVar())) {
            ExprRewriter exprRewriter = new ExprRewriter(this.values);
            el.getExpr().visit((ExprVisitor)exprRewriter);
            this.push(new ElementBind(el.getVar(), (Expr)exprRewriter.getResult()));
        } else {
            this.push(new ElementTriplesBlock());
        }
    }

    public void visit(ElementFind el) {
        Node n = this.changeNode((Node)el.getVar());
        Triple triple = this.rewrite(el.getTriple());
        if (n.equals((Object)el.getVar())) {
            this.push(new ElementFind(Var.alloc((Node)n), triple));
        } else {
            ElementTriplesBlock etb = new ElementTriplesBlock();
            etb.addTriple(triple);
            this.push(etb);
        }
    }

    public void visit(ElementData el) {
        ElementData retval = new ElementData();
        for (Var v : el.getVars()) {
            retval.add(v);
        }
        for (Binding binding : el.getRows()) {
            retval.add(binding);
        }
        this.push(retval);
    }

    public void visit(ElementUnion el) {
        ElementUnion retval = new ElementUnion();
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
            retval.addElement((Element)this.getResult());
        }
        this.push(retval);
    }

    public void visit(ElementOptional el) {
        el.getOptionalElement().visit((ElementVisitor)this);
        this.push(new ElementOptional((Element)this.getResult()));
    }

    public void visit(ElementGroup el) {
        ElementGroup retval = new ElementGroup();
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
            retval.addElement((Element)this.getResult());
        }
        this.push(retval);
    }

    public void visit(ElementDataset el) {
        Element pattern = null;
        if (el.getElement() != null) {
            el.getElement().visit((ElementVisitor)this);
            pattern = (Element)this.getResult();
        }
        this.push(new ElementDataset(el.getDataset(), pattern));
    }

    public void visit(ElementNamedGraph el) {
        Node n = el.getGraphNameNode();
        if (n != null) {
            n = this.changeNode(n);
        }
        el.getElement().visit((ElementVisitor)this);
        this.push(new ElementNamedGraph(n, (Element)this.getResult()));
    }

    public void visit(ElementExists el) {
        el.getElement().visit((ElementVisitor)this);
        this.push(new ElementExists((Element)this.getResult()));
    }

    public void visit(ElementNotExists el) {
        el.getElement().visit((ElementVisitor)this);
        this.push(new ElementNotExists((Element)this.getResult()));
    }

    public void visit(ElementMinus el) {
        el.getMinusElement().visit((ElementVisitor)this);
        this.push(new ElementMinus((Element)this.getResult()));
    }

    public void visit(ElementService el) {
        el.getElement().visit((ElementVisitor)this);
        this.push(new ElementService(this.changeNode(el.getServiceNode()), (Element)this.getResult(), el.getSilent()));
    }

    public void visit(ElementSubQuery el) {
        Query q = AbstractQueryBuilder.clone(el.getQuery());
        this.push(new ElementSubQuery(AbstractQueryBuilder.rewrite(q, this.values)));
    }
}

