# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['StepType', 'fastrl_make_requirements', 'add_namedtuple_doc', 'SimpleStep', 'test_in', 'test_len', 'test_lt',
           'run_tensorboard']

# %% ../nbs/00_core.ipynb 2
# Python native modules
import os,warnings,logging,typing
# Third party libs
from fastcore.all import *
from fastai.torch_core import *
from fastai.basics import *
from torch.utils.tensorboard import SummaryWriter
import pandas as pd
import torch
import numpy as np
# Local modules

_logger = logging.getLogger()
_li = _logger.info

# %% ../nbs/00_core.ipynb 5
@call_parse
def fastrl_make_requirements(
    path:Path=None, # The path to a dir with the settings.ini, if none, cwd.
    project_file:str='settings.ini', # The file to load for reading the requirements
    out_path:Path=None # The output path (can be relative to `path`)
):
    logging.basicConfig()
    requirement_types = ['','dev_','pip_']
    path = ifnone(path, Path.cwd())/project_file

    if not path.exists(): raise OSError(f'File {path} does not exist')

    out_path = ifnone(out_path, Path('extra'))
    out_path = out_path if out_path.is_absolute() else path.parent/out_path
    out_path.mkdir(parents=True, exist_ok=True)
    _li('Outputting to path: %s',out_path)
    config = Config(path.parent,path.name)

    for req in requirement_types:
        requirements = config[req+'requirements']

        requirements = requirements.replace(' ','\n')

        Path(out_path/(req+'requirements.txt')).write_text(requirements)

# %% ../nbs/00_core.ipynb 6
def _fmt_fld(t:typing.Tuple[str,type],namedtuple):
    default_v = ''
    if t[0] in namedtuple._field_defaults:
        default_v = f' = `{namedtuple._field_defaults[t[0]]}`'
    return ' - **%s**:`%s` '%t+default_v+getattr(namedtuple,t[0]).__doc__

def add_namedtuple_doc(
    t:typing.NamedTuple, # Primary tuple to get docs from
    doc:str, # Primary doc for the overall tuple, where the docs for individual fields will be concated.
    **fields_docs:dict # Field names with associated docs to be attached in the format: field_a='some documentation'
):
    "Add docs to `t` from `doc` along with individual doc fields `fields_docs`"
    if not hasattr(t,'__base_doc__'): t.__base_doc__ = doc
    for k,v in fields_docs.items(): getattr(t,k).__doc__ = v
    # TODO: can we add optional default fields also?
    flds = L(t.__annotations__.items()).map(_fmt_fld,namedtuple=t)
    
    s = 'Parameters:\n'+'\n'.join(flds)
    t.__doc__ = doc + '\n\n' + s    

# %% ../nbs/00_core.ipynb 7
class SimpleStep(typing.NamedTuple):
    state:       torch.FloatTensor=torch.FloatTensor([0])
    action:      torch.FloatTensor=torch.FloatTensor([0])
    next_state:  torch.FloatTensor=torch.FloatTensor([0])
    terminated:  torch.BoolTensor=torch.BoolTensor([1])
    truncated:   torch.BoolTensor=torch.BoolTensor([1])
    reward:      torch.FloatTensor=torch.LongTensor([0])
    total_reward:torch.FloatTensor=torch.FloatTensor([0])
    env_id:      torch.LongTensor=torch.LongTensor([0])
    proc_id:     torch.LongTensor=torch.LongTensor([0])
    step_n:      torch.LongTensor=torch.LongTensor([0])
    episode_n:   torch.LongTensor=torch.LongTensor([0])
    image:       torch.FloatTensor=torch.FloatTensor([0])
    
    @classmethod
    def random(cls,seed=None,**flds):
        _flds,_annos = cls._fields,cls.__annotations__

        def _random_annos(anno):
            t = anno(1)
            if anno==torch.BoolTensor: t.random_(2) 
            else:                      t.random_(100)
            return t

        return cls(
            *(flds.get(
                f,_random_annos(_annos[f])
            ) for f in _flds)
        )

add_namedtuple_doc(
    SimpleStep,
    'Represents a single step in an environment.',
    state = 'Both the initial state of the environment and the previous state.',
    next_state = 'Both the next state, and the last state in the environment',
    terminated = """Represents an ending condition for an environment such as reaching a goal or 'living long enough' as 
                    described by the MDP.
                    Good reference is: https://github.com/openai/gym/blob/39b8661cb09f19cb8c8d2f59b57417517de89cb0/gym/core.py#L151-L155""",
    truncated = """Represents an ending condition for an environment that can be seen as an out of bounds condition either
                   literally going out of bounds, breaking rules, or exceeding the timelimit allowed by the MDP.
                   Good reference is: https://github.com/openai/gym/blob/39b8661cb09f19cb8c8d2f59b57417517de89cb0/gym/core.py#L151-L155'""",
    reward = 'The single reward for this step.',
    total_reward = 'The total accumulated reward for this episode up to this step.',
    action = 'The action that was taken to transition from `state` to `next_state`',
    env_id = 'The environment this step came from (useful for debugging)',
    proc_id = 'The process this step came from (useful for debugging)',
    step_n = 'The step number in a given episode.',
    episode_n = 'The episode this environment is currently running through.',
    image = """Intended for display and logging only. If the intention is to use images for training an
               agent, then use a env wrapper instead."""
)

# %% ../nbs/00_core.ipynb 12
StepType = (SimpleStep,)

# %% ../nbs/00_core.ipynb 30
def test_in(a,b):
    "`test` that `a in b`"
    test(a,b,in_, ' in ')

# %% ../nbs/00_core.ipynb 32
def _len_check(a,b): 
    return len(a)==(len(b) if not isinstance(b,int) else b)

def test_len(a,b,meta_info=''):
    "`test` that `len(a) == int(b) or len(a) == len(b)`"
    test(a,b,_len_check, f' len == len {meta_info}')

# %% ../nbs/00_core.ipynb 34
def _less_than(a,b): return a < b
def test_lt(a,b):
    "`test` that `a < b`"
    test(a,b,_less_than, ' a < b')

# %% ../nbs/00_core.ipynb 37
def run_tensorboard(port=6006, # The port to run tensorboard on/connect on
                    start_tag=None, # Starting regex e.g.: experience_replay/1
                    samples_per_plugin=None, # Sampling freq such as  images=0 (keep all)
                    extra_args=None, # Any additional arguments in the `--arg value` format
                    rm_glob=None # Remove old logs via a parttern e.g.: '*' will remove all files: runs/* 
                   ):
    if rm_glob is not None:
        for p in Path('runs').glob(rm_glob): p.delete()
    import socket
    from tensorboard import notebook
    a_socket=socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    cmd=None
    if not a_socket.connect_ex(('127.0.0.1',6006)):
        notebook.display(port=port,height=1000)
    else:
        cmd=f'--logdir runs --port {port} --host=0.0.0.0'
        if samples_per_plugin is not None: cmd+=f' --samples_per_plugin {samples_per_plugin}'
        if start_tag is not None:          cmd+=f' --tag {start_tag}'
        if extra_args is not None:         cmd+=f' {extra_args}'
        notebook.start(cmd)
    return cmd
