#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['cilantropy']

package_data = \
{'': ['*'],
 'cilantropy': ['static/*',
                'static/css/*',
                'static/css/redmond/*',
                'static/css/redmond/images/*',
                'templates/*',
                'tests/*']}

install_requires = \
['Flask>=1.1.2',
 'colorama>=0.4.3',
 'docopt>=0.6.2',
 'docutils>=0.16',
 'jinja2>=2.11.2']

extras_require = \
{'dev': ['flit>=2,<4'], 'test': ['nose'], 'uwsgi': ['uWSGI>=2.0.19.1']}

entry_points = \
{'console_scripts': ['cilantropy = cilantropy.__main__:run_main',
                     'plp = cilantropy.console:run_main']}

setup(name='cilantropy',
      version='0.2.1',
      description='Cilantropy is a Python Package Manager interface created to provide an "easy-to-use" visual and also a command-line interface for Pythonistas.',
      author='Tkachenko Igor',
      author_email='foozzione@gmail.com',
      url='https://github.com/foozzi/cilantropy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3',
     )
