# OptionsConfig

Unified configuration management for Python applications. Define your configuration schema once, use it everywhere.

[![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

## Features

- **📋 Single Schema Definition** - Define configuration options once in a typed schema
- **📚 Generate Documentation** - Create `.env.example` and README sections automatically
- **🔗 Dependency Management** - Define relationships between configuration options
- **📦 TOML Configuration** - Load schema from `pyproject.toml` for cleaner code

## Requirements
- Python >= 3.8

## Installation
```bash
pip install optionsconfig
```

## Usage
See both [examples](examples) and their respective documentation. Each can also be used to test the installation.
* [examples/direct-pass/DIRECT_PASS.md](examples/direct-pass/DIRECT_PASS.md)
* [examples/toml/TOML.md](examples/toml/TOML.md)
  
## License

MIT License - see [LICENSE](LICENSE)  for details

## Contributing

Contributions welcome! TODO

## Schema
- **[Schema](SCHEMA.md)** - Detailed information on schema configuration

## Links

- **Repository**: https://github.com/Surxe/OptionsConfig
- **Issues**: https://github.com/Surxe/OptionsConfig/issues