#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time         : 2019/4/29 23:20
# @File           : ZhihuModel
# @Des           : 
# @Email        : billsteve@126.com
from XX.Model.SqlAlchemy.BaseModel import *
from sqlalchemy import Column, String, TIMESTAMP, text
from sqlalchemy.dialects.mysql import INTEGER, LONGTEXT
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class Answer(Base, BaseModel):
    __tablename__ = 'answer'

    id = Column(INTEGER(11), primary_key=True)
    web_id = Column(String(255))
    type = Column(String(255))
    excerpt = Column(String(255))
    url = Column(String(255))
    voteupCount = Column(INTEGER(11))
    commentCount = Column(INTEGER(11))
    createdTime = Column(INTEGER(11))
    updatedTime = Column(INTEGER(11))
    content = Column(String(255))
    thumbnailInfo = Column(LONGTEXT)
    relationship = Column(LONGTEXT)
    question_web_id = Column(LONGTEXT)
    author_web_id = Column(LONGTEXT)
    flag = Column(String(255))
    attachedInfoBytes = Column(String(255))
    is_del = Column(INTEGER(11))
    create_ts = Column(INTEGER(11))
    update_ts = Column(INTEGER(11))

    def __init__(self, *arg, **kw):
        self.attachedInfoBytes = kw.get("attachedInfoBytes", None)
        self.author_web_id = kw.get("author_web_id", None)
        self.commentCount = kw.get("commentCount", None)
        self.content = kw.get("content", None)
        self.create_ts = kw.get("create_ts", None)
        self.createdTime = kw.get("createdTime", None)
        self.excerpt = kw.get("excerpt", None)
        self.flag = kw.get("flag", None)
        self.id = kw.get("id", None)
        self.is_del = kw.get("is_del", None)
        self.metadata = kw.get("metadata", None)
        self.question_web_id = kw.get("question_web_id", None)
        self.relationship = kw.get("relationship", None)
        self.thumbnailInfo = kw.get("thumbnailInfo", None)
        self.type = kw.get("type", None)
        self.update_ts = kw.get("update_ts", None)
        self.updatedTime = kw.get("updatedTime", None)
        self.url = kw.get("url", None)
        self.voteupCount = kw.get("voteupCount", None)
        self.web_id = kw.get("web_id", None)


class Article(Base, BaseModel):
    __tablename__ = 'article'

    id = Column(INTEGER(11), primary_key=True)
    web_id = Column(String(255))
    title = Column(String(255))
    type = Column(String(255))
    url = Column(String(255))
    excerpt = Column(String(255))
    voteupCount = Column(INTEGER(11))
    commentCount = Column(INTEGER(11))
    createdTime = Column(INTEGER(11))
    updatedTime = Column(INTEGER(11))
    content = Column(String(255))
    thumbnailInfo = Column(LONGTEXT)
    author_web_id = Column(LONGTEXT)
    voting = Column(INTEGER(11))
    relationship = Column(LONGTEXT)
    flag = Column(String(255))
    attachedInfoBytes = Column(String(255))
    is_del = Column(INTEGER(11))
    create_ts = Column(INTEGER(11))
    update_ts = Column(INTEGER(11))

    def __init__(self, *arg, **kw):
        self.attachedInfoBytes = kw.get("attachedInfoBytes", None)
        self.author_web_id = kw.get("author_web_id", None)
        self.commentCount = kw.get("commentCount", None)
        self.content = kw.get("content", None)
        self.create_ts = kw.get("create_ts", None)
        self.createdTime = kw.get("createdTime", None)
        self.excerpt = kw.get("excerpt", None)
        self.flag = kw.get("flag", None)
        self.id = kw.get("id", None)
        self.is_del = kw.get("is_del", None)
        self.metadata = kw.get("metadata", None)
        self.relationship = kw.get("relationship", None)
        self.thumbnailInfo = kw.get("thumbnailInfo", None)
        self.title = kw.get("title", None)
        self.type = kw.get("type", None)
        self.update_ts = kw.get("update_ts", None)
        self.updatedTime = kw.get("updatedTime", None)
        self.url = kw.get("url", None)
        self.voteupCount = kw.get("voteupCount", None)
        self.voting = kw.get("voting", None)
        self.web_id = kw.get("web_id", None)


class Topic(Base, BaseModel):
    __tablename__ = 'topic'

    id = Column(INTEGER(11), primary_key=True)
    unansweredCount = Column(INTEGER(11))
    bestAnswerersCount = Column(INTEGER(11))
    isBlack = Column(String(255))
    relationship = Column(LONGTEXT)
    isIndexVisible = Column(String(255))
    excerpt = Column(String(255))
    isVote = Column(String(255))
    isIndexEditable = Column(String(255))
    meta_web_id = Column(String(255))
    isFollowing = Column(String(255))
    web_id = Column(String(255))
    questionsCount = Column(INTEGER(11))
    category = Column(String(255))
    name = Column(String(255))
    introduction = Column(String(255))
    fatherCount = Column(INTEGER(11))
    headerCard = Column(LONGTEXT)
    url = Column(String(255))
    followersCount = Column(INTEGER(11))
    avatarUrl = Column(String(255))
    bestAnswersCount = Column(INTEGER(11))
    type = Column(String(255))
    is_del = Column(INTEGER(11), server_default=text("'0'"))
    create_ts = Column(INTEGER(11))
    update_ts = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))

    def __init__(self, *arg, **kw):
        self.avatarUrl = kw.get("avatarUrl", None)
        self.bestAnswerersCount = kw.get("bestAnswerersCount", None)
        self.bestAnswersCount = kw.get("bestAnswersCount", None)
        self.category = kw.get("category", None)
        self.create_ts = kw.get("create_ts", None)
        self.excerpt = kw.get("excerpt", None)
        self.fatherCount = kw.get("fatherCount", None)
        self.followersCount = kw.get("followersCount", None)
        self.headerCard = kw.get("headerCard", None)
        self.id = kw.get("id", None)
        self.introduction = kw.get("introduction", None)
        self.isBlack = kw.get("isBlack", None)
        self.isFollowing = kw.get("isFollowing", None)
        self.isIndexEditable = kw.get("isIndexEditable", None)
        self.isIndexVisible = kw.get("isIndexVisible", None)
        self.isVote = kw.get("isVote", None)
        self.is_del = kw.get("is_del", None)
        self.meta_web_id = kw.get("meta_web_id", None)
        self.metadata = kw.get("metadata", None)
        self.name = kw.get("name", None)
        self.questionsCount = kw.get("questionsCount", None)
        self.relationship = kw.get("relationship", None)
        self.type = kw.get("type", None)
        self.unansweredCount = kw.get("unansweredCount", None)
        self.update_ts = kw.get("update_ts", None)
        self.url = kw.get("url", None)
        self.web_id = kw.get("web_id", None)


class User(Base, BaseModel):
    __tablename__ = 'users'

    id = Column(INTEGER(11), primary_key=True)
    avatarUrl = Column(String(255))
    badge = Column(LONGTEXT)
    gender = Column(INTEGER(11))
    headline = Column(String(255))
    web_id = Column(String(255))
    isFollowed = Column(String(255))
    isFollowing = Column(String(255))
    name = Column(String(255))
    type = Column(String(255))
    url = Column(String(255))
    urlToken = Column(String(255))
    userType = Column(String(255))
    is_del = Column(INTEGER(11))
    create_ts = Column(INTEGER(11))
    update_ts = Column(INTEGER(11))

    def __init__(self, *arg, **kw):
        self.avatarUrl = kw.get("avatarUrl", None)
        self.badge = kw.get("badge", None)
        self.create_ts = kw.get("create_ts", None)
        self.gender = kw.get("gender", None)
        self.headline = kw.get("headline", None)
        self.id = kw.get("id", None)
        self.isFollowed = kw.get("isFollowed", None)
        self.isFollowing = kw.get("isFollowing", None)
        self.is_del = kw.get("is_del", None)
        self.metadata = kw.get("metadata", None)
        self.name = kw.get("name", None)
        self.type = kw.get("type", None)
        self.update_ts = kw.get("update_ts", None)
        self.url = kw.get("url", None)
        self.urlToken = kw.get("urlToken", None)
        self.userType = kw.get("userType", None)
        self.web_id = kw.get("web_id", None)


class WikiBox(Base, BaseModel):
    __tablename__ = 'wiki_box'

    id = Column(INTEGER(11), primary_key=True)
    web_id = Column(String(255))
    name = Column(String(255))
    url = Column(String(255))
    type = Column(String(255))
    excerpt = Column(String(255))
    introduction = Column(String(255))
    description = Column(String(255))
    avatarUrl = Column(String(255))
    isFollowing = Column(String(255))
    questionsCount = Column(INTEGER(11))
    followersCount = Column(INTEGER(11))
    followerCount = Column(INTEGER(11))
    topAnswerCount = Column(INTEGER(11))
    score = Column(INTEGER(11))
    aliases = Column(LONGTEXT)
    hasMeta = Column(String(255))
    meta_web_id = Column(LONGTEXT)
    attachedInfoBytes = Column(String(255))
    wikiType = Column(String(255))
    discussionCount = Column(INTEGER(11))
    hasIndexSection = Column(String(255))
    essenceFeedCount = Column(INTEGER(11))
    contentEssenceList = Column(LONGTEXT)
    extraContentEssenceList = Column(LONGTEXT)
    is_del = Column(INTEGER(11))
    create_ts = Column(INTEGER(11))
    update_ts = Column(INTEGER(11))

    def __init__(self, *arg, **kw):
        self.aliases = kw.get("aliases", None)
        self.attachedInfoBytes = kw.get("attachedInfoBytes", None)
        self.avatarUrl = kw.get("avatarUrl", None)
        self.contentEssenceList = kw.get("contentEssenceList", None)
        self.create_ts = kw.get("create_ts", None)
        self.description = kw.get("description", None)
        self.discussionCount = kw.get("discussionCount", None)
        self.essenceFeedCount = kw.get("essenceFeedCount", None)
        self.excerpt = kw.get("excerpt", None)
        self.extraContentEssenceList = kw.get("extraContentEssenceList", None)
        self.followerCount = kw.get("followerCount", None)
        self.followersCount = kw.get("followersCount", None)
        self.hasIndexSection = kw.get("hasIndexSection", None)
        self.hasMeta = kw.get("hasMeta", None)
        self.id = kw.get("id", None)
        self.introduction = kw.get("introduction", None)
        self.isFollowing = kw.get("isFollowing", None)
        self.is_del = kw.get("is_del", None)
        self.meta_web_id = kw.get("meta_web_id", None)
        self.metadata = kw.get("metadata", None)
        self.name = kw.get("name", None)
        self.questionsCount = kw.get("questionsCount", None)
        self.score = kw.get("score", None)
        self.topAnswerCount = kw.get("topAnswerCount", None)
        self.type = kw.get("type", None)
        self.update_ts = kw.get("update_ts", None)
        self.url = kw.get("url", None)
        self.web_id = kw.get("web_id", None)
        self.wikiType = kw.get("wikiType", None)


if __name__ == '__main__':
    createInitFunction(NewsSearch)
