# AUTOGENERATED! DO NOT EDIT! File to edit: index.ipynb (unless otherwise specified).

__all__ = ['get_repo', 'get_issues', 'brokenlink_issue']

# Cell
from github import Github, UnknownObjectException, Repository
from fastlinkcheck import link_check
from fastcore.all import *

# Cell
def get_repo(repo:str=None, token=None) -> Repository:
    "Get a `Repository` object.  Optionally supply a `token` for private repositories."
    repo=ifnone(repo, os.getenv('GITHUB_REPOSITORY'))
    assert repo, 'You must specify the repo parameter or set the `GITHUB_REPOSITORY` the environment variable.'
    try:
        return Github(token).get_repo(repo)
    except UnknownObjectException as e:
        raise Exception(f'Repo: `{repo}` not found. If this is a private repo make sure you provide an appropriate token\n {e}')

# Cell
def get_issues(repo:str=None, state:str='open', token:str=None):
    "Get all issues for a repository"
    return [i for i in get_repo(repo).get_issues(state=state)]

# Cell
def brokenlink_issue(path:Param("Root directory searched recursively for HTML files", str),
                     ghtoken:Param("GitHub Token for authentication", str)=None,
                     host:Param("Host and path (without protocol) of web server", str)='',
                     config_file:Param("Location of file with urls to ignore",str)=None,
                     title:Param("If specified, open an issue with a title of `title` if broken links are found.", str)=None):
    """
    A GitHub Action utility that searches the `path` for broken links and opens an issue if an open issue with the same `title` is not found.
    """
    repo = os.getenv('GITHUB_REPOSITORY')
    token = ifnone(ghtoken, os.getenv('INPUT_TOKEN'))
    assert repo, "You must set the environment variable `GITHUB_REPOSITORY` if running this outside Actions."
    l = link_check(path=path, host=host, config_file=config_file, actions_output=True, print_logs=True)
    r = get_repo(repo=repo, token=token)
    incumbent_issue = first([i for i in get_issues(repo=repo, state='open', token=token) if i.title == title])
    if l:
        i = ifnone(incumbent_issue, r.create_issue(title, body=repr(l)) if title else None)
        if i:
            print(f'Related: {i.html_url}')
            print(f"::set-output name=related_issue_num::{i.number}")