"""
This module is to contain helpers, which collect info about python code
execution
"""
import sys


# generated by "python benchmarks/build_heuristics.py"

PY_VERSION = sys.version_info[0:2]
if PY_VERSION <= (3, 6):

    # 3.6.15
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.0568550033715e-11
        STEP = 100
        LOGICAL = 251
        DICT_LOOKUP = 327
        MATH_SIMPLE = 377
        ATTR_LOOKUP = 342
        TUPLE_INIT = 538
        LIST_INIT = 675
        SET_INIT = 1711
        DICT_INIT = 1667
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 171100

elif PY_VERSION <= (3, 7):  # pragma: no cover

    # 3.7.16
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.08321829275715e-11
        STEP = 100
        LOGICAL = 236
        DICT_LOOKUP = 337
        MATH_SIMPLE = 365
        ATTR_LOOKUP = 319
        TUPLE_INIT = 525
        LIST_INIT = 655
        SET_INIT = 1643
        DICT_INIT = 1685
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 168500

elif PY_VERSION == (3, 8):  # pragma: no cover

    # 3.8.16
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.144752377655609e-11
        STEP = 100
        LOGICAL = 226
        DICT_LOOKUP = 319
        MATH_SIMPLE = 368
        ATTR_LOOKUP = 309
        TUPLE_INIT = 532
        LIST_INIT = 675
        SET_INIT = 1677
        DICT_INIT = 1758
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 175800

elif PY_VERSION == (3, 9):  # pragma: no cover

    # 3.9.12
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.01792780282291e-11
        STEP = 100
        LOGICAL = 241
        DICT_LOOKUP = 345
        MATH_SIMPLE = 409
        ATTR_LOOKUP = 328
        TUPLE_INIT = 610
        LIST_INIT = 775
        SET_INIT = 1422
        DICT_INIT = 1912
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 191200

elif PY_VERSION == (3, 10):  # pragma: no cover

    # 3.10.9
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.1176799481692785e-11
        STEP = 100
        LOGICAL = 206
        DICT_LOOKUP = 306
        MATH_SIMPLE = 365
        ATTR_LOOKUP = 301
        TUPLE_INIT = 565
        LIST_INIT = 668
        SET_INIT = 1431
        DICT_INIT = 1798
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 179800

else:

    # 3.11.1
    class Weights:  # type: ignore # pragma: no cover # pylint: disable=missing-class-docstring # noqa: F811
        # base_time: 4.285590663856272e-11
        STEP = 100
        LOGICAL = 178
        DICT_LOOKUP = 313
        MATH_SIMPLE = 343
        ATTR_LOOKUP = 282
        TUPLE_INIT = 530
        LIST_INIT = 647
        SET_INIT = 1379
        DICT_INIT = 1958
        FUNCTION_CALL = DICT_LOOKUP * 4
        UNPREDICTABLE = 195800
