"""Constant values for the Tado component."""

# Types
TYPE_AIR_CONDITIONING = "AIR_CONDITIONING"
TYPE_HEATING = "HEATING"
TYPE_HOT_WATER = "HOT_WATER"

# Base modes
CONST_MODE_OFF = "OFF"
CONST_MODE_SMART_SCHEDULE = "SMART_SCHEDULE"  # Use the schedule
CONST_MODE_AUTO = "AUTO"
CONST_MODE_COOL = "COOL"
CONST_MODE_HEAT = "HEAT"
CONST_MODE_DRY = "DRY"
CONST_MODE_FAN = "FAN"

CONST_LINK_OFFLINE = "OFFLINE"

CONST_FAN_OFF = "OFF"
CONST_FAN_AUTO = "AUTO"
CONST_FAN_LOW = "LOW"
CONST_FAN_MIDDLE = "MIDDLE"
CONST_FAN_HIGH = "HIGH"

# When we change the temperature setting, we need an overlay mode
CONST_OVERLAY_TADO_MODE = "NEXT_TIME_BLOCK"  # wait until tado changes the mode automatic
CONST_OVERLAY_MANUAL = "MANUAL"  # the user has change the temperature or mode manually
CONST_OVERLAY_TIMER = "TIMER"  # the temperature will be reset after a timespan

# Heat always comes first since we get the
# min and max tempatures for the zone from
# it.
# Heat is preferred as it generally has a lower minimum temperature
ORDERED_KNOWN_TADO_MODES = [
    CONST_MODE_HEAT,
    CONST_MODE_COOL,
    CONST_MODE_AUTO,
    CONST_MODE_DRY,
    CONST_MODE_FAN,
]

CONST_HVAC_HEAT = "HEATING"
CONST_HVAC_DRY = "DRYING"
CONST_HVAC_FAN = "FAN"
CONST_HVAC_COOL = "COOLING"
CONST_HVAC_IDLE = "IDLE"
CONST_HVAC_OFF = "OFF"
CONST_HVAC_HOT_WATER = TYPE_HOT_WATER

TADO_MODES_TO_HVAC_ACTION = {
    CONST_MODE_HEAT: CONST_HVAC_HEAT,
    CONST_MODE_DRY: CONST_HVAC_DRY,
    CONST_MODE_FAN: CONST_HVAC_FAN,
    CONST_MODE_COOL: CONST_HVAC_COOL,
}

TADO_HVAC_ACTION_TO_MODES = {
    CONST_HVAC_HEAT: CONST_MODE_HEAT,
    CONST_HVAC_HOT_WATER: CONST_HVAC_HEAT,
    CONST_HVAC_DRY: CONST_MODE_DRY,
    CONST_HVAC_FAN: CONST_MODE_FAN,
    CONST_HVAC_COOL: CONST_MODE_COOL,
}


# These modes will not allow a temp to be set
TADO_MODES_WITH_NO_TEMP_SETTING = [CONST_MODE_AUTO, CONST_MODE_DRY, CONST_MODE_FAN]

DEFAULT_TADO_PRECISION = 0.1
