# Generated by Django 4.1.4 on 2022-12-13 18:21

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Classification',
            fields=[
                ('companyid', models.IntegerField(primary_key=True, serialize=False)),
                ('classificationid', models.BigIntegerField()),
                ('classificationname', models.CharField(blank=True, max_length=100, null=True)),
                ('level', models.IntegerField(blank=True, null=True)),
                ('parent', models.BigIntegerField(blank=True, null=True)),
                ('taxtypeid', models.IntegerField(blank=True, null=True)),
                ('groupid', models.IntegerField(blank=True, null=True)),
                ('tax', models.BooleanField(blank=True, null=True)),
                ('taxpercentage', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('taxcapitalized', models.BooleanField(blank=True, null=True)),
                ('depreciation', models.CharField(blank=True, max_length=2, null=True)),
                ('minimum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('maximum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('lifespan', models.IntegerField(blank=True, null=True)),
                ('locationid', models.IntegerField(blank=True, null=True)),
                ('rent', models.IntegerField(blank=True, null=True)),
                ('businessid', models.IntegerField(blank=True, null=True)),
                ('impute', models.BooleanField(blank=True, null=True)),
                ('accountdevolution', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('budget', models.BooleanField(blank=True, null=True)),
                ('budgetquantity', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('budgetvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('positiontariff', models.CharField(blank=True, max_length=20, null=True)),
                ('bonus', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('bonus1', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('bonus2', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('prefix', models.CharField(blank=True, max_length=1, null=True)),
                ('inventory', models.CharField(blank=True, max_length=1, null=True)),
                ('blight', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('blightcost', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('adjustmentcostvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('manpower', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('indirect', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('changeprice', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('expenseobjectid', models.IntegerField(blank=True, null=True)),
                ('costcenterid', models.IntegerField(blank=True, null=True)),
                ('oldcode', models.CharField(blank=True, max_length=20, null=True)),
                ('adjustmentcost', models.CharField(blank=True, max_length=1, null=True)),
                ('guarantee', models.IntegerField(blank=True, null=True)),
                ('guaranteevalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('grouporder', models.IntegerField(blank=True, null=True)),
                ('typeasset', models.CharField(blank=True, max_length=2, null=True)),
                ('costmethod', models.CharField(blank=True, max_length=1, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('finite', models.BooleanField(blank=True, null=True)),
                ('depreciate', models.BooleanField(blank=True, null=True)),
                ('expiration', models.IntegerField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=1, null=True)),
                ('ambulatory', models.BooleanField(blank=True, null=True)),
                ('hospitable', models.BooleanField(blank=True, null=True)),
                ('mobile', models.BooleanField(blank=True, null=True)),
                ('domicile', models.BooleanField(blank=True, null=True)),
                ('other', models.BooleanField(blank=True, null=True)),
                ('gender', models.CharField(blank=True, max_length=1, null=True)),
                ('groupageid', models.IntegerField(blank=True, null=True)),
                ('cr', models.BooleanField(blank=True, null=True)),
                ('ir', models.BooleanField(blank=True, null=True)),
                ('low', models.BooleanField(blank=True, null=True)),
                ('medium', models.BooleanField(blank=True, null=True)),
                ('high', models.BooleanField(blank=True, null=True)),
                ('factor', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('recuperation', models.BooleanField(blank=True, null=True)),
                ('pyp', models.BooleanField(blank=True, null=True)),
                ('urgency', models.BooleanField(blank=True, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('flatratecost', models.BooleanField(blank=True, null=True)),
                ('judgment', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'classification',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('companyid', models.IntegerField(primary_key=True, serialize=False)),
                ('discountid', models.IntegerField()),
                ('discountname', models.CharField(blank=True, max_length=100, null=True)),
                ('typediscountid', models.IntegerField(blank=True, null=True)),
                ('locationid', models.IntegerField(blank=True, null=True)),
                ('geographiclocationid', models.IntegerField(blank=True, null=True)),
                ('clientid', models.BigIntegerField(blank=True, null=True)),
                ('directionid', models.IntegerField(blank=True, null=True)),
                ('segmentid', models.IntegerField()),
                ('abcclient', models.CharField(max_length=1)),
                ('vendorid', models.BigIntegerField(blank=True, null=True)),
                ('dateinitial', models.DateTimeField(blank=True, null=True)),
                ('datefinal', models.DateTimeField(blank=True, null=True)),
                ('typeapplies', models.CharField(blank=True, max_length=1, null=True)),
                ('typepriceid', models.IntegerField(blank=True, null=True)),
                ('currencyid', models.IntegerField(blank=True, null=True)),
                ('exchangerate', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('businessid', models.IntegerField(blank=True, null=True)),
                ('classificationid', models.IntegerField(blank=True, null=True)),
                ('productid', models.BigIntegerField(blank=True, null=True)),
                ('brandid', models.IntegerField(blank=True, null=True)),
                ('lineid', models.IntegerField(blank=True, null=True)),
                ('abcproduct', models.CharField(max_length=1)),
                ('price', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('discountpercentage', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('expirationinitial', models.DateField(blank=True, null=True)),
                ('expirationfinal', models.DateField(blank=True, null=True)),
                ('value', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('bondpercentage', models.FloatField(blank=True, null=True)),
                ('bondvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('image', models.BinaryField(blank=True, null=True)),
                ('format', models.IntegerField(blank=True, null=True)),
                ('tariff', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('tariffsubstraction', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('cost', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('typecampaign', models.CharField(blank=True, max_length=1, null=True)),
                ('state', models.CharField(blank=True, max_length=1, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=4000, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('documentid', models.CharField(blank=True, max_length=3, null=True)),
                ('numberid', models.IntegerField(blank=True, null=True)),
                ('codeexternal', models.CharField(blank=True, max_length=10, null=True)),
            ],
            options={
                'db_table': 'discount',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_id', models.IntegerField(verbose_name='Product id')),
                ('name', models.CharField(max_length=250, verbose_name='Product name')),
                ('enabled', models.BooleanField(default=True, verbose_name='Is enabled')),
            ],
        ),
        migrations.CreateModel(
            name='OasisProduct',
            fields=[
                ('companyid', models.OneToOneField(db_column='companyid', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, related_name='company_products', serialize=False, to='oasis.classification')),
                ('productid', models.BigIntegerField()),
                ('productname', models.CharField(blank=True, max_length=1000, null=True)),
                ('classificationid', models.IntegerField(blank=True, null=True)),
                ('service', models.BooleanField(blank=True, null=True)),
                ('inventory', models.CharField(blank=True, max_length=1, null=True)),
                ('price', models.CharField(blank=True, max_length=1, null=True)),
                ('individual', models.BooleanField(blank=True, null=True)),
                ('ingress', models.DateField(blank=True, null=True)),
                ('discount', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('measureunitid', models.IntegerField(blank=True, null=True)),
                ('taxtypeid', models.IntegerField(blank=True, null=True)),
                ('groupid', models.IntegerField(blank=True, null=True)),
                ('tax', models.BooleanField(blank=True, null=True)),
                ('taxpercentage', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('unitalternate', models.IntegerField(blank=True, null=True)),
                ('factorconversion', models.FloatField(blank=True, null=True)),
                ('depreciation', models.CharField(blank=True, max_length=2, null=True)),
                ('lifespan', models.IntegerField(blank=True, null=True)),
                ('taxcapitalized', models.BooleanField(blank=True, null=True)),
                ('substitute', models.BigIntegerField(blank=True, null=True)),
                ('locationid', models.IntegerField(blank=True, null=True)),
                ('localizationid', models.CharField(blank=True, max_length=20, null=True)),
                ('clientid', models.BigIntegerField(blank=True, null=True)),
                ('oldcode', models.CharField(blank=True, max_length=100, null=True)),
                ('balance', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('inventoried', models.BooleanField(blank=True, null=True)),
                ('random', models.BigIntegerField(blank=True, null=True)),
                ('cycle', models.IntegerField(blank=True, null=True)),
                ('characteristic', models.BooleanField(blank=True, null=True)),
                ('characteristicid', models.IntegerField(blank=True, null=True)),
                ('presentation', models.BooleanField(blank=True, null=True)),
                ('presentationvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('expiration', models.BooleanField(blank=True, null=True)),
                ('control', models.BooleanField(blank=True, null=True)),
                ('lot', models.BooleanField(blank=True, null=True)),
                ('minimum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('standard', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('maximum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('dynamic', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('costproduction', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('averageactual', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('averageanterior', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('logo', models.IntegerField(blank=True, null=True)),
                ('level', models.IntegerField(blank=True, null=True)),
                ('abcnumber', models.IntegerField(blank=True, null=True)),
                ('production', models.BooleanField(blank=True, null=True)),
                ('state', models.CharField(blank=True, max_length=1, null=True)),
                ('rent', models.IntegerField(blank=True, null=True)),
                ('surtax', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('surtaxcapitalized', models.BooleanField(blank=True, null=True)),
                ('taxica', models.IntegerField(blank=True, null=True)),
                ('taxicap', models.IntegerField(blank=True, null=True)),
                ('taxdistributor', models.BooleanField(blank=True, null=True)),
                ('unitpurchase', models.IntegerField(blank=True, null=True)),
                ('unitsale', models.IntegerField(blank=True, null=True)),
                ('ean', models.BigIntegerField(blank=True, null=True)),
                ('generic', models.BooleanField(blank=True, null=True)),
                ('genericid', models.BigIntegerField(blank=True, null=True)),
                ('colorid', models.IntegerField(blank=True, null=True)),
                ('sizeid', models.IntegerField(blank=True, null=True)),
                ('genreid', models.IntegerField(blank=True, null=True)),
                ('materialid', models.IntegerField(blank=True, null=True)),
                ('gammaid', models.IntegerField(blank=True, null=True)),
                ('quality', models.BooleanField(blank=True, null=True)),
                ('origin', models.CharField(blank=True, max_length=1, null=True)),
                ('height', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('length', models.DecimalField(blank=True, db_column='long', decimal_places=4, max_digits=19, null=True)),
                ('width', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('weight', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('volume', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('stock', models.BooleanField(blank=True, null=True)),
                ('budget', models.BooleanField(blank=True, null=True)),
                ('tolerancebudget', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('budgetorder', models.BooleanField(blank=True, null=True)),
                ('planexportation', models.IntegerField(blank=True, null=True)),
                ('positiontariff', models.CharField(blank=True, max_length=20, null=True)),
                ('packing', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('box', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('businessid', models.IntegerField(blank=True, null=True)),
                ('combo', models.BooleanField(blank=True, null=True)),
                ('initials', models.CharField(blank=True, max_length=50, null=True)),
                ('daysdose', models.IntegerField(blank=True, null=True)),
                ('special', models.BooleanField(blank=True, null=True)),
                ('checked', models.BooleanField(blank=True, null=True)),
                ('pos', models.BooleanField(blank=True, null=True)),
                ('recovery', models.BooleanField(blank=True, null=True)),
                ('depth', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('designid', models.IntegerField(blank=True, null=True)),
                ('brandid', models.IntegerField(blank=True, null=True)),
                ('functionid', models.IntegerField(blank=True, null=True)),
                ('collectionid', models.IntegerField(blank=True, null=True)),
                ('codealternate', models.CharField(blank=True, max_length=20, null=True)),
                ('lineid', models.IntegerField(blank=True, null=True)),
                ('importation', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('materialraw', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('materialrawind', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('manpower', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('manpowerind', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('direct', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('indirect', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('sex', models.CharField(blank=True, max_length=1, null=True)),
                ('ageinitial', models.IntegerField(blank=True, null=True)),
                ('agefinal', models.IntegerField(blank=True, null=True)),
                ('rangeage', models.CharField(blank=True, max_length=1, null=True)),
                ('levelattention', models.IntegerField(blank=True, null=True)),
                ('levelcomplexity', models.IntegerField(blank=True, null=True)),
                ('gruousurgical', models.IntegerField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=3, null=True)),
                ('quantity', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('quantitymaximum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('elaborated', models.BigIntegerField(blank=True, null=True)),
                ('revised', models.BigIntegerField(blank=True, null=True)),
                ('approved', models.BigIntegerField(blank=True, null=True)),
                ('tokendate', models.DateField(blank=True, null=True)),
                ('producname1', models.CharField(blank=True, max_length=100, null=True)),
                ('productiondate', models.DateField(blank=True, null=True)),
                ('countryid', models.IntegerField(blank=True, null=True)),
                ('costdate', models.DateField(blank=True, null=True)),
                ('costproductiondate', models.DateField(blank=True, null=True)),
                ('lastpurchase', models.DateField(blank=True, null=True)),
                ('lastsupplier', models.BigIntegerField(blank=True, null=True)),
                ('lastprice', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('coststandard', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('activityica', models.IntegerField(blank=True, null=True)),
                ('eanchar', models.CharField(blank=True, max_length=30, null=True)),
                ('tariffhealth', models.IntegerField(blank=True, null=True)),
                ('finance', models.BooleanField(blank=True, null=True)),
                ('abc', models.CharField(blank=True, max_length=1, null=True)),
                ('capacity', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('localization2', models.CharField(blank=True, max_length=20, null=True)),
                ('descriptiontariff', models.CharField(blank=True, max_length=50, null=True)),
                ('margin', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('additionalprice1', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('additionalprice2', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('taxvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('marginminimum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('marginmaximum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('fund', models.IntegerField(blank=True, null=True)),
                ('factor', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('sourceid', models.IntegerField(blank=True, null=True)),
                ('entryid', models.BigIntegerField(blank=True, null=True)),
                ('expenseobjectid', models.IntegerField(blank=True, null=True)),
                ('returnable', models.BooleanField(blank=True, null=True)),
                ('growth', models.IntegerField(blank=True, null=True)),
                ('marked', models.BooleanField(blank=True, null=True)),
                ('invimadate', models.DateField(blank=True, null=True)),
                ('bpmdate', models.DateField(blank=True, null=True)),
                ('namegeneric', models.CharField(blank=True, max_length=100, null=True)),
                ('namecommercial', models.CharField(blank=True, max_length=100, null=True)),
                ('field1', models.CharField(blank=True, max_length=10, null=True)),
                ('field2', models.CharField(blank=True, max_length=10, null=True)),
                ('field3', models.CharField(blank=True, max_length=10, null=True)),
                ('emission', models.DateField(blank=True, null=True)),
                ('expirationdate', models.DateField(blank=True, null=True)),
                ('interestrate', models.DateField(blank=True, null=True)),
                ('periodicity', models.CharField(blank=True, max_length=2, null=True)),
                ('lastcoupondate', models.DateField(blank=True, null=True)),
                ('currencyid', models.IntegerField(blank=True, null=True)),
                ('performance', models.CharField(blank=True, max_length=1, null=True)),
                ('consignment', models.BooleanField(blank=True, null=True)),
                ('serial', models.BooleanField(blank=True, null=True)),
                ('requireean128', models.BooleanField(blank=True, null=True)),
                ('ean128', models.CharField(blank=True, max_length=128, null=True)),
                ('costcenterid', models.IntegerField(blank=True, null=True)),
                ('projectid', models.IntegerField(blank=True, null=True)),
                ('costcenterid1', models.IntegerField(blank=True, null=True)),
                ('seal', models.IntegerField(blank=True, null=True)),
                ('bonus', models.BooleanField(blank=True, null=True)),
                ('image', models.BinaryField(blank=True, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('valuenominal', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('class_field', models.CharField(blank=True, db_column='class', max_length=1, null=True)),
                ('codeinvima', models.CharField(blank=True, max_length=20, null=True)),
                ('partial', models.BooleanField(blank=True, null=True)),
                ('groupsurgicalid', models.IntegerField(blank=True, null=True)),
                ('copayment', models.BooleanField(blank=True, null=True)),
                ('parturition', models.BooleanField(blank=True, null=True)),
                ('highcost', models.IntegerField(blank=True, null=True)),
                ('upc', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('grouppharmacologicalid', models.IntegerField(blank=True, null=True)),
                ('principleactiveid', models.IntegerField(blank=True, null=True)),
                ('formpharmaceuticalid', models.IntegerField(blank=True, null=True)),
                ('concentrationid', models.IntegerField(blank=True, null=True)),
                ('homologous', models.BooleanField(blank=True, null=True)),
                ('concentration', models.CharField(blank=True, max_length=100, null=True)),
                ('codehomologous', models.CharField(blank=True, max_length=100, null=True)),
                ('cups', models.BooleanField(blank=True, null=True)),
                ('levelauthorization', models.IntegerField(blank=True, null=True)),
                ('classificationidalternate', models.BigIntegerField(blank=True, null=True)),
                ('automatic', models.BooleanField(blank=True, null=True)),
                ('quantitytime', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('nounification', models.BooleanField(blank=True, null=True)),
                ('quantitymonth', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('quantityyear', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('valueminimum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('valuemaximum', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('quotamoderator', models.BooleanField(blank=True, null=True)),
                ('highcostcontrib', models.IntegerField(blank=True, null=True)),
                ('capitated', models.BooleanField(blank=True, null=True)),
                ('print', models.BooleanField(blank=True, null=True)),
                ('atcpos', models.CharField(blank=True, max_length=20, null=True)),
                ('typegeneric', models.CharField(blank=True, max_length=20, null=True)),
                ('health', models.BooleanField(blank=True, null=True)),
                ('description', models.CharField(blank=True, max_length=4000, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('codeium', models.CharField(blank=True, max_length=30, null=True)),
                ('codeium1', models.CharField(blank=True, max_length=30, null=True)),
                ('codeium2', models.CharField(blank=True, max_length=30, null=True)),
                ('coldchain', models.BooleanField(blank=True, null=True)),
                ('regulated', models.BooleanField(blank=True, null=True)),
                ('valuerecovery', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('temperature', models.BooleanField(blank=True, null=True)),
                ('judgment', models.IntegerField(blank=True, null=True)),
                ('diagnostic', models.IntegerField(blank=True, null=True)),
                ('retentionbyproduct', models.BooleanField(blank=True, null=True)),
                ('coffeefreight', models.CharField(blank=True, max_length=1, null=True)),
                ('combomodel', models.CharField(blank=True, max_length=1, null=True)),
                ('productcurve', models.BooleanField(blank=True, null=True)),
                ('coverid', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'product',
                'managed': False,
            },
        ),
        migrations.AddConstraint(
            model_name='product',
            constraint=models.UniqueConstraint(fields=('product_id',), name='ownproduct_productid_unique'),
        ),
    ]
