# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['handsdown',
 'handsdown.assets',
 'handsdown.ast_parser',
 'handsdown.ast_parser.analyzers',
 'handsdown.ast_parser.node_records',
 'handsdown.processors',
 'handsdown.utils']

package_data = \
{'': ['*']}

install_requires = \
['importlib-resources', 'pip', 'typed-ast']

entry_points = \
{'console_scripts': ['handsdown = handsdown.main:main']}

setup_kwargs = {
    'name': 'handsdown',
    'version': '0.6.0',
    'description': 'Python docstring-based documentation generator for lazy perfectionists.',
    'long_description': '# 🙌 Handsdown - Python documentation generator\n\n\n[![PyPI - Handsdown](https://img.shields.io/pypi/v/handsdown.svg?color=blue&style=for-the-badge)](https://pypi.org/project/handsdown)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/handsdown.svg?color=blue&style=for-the-badge)](https://pypi.org/project/handsdown)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/handsdown?color=blue&style=for-the-badge)\n[![Build Status](https://img.shields.io/travis/vemel/handsdown.svg?style=for-the-badge)](https://travis-ci.org/vemel/handsdown)\n[![Code Coverage](https://img.shields.io/codecov/c/gh/vemel/handsdown.svg?style=for-the-badge)](https://codecov.io/gh/vemel/handsdown/tree/master/handsdown)\n[![Docs](https://img.shields.io/readthedocs/handsdown.svg?color=blue&style=for-the-badge)](https://handsdown.readthedocs.io/)\n\nPython docstring-based documentation generator for lazy perfectionists.\n\n- [🙌 Handsdown - Python documentation generator](#-handsdown---python-documentation-generator)\n  - [Features](#features)\n  - [Do you need handsdown?](#do-you-need-handsdown)\n  - [Examples](#examples)\n  - [Usage](#usage)\n    - [💻 From command line](#-from-command-line)\n    - [📦 As a Docker image](#-as-a-docker-image)\n    - [📝 As a GitHub Pages manager](#-as-a-github-pages-manager)\n    - [🐏 Deploy on Read the Docs](#-deploy-on-read-the-docs)\n    - [📋 Build static HTML](#-build-static-html)\n    - [🧩 As a module](#-as-a-module)\n  - [Installation](#installation)\n  - [Development](#development)\n  - [Changelog](#changelog)\n\n## Features\n\n- [PEP 257](https://www.python.org/dev/peps/pep-0257/),\n  [Google](http://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings),\n  [Sphinx](https://sphinx-rtd-tutorial.readthedocs.io/en/latest/docstrings.html)\n  and [reStructuredText](https://www.python.org/dev/peps/pep-0287/)\n  docstrings support. All of them are converted to a valid Markdown.\n- Works with [Django](https://www.djangoproject.com/) and [Flask](https://palletsprojects.com/p/flask/) apps\n- Can be used locally, or\n  [right on GitHub](https://github.com/vemel/handsdown/blob/master/docs/README.md) or even deployed on\n  [GitHub Pages](https://vemel.github.io/handsdown/) and [Read the Docs](https://handsdown.readthedocs.io/)!\n- Signatures for every class, function, property and method.\n- Support for type annotations. Even for the ones from the `__future__`!\n- Nice list of all modules in [Modules](https://github.com/vemel/handsdown/blob/master/docs/MODULES.md)\n- Gather all scattered `README.md` in submodules to one place\n- Find related source code from every doc section.\n- Make links by just adding `module.import.String` to docs.\n- Do you use type annotations? Well, you get auto-discovery of related modules for free!\n\n## Do you need handsdown?\n\nYou definitely *do* if you:\n\n- prefer to automate documentation builds\n- work with a team and plan to simplify knowledge sharing\n- want to show your project without navigating through a source code\n- build `Django` or `Flask` applications\n- are proud of your project and not afraid to show it\n- love Open Source\n\nAnd probably *do not* if you:\n\n- not very into docstrings and type annotations\n- like to abstract a documentation away from the way things really are\n- use [Pandas docstrings](https://pandas.pydata.org/pandas-docs/stable/development/contributing_docstring.html)\n  as they are not supported yet\n\n## Examples\n\n- [All documentation](https://vemel.github.io/handsdown/) in this project\n- [Main](https://github.com/vemel/handsdown/blob/master/examples/main_example.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/main_example.md)\n- [RST docstrings](https://github.com/vemel/handsdown/blob/master/examples/rst_docstrings.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/rst_docstrings.md)\n- [Google docstrings](https://github.com/vemel/handsdown/blob/master/examples/google_docstrings.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/google_docstrings.md)\n- [PEP 257 docstrings](https://github.com/vemel/handsdown/blob/master/examples/pep257_docstrings.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/pep257_docstrings.md)\n- [Sphinx docstrings](https://github.com/vemel/handsdown/blob/master/examples/sphinx_docstrings.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/sphinx_docstrings.md)\n- [Type annotations](https://github.com/vemel/handsdown/blob/master/examples/typed.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/typed.md)\n- [Comment-style type annotations](https://github.com/vemel/handsdown/blob/master/examples/comment_typed.py) with [generated output](https://github.com/vemel/handsdown/tree/master/docs/examples/comment_typed.md)\n\n## Usage\n\n### 💻 From command line\n\nJust go to your favorite project that has lots of docstrings but missing\nauto-generated docs and let `handsdown` do the thing.\n\n```bash\ncd ~/my/project\n\n# build documentation *.md* files in docs/* directory\nhandsdown\n\n# or provide custom output directory: output_dir/*\nhandsdown -o output_dir\n\n# generate docs only for my_module, but exclude migrations\nhandsdown my_module --exclude my_module/migrations\n\n# generate documentation for deployment\nhandsdown --external `git config --get remote.origin.url` -n ProjectName --branch main\n```\n\nNavigate to `docs/README.md` to check your new documentation!\n\n### 📦 As a Docker image\n\n- Install [Docker](https://docs.docker.com/install/)\n- Pull latest `handsdown` version and tag it\n\n```bash\ndocker pull docker.pkg.github.com/vemel/handsdown/handsdown:latest\ndocker tag docker.pkg.github.com/vemel/handsdown/handsdown:latest handsdown\n```\n\n- Generate docs for `ProjectName` in current directory\n\n```bash\n# for Python 3 project\ndocker run -v `pwd`:/app handsdown -n ProjectName\n\n# for Python 2 project\nPYTHON_VER=2 docker run -v `pwd`:/app handsdown -n ProjectName\n\n# generate documentation for deployment\ndocker run -v `pwd`:/app handsdown --external `git config --get remote.origin.url` -n ProjectName\n```\n\n### 📝 As a GitHub Pages manager\n\nWith `--external` CLI flag, `handsdown` generates all required configuration\nfor [GitHub Pages](https://pages.github.com/), so you just need to setup your\nGitHub repository.\n\n```bash\n# Generate documentation that points to master branch\n# do not use custom output location, as `GitHub Pages`\n# works only with `docs` directory\nhandsdown --external `git config --get remote.origin.url`\n\n# or specify GitHub url directly\nhandsdown --external https://github.com/<user>/<project>/blob/master/\n```\n\n- Generate documentation with `--external` flag as shown above, do not use `--output`\n  flag, only `docs` folder is supported by `GitHub Pages`\n- Commit and push all changes a to `master` branch.\n- Set your GitHub project `Settings` > `GitHub Pages` > `Source` to `master branch /docs folder`\n\nAll set! You can change `docs/_config.yml` to add your own touch.\n\nWith `--external` flag links to your source are absolute and point to your GitHub repo. If you\nstill want to have relative links to source, e.g. for using docs locally,\ngenerate docs to another folder\n\n```bash\n# `docs_local` folder will be created in your project root\n# you probably want to add it to .gitignore\nhandsdown -o docs_local\n```\n\n### 🐏 Deploy on Read the Docs\n\nWith `--external` CLI flag, `handsdown` generates all required configuration\nfor [Read the Docs](https://readthedocs.org/), so you just need to to add your\nGitHub repository to `Read the Docs`.\n\n```bash\n# Generate documentation that points to master branch\n# do not use custom output location, as `GitHub Pages`\n# works only with `docs` directory\nhandsdown --external `git config --get remote.origin.url`\n\n# or specify GitHub url directly\nhandsdown --external https://github.com/<user>/<project>/\n```\n\n- Generate documentation with `--external` flag as shown above, do not use `--output`\n  flag, only `docs` folder is supported by `Read the Docs`\n- Commit and push all changes a to `master` branch.\n- Add your repository on [Read the Docs](https://readthedocs.org/)\n\nAll set! You can change `.readthedocs.yml` and `mkdocs.yml` to add your own touch.\n\n### 📋 Build static HTML\n\n```bash\n# Generate documentation that points to master branch\n# with source links pointing to your repository\n# this command also creates `mkdocs.yml`\nhandsdown --external `git config --get remote.origin.url`\n\n# Run mkdocs to build HTML\nmkdocs build\n```\n\n### 🧩 As a module\n\n```python\nfrom handsdown.generator import Generator\nfrom handsdown.utils.path_finder import PathFinder\n\n# this is our project root directory\nrepo_path = Path.cwd()\n\n# this little tool works like `pathlib.Path.glob` with some extra magic\n# but in this case `repo_path.glob("**/*.py")` would do as well\npath_finder = PathFinder(repo_path, "**/*.py")\n\n# no docs for tests and build\npath_finder.exclude("tests/*", "build/*")\n\n# initialize generator\nhandsdown = Generator(\n    input_path=repo_path,\n    output_path=repo_path / \'output\',\n    source_paths=path_finder.glob("**/*.py")\n)\n\n# generate all docs at once\nhandsdown.generate_docs()\n\n# or generate just for one doc\nhandsdown.generate_doc(repo_path / \'my_module\' / \'source.py\')\n\n# and generate index.md file\nhandsdown.generate_index()\n\n# navigate to `output` dir and check results\n```\n\n## Installation\n\nInstall using `pip` from PyPI\n\n```bash\npip install handsdown\n```\n\nor directly from GitHub if you cannot wait to test new features\n\n```bash\npip install git+https://github.com/vemel/handsdown.git\n```\n\n## Development\n\n- Install [pipenv](https://pypi.org/project/pipenv/)\n- Run `pipenv install -d`\n- Use `black` formatter in your IDE\n\n## Changelog\n\nChangelog can be found in [Releases](https://github.com/vemel/handsdown/releases)\n',
    'author': 'Vlad Emelianov',
    'author_email': 'vlad.emelianov.nz@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://vemel.github.io/handsdown/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
