"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitUrlTagger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class GitUrlTagger {
    constructor(props) {
        this.props = props;
        this._gitUrlTaggerFileName = '.git-url-tagger.json';
        let gitUrl = this.pullGitUrlFromFile();
        if (!gitUrl) {
            gitUrl = this.retrieveGitUrl();
            this.putGitUrlInFile(gitUrl);
            const shouldNormalize = props?.normalizeUrl ?? true;
            this.gitUrl = shouldNormalize ? this.normalizeUrl(gitUrl) : gitUrl;
        }
        else {
            this.gitUrl = gitUrl;
        }
    }
    visit(construct) {
        new aws_cdk_lib_1.Tag(this.props?.tagName || 'GitUrl', this.gitUrl).visit(construct);
    }
    findGitDirectory() {
        let currentDir = process.cwd(); // Get the current directory
        while (currentDir !== '/') {
            const gitDir = path.join(currentDir, '.git');
            if (fs.existsSync(gitDir)) {
                return gitDir;
            }
            currentDir = path.dirname(currentDir); // Move up to the parent directory
        }
        return ''; // .git directory not found
    }
    findRootDirectory() {
        let currentDir = process.cwd(); // Get the current directory
        while (currentDir !== '/') {
            const packageJson = path.join(currentDir, 'package.json');
            if (fs.existsSync(packageJson)) {
                return currentDir;
            }
            currentDir = path.dirname(currentDir); // Move up to the parent directory
        }
        return process.cwd(); // root directory not found
    }
    pullGitUrlFromFile() {
        const rootpath = this.findRootDirectory();
        const gitUrlTaggerConfig = path.join(rootpath, this._gitUrlTaggerFileName);
        if (fs.existsSync(gitUrlTaggerConfig)) {
            const data = fs.readFileSync(gitUrlTaggerConfig, 'utf8');
            const config = JSON.parse(data);
            return config.url;
        }
    }
    putGitUrlInFile(gitUrl) {
        let rootpath = this.findRootDirectory();
        const gitUrlTaggerConfig = path.join(rootpath, this._gitUrlTaggerFileName);
        fs.writeFileSync(gitUrlTaggerConfig, JSON.stringify({ url: gitUrl }));
    }
    retrieveGitUrl() {
        const gitpath = this.findGitDirectory();
        if (!gitpath) {
            throw new Error('No .git folder found');
        }
        const data = fs.readFileSync(path.join(gitpath, 'config'), 'utf8');
        for (const line of data.split('\n')) {
            if (line.includes('url = ')) {
                return line.trim().split(' ')[2];
            }
        }
        return 'No Code Repo Found';
    }
    normalizeUrl(gitUrl) {
        const regexSSH = /^git@([A-Za-z0-9-]+\.[A-Za-z0-9-]+):([A-Za-z0-9-]+)\/([A-Za-z0-9-]+)\.git$/;
        let regexMatches = regexSSH.exec(gitUrl);
        if (!regexMatches) {
            return gitUrl;
        }
        const [_all, site, org, repo] = regexMatches;
        if (org && repo) {
            return `https://${site}/${org}/${repo}`;
        }
        return gitUrl;
    }
}
_a = JSII_RTTI_SYMBOL_1;
GitUrlTagger[_a] = { fqn: "@layerborn/cdk-git-tagger.GitUrlTagger", version: "0.0.14" };
exports.GitUrlTagger = GitUrlTagger;
//# sourceMappingURL=data:application/json;base64,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