import { IAspect } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
export interface GitUrlTaggerProps {
    /**
       * The Tag key/name to use
       *
       * @default 'GitUrl'
       */
    readonly tagName?: string;
    /**
       * A flag on whether to try to normalize the URL found in the git config
       * If enabled, it will turn ssh urls into https urls.
       *
       * @default true
       */
    readonly normalizeUrl?: boolean;
}
export declare class GitUrlTagger implements IAspect {
    private props?;
    private gitUrl;
    private readonly _gitUrlTaggerFileName;
    constructor(props?: GitUrlTaggerProps | undefined);
    visit(construct: IConstruct): void;
    findGitDirectory(): string;
    private findRootDirectory;
    private pullGitUrlFromFile;
    putGitUrlInFile(gitUrl: string): void;
    retrieveGitUrl(): string;
    private normalizeUrl;
}
