# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class RescheduleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RescheduleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'agent_ids': 'list[str]',
            'activity_code_ids': 'list[str]',
            'do_not_change_weekly_paid_time': 'bool',
            'do_not_change_daily_paid_time': 'bool',
            'do_not_change_shift_start_times': 'bool',
            'do_not_change_manually_edited_shifts': 'bool'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'agent_ids': 'agentIds',
            'activity_code_ids': 'activityCodeIds',
            'do_not_change_weekly_paid_time': 'doNotChangeWeeklyPaidTime',
            'do_not_change_daily_paid_time': 'doNotChangeDailyPaidTime',
            'do_not_change_shift_start_times': 'doNotChangeShiftStartTimes',
            'do_not_change_manually_edited_shifts': 'doNotChangeManuallyEditedShifts'
        }

        self._start_date = None
        self._end_date = None
        self._agent_ids = None
        self._activity_code_ids = None
        self._do_not_change_weekly_paid_time = None
        self._do_not_change_daily_paid_time = None
        self._do_not_change_shift_start_times = None
        self._do_not_change_manually_edited_shifts = None

    @property
    def start_date(self):
        """
        Gets the start_date of this RescheduleRequest.
        The start date of the range to reschedule in ISO-8601 format

        :return: The start_date of this RescheduleRequest.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this RescheduleRequest.
        The start date of the range to reschedule in ISO-8601 format

        :param start_date: The start_date of this RescheduleRequest.
        :type: datetime
        """
        
        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this RescheduleRequest.
        The end date of the range to reschedule in ISO-8601 format

        :return: The end_date of this RescheduleRequest.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this RescheduleRequest.
        The end date of the range to reschedule in ISO-8601 format

        :param end_date: The end_date of this RescheduleRequest.
        :type: datetime
        """
        
        self._end_date = end_date

    @property
    def agent_ids(self):
        """
        Gets the agent_ids of this RescheduleRequest.
        The IDs of the agents to reschedule.  Null or empty means all agents on the schedule

        :return: The agent_ids of this RescheduleRequest.
        :rtype: list[str]
        """
        return self._agent_ids

    @agent_ids.setter
    def agent_ids(self, agent_ids):
        """
        Sets the agent_ids of this RescheduleRequest.
        The IDs of the agents to reschedule.  Null or empty means all agents on the schedule

        :param agent_ids: The agent_ids of this RescheduleRequest.
        :type: list[str]
        """
        
        self._agent_ids = agent_ids

    @property
    def activity_code_ids(self):
        """
        Gets the activity_code_ids of this RescheduleRequest.
        The IDs of the activity codes to reschedule. Null or empty means all activity codes will be considered

        :return: The activity_code_ids of this RescheduleRequest.
        :rtype: list[str]
        """
        return self._activity_code_ids

    @activity_code_ids.setter
    def activity_code_ids(self, activity_code_ids):
        """
        Sets the activity_code_ids of this RescheduleRequest.
        The IDs of the activity codes to reschedule. Null or empty means all activity codes will be considered

        :param activity_code_ids: The activity_code_ids of this RescheduleRequest.
        :type: list[str]
        """
        
        self._activity_code_ids = activity_code_ids

    @property
    def do_not_change_weekly_paid_time(self):
        """
        Gets the do_not_change_weekly_paid_time of this RescheduleRequest.
        Whether to prevent changes to weekly paid time

        :return: The do_not_change_weekly_paid_time of this RescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_weekly_paid_time

    @do_not_change_weekly_paid_time.setter
    def do_not_change_weekly_paid_time(self, do_not_change_weekly_paid_time):
        """
        Sets the do_not_change_weekly_paid_time of this RescheduleRequest.
        Whether to prevent changes to weekly paid time

        :param do_not_change_weekly_paid_time: The do_not_change_weekly_paid_time of this RescheduleRequest.
        :type: bool
        """
        
        self._do_not_change_weekly_paid_time = do_not_change_weekly_paid_time

    @property
    def do_not_change_daily_paid_time(self):
        """
        Gets the do_not_change_daily_paid_time of this RescheduleRequest.
        Whether to prevent changes to daily paid time

        :return: The do_not_change_daily_paid_time of this RescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_daily_paid_time

    @do_not_change_daily_paid_time.setter
    def do_not_change_daily_paid_time(self, do_not_change_daily_paid_time):
        """
        Sets the do_not_change_daily_paid_time of this RescheduleRequest.
        Whether to prevent changes to daily paid time

        :param do_not_change_daily_paid_time: The do_not_change_daily_paid_time of this RescheduleRequest.
        :type: bool
        """
        
        self._do_not_change_daily_paid_time = do_not_change_daily_paid_time

    @property
    def do_not_change_shift_start_times(self):
        """
        Gets the do_not_change_shift_start_times of this RescheduleRequest.
        Whether to prevent changes to shift start times

        :return: The do_not_change_shift_start_times of this RescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_shift_start_times

    @do_not_change_shift_start_times.setter
    def do_not_change_shift_start_times(self, do_not_change_shift_start_times):
        """
        Sets the do_not_change_shift_start_times of this RescheduleRequest.
        Whether to prevent changes to shift start times

        :param do_not_change_shift_start_times: The do_not_change_shift_start_times of this RescheduleRequest.
        :type: bool
        """
        
        self._do_not_change_shift_start_times = do_not_change_shift_start_times

    @property
    def do_not_change_manually_edited_shifts(self):
        """
        Gets the do_not_change_manually_edited_shifts of this RescheduleRequest.
        Whether to prevent changes to manually edited shifts

        :return: The do_not_change_manually_edited_shifts of this RescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_manually_edited_shifts

    @do_not_change_manually_edited_shifts.setter
    def do_not_change_manually_edited_shifts(self, do_not_change_manually_edited_shifts):
        """
        Sets the do_not_change_manually_edited_shifts of this RescheduleRequest.
        Whether to prevent changes to manually edited shifts

        :param do_not_change_manually_edited_shifts: The do_not_change_manually_edited_shifts of this RescheduleRequest.
        :type: bool
        """
        
        self._do_not_change_manually_edited_shifts = do_not_change_manually_edited_shifts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

