# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class NumberPlan(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        NumberPlan - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'version': 'int',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'modified_by': 'str',
            'created_by': 'str',
            'state': 'str',
            'modified_by_app': 'str',
            'created_by_app': 'str',
            'match': 'str',
            'normalized_format': 'str',
            'priority': 'int',
            'numbers': 'list[Number]',
            'digit_length': 'DigitLength',
            'classification': 'str',
            'match_type': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'version': 'version',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'modified_by': 'modifiedBy',
            'created_by': 'createdBy',
            'state': 'state',
            'modified_by_app': 'modifiedByApp',
            'created_by_app': 'createdByApp',
            'match': 'match',
            'normalized_format': 'normalizedFormat',
            'priority': 'priority',
            'numbers': 'numbers',
            'digit_length': 'digitLength',
            'classification': 'classification',
            'match_type': 'matchType',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._version = None
        self._date_created = None
        self._date_modified = None
        self._modified_by = None
        self._created_by = None
        self._state = None
        self._modified_by_app = None
        self._created_by_app = None
        self._match = None
        self._normalized_format = None
        self._priority = None
        self._numbers = None
        self._digit_length = None
        self._classification = None
        self._match_type = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this NumberPlan.
        The globally unique identifier for the object.

        :return: The id of this NumberPlan.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NumberPlan.
        The globally unique identifier for the object.

        :param id: The id of this NumberPlan.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this NumberPlan.
        The name of the entity.

        :return: The name of this NumberPlan.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NumberPlan.
        The name of the entity.

        :param name: The name of this NumberPlan.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this NumberPlan.
        The resource's description.

        :return: The description of this NumberPlan.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NumberPlan.
        The resource's description.

        :param description: The description of this NumberPlan.
        :type: str
        """
        
        self._description = description

    @property
    def version(self):
        """
        Gets the version of this NumberPlan.
        The current version of the resource.

        :return: The version of this NumberPlan.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this NumberPlan.
        The current version of the resource.

        :param version: The version of this NumberPlan.
        :type: int
        """
        
        self._version = version

    @property
    def date_created(self):
        """
        Gets the date_created of this NumberPlan.
        The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this NumberPlan.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this NumberPlan.
        The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this NumberPlan.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this NumberPlan.
        The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this NumberPlan.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this NumberPlan.
        The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this NumberPlan.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def modified_by(self):
        """
        Gets the modified_by of this NumberPlan.
        The ID of the user that last modified the resource.

        :return: The modified_by of this NumberPlan.
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this NumberPlan.
        The ID of the user that last modified the resource.

        :param modified_by: The modified_by of this NumberPlan.
        :type: str
        """
        
        self._modified_by = modified_by

    @property
    def created_by(self):
        """
        Gets the created_by of this NumberPlan.
        The ID of the user that created the resource.

        :return: The created_by of this NumberPlan.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this NumberPlan.
        The ID of the user that created the resource.

        :param created_by: The created_by of this NumberPlan.
        :type: str
        """
        
        self._created_by = created_by

    @property
    def state(self):
        """
        Gets the state of this NumberPlan.
        Indicates if the resource is active, inactive, or deleted.

        :return: The state of this NumberPlan.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this NumberPlan.
        Indicates if the resource is active, inactive, or deleted.

        :param state: The state of this NumberPlan.
        :type: str
        """
        allowed_values = ["active", "inactive", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def modified_by_app(self):
        """
        Gets the modified_by_app of this NumberPlan.
        The application that last modified the resource.

        :return: The modified_by_app of this NumberPlan.
        :rtype: str
        """
        return self._modified_by_app

    @modified_by_app.setter
    def modified_by_app(self, modified_by_app):
        """
        Sets the modified_by_app of this NumberPlan.
        The application that last modified the resource.

        :param modified_by_app: The modified_by_app of this NumberPlan.
        :type: str
        """
        
        self._modified_by_app = modified_by_app

    @property
    def created_by_app(self):
        """
        Gets the created_by_app of this NumberPlan.
        The application that created the resource.

        :return: The created_by_app of this NumberPlan.
        :rtype: str
        """
        return self._created_by_app

    @created_by_app.setter
    def created_by_app(self, created_by_app):
        """
        Sets the created_by_app of this NumberPlan.
        The application that created the resource.

        :param created_by_app: The created_by_app of this NumberPlan.
        :type: str
        """
        
        self._created_by_app = created_by_app

    @property
    def match(self):
        """
        Gets the match of this NumberPlan.


        :return: The match of this NumberPlan.
        :rtype: str
        """
        return self._match

    @match.setter
    def match(self, match):
        """
        Sets the match of this NumberPlan.


        :param match: The match of this NumberPlan.
        :type: str
        """
        
        self._match = match

    @property
    def normalized_format(self):
        """
        Gets the normalized_format of this NumberPlan.


        :return: The normalized_format of this NumberPlan.
        :rtype: str
        """
        return self._normalized_format

    @normalized_format.setter
    def normalized_format(self, normalized_format):
        """
        Sets the normalized_format of this NumberPlan.


        :param normalized_format: The normalized_format of this NumberPlan.
        :type: str
        """
        
        self._normalized_format = normalized_format

    @property
    def priority(self):
        """
        Gets the priority of this NumberPlan.


        :return: The priority of this NumberPlan.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this NumberPlan.


        :param priority: The priority of this NumberPlan.
        :type: int
        """
        
        self._priority = priority

    @property
    def numbers(self):
        """
        Gets the numbers of this NumberPlan.


        :return: The numbers of this NumberPlan.
        :rtype: list[Number]
        """
        return self._numbers

    @numbers.setter
    def numbers(self, numbers):
        """
        Sets the numbers of this NumberPlan.


        :param numbers: The numbers of this NumberPlan.
        :type: list[Number]
        """
        
        self._numbers = numbers

    @property
    def digit_length(self):
        """
        Gets the digit_length of this NumberPlan.


        :return: The digit_length of this NumberPlan.
        :rtype: DigitLength
        """
        return self._digit_length

    @digit_length.setter
    def digit_length(self, digit_length):
        """
        Sets the digit_length of this NumberPlan.


        :param digit_length: The digit_length of this NumberPlan.
        :type: DigitLength
        """
        
        self._digit_length = digit_length

    @property
    def classification(self):
        """
        Gets the classification of this NumberPlan.


        :return: The classification of this NumberPlan.
        :rtype: str
        """
        return self._classification

    @classification.setter
    def classification(self, classification):
        """
        Sets the classification of this NumberPlan.


        :param classification: The classification of this NumberPlan.
        :type: str
        """
        
        self._classification = classification

    @property
    def match_type(self):
        """
        Gets the match_type of this NumberPlan.


        :return: The match_type of this NumberPlan.
        :rtype: str
        """
        return self._match_type

    @match_type.setter
    def match_type(self, match_type):
        """
        Sets the match_type of this NumberPlan.


        :param match_type: The match_type of this NumberPlan.
        :type: str
        """
        
        self._match_type = match_type

    @property
    def self_uri(self):
        """
        Gets the self_uri of this NumberPlan.
        The URI for this object

        :return: The self_uri of this NumberPlan.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this NumberPlan.
        The URI for this object

        :param self_uri: The self_uri of this NumberPlan.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

