# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AsyncQueryStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AsyncQueryStatus - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'error_message': 'str',
            'expiration_date': 'datetime',
            'submission_date': 'datetime',
            'completion_date': 'datetime'
        }

        self.attribute_map = {
            'state': 'state',
            'error_message': 'errorMessage',
            'expiration_date': 'expirationDate',
            'submission_date': 'submissionDate',
            'completion_date': 'completionDate'
        }

        self._state = None
        self._error_message = None
        self._expiration_date = None
        self._submission_date = None
        self._completion_date = None

    @property
    def state(self):
        """
        Gets the state of this AsyncQueryStatus.
        The current state of the asynchronous query

        :return: The state of this AsyncQueryStatus.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this AsyncQueryStatus.
        The current state of the asynchronous query

        :param state: The state of this AsyncQueryStatus.
        :type: str
        """
        allowed_values = ["QUEUED", "PENDING", "FAILED", "CANCELLED", "FULFILLED", "EXPIRED"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def error_message(self):
        """
        Gets the error_message of this AsyncQueryStatus.
        The error associated with the current query, if the state is FAILED

        :return: The error_message of this AsyncQueryStatus.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this AsyncQueryStatus.
        The error associated with the current query, if the state is FAILED

        :param error_message: The error_message of this AsyncQueryStatus.
        :type: str
        """
        
        self._error_message = error_message

    @property
    def expiration_date(self):
        """
        Gets the expiration_date of this AsyncQueryStatus.
        The time at which results for this query will expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The expiration_date of this AsyncQueryStatus.
        :rtype: datetime
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """
        Sets the expiration_date of this AsyncQueryStatus.
        The time at which results for this query will expire. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param expiration_date: The expiration_date of this AsyncQueryStatus.
        :type: datetime
        """
        
        self._expiration_date = expiration_date

    @property
    def submission_date(self):
        """
        Gets the submission_date of this AsyncQueryStatus.
        The time at which the query was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The submission_date of this AsyncQueryStatus.
        :rtype: datetime
        """
        return self._submission_date

    @submission_date.setter
    def submission_date(self, submission_date):
        """
        Sets the submission_date of this AsyncQueryStatus.
        The time at which the query was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param submission_date: The submission_date of this AsyncQueryStatus.
        :type: datetime
        """
        
        self._submission_date = submission_date

    @property
    def completion_date(self):
        """
        Gets the completion_date of this AsyncQueryStatus.
        The time at which the query completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The completion_date of this AsyncQueryStatus.
        :rtype: datetime
        """
        return self._completion_date

    @completion_date.setter
    def completion_date(self, completion_date):
        """
        Sets the completion_date of this AsyncQueryStatus.
        The time at which the query completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param completion_date: The completion_date of this AsyncQueryStatus.
        :type: datetime
        """
        
        self._completion_date = completion_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

