# -*- coding: utf-8 -*-
# Generated by scripts/generate_from_specs.py
from __future__ import unicode_literals

# CompletionCriteria

APPROX_TIME = "approx_time"
MASTERY = "mastery"
PAGES = "pages"
REFERENCE = "reference"
TIME = "time"

choices = (
    (APPROX_TIME, "Approx Time"),
    (MASTERY, "Mastery"),
    (PAGES, "Pages"),
    (REFERENCE, "Reference"),
    (TIME, "Time"),
)

COMPLETIONCRITERIALIST = [
    APPROX_TIME,
    MASTERY,
    PAGES,
    REFERENCE,
    TIME,
]

SCHEMA = {
    "description": "Schema for completion criteria of content nodes",
    "$id": "/schemas/completion_criteria",
    "anyOf": [
        {
            "required": ["threshold"],
            "properties": {
                "threshold": {"exclusiveMinimum": 0, "type": "number"},
                "model": {
                    "anyOf": [
                        {"const": "time"},
                        {"const": "approx_time"},
                        {"const": "pages"},
                    ]
                },
            },
        },
        {
            "required": ["threshold"],
            "properties": {
                "threshold": {
                    "pattern": "^(100|[1-9][0-9]?)%$",
                    "maxLength": 4,
                    "type": "string",
                    "description": "A percentage",
                    "minLength": 2,
                },
                "model": {"const": "pages"},
            },
        },
        {
            "required": ["threshold"],
            "properties": {
                "threshold": {"$ref": "#/definitions/mastery_criteria"},
                "model": {"const": "mastery"},
            },
        },
        {
            "required": [],
            "properties": {
                "threshold": {"type": "null"},
                "model": {"const": "reference"},
            },
        },
    ],
    "required": ["model"],
    "additionalProperties": False,
    "definitions": {
        "model": {
            "$exportConstants": "completion_criteria",
            "enum": ["time", "approx_time", "pages", "mastery", "reference"],
            "type": "string",
        },
        "mastery_criteria": {"$ref": "/schemas/mastery_criteria"},
    },
    "$schema": "http://json-schema.org/draft-07/schema#",
    "type": "object",
    "properties": {
        "threshold": True,
        "model": {"$ref": "#/definitions/model"},
        "learner_managed": {"type": "boolean"},
    },
}
