# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: tendermint/abci/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class CheckTxType(betterproto.Enum):
    NEW = 0
    RECHECK = 1


class EvidenceType(betterproto.Enum):
    UNKNOWN = 0
    DUPLICATE_VOTE = 1
    LIGHT_CLIENT_ATTACK = 2


class ResponseOfferSnapshotResult(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    ABORT = 2
    REJECT = 3
    REJECT_FORMAT = 4
    REJECT_SENDER = 5


class ResponseApplySnapshotChunkResult(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    ABORT = 2
    RETRY = 3
    RETRY_SNAPSHOT = 4
    REJECT_SNAPSHOT = 5


@dataclass(eq=False, repr=False)
class Request(betterproto.Message):
    echo: "RequestEcho" = betterproto.message_field(1, group="value")
    flush: "RequestFlush" = betterproto.message_field(2, group="value")
    info: "RequestInfo" = betterproto.message_field(3, group="value")
    set_option: "RequestSetOption" = betterproto.message_field(4, group="value")
    init_chain: "RequestInitChain" = betterproto.message_field(5, group="value")
    query: "RequestQuery" = betterproto.message_field(6, group="value")
    begin_block: "RequestBeginBlock" = betterproto.message_field(7, group="value")
    check_tx: "RequestCheckTx" = betterproto.message_field(8, group="value")
    deliver_tx: "RequestDeliverTx" = betterproto.message_field(9, group="value")
    end_block: "RequestEndBlock" = betterproto.message_field(10, group="value")
    commit: "RequestCommit" = betterproto.message_field(11, group="value")
    list_snapshots: "RequestListSnapshots" = betterproto.message_field(
        12, group="value"
    )
    offer_snapshot: "RequestOfferSnapshot" = betterproto.message_field(
        13, group="value"
    )
    load_snapshot_chunk: "RequestLoadSnapshotChunk" = betterproto.message_field(
        14, group="value"
    )
    apply_snapshot_chunk: "RequestApplySnapshotChunk" = betterproto.message_field(
        15, group="value"
    )


@dataclass(eq=False, repr=False)
class RequestEcho(betterproto.Message):
    message: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RequestFlush(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RequestInfo(betterproto.Message):
    version: str = betterproto.string_field(1)
    block_version: int = betterproto.uint64_field(2)
    p2_p_version: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class RequestSetOption(betterproto.Message):
    """nondeterministic"""

    key: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RequestInitChain(betterproto.Message):
    time: datetime = betterproto.message_field(1)
    chain_id: str = betterproto.string_field(2)
    consensus_params: "ConsensusParams" = betterproto.message_field(3)
    validators: List["ValidatorUpdate"] = betterproto.message_field(4)
    app_state_bytes: bytes = betterproto.bytes_field(5)
    initial_height: int = betterproto.int64_field(6)


@dataclass(eq=False, repr=False)
class RequestQuery(betterproto.Message):
    data: bytes = betterproto.bytes_field(1)
    path: str = betterproto.string_field(2)
    height: int = betterproto.int64_field(3)
    prove: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class RequestBeginBlock(betterproto.Message):
    hash: bytes = betterproto.bytes_field(1)
    header: "_types__.Header" = betterproto.message_field(2)
    last_commit_info: "LastCommitInfo" = betterproto.message_field(3)
    byzantine_validators: List["Evidence"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class RequestCheckTx(betterproto.Message):
    tx: bytes = betterproto.bytes_field(1)
    type: "CheckTxType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class RequestDeliverTx(betterproto.Message):
    tx: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class RequestEndBlock(betterproto.Message):
    height: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class RequestCommit(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RequestListSnapshots(betterproto.Message):
    """lists available snapshots"""

    pass


@dataclass(eq=False, repr=False)
class RequestOfferSnapshot(betterproto.Message):
    """offers a snapshot to the application"""

    snapshot: "Snapshot" = betterproto.message_field(1)
    app_hash: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class RequestLoadSnapshotChunk(betterproto.Message):
    """loads a snapshot chunk"""

    height: int = betterproto.uint64_field(1)
    format: int = betterproto.uint32_field(2)
    chunk: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class RequestApplySnapshotChunk(betterproto.Message):
    """Applies a snapshot chunk"""

    index: int = betterproto.uint32_field(1)
    chunk: bytes = betterproto.bytes_field(2)
    sender: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Response(betterproto.Message):
    exception: "ResponseException" = betterproto.message_field(1, group="value")
    echo: "ResponseEcho" = betterproto.message_field(2, group="value")
    flush: "ResponseFlush" = betterproto.message_field(3, group="value")
    info: "ResponseInfo" = betterproto.message_field(4, group="value")
    set_option: "ResponseSetOption" = betterproto.message_field(5, group="value")
    init_chain: "ResponseInitChain" = betterproto.message_field(6, group="value")
    query: "ResponseQuery" = betterproto.message_field(7, group="value")
    begin_block: "ResponseBeginBlock" = betterproto.message_field(8, group="value")
    check_tx: "ResponseCheckTx" = betterproto.message_field(9, group="value")
    deliver_tx: "ResponseDeliverTx" = betterproto.message_field(10, group="value")
    end_block: "ResponseEndBlock" = betterproto.message_field(11, group="value")
    commit: "ResponseCommit" = betterproto.message_field(12, group="value")
    list_snapshots: "ResponseListSnapshots" = betterproto.message_field(
        13, group="value"
    )
    offer_snapshot: "ResponseOfferSnapshot" = betterproto.message_field(
        14, group="value"
    )
    load_snapshot_chunk: "ResponseLoadSnapshotChunk" = betterproto.message_field(
        15, group="value"
    )
    apply_snapshot_chunk: "ResponseApplySnapshotChunk" = betterproto.message_field(
        16, group="value"
    )


@dataclass(eq=False, repr=False)
class ResponseException(betterproto.Message):
    """nondeterministic"""

    error: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ResponseEcho(betterproto.Message):
    message: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ResponseFlush(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ResponseInfo(betterproto.Message):
    data: str = betterproto.string_field(1)
    version: str = betterproto.string_field(2)
    app_version: int = betterproto.uint64_field(3)
    last_block_height: int = betterproto.int64_field(4)
    last_block_app_hash: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class ResponseSetOption(betterproto.Message):
    """nondeterministic"""

    code: int = betterproto.uint32_field(1)
    # bytes data = 2;
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ResponseInitChain(betterproto.Message):
    consensus_params: "ConsensusParams" = betterproto.message_field(1)
    validators: List["ValidatorUpdate"] = betterproto.message_field(2)
    app_hash: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class ResponseQuery(betterproto.Message):
    code: int = betterproto.uint32_field(1)
    # bytes data = 2; // use "value" instead.
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)
    index: int = betterproto.int64_field(5)
    key: bytes = betterproto.bytes_field(6)
    value: bytes = betterproto.bytes_field(7)
    proof_ops: "_crypto__.ProofOps" = betterproto.message_field(8)
    height: int = betterproto.int64_field(9)
    codespace: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class ResponseBeginBlock(betterproto.Message):
    events: List["Event"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ResponseCheckTx(betterproto.Message):
    code: int = betterproto.uint32_field(1)
    data: bytes = betterproto.bytes_field(2)
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)
    gas_wanted: int = betterproto.int64_field(5)
    gas_used: int = betterproto.int64_field(6)
    events: List["Event"] = betterproto.message_field(7)
    codespace: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class ResponseDeliverTx(betterproto.Message):
    code: int = betterproto.uint32_field(1)
    data: bytes = betterproto.bytes_field(2)
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)
    gas_wanted: int = betterproto.int64_field(5)
    gas_used: int = betterproto.int64_field(6)
    events: List["Event"] = betterproto.message_field(7)
    codespace: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class ResponseEndBlock(betterproto.Message):
    validator_updates: List["ValidatorUpdate"] = betterproto.message_field(1)
    consensus_param_updates: "ConsensusParams" = betterproto.message_field(2)
    events: List["Event"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ResponseCommit(betterproto.Message):
    # reserve 1
    data: bytes = betterproto.bytes_field(2)
    retain_height: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class ResponseListSnapshots(betterproto.Message):
    snapshots: List["Snapshot"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ResponseOfferSnapshot(betterproto.Message):
    result: "ResponseOfferSnapshotResult" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ResponseLoadSnapshotChunk(betterproto.Message):
    chunk: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class ResponseApplySnapshotChunk(betterproto.Message):
    result: "ResponseApplySnapshotChunkResult" = betterproto.enum_field(1)
    refetch_chunks: List[int] = betterproto.uint32_field(2)
    reject_senders: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ConsensusParams(betterproto.Message):
    """
    ConsensusParams contains all consensus-relevant parameters that can be
    adjusted by the abci app
    """

    block: "BlockParams" = betterproto.message_field(1)
    evidence: "_types__.EvidenceParams" = betterproto.message_field(2)
    validator: "_types__.ValidatorParams" = betterproto.message_field(3)
    version: "_types__.VersionParams" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class BlockParams(betterproto.Message):
    """BlockParams contains limits on the block size."""

    # Note: must be greater than 0
    max_bytes: int = betterproto.int64_field(1)
    # Note: must be greater or equal to -1
    max_gas: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class LastCommitInfo(betterproto.Message):
    round: int = betterproto.int32_field(1)
    votes: List["VoteInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """
    Event allows application developers to attach additional information to
    ResponseBeginBlock, ResponseEndBlock, ResponseCheckTx and
    ResponseDeliverTx. Later, transactions may be queried using these events.
    """

    type: str = betterproto.string_field(1)
    attributes: List["EventAttribute"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EventAttribute(betterproto.Message):
    """EventAttribute is a single key-value pair, associated with an event."""

    key: bytes = betterproto.bytes_field(1)
    value: bytes = betterproto.bytes_field(2)
    index: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class TxResult(betterproto.Message):
    """
    TxResult contains results of executing the transaction. One usage is
    indexing transaction results.
    """

    height: int = betterproto.int64_field(1)
    index: int = betterproto.uint32_field(2)
    tx: bytes = betterproto.bytes_field(3)
    result: "ResponseDeliverTx" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Validator(betterproto.Message):
    """Validator"""

    address: bytes = betterproto.bytes_field(1)
    # PubKey pub_key = 2 [(gogoproto.nullable)=false];
    power: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class ValidatorUpdate(betterproto.Message):
    """ValidatorUpdate"""

    pub_key: "_crypto__.PublicKey" = betterproto.message_field(1)
    power: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class VoteInfo(betterproto.Message):
    """VoteInfo"""

    validator: "Validator" = betterproto.message_field(1)
    signed_last_block: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class Evidence(betterproto.Message):
    type: "EvidenceType" = betterproto.enum_field(1)
    # The offending validator
    validator: "Validator" = betterproto.message_field(2)
    # The height when the offense occurred
    height: int = betterproto.int64_field(3)
    # The corresponding time where the offense occurred
    time: datetime = betterproto.message_field(4)
    # Total voting power of the validator set in case the ABCI application does
    # not store historical validators.
    # https://github.com/tendermint/tendermint/issues/4581
    total_voting_power: int = betterproto.int64_field(5)


@dataclass(eq=False, repr=False)
class Snapshot(betterproto.Message):
    height: int = betterproto.uint64_field(1)
    format: int = betterproto.uint32_field(2)
    chunks: int = betterproto.uint32_field(3)
    hash: bytes = betterproto.bytes_field(4)
    metadata: bytes = betterproto.bytes_field(5)


class AbciApplicationStub(betterproto.ServiceStub):
    async def echo(self, *, message: str = "") -> "ResponseEcho":

        request = RequestEcho()
        request.message = message

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/Echo", request, ResponseEcho
        )

    async def flush(self) -> "ResponseFlush":

        request = RequestFlush()

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/Flush", request, ResponseFlush
        )

    async def info(
        self, *, version: str = "", block_version: int = 0, p2_p_version: int = 0
    ) -> "ResponseInfo":

        request = RequestInfo()
        request.version = version
        request.block_version = block_version
        request.p2_p_version = p2_p_version

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/Info", request, ResponseInfo
        )

    async def set_option(
        self, *, key: str = "", value: str = ""
    ) -> "ResponseSetOption":

        request = RequestSetOption()
        request.key = key
        request.value = value

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/SetOption", request, ResponseSetOption
        )

    async def deliver_tx(self, *, tx: bytes = b"") -> "ResponseDeliverTx":

        request = RequestDeliverTx()
        request.tx = tx

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/DeliverTx", request, ResponseDeliverTx
        )

    async def check_tx(
        self, *, tx: bytes = b"", type: "CheckTxType" = 0
    ) -> "ResponseCheckTx":

        request = RequestCheckTx()
        request.tx = tx
        request.type = type

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/CheckTx", request, ResponseCheckTx
        )

    async def query(
        self, *, data: bytes = b"", path: str = "", height: int = 0, prove: bool = False
    ) -> "ResponseQuery":

        request = RequestQuery()
        request.data = data
        request.path = path
        request.height = height
        request.prove = prove

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/Query", request, ResponseQuery
        )

    async def commit(self) -> "ResponseCommit":

        request = RequestCommit()

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/Commit", request, ResponseCommit
        )

    async def init_chain(
        self,
        *,
        time: datetime = None,
        chain_id: str = "",
        consensus_params: "ConsensusParams" = None,
        validators: Optional[List["ValidatorUpdate"]] = None,
        app_state_bytes: bytes = b"",
        initial_height: int = 0
    ) -> "ResponseInitChain":
        validators = validators or []

        request = RequestInitChain()
        if time is not None:
            request.time = time
        request.chain_id = chain_id
        if consensus_params is not None:
            request.consensus_params = consensus_params
        if validators is not None:
            request.validators = validators
        request.app_state_bytes = app_state_bytes
        request.initial_height = initial_height

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/InitChain", request, ResponseInitChain
        )

    async def begin_block(
        self,
        *,
        hash: bytes = b"",
        header: "_types__.Header" = None,
        last_commit_info: "LastCommitInfo" = None,
        byzantine_validators: Optional[List["Evidence"]] = None
    ) -> "ResponseBeginBlock":
        byzantine_validators = byzantine_validators or []

        request = RequestBeginBlock()
        request.hash = hash
        if header is not None:
            request.header = header
        if last_commit_info is not None:
            request.last_commit_info = last_commit_info
        if byzantine_validators is not None:
            request.byzantine_validators = byzantine_validators

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/BeginBlock", request, ResponseBeginBlock
        )

    async def end_block(self, *, height: int = 0) -> "ResponseEndBlock":

        request = RequestEndBlock()
        request.height = height

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/EndBlock", request, ResponseEndBlock
        )

    async def list_snapshots(self) -> "ResponseListSnapshots":

        request = RequestListSnapshots()

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/ListSnapshots",
            request,
            ResponseListSnapshots,
        )

    async def offer_snapshot(
        self, *, snapshot: "Snapshot" = None, app_hash: bytes = b""
    ) -> "ResponseOfferSnapshot":

        request = RequestOfferSnapshot()
        if snapshot is not None:
            request.snapshot = snapshot
        request.app_hash = app_hash

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/OfferSnapshot",
            request,
            ResponseOfferSnapshot,
        )

    async def load_snapshot_chunk(
        self, *, height: int = 0, format: int = 0, chunk: int = 0
    ) -> "ResponseLoadSnapshotChunk":

        request = RequestLoadSnapshotChunk()
        request.height = height
        request.format = format
        request.chunk = chunk

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/LoadSnapshotChunk",
            request,
            ResponseLoadSnapshotChunk,
        )

    async def apply_snapshot_chunk(
        self, *, index: int = 0, chunk: bytes = b"", sender: str = ""
    ) -> "ResponseApplySnapshotChunk":

        request = RequestApplySnapshotChunk()
        request.index = index
        request.chunk = chunk
        request.sender = sender

        return await self._unary_unary(
            "/tendermint.abci.ABCIApplication/ApplySnapshotChunk",
            request,
            ResponseApplySnapshotChunk,
        )


class AbciApplicationBase(ServiceBase):
    async def echo(self, message: str) -> "ResponseEcho":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def flush(self) -> "ResponseFlush":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def info(
        self, version: str, block_version: int, p2_p_version: int
    ) -> "ResponseInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_option(self, key: str, value: str) -> "ResponseSetOption":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def deliver_tx(self, tx: bytes) -> "ResponseDeliverTx":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_tx(self, tx: bytes, type: "CheckTxType") -> "ResponseCheckTx":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def query(
        self, data: bytes, path: str, height: int, prove: bool
    ) -> "ResponseQuery":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def commit(self) -> "ResponseCommit":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def init_chain(
        self,
        time: datetime,
        chain_id: str,
        consensus_params: "ConsensusParams",
        validators: Optional[List["ValidatorUpdate"]],
        app_state_bytes: bytes,
        initial_height: int,
    ) -> "ResponseInitChain":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def begin_block(
        self,
        hash: bytes,
        header: "_types__.Header",
        last_commit_info: "LastCommitInfo",
        byzantine_validators: Optional[List["Evidence"]],
    ) -> "ResponseBeginBlock":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def end_block(self, height: int) -> "ResponseEndBlock":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_snapshots(self) -> "ResponseListSnapshots":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def offer_snapshot(
        self, snapshot: "Snapshot", app_hash: bytes
    ) -> "ResponseOfferSnapshot":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def load_snapshot_chunk(
        self, height: int, format: int, chunk: int
    ) -> "ResponseLoadSnapshotChunk":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def apply_snapshot_chunk(
        self, index: int, chunk: bytes, sender: str
    ) -> "ResponseApplySnapshotChunk":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_echo(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "message": request.message,
        }

        response = await self.echo(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_flush(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.flush(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "version": request.version,
            "block_version": request.block_version,
            "p2_p_version": request.p2_p_version,
        }

        response = await self.info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_set_option(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "key": request.key,
            "value": request.value,
        }

        response = await self.set_option(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_deliver_tx(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "tx": request.tx,
        }

        response = await self.deliver_tx(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_check_tx(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "tx": request.tx,
            "type": request.type,
        }

        response = await self.check_tx(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_query(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "data": request.data,
            "path": request.path,
            "height": request.height,
            "prove": request.prove,
        }

        response = await self.query(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.commit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_init_chain(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "time": request.time,
            "chain_id": request.chain_id,
            "consensus_params": request.consensus_params,
            "validators": request.validators,
            "app_state_bytes": request.app_state_bytes,
            "initial_height": request.initial_height,
        }

        response = await self.init_chain(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_begin_block(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "hash": request.hash,
            "header": request.header,
            "last_commit_info": request.last_commit_info,
            "byzantine_validators": request.byzantine_validators,
        }

        response = await self.begin_block(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_end_block(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
        }

        response = await self.end_block(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_snapshots(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.list_snapshots(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_offer_snapshot(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "snapshot": request.snapshot,
            "app_hash": request.app_hash,
        }

        response = await self.offer_snapshot(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_load_snapshot_chunk(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
            "format": request.format,
            "chunk": request.chunk,
        }

        response = await self.load_snapshot_chunk(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_apply_snapshot_chunk(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "index": request.index,
            "chunk": request.chunk,
            "sender": request.sender,
        }

        response = await self.apply_snapshot_chunk(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/tendermint.abci.ABCIApplication/Echo": grpclib.const.Handler(
                self.__rpc_echo,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestEcho,
                ResponseEcho,
            ),
            "/tendermint.abci.ABCIApplication/Flush": grpclib.const.Handler(
                self.__rpc_flush,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestFlush,
                ResponseFlush,
            ),
            "/tendermint.abci.ABCIApplication/Info": grpclib.const.Handler(
                self.__rpc_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestInfo,
                ResponseInfo,
            ),
            "/tendermint.abci.ABCIApplication/SetOption": grpclib.const.Handler(
                self.__rpc_set_option,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestSetOption,
                ResponseSetOption,
            ),
            "/tendermint.abci.ABCIApplication/DeliverTx": grpclib.const.Handler(
                self.__rpc_deliver_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestDeliverTx,
                ResponseDeliverTx,
            ),
            "/tendermint.abci.ABCIApplication/CheckTx": grpclib.const.Handler(
                self.__rpc_check_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestCheckTx,
                ResponseCheckTx,
            ),
            "/tendermint.abci.ABCIApplication/Query": grpclib.const.Handler(
                self.__rpc_query,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestQuery,
                ResponseQuery,
            ),
            "/tendermint.abci.ABCIApplication/Commit": grpclib.const.Handler(
                self.__rpc_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestCommit,
                ResponseCommit,
            ),
            "/tendermint.abci.ABCIApplication/InitChain": grpclib.const.Handler(
                self.__rpc_init_chain,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestInitChain,
                ResponseInitChain,
            ),
            "/tendermint.abci.ABCIApplication/BeginBlock": grpclib.const.Handler(
                self.__rpc_begin_block,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestBeginBlock,
                ResponseBeginBlock,
            ),
            "/tendermint.abci.ABCIApplication/EndBlock": grpclib.const.Handler(
                self.__rpc_end_block,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestEndBlock,
                ResponseEndBlock,
            ),
            "/tendermint.abci.ABCIApplication/ListSnapshots": grpclib.const.Handler(
                self.__rpc_list_snapshots,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestListSnapshots,
                ResponseListSnapshots,
            ),
            "/tendermint.abci.ABCIApplication/OfferSnapshot": grpclib.const.Handler(
                self.__rpc_offer_snapshot,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestOfferSnapshot,
                ResponseOfferSnapshot,
            ),
            "/tendermint.abci.ABCIApplication/LoadSnapshotChunk": grpclib.const.Handler(
                self.__rpc_load_snapshot_chunk,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestLoadSnapshotChunk,
                ResponseLoadSnapshotChunk,
            ),
            "/tendermint.abci.ABCIApplication/ApplySnapshotChunk": grpclib.const.Handler(
                self.__rpc_apply_snapshot_chunk,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestApplySnapshotChunk,
                ResponseApplySnapshotChunk,
            ),
        }


from .. import crypto as _crypto__
from .. import types as _types__
