# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['osmosis_proto',
 'osmosis_proto.cosmos',
 'osmosis_proto.cosmos.auth',
 'osmosis_proto.cosmos.auth.v1beta1',
 'osmosis_proto.cosmos.authz',
 'osmosis_proto.cosmos.authz.v1beta1',
 'osmosis_proto.cosmos.bank',
 'osmosis_proto.cosmos.bank.v1beta1',
 'osmosis_proto.cosmos.base',
 'osmosis_proto.cosmos.base.abci',
 'osmosis_proto.cosmos.base.abci.v1beta1',
 'osmosis_proto.cosmos.base.kv',
 'osmosis_proto.cosmos.base.kv.v1beta1',
 'osmosis_proto.cosmos.base.query',
 'osmosis_proto.cosmos.base.query.v1beta1',
 'osmosis_proto.cosmos.base.reflection',
 'osmosis_proto.cosmos.base.reflection.v1beta1',
 'osmosis_proto.cosmos.base.reflection.v2alpha1',
 'osmosis_proto.cosmos.base.snapshots',
 'osmosis_proto.cosmos.base.snapshots.v1beta1',
 'osmosis_proto.cosmos.base.store',
 'osmosis_proto.cosmos.base.store.v1beta1',
 'osmosis_proto.cosmos.base.tendermint',
 'osmosis_proto.cosmos.base.tendermint.v1beta1',
 'osmosis_proto.cosmos.base.v1beta1',
 'osmosis_proto.cosmos.capability',
 'osmosis_proto.cosmos.capability.v1beta1',
 'osmosis_proto.cosmos.crisis',
 'osmosis_proto.cosmos.crisis.v1beta1',
 'osmosis_proto.cosmos.crypto',
 'osmosis_proto.cosmos.crypto.ed25519',
 'osmosis_proto.cosmos.crypto.multisig',
 'osmosis_proto.cosmos.crypto.multisig.v1beta1',
 'osmosis_proto.cosmos.crypto.secp256k1',
 'osmosis_proto.cosmos.crypto.secp256r1',
 'osmosis_proto.cosmos.distribution',
 'osmosis_proto.cosmos.distribution.v1beta1',
 'osmosis_proto.cosmos.evidence',
 'osmosis_proto.cosmos.evidence.v1beta1',
 'osmosis_proto.cosmos.feegrant',
 'osmosis_proto.cosmos.feegrant.v1beta1',
 'osmosis_proto.cosmos.genutil',
 'osmosis_proto.cosmos.genutil.v1beta1',
 'osmosis_proto.cosmos.gov',
 'osmosis_proto.cosmos.gov.v1beta1',
 'osmosis_proto.cosmos.mint',
 'osmosis_proto.cosmos.mint.v1beta1',
 'osmosis_proto.cosmos.params',
 'osmosis_proto.cosmos.params.v1beta1',
 'osmosis_proto.cosmos.slashing',
 'osmosis_proto.cosmos.slashing.v1beta1',
 'osmosis_proto.cosmos.staking',
 'osmosis_proto.cosmos.staking.v1beta1',
 'osmosis_proto.cosmos.tx',
 'osmosis_proto.cosmos.tx.signing',
 'osmosis_proto.cosmos.tx.signing.v1beta1',
 'osmosis_proto.cosmos.tx.v1beta1',
 'osmosis_proto.cosmos.upgrade',
 'osmosis_proto.cosmos.upgrade.v1beta1',
 'osmosis_proto.cosmos.vesting',
 'osmosis_proto.cosmos.vesting.v1beta1',
 'osmosis_proto.cosmos_proto',
 'osmosis_proto.epochs',
 'osmosis_proto.epochs.v1beta1',
 'osmosis_proto.gamm',
 'osmosis_proto.gamm.poolmodels',
 'osmosis_proto.gamm.poolmodels.balancer',
 'osmosis_proto.gamm.poolmodels.balancer.v1beta1',
 'osmosis_proto.gamm.poolmodels.stableswap',
 'osmosis_proto.gamm.poolmodels.stableswap.v1beta1',
 'osmosis_proto.gamm.v1beta1',
 'osmosis_proto.gogoproto',
 'osmosis_proto.google',
 'osmosis_proto.google.api',
 'osmosis_proto.ibcratelimit',
 'osmosis_proto.ibcratelimit.v1beta1',
 'osmosis_proto.incentives',
 'osmosis_proto.lockup',
 'osmosis_proto.mint',
 'osmosis_proto.mint.v1beta1',
 'osmosis_proto.poolincentives',
 'osmosis_proto.poolincentives.v1beta1',
 'osmosis_proto.store',
 'osmosis_proto.store.v1beta1',
 'osmosis_proto.streamswap',
 'osmosis_proto.streamswap.v1',
 'osmosis_proto.superfluid',
 'osmosis_proto.superfluid.v1beta1',
 'osmosis_proto.tokenfactory',
 'osmosis_proto.tokenfactory.v1beta1',
 'osmosis_proto.twap',
 'osmosis_proto.twap.v1beta1',
 'osmosis_proto.txfees',
 'osmosis_proto.txfees.v1beta1',
 'terra_proto',
 'terra_proto.cosmos',
 'terra_proto.cosmos.auth',
 'terra_proto.cosmos.auth.v1beta1',
 'terra_proto.cosmos.authz',
 'terra_proto.cosmos.authz.v1beta1',
 'terra_proto.cosmos.bank',
 'terra_proto.cosmos.bank.v1beta1',
 'terra_proto.cosmos.base',
 'terra_proto.cosmos.base.abci',
 'terra_proto.cosmos.base.abci.v1beta1',
 'terra_proto.cosmos.base.kv',
 'terra_proto.cosmos.base.kv.v1beta1',
 'terra_proto.cosmos.base.query',
 'terra_proto.cosmos.base.query.v1beta1',
 'terra_proto.cosmos.base.reflection',
 'terra_proto.cosmos.base.reflection.v1beta1',
 'terra_proto.cosmos.base.reflection.v2alpha1',
 'terra_proto.cosmos.base.snapshots',
 'terra_proto.cosmos.base.snapshots.v1beta1',
 'terra_proto.cosmos.base.store',
 'terra_proto.cosmos.base.store.v1beta1',
 'terra_proto.cosmos.base.tendermint',
 'terra_proto.cosmos.base.tendermint.v1beta1',
 'terra_proto.cosmos.base.v1beta1',
 'terra_proto.cosmos.capability',
 'terra_proto.cosmos.capability.v1beta1',
 'terra_proto.cosmos.crisis',
 'terra_proto.cosmos.crisis.v1beta1',
 'terra_proto.cosmos.crypto',
 'terra_proto.cosmos.crypto.ed25519',
 'terra_proto.cosmos.crypto.multisig',
 'terra_proto.cosmos.crypto.multisig.v1beta1',
 'terra_proto.cosmos.crypto.secp256k1',
 'terra_proto.cosmos.crypto.secp256r1',
 'terra_proto.cosmos.distribution',
 'terra_proto.cosmos.distribution.v1beta1',
 'terra_proto.cosmos.evidence',
 'terra_proto.cosmos.evidence.v1beta1',
 'terra_proto.cosmos.feegrant',
 'terra_proto.cosmos.feegrant.v1beta1',
 'terra_proto.cosmos.genutil',
 'terra_proto.cosmos.genutil.v1beta1',
 'terra_proto.cosmos.gov',
 'terra_proto.cosmos.gov.v1beta1',
 'terra_proto.cosmos.mint',
 'terra_proto.cosmos.mint.v1beta1',
 'terra_proto.cosmos.params',
 'terra_proto.cosmos.params.v1beta1',
 'terra_proto.cosmos.slashing',
 'terra_proto.cosmos.slashing.v1beta1',
 'terra_proto.cosmos.staking',
 'terra_proto.cosmos.staking.v1beta1',
 'terra_proto.cosmos.tx',
 'terra_proto.cosmos.tx.signing',
 'terra_proto.cosmos.tx.signing.v1beta1',
 'terra_proto.cosmos.tx.v1beta1',
 'terra_proto.cosmos.upgrade',
 'terra_proto.cosmos.upgrade.v1beta1',
 'terra_proto.cosmos.vesting',
 'terra_proto.cosmos.vesting.v1beta1',
 'terra_proto.cosmos_proto',
 'terra_proto.cosmwasm',
 'terra_proto.cosmwasm.wasm',
 'terra_proto.cosmwasm.wasm.v1',
 'terra_proto.gogoproto',
 'terra_proto.google',
 'terra_proto.google.api',
 'terra_proto.ibc',
 'terra_proto.ibc.applications',
 'terra_proto.ibc.applications.fee',
 'terra_proto.ibc.applications.fee.v1',
 'terra_proto.ibc.applications.interchain_accounts',
 'terra_proto.ibc.applications.interchain_accounts.controller',
 'terra_proto.ibc.applications.interchain_accounts.controller.v1',
 'terra_proto.ibc.applications.interchain_accounts.host',
 'terra_proto.ibc.applications.interchain_accounts.host.v1',
 'terra_proto.ibc.applications.interchain_accounts.v1',
 'terra_proto.ibc.applications.transfer',
 'terra_proto.ibc.applications.transfer.v1',
 'terra_proto.ibc.applications.transfer.v2',
 'terra_proto.ibc.core',
 'terra_proto.ibc.core.channel',
 'terra_proto.ibc.core.channel.v1',
 'terra_proto.ibc.core.client',
 'terra_proto.ibc.core.client.v1',
 'terra_proto.ibc.core.commitment',
 'terra_proto.ibc.core.commitment.v1',
 'terra_proto.ibc.core.connection',
 'terra_proto.ibc.core.connection.v1',
 'terra_proto.ibc.core.types',
 'terra_proto.ibc.core.types.v1',
 'terra_proto.ibc.lightclients',
 'terra_proto.ibc.lightclients.localhost',
 'terra_proto.ibc.lightclients.localhost.v1',
 'terra_proto.ibc.lightclients.solomachine',
 'terra_proto.ibc.lightclients.solomachine.v1',
 'terra_proto.ibc.lightclients.solomachine.v2',
 'terra_proto.ibc.lightclients.tendermint',
 'terra_proto.ibc.lightclients.tendermint.v1',
 'terra_proto.ics23',
 'terra_proto.tendermint',
 'terra_proto.tendermint.abci',
 'terra_proto.tendermint.crypto',
 'terra_proto.tendermint.libs',
 'terra_proto.tendermint.libs.bits',
 'terra_proto.tendermint.p2p',
 'terra_proto.tendermint.types',
 'terra_proto.tendermint.version']

package_data = \
{'': ['*']}

install_requires = \
['MarkupSafe==2.0.1', 'betterproto==2.0.0b4']

setup_kwargs = {
    'name': 'cosmos-proto',
    'version': '0.0.0',
    'description': 'The Python Protobuf implementation for Cosmos SDK chains',
    'long_description': '# Python implementation for cosmos.proto\n\nCurrently, this repo contains generated python files for Terra 2 and Osmosis Blockchains supported Modules.\n\n### Setup\n\n1. Create virtual environment \n\n```\n$ python3 -m venv env\n$ source env/bin/activate\n```\n\n2. Install poetry\n```\n$ pip install poetry\n```\n\n3. Install packages,\n\n```\n$ pip install poetry\n$ poetry install\n```\n\nIf you encounter "version solving failed." error, try `poetry add <package_name>`, followed by `poetry lock` and then `poetry install`\n\n### Generating python files for new proto files\n\nWe use `betterproto[compiler]` for generating python code from proto files, and it is party a manual process. Here are a few pointers to help you through the process - \n\n\n- `cd` into each module and make sure all *.proto files are in one place.\n- For each .proto file, check the import paths and update them if needed. \n- Once the paths are corrected, use the following command to generate python files. \n\n```\n$ protoc -I . --python_betterproto_out=<OUTPUT DIR NAME> <PROTO FILE NAMES>\n```\n\nFor eq - protoc -I . --python_betterproto_out=py genesis.proto query.proto gov.proto feetoken.proto\n\nTo install `betterproto[compiler]`, use - \n\n```\npip install "betterproto[compiler]"\n```\n\n\n\n\nTO DO : Update the scripts',
    'author': 'AstroTech Labs, PTE.',
    'author_email': 'buidl@astrotechlabs.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/AstroTech-Labs/cosmos_proto',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
