# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: feetoken.proto, genesis.proto, gov.proto, query.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class FeeToken(betterproto.Message):
    """
    FeeToken is a struct that specifies a coin denom, and pool ID pair. This
    marks the token as eligible for use as a tx fee asset in Osmosis. Its price
    in osmo is derived through looking at the provided pool ID. The pool ID
    must have osmo as one of its assets.
    """

    denom: str = betterproto.string_field(1)
    pool_id: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the txfees module's genesis state."""

    basedenom: str = betterproto.string_field(1)
    feetokens: List["FeeToken"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryFeeTokensRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class QueryFeeTokensResponse(betterproto.Message):
    fee_tokens: List["FeeToken"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomSpotPriceRequest(betterproto.Message):
    """
    QueryDenomSpotPriceRequest defines grpc request structure for querying spot
    price for the specified tx fee denom
    """

    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomSpotPriceResponse(betterproto.Message):
    """
    QueryDenomSpotPriceRequest defines grpc response structure for querying
    spot price for the specified tx fee denom
    """

    pool_id: int = betterproto.uint64_field(1)
    spot_price: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryDenomPoolIdRequest(betterproto.Message):
    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomPoolIdResponse(betterproto.Message):
    pool_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class QueryBaseDenomRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class QueryBaseDenomResponse(betterproto.Message):
    base_denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class UpdateFeeTokenProposal(betterproto.Message):
    """
    UpdateFeeTokenProposal is a gov Content type for adding a new whitelisted
    fee token. It must specify a denom along with gamm pool ID to use as a spot
    price calculator. It can be used to add a new denom to the whitelist It can
    also be used to update the Pool to associate with the denom. If Pool ID is
    set to 0, it will remove the denom from the whitelisted set.
    """

    title: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    feetoken: "FeeToken" = betterproto.message_field(3)


class QueryStub(betterproto.ServiceStub):
    async def fee_tokens(
        self,
        query_fee_tokens_request: "QueryFeeTokensRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryFeeTokensResponse":
        return await self._unary_unary(
            "/osmosis.txfees.v1beta1.Query/FeeTokens",
            query_fee_tokens_request,
            QueryFeeTokensResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denom_spot_price(
        self,
        query_denom_spot_price_request: "QueryDenomSpotPriceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomSpotPriceResponse":
        return await self._unary_unary(
            "/osmosis.txfees.v1beta1.Query/DenomSpotPrice",
            query_denom_spot_price_request,
            QueryDenomSpotPriceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denom_pool_id(
        self,
        query_denom_pool_id_request: "QueryDenomPoolIdRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomPoolIdResponse":
        return await self._unary_unary(
            "/osmosis.txfees.v1beta1.Query/DenomPoolId",
            query_denom_pool_id_request,
            QueryDenomPoolIdResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def base_denom(
        self,
        query_base_denom_request: "QueryBaseDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryBaseDenomResponse":
        return await self._unary_unary(
            "/osmosis.txfees.v1beta1.Query/BaseDenom",
            query_base_denom_request,
            QueryBaseDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def fee_tokens(
        self, query_fee_tokens_request: "QueryFeeTokensRequest"
    ) -> "QueryFeeTokensResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denom_spot_price(
        self, query_denom_spot_price_request: "QueryDenomSpotPriceRequest"
    ) -> "QueryDenomSpotPriceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denom_pool_id(
        self, query_denom_pool_id_request: "QueryDenomPoolIdRequest"
    ) -> "QueryDenomPoolIdResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def base_denom(
        self, query_base_denom_request: "QueryBaseDenomRequest"
    ) -> "QueryBaseDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_fee_tokens(
        self,
        stream: "grpclib.server.Stream[QueryFeeTokensRequest, QueryFeeTokensResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fee_tokens(request)
        await stream.send_message(response)

    async def __rpc_denom_spot_price(
        self,
        stream: "grpclib.server.Stream[QueryDenomSpotPriceRequest, QueryDenomSpotPriceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denom_spot_price(request)
        await stream.send_message(response)

    async def __rpc_denom_pool_id(
        self,
        stream: "grpclib.server.Stream[QueryDenomPoolIdRequest, QueryDenomPoolIdResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denom_pool_id(request)
        await stream.send_message(response)

    async def __rpc_base_denom(
        self,
        stream: "grpclib.server.Stream[QueryBaseDenomRequest, QueryBaseDenomResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.base_denom(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.txfees.v1beta1.Query/FeeTokens": grpclib.const.Handler(
                self.__rpc_fee_tokens,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryFeeTokensRequest,
                QueryFeeTokensResponse,
            ),
            "/osmosis.txfees.v1beta1.Query/DenomSpotPrice": grpclib.const.Handler(
                self.__rpc_denom_spot_price,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomSpotPriceRequest,
                QueryDenomSpotPriceResponse,
            ),
            "/osmosis.txfees.v1beta1.Query/DenomPoolId": grpclib.const.Handler(
                self.__rpc_denom_pool_id,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomPoolIdRequest,
                QueryDenomPoolIdResponse,
            ),
            "/osmosis.txfees.v1beta1.Query/BaseDenom": grpclib.const.Handler(
                self.__rpc_base_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryBaseDenomRequest,
                QueryBaseDenomResponse,
            ),
        }
