# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: genesis.proto, query.proto, twap_record.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class TwapRecord(betterproto.Message):
    """
    A TWAP record should be indexed in state by pool_id, (asset pair),
    timestamp The asset pair assets should be lexicographically sorted.
    Technically (pool_id, asset_0_denom, asset_1_denom, height) do not need to
    appear in the struct however we view this as the wrong performance tradeoff
    given SDK today. Would rather we optimize for readability and correctness,
    than an optimal state storage format. The system bottleneck is elsewhere
    for now.
    """

    pool_id: int = betterproto.uint64_field(1)
    asset0_denom: str = betterproto.string_field(2)
    """Lexicographically smaller denom of the pair"""

    asset1_denom: str = betterproto.string_field(3)
    """Lexicographically larger denom of the pair"""

    height: int = betterproto.int64_field(4)
    """height this record corresponds to, for debugging purposes"""

    time: datetime = betterproto.message_field(5)
    """
    This field should only exist until we have a global registry in the state
    machine, mapping prior block heights within {TIME RANGE} to times.
    """

    p0_last_spot_price: str = betterproto.string_field(6)
    """
    We store the last spot prices in the struct, so that we can interpolate
    accumulator values for times between when accumulator records are stored.
    """

    p1_last_spot_price: str = betterproto.string_field(7)
    p0_arithmetic_twap_accumulator: str = betterproto.string_field(8)
    p1_arithmetic_twap_accumulator: str = betterproto.string_field(9)
    last_error_time: datetime = betterproto.message_field(11)
    """
    This field contains the time in which the last spot price error occured. It
    is used to alert the caller if they are getting a potentially erroneous
    TWAP, due to an unforeseen underlying error.
    """


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params holds parameters for the twap module"""

    prune_epoch_identifier: str = betterproto.string_field(1)
    record_history_keep_period: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the twap module's genesis state."""

    twaps: List["TwapRecord"] = betterproto.message_field(1)
    """twaps is the collection of all twap records."""

    params: "Params" = betterproto.message_field(2)
    """params is the container of twap parameters."""


@dataclass(eq=False, repr=False)
class ArithmeticTwapRequest(betterproto.Message):
    pool_id: int = betterproto.uint64_field(1)
    base_asset: str = betterproto.string_field(2)
    quote_asset: str = betterproto.string_field(3)
    start_time: datetime = betterproto.message_field(4)
    end_time: datetime = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class ArithmeticTwapResponse(betterproto.Message):
    arithmetic_twap: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ArithmeticTwapToNowRequest(betterproto.Message):
    pool_id: int = betterproto.uint64_field(1)
    base_asset: str = betterproto.string_field(2)
    quote_asset: str = betterproto.string_field(3)
    start_time: datetime = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ArithmeticTwapToNowResponse(betterproto.Message):
    arithmetic_twap: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ParamsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ParamsResponse(betterproto.Message):
    params: "Params" = betterproto.message_field(1)


class QueryStub(betterproto.ServiceStub):
    async def params(
        self,
        params_request: "ParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ParamsResponse":
        return await self._unary_unary(
            "/osmosis.twap.v1beta1.Query/Params",
            params_request,
            ParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def arithmetic_twap(
        self,
        arithmetic_twap_request: "ArithmeticTwapRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ArithmeticTwapResponse":
        return await self._unary_unary(
            "/osmosis.twap.v1beta1.Query/ArithmeticTwap",
            arithmetic_twap_request,
            ArithmeticTwapResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def arithmetic_twap_to_now(
        self,
        arithmetic_twap_to_now_request: "ArithmeticTwapToNowRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ArithmeticTwapToNowResponse":
        return await self._unary_unary(
            "/osmosis.twap.v1beta1.Query/ArithmeticTwapToNow",
            arithmetic_twap_to_now_request,
            ArithmeticTwapToNowResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def params(self, params_request: "ParamsRequest") -> "ParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def arithmetic_twap(
        self, arithmetic_twap_request: "ArithmeticTwapRequest"
    ) -> "ArithmeticTwapResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def arithmetic_twap_to_now(
        self, arithmetic_twap_to_now_request: "ArithmeticTwapToNowRequest"
    ) -> "ArithmeticTwapToNowResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[ParamsRequest, ParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_arithmetic_twap(
        self,
        stream: "grpclib.server.Stream[ArithmeticTwapRequest, ArithmeticTwapResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.arithmetic_twap(request)
        await stream.send_message(response)

    async def __rpc_arithmetic_twap_to_now(
        self,
        stream: "grpclib.server.Stream[ArithmeticTwapToNowRequest, ArithmeticTwapToNowResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.arithmetic_twap_to_now(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.twap.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                ParamsRequest,
                ParamsResponse,
            ),
            "/osmosis.twap.v1beta1.Query/ArithmeticTwap": grpclib.const.Handler(
                self.__rpc_arithmetic_twap,
                grpclib.const.Cardinality.UNARY_UNARY,
                ArithmeticTwapRequest,
                ArithmeticTwapResponse,
            ),
            "/osmosis.twap.v1beta1.Query/ArithmeticTwapToNow": grpclib.const.Handler(
                self.__rpc_arithmetic_twap_to_now,
                grpclib.const.Cardinality.UNARY_UNARY,
                ArithmeticTwapToNowRequest,
                ArithmeticTwapToNowResponse,
            ),
        }
