# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: authorityMetadata.proto, genesis.proto, params.proto, query.proto, tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....cosmos.bank import v1beta1 as ___cosmos_bank_v1_beta1__
from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class DenomAuthorityMetadata(betterproto.Message):
    """
    DenomAuthorityMetadata specifies metadata for addresses that have specific
    capabilities over a token factory denom. Right now there is only one Admin
    permission, but is planned to be extended to the future.
    """

    admin: str = betterproto.string_field(1)
    """Can be empty for no admin, or a valid osmosis address"""


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the tokenfactory module."""

    denom_creation_fee: List[
        "___cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the tokenfactory module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    """params defines the paramaters of the module."""

    factory_denoms: List["GenesisDenom"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GenesisDenom(betterproto.Message):
    """
    GenesisDenom defines a tokenfactory denom that is defined within genesis
    state. The structure contains DenomAuthorityMetadata which defines the
    denom's admin.
    """

    denom: str = betterproto.string_field(1)
    authority_metadata: "DenomAuthorityMetadata" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """params defines the parameters of the module."""


@dataclass(eq=False, repr=False)
class QueryDenomAuthorityMetadataRequest(betterproto.Message):
    """
    QueryDenomAuthorityMetadataRequest defines the request structure for the
    DenomAuthorityMetadata gRPC query.
    """

    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomAuthorityMetadataResponse(betterproto.Message):
    """
    QueryDenomAuthorityMetadataResponse defines the response structure for the
    DenomAuthorityMetadata gRPC query.
    """

    authority_metadata: "DenomAuthorityMetadata" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomsFromCreatorRequest(betterproto.Message):
    """
    QueryDenomsFromCreatorRequest defines the request structure for the
    DenomsFromCreator gRPC query.
    """

    creator: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomsFromCreatorResponse(betterproto.Message):
    """
    QueryDenomsFromCreatorRequest defines the response structure for the
    DenomsFromCreator gRPC query.
    """

    denoms: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgCreateDenom(betterproto.Message):
    """
    MsgCreateDenom defines the message structure for the CreateDenom gRPC
    service method. It allows an account to create a new denom. It requires a
    sender address and a sub denomination. The (sender_address,
    sub_denomination) tuple must be unique and cannot be re-used. The resulting
    denom created is defined as <factory/{creatorAddress}/{subdenom}>. The
    resulting denom's admin is originally set to be the creator, but this can
    be changed later. The token denom does not indicate the current admin.
    """

    sender: str = betterproto.string_field(1)
    subdenom: str = betterproto.string_field(2)
    """subdenom can be up to 44 "alphanumeric" characters long."""


@dataclass(eq=False, repr=False)
class MsgCreateDenomResponse(betterproto.Message):
    """
    MsgCreateDenomResponse is the return value of MsgCreateDenom It returns the
    full string of the newly created denom
    """

    new_token_denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgMint(betterproto.Message):
    """
    MsgMint is the sdk.Msg type for allowing an admin account to mint more of a
    token.  For now, we only support minting to the sender account
    """

    sender: str = betterproto.string_field(1)
    amount: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgMintResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgBurn(betterproto.Message):
    """
    MsgBurn is the sdk.Msg type for allowing an admin account to burn a token.
    For now, we only support burning from the sender account.
    """

    sender: str = betterproto.string_field(1)
    amount: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgBurnResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgChangeAdmin(betterproto.Message):
    """
    MsgChangeAdmin is the sdk.Msg type for allowing an admin account to
    reassign adminship of a denom to a new account
    """

    sender: str = betterproto.string_field(1)
    denom: str = betterproto.string_field(2)
    new_admin: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChangeAdminResponse(betterproto.Message):
    """
    MsgChangeAdminResponse defines the response structure for an executed
    MsgChangeAdmin message.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgSetDenomMetadata(betterproto.Message):
    """
    MsgSetDenomMetadata is the sdk.Msg type for allowing an admin account to
    set the denom's bank metadata
    """

    sender: str = betterproto.string_field(1)
    metadata: "___cosmos_bank_v1_beta1__.Metadata" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgSetDenomMetadataResponse(betterproto.Message):
    """
    MsgSetDenomMetadataResponse defines the response structure for an executed
    MsgSetDenomMetadata message.
    """

    pass


class QueryStub(betterproto.ServiceStub):
    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denom_authority_metadata(
        self,
        query_denom_authority_metadata_request: "QueryDenomAuthorityMetadataRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomAuthorityMetadataResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Query/DenomAuthorityMetadata",
            query_denom_authority_metadata_request,
            QueryDenomAuthorityMetadataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denoms_from_creator(
        self,
        query_denoms_from_creator_request: "QueryDenomsFromCreatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomsFromCreatorResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Query/DenomsFromCreator",
            query_denoms_from_creator_request,
            QueryDenomsFromCreatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgStub(betterproto.ServiceStub):
    async def create_denom(
        self,
        msg_create_denom: "MsgCreateDenom",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateDenomResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Msg/CreateDenom",
            msg_create_denom,
            MsgCreateDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def mint(
        self,
        msg_mint: "MsgMint",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgMintResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Msg/Mint",
            msg_mint,
            MsgMintResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def burn(
        self,
        msg_burn: "MsgBurn",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgBurnResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Msg/Burn",
            msg_burn,
            MsgBurnResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def change_admin(
        self,
        msg_change_admin: "MsgChangeAdmin",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChangeAdminResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Msg/ChangeAdmin",
            msg_change_admin,
            MsgChangeAdminResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_denom_metadata(
        self,
        msg_set_denom_metadata: "MsgSetDenomMetadata",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSetDenomMetadataResponse":
        return await self._unary_unary(
            "/osmosis.tokenfactory.v1beta1.Msg/SetDenomMetadata",
            msg_set_denom_metadata,
            MsgSetDenomMetadataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denom_authority_metadata(
        self,
        query_denom_authority_metadata_request: "QueryDenomAuthorityMetadataRequest",
    ) -> "QueryDenomAuthorityMetadataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denoms_from_creator(
        self, query_denoms_from_creator_request: "QueryDenomsFromCreatorRequest"
    ) -> "QueryDenomsFromCreatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_denom_authority_metadata(
        self,
        stream: "grpclib.server.Stream[QueryDenomAuthorityMetadataRequest, QueryDenomAuthorityMetadataResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denom_authority_metadata(request)
        await stream.send_message(response)

    async def __rpc_denoms_from_creator(
        self,
        stream: "grpclib.server.Stream[QueryDenomsFromCreatorRequest, QueryDenomsFromCreatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denoms_from_creator(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.tokenfactory.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Query/DenomAuthorityMetadata": grpclib.const.Handler(
                self.__rpc_denom_authority_metadata,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomAuthorityMetadataRequest,
                QueryDenomAuthorityMetadataResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Query/DenomsFromCreator": grpclib.const.Handler(
                self.__rpc_denoms_from_creator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomsFromCreatorRequest,
                QueryDenomsFromCreatorResponse,
            ),
        }


class MsgBase(ServiceBase):
    async def create_denom(
        self, msg_create_denom: "MsgCreateDenom"
    ) -> "MsgCreateDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def mint(self, msg_mint: "MsgMint") -> "MsgMintResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def burn(self, msg_burn: "MsgBurn") -> "MsgBurnResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def change_admin(
        self, msg_change_admin: "MsgChangeAdmin"
    ) -> "MsgChangeAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_denom_metadata(
        self, msg_set_denom_metadata: "MsgSetDenomMetadata"
    ) -> "MsgSetDenomMetadataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_denom(
        self, stream: "grpclib.server.Stream[MsgCreateDenom, MsgCreateDenomResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_denom(request)
        await stream.send_message(response)

    async def __rpc_mint(
        self, stream: "grpclib.server.Stream[MsgMint, MsgMintResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.mint(request)
        await stream.send_message(response)

    async def __rpc_burn(
        self, stream: "grpclib.server.Stream[MsgBurn, MsgBurnResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.burn(request)
        await stream.send_message(response)

    async def __rpc_change_admin(
        self, stream: "grpclib.server.Stream[MsgChangeAdmin, MsgChangeAdminResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.change_admin(request)
        await stream.send_message(response)

    async def __rpc_set_denom_metadata(
        self,
        stream: "grpclib.server.Stream[MsgSetDenomMetadata, MsgSetDenomMetadataResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_denom_metadata(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.tokenfactory.v1beta1.Msg/CreateDenom": grpclib.const.Handler(
                self.__rpc_create_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateDenom,
                MsgCreateDenomResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Msg/Mint": grpclib.const.Handler(
                self.__rpc_mint,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMint,
                MsgMintResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Msg/Burn": grpclib.const.Handler(
                self.__rpc_burn,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgBurn,
                MsgBurnResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Msg/ChangeAdmin": grpclib.const.Handler(
                self.__rpc_change_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChangeAdmin,
                MsgChangeAdminResponse,
            ),
            "/osmosis.tokenfactory.v1beta1.Msg/SetDenomMetadata": grpclib.const.Handler(
                self.__rpc_set_denom_metadata,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSetDenomMetadata,
                MsgSetDenomMetadataResponse,
            ),
        }
