# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: genesis.proto, params.proto, query.proto, superfluid.proto, tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...cosmos.base import v1beta1 as __cosmos_base_v1_beta1__
from ...cosmos.base.query import v1beta1 as __cosmos_base_query_v1_beta1__
from ...cosmos.staking import v1beta1 as __cosmos_staking_v1_beta1__
from .. import lockup as _lockup__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class SuperfluidAssetType(betterproto.Enum):
    """
    SuperfluidAssetType indicates whether the superfluid asset is a native
    token itself or the lp share of a pool.
    """

    SuperfluidAssetTypeNative = 0
    SuperfluidAssetTypeLPShare = 1


@dataclass(eq=False, repr=False)
class SuperfluidAsset(betterproto.Message):
    """
    SuperfluidAsset stores the pair of superfluid asset type and denom pair
    """

    denom: str = betterproto.string_field(1)
    asset_type: "SuperfluidAssetType" = betterproto.enum_field(2)
    """
    AssetType indicates whether the superfluid asset is a native token or an lp
    share
    """


@dataclass(eq=False, repr=False)
class SuperfluidIntermediaryAccount(betterproto.Message):
    """
    SuperfluidIntermediaryAccount takes the role of intermediary between LP
    token and OSMO tokens for superfluid staking. The intermediary account is
    the actual account responsible for delegation, not the validator account
    itself.
    """

    denom: str = betterproto.string_field(1)
    """Denom indicates the denom of the superfluid asset."""

    val_addr: str = betterproto.string_field(2)
    gauge_id: int = betterproto.uint64_field(3)
    """perpetual gauge for rewards distribution"""


@dataclass(eq=False, repr=False)
class OsmoEquivalentMultiplierRecord(betterproto.Message):
    """
    The Osmo-Equivalent-Multiplier Record for epoch N refers to the osmo worth
    we treat an LP share as having, for all of epoch N. Eventually this is
    intended to be set as the Time-weighted-average-osmo-backing for the entire
    duration of epoch N-1. (Thereby locking whats in use for epoch N as based
    on the prior epochs rewards) However for now, this is not the TWAP but
    instead the spot price at the boundary. For different types of assets in
    the future, it could change.
    """

    epoch_number: int = betterproto.int64_field(1)
    denom: str = betterproto.string_field(2)
    """superfluid asset denom, can be LP token or native token"""

    multiplier: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationRecord(betterproto.Message):
    """
    SuperfluidDelegationRecord is a struct used to indicate superfluid
    delegations of an account in the state machine in a user friendly form.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    delegation_amount: "__cosmos_base_v1_beta1__.Coin" = betterproto.message_field(3)
    equivalent_staked_amount: "__cosmos_base_v1_beta1__.Coin" = (
        betterproto.message_field(4)
    )


@dataclass(eq=False, repr=False)
class LockIdIntermediaryAccountConnection(betterproto.Message):
    """
    LockIdIntermediaryAccountConnection is a struct used to indicate the
    relationship between the underlying lock id and superfluid delegation done
    via lp shares.
    """

    lock_id: int = betterproto.uint64_field(1)
    intermediary_account: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class UnpoolWhitelistedPools(betterproto.Message):
    ids: List[int] = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params holds parameters for the superfluid module"""

    minimum_risk_factor: str = betterproto.string_field(1)
    """
    minimum_risk_factor is to be cut on OSMO equivalent value of lp tokens for
    superfluid staking, default: 5%. The minimum risk factor works to counter-
    balance the staked amount on chain's exposure to various asset
    volatilities, and have base staking be 'resistant' to volatility.
    """


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    superfluid_assets: List["SuperfluidAsset"] = betterproto.message_field(2)
    """
    superfluid_assets defines the registered superfluid assets that have been
    registered via governance.
    """

    osmo_equivalent_multipliers: List[
        "OsmoEquivalentMultiplierRecord"
    ] = betterproto.message_field(3)
    """
    osmo_equivalent_multipliers is the records of osmo equivalent amount of
    each superfluid registered pool, updated every epoch.
    """

    intermediary_accounts: List[
        "SuperfluidIntermediaryAccount"
    ] = betterproto.message_field(4)
    """
    intermediary_accounts is a secondary account for superfluid staking that
    plays an intermediary role between validators and the delegators.
    """

    intemediary_account_connections: List[
        "LockIdIntermediaryAccountConnection"
    ] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    params: "Params" = betterproto.message_field(1)
    """params defines the parameters of the module."""


@dataclass(eq=False, repr=False)
class AssetTypeRequest(betterproto.Message):
    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AssetTypeResponse(betterproto.Message):
    asset_type: "SuperfluidAssetType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class AllAssetsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AllAssetsResponse(betterproto.Message):
    assets: List["SuperfluidAsset"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AssetMultiplierRequest(betterproto.Message):
    denom: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AssetMultiplierResponse(betterproto.Message):
    osmo_equivalent_multiplier: "OsmoEquivalentMultiplierRecord" = (
        betterproto.message_field(1)
    )


@dataclass(eq=False, repr=False)
class SuperfluidIntermediaryAccountInfo(betterproto.Message):
    denom: str = betterproto.string_field(1)
    val_addr: str = betterproto.string_field(2)
    gauge_id: int = betterproto.uint64_field(3)
    address: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class AllIntermediaryAccountsRequest(betterproto.Message):
    pagination: "__cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )


@dataclass(eq=False, repr=False)
class AllIntermediaryAccountsResponse(betterproto.Message):
    accounts: List["SuperfluidIntermediaryAccountInfo"] = betterproto.message_field(1)
    pagination: "__cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class ConnectedIntermediaryAccountRequest(betterproto.Message):
    lock_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class ConnectedIntermediaryAccountResponse(betterproto.Message):
    account: "SuperfluidIntermediaryAccountInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TotalSuperfluidDelegationsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class TotalSuperfluidDelegationsResponse(betterproto.Message):
    total_delegations: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationAmountRequest(betterproto.Message):
    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    denom: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationAmountResponse(betterproto.Message):
    amount: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationsByDelegatorRequest(betterproto.Message):
    delegator_address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationsByDelegatorResponse(betterproto.Message):
    superfluid_delegation_records: List[
        "SuperfluidDelegationRecord"
    ] = betterproto.message_field(1)
    total_delegated_coins: List[
        "__cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(2)
    total_equivalent_staked_amount: "__cosmos_base_v1_beta1__.Coin" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class SuperfluidUndelegationsByDelegatorRequest(betterproto.Message):
    delegator_address: str = betterproto.string_field(1)
    denom: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SuperfluidUndelegationsByDelegatorResponse(betterproto.Message):
    superfluid_delegation_records: List[
        "SuperfluidDelegationRecord"
    ] = betterproto.message_field(1)
    total_undelegated_coins: List[
        "__cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(2)
    synthetic_locks: List["_lockup__.SyntheticLock"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationsByValidatorDenomRequest(betterproto.Message):
    validator_address: str = betterproto.string_field(1)
    denom: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SuperfluidDelegationsByValidatorDenomResponse(betterproto.Message):
    superfluid_delegation_records: List[
        "SuperfluidDelegationRecord"
    ] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class EstimateSuperfluidDelegatedAmountByValidatorDenomRequest(betterproto.Message):
    validator_address: str = betterproto.string_field(1)
    denom: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EstimateSuperfluidDelegatedAmountByValidatorDenomResponse(betterproto.Message):
    total_delegated_coins: List[
        "__cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalDelegationByDelegatorRequest(betterproto.Message):
    delegator_address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryTotalDelegationByDelegatorResponse(betterproto.Message):
    superfluid_delegation_records: List[
        "SuperfluidDelegationRecord"
    ] = betterproto.message_field(1)
    delegation_response: List[
        "__cosmos_staking_v1_beta1__.DelegationResponse"
    ] = betterproto.message_field(2)
    total_delegated_coins: List[
        "__cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(3)
    total_equivalent_staked_amount: "__cosmos_base_v1_beta1__.Coin" = (
        betterproto.message_field(4)
    )


@dataclass(eq=False, repr=False)
class MsgSuperfluidDelegate(betterproto.Message):
    sender: str = betterproto.string_field(1)
    lock_id: int = betterproto.uint64_field(2)
    val_addr: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgSuperfluidDelegateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgSuperfluidUndelegate(betterproto.Message):
    sender: str = betterproto.string_field(1)
    lock_id: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class MsgSuperfluidUndelegateResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgSuperfluidUnbondLock(betterproto.Message):
    sender: str = betterproto.string_field(1)
    lock_id: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class MsgSuperfluidUnbondLockResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgLockAndSuperfluidDelegate(betterproto.Message):
    """
    MsgLockAndSuperfluidDelegate locks coins with the unbonding period
    duration, and then does a superfluid lock from the newly created lockup, to
    the specified validator addr.
    """

    sender: str = betterproto.string_field(1)
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(2)
    val_addr: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgLockAndSuperfluidDelegateResponse(betterproto.Message):
    id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgUnPoolWhitelistedPool(betterproto.Message):
    """
    MsgUnPoolWhitelistedPool Unpools every lock the sender has, that is
    associated with pool pool_id. If pool_id is not approved for unpooling by
    governance, this is a no-op. Unpooling takes the locked gamm shares, and
    runs "ExitPool" on it, to get the constituent tokens. e.g. z gamm/pool/1
    tokens ExitPools into constituent tokens x uatom, y uosmo. Then it creates
    a new lock for every constituent token, with the duration associated with
    the lock. If the lock was unbonding, the new lockup durations should be the
    time left until unbond completion.
    """

    sender: str = betterproto.string_field(1)
    pool_id: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class MsgUnPoolWhitelistedPoolResponse(betterproto.Message):
    exited_lock_ids: List[int] = betterproto.uint64_field(1)


class QueryStub(betterproto.ServiceStub):
    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def asset_type(
        self,
        asset_type_request: "AssetTypeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AssetTypeResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/AssetType",
            asset_type_request,
            AssetTypeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def all_assets(
        self,
        all_assets_request: "AllAssetsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AllAssetsResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/AllAssets",
            all_assets_request,
            AllAssetsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def asset_multiplier(
        self,
        asset_multiplier_request: "AssetMultiplierRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AssetMultiplierResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/AssetMultiplier",
            asset_multiplier_request,
            AssetMultiplierResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def all_intermediary_accounts(
        self,
        all_intermediary_accounts_request: "AllIntermediaryAccountsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AllIntermediaryAccountsResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/AllIntermediaryAccounts",
            all_intermediary_accounts_request,
            AllIntermediaryAccountsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def connected_intermediary_account(
        self,
        connected_intermediary_account_request: "ConnectedIntermediaryAccountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ConnectedIntermediaryAccountResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/ConnectedIntermediaryAccount",
            connected_intermediary_account_request,
            ConnectedIntermediaryAccountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def total_superfluid_delegations(
        self,
        total_superfluid_delegations_request: "TotalSuperfluidDelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "TotalSuperfluidDelegationsResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/TotalSuperfluidDelegations",
            total_superfluid_delegations_request,
            TotalSuperfluidDelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_delegation_amount(
        self,
        superfluid_delegation_amount_request: "SuperfluidDelegationAmountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SuperfluidDelegationAmountResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/SuperfluidDelegationAmount",
            superfluid_delegation_amount_request,
            SuperfluidDelegationAmountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_delegations_by_delegator(
        self,
        superfluid_delegations_by_delegator_request: "SuperfluidDelegationsByDelegatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SuperfluidDelegationsByDelegatorResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/SuperfluidDelegationsByDelegator",
            superfluid_delegations_by_delegator_request,
            SuperfluidDelegationsByDelegatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_undelegations_by_delegator(
        self,
        superfluid_undelegations_by_delegator_request: "SuperfluidUndelegationsByDelegatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SuperfluidUndelegationsByDelegatorResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/SuperfluidUndelegationsByDelegator",
            superfluid_undelegations_by_delegator_request,
            SuperfluidUndelegationsByDelegatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_delegations_by_validator_denom(
        self,
        superfluid_delegations_by_validator_denom_request: "SuperfluidDelegationsByValidatorDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SuperfluidDelegationsByValidatorDenomResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/SuperfluidDelegationsByValidatorDenom",
            superfluid_delegations_by_validator_denom_request,
            SuperfluidDelegationsByValidatorDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def estimate_superfluid_delegated_amount_by_validator_denom(
        self,
        estimate_superfluid_delegated_amount_by_validator_denom_request: "EstimateSuperfluidDelegatedAmountByValidatorDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EstimateSuperfluidDelegatedAmountByValidatorDenomResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/EstimateSuperfluidDelegatedAmountByValidatorDenom",
            estimate_superfluid_delegated_amount_by_validator_denom_request,
            EstimateSuperfluidDelegatedAmountByValidatorDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def total_delegation_by_delegator(
        self,
        query_total_delegation_by_delegator_request: "QueryTotalDelegationByDelegatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryTotalDelegationByDelegatorResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Query/TotalDelegationByDelegator",
            query_total_delegation_by_delegator_request,
            QueryTotalDelegationByDelegatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgStub(betterproto.ServiceStub):
    async def superfluid_delegate(
        self,
        msg_superfluid_delegate: "MsgSuperfluidDelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSuperfluidDelegateResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Msg/SuperfluidDelegate",
            msg_superfluid_delegate,
            MsgSuperfluidDelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_undelegate(
        self,
        msg_superfluid_undelegate: "MsgSuperfluidUndelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSuperfluidUndelegateResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Msg/SuperfluidUndelegate",
            msg_superfluid_undelegate,
            MsgSuperfluidUndelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def superfluid_unbond_lock(
        self,
        msg_superfluid_unbond_lock: "MsgSuperfluidUnbondLock",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSuperfluidUnbondLockResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Msg/SuperfluidUnbondLock",
            msg_superfluid_unbond_lock,
            MsgSuperfluidUnbondLockResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def lock_and_superfluid_delegate(
        self,
        msg_lock_and_superfluid_delegate: "MsgLockAndSuperfluidDelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgLockAndSuperfluidDelegateResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Msg/LockAndSuperfluidDelegate",
            msg_lock_and_superfluid_delegate,
            MsgLockAndSuperfluidDelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def un_pool_whitelisted_pool(
        self,
        msg_un_pool_whitelisted_pool: "MsgUnPoolWhitelistedPool",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgUnPoolWhitelistedPoolResponse":
        return await self._unary_unary(
            "/osmosis.superfluid.Msg/UnPoolWhitelistedPool",
            msg_un_pool_whitelisted_pool,
            MsgUnPoolWhitelistedPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def asset_type(
        self, asset_type_request: "AssetTypeRequest"
    ) -> "AssetTypeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def all_assets(
        self, all_assets_request: "AllAssetsRequest"
    ) -> "AllAssetsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def asset_multiplier(
        self, asset_multiplier_request: "AssetMultiplierRequest"
    ) -> "AssetMultiplierResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def all_intermediary_accounts(
        self, all_intermediary_accounts_request: "AllIntermediaryAccountsRequest"
    ) -> "AllIntermediaryAccountsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def connected_intermediary_account(
        self,
        connected_intermediary_account_request: "ConnectedIntermediaryAccountRequest",
    ) -> "ConnectedIntermediaryAccountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_superfluid_delegations(
        self, total_superfluid_delegations_request: "TotalSuperfluidDelegationsRequest"
    ) -> "TotalSuperfluidDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_delegation_amount(
        self, superfluid_delegation_amount_request: "SuperfluidDelegationAmountRequest"
    ) -> "SuperfluidDelegationAmountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_delegations_by_delegator(
        self,
        superfluid_delegations_by_delegator_request: "SuperfluidDelegationsByDelegatorRequest",
    ) -> "SuperfluidDelegationsByDelegatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_undelegations_by_delegator(
        self,
        superfluid_undelegations_by_delegator_request: "SuperfluidUndelegationsByDelegatorRequest",
    ) -> "SuperfluidUndelegationsByDelegatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_delegations_by_validator_denom(
        self,
        superfluid_delegations_by_validator_denom_request: "SuperfluidDelegationsByValidatorDenomRequest",
    ) -> "SuperfluidDelegationsByValidatorDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def estimate_superfluid_delegated_amount_by_validator_denom(
        self,
        estimate_superfluid_delegated_amount_by_validator_denom_request: "EstimateSuperfluidDelegatedAmountByValidatorDenomRequest",
    ) -> "EstimateSuperfluidDelegatedAmountByValidatorDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_delegation_by_delegator(
        self,
        query_total_delegation_by_delegator_request: "QueryTotalDelegationByDelegatorRequest",
    ) -> "QueryTotalDelegationByDelegatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_asset_type(
        self, stream: "grpclib.server.Stream[AssetTypeRequest, AssetTypeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.asset_type(request)
        await stream.send_message(response)

    async def __rpc_all_assets(
        self, stream: "grpclib.server.Stream[AllAssetsRequest, AllAssetsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.all_assets(request)
        await stream.send_message(response)

    async def __rpc_asset_multiplier(
        self,
        stream: "grpclib.server.Stream[AssetMultiplierRequest, AssetMultiplierResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.asset_multiplier(request)
        await stream.send_message(response)

    async def __rpc_all_intermediary_accounts(
        self,
        stream: "grpclib.server.Stream[AllIntermediaryAccountsRequest, AllIntermediaryAccountsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.all_intermediary_accounts(request)
        await stream.send_message(response)

    async def __rpc_connected_intermediary_account(
        self,
        stream: "grpclib.server.Stream[ConnectedIntermediaryAccountRequest, ConnectedIntermediaryAccountResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.connected_intermediary_account(request)
        await stream.send_message(response)

    async def __rpc_total_superfluid_delegations(
        self,
        stream: "grpclib.server.Stream[TotalSuperfluidDelegationsRequest, TotalSuperfluidDelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.total_superfluid_delegations(request)
        await stream.send_message(response)

    async def __rpc_superfluid_delegation_amount(
        self,
        stream: "grpclib.server.Stream[SuperfluidDelegationAmountRequest, SuperfluidDelegationAmountResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_delegation_amount(request)
        await stream.send_message(response)

    async def __rpc_superfluid_delegations_by_delegator(
        self,
        stream: "grpclib.server.Stream[SuperfluidDelegationsByDelegatorRequest, SuperfluidDelegationsByDelegatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_delegations_by_delegator(request)
        await stream.send_message(response)

    async def __rpc_superfluid_undelegations_by_delegator(
        self,
        stream: "grpclib.server.Stream[SuperfluidUndelegationsByDelegatorRequest, SuperfluidUndelegationsByDelegatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_undelegations_by_delegator(request)
        await stream.send_message(response)

    async def __rpc_superfluid_delegations_by_validator_denom(
        self,
        stream: "grpclib.server.Stream[SuperfluidDelegationsByValidatorDenomRequest, SuperfluidDelegationsByValidatorDenomResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_delegations_by_validator_denom(request)
        await stream.send_message(response)

    async def __rpc_estimate_superfluid_delegated_amount_by_validator_denom(
        self,
        stream: "grpclib.server.Stream[EstimateSuperfluidDelegatedAmountByValidatorDenomRequest, EstimateSuperfluidDelegatedAmountByValidatorDenomResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.estimate_superfluid_delegated_amount_by_validator_denom(
            request
        )
        await stream.send_message(response)

    async def __rpc_total_delegation_by_delegator(
        self,
        stream: "grpclib.server.Stream[QueryTotalDelegationByDelegatorRequest, QueryTotalDelegationByDelegatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.total_delegation_by_delegator(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.superfluid.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/osmosis.superfluid.Query/AssetType": grpclib.const.Handler(
                self.__rpc_asset_type,
                grpclib.const.Cardinality.UNARY_UNARY,
                AssetTypeRequest,
                AssetTypeResponse,
            ),
            "/osmosis.superfluid.Query/AllAssets": grpclib.const.Handler(
                self.__rpc_all_assets,
                grpclib.const.Cardinality.UNARY_UNARY,
                AllAssetsRequest,
                AllAssetsResponse,
            ),
            "/osmosis.superfluid.Query/AssetMultiplier": grpclib.const.Handler(
                self.__rpc_asset_multiplier,
                grpclib.const.Cardinality.UNARY_UNARY,
                AssetMultiplierRequest,
                AssetMultiplierResponse,
            ),
            "/osmosis.superfluid.Query/AllIntermediaryAccounts": grpclib.const.Handler(
                self.__rpc_all_intermediary_accounts,
                grpclib.const.Cardinality.UNARY_UNARY,
                AllIntermediaryAccountsRequest,
                AllIntermediaryAccountsResponse,
            ),
            "/osmosis.superfluid.Query/ConnectedIntermediaryAccount": grpclib.const.Handler(
                self.__rpc_connected_intermediary_account,
                grpclib.const.Cardinality.UNARY_UNARY,
                ConnectedIntermediaryAccountRequest,
                ConnectedIntermediaryAccountResponse,
            ),
            "/osmosis.superfluid.Query/TotalSuperfluidDelegations": grpclib.const.Handler(
                self.__rpc_total_superfluid_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                TotalSuperfluidDelegationsRequest,
                TotalSuperfluidDelegationsResponse,
            ),
            "/osmosis.superfluid.Query/SuperfluidDelegationAmount": grpclib.const.Handler(
                self.__rpc_superfluid_delegation_amount,
                grpclib.const.Cardinality.UNARY_UNARY,
                SuperfluidDelegationAmountRequest,
                SuperfluidDelegationAmountResponse,
            ),
            "/osmosis.superfluid.Query/SuperfluidDelegationsByDelegator": grpclib.const.Handler(
                self.__rpc_superfluid_delegations_by_delegator,
                grpclib.const.Cardinality.UNARY_UNARY,
                SuperfluidDelegationsByDelegatorRequest,
                SuperfluidDelegationsByDelegatorResponse,
            ),
            "/osmosis.superfluid.Query/SuperfluidUndelegationsByDelegator": grpclib.const.Handler(
                self.__rpc_superfluid_undelegations_by_delegator,
                grpclib.const.Cardinality.UNARY_UNARY,
                SuperfluidUndelegationsByDelegatorRequest,
                SuperfluidUndelegationsByDelegatorResponse,
            ),
            "/osmosis.superfluid.Query/SuperfluidDelegationsByValidatorDenom": grpclib.const.Handler(
                self.__rpc_superfluid_delegations_by_validator_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                SuperfluidDelegationsByValidatorDenomRequest,
                SuperfluidDelegationsByValidatorDenomResponse,
            ),
            "/osmosis.superfluid.Query/EstimateSuperfluidDelegatedAmountByValidatorDenom": grpclib.const.Handler(
                self.__rpc_estimate_superfluid_delegated_amount_by_validator_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                EstimateSuperfluidDelegatedAmountByValidatorDenomRequest,
                EstimateSuperfluidDelegatedAmountByValidatorDenomResponse,
            ),
            "/osmosis.superfluid.Query/TotalDelegationByDelegator": grpclib.const.Handler(
                self.__rpc_total_delegation_by_delegator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTotalDelegationByDelegatorRequest,
                QueryTotalDelegationByDelegatorResponse,
            ),
        }


class MsgBase(ServiceBase):
    async def superfluid_delegate(
        self, msg_superfluid_delegate: "MsgSuperfluidDelegate"
    ) -> "MsgSuperfluidDelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_undelegate(
        self, msg_superfluid_undelegate: "MsgSuperfluidUndelegate"
    ) -> "MsgSuperfluidUndelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def superfluid_unbond_lock(
        self, msg_superfluid_unbond_lock: "MsgSuperfluidUnbondLock"
    ) -> "MsgSuperfluidUnbondLockResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def lock_and_superfluid_delegate(
        self, msg_lock_and_superfluid_delegate: "MsgLockAndSuperfluidDelegate"
    ) -> "MsgLockAndSuperfluidDelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def un_pool_whitelisted_pool(
        self, msg_un_pool_whitelisted_pool: "MsgUnPoolWhitelistedPool"
    ) -> "MsgUnPoolWhitelistedPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_superfluid_delegate(
        self,
        stream: "grpclib.server.Stream[MsgSuperfluidDelegate, MsgSuperfluidDelegateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_delegate(request)
        await stream.send_message(response)

    async def __rpc_superfluid_undelegate(
        self,
        stream: "grpclib.server.Stream[MsgSuperfluidUndelegate, MsgSuperfluidUndelegateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_undelegate(request)
        await stream.send_message(response)

    async def __rpc_superfluid_unbond_lock(
        self,
        stream: "grpclib.server.Stream[MsgSuperfluidUnbondLock, MsgSuperfluidUnbondLockResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.superfluid_unbond_lock(request)
        await stream.send_message(response)

    async def __rpc_lock_and_superfluid_delegate(
        self,
        stream: "grpclib.server.Stream[MsgLockAndSuperfluidDelegate, MsgLockAndSuperfluidDelegateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.lock_and_superfluid_delegate(request)
        await stream.send_message(response)

    async def __rpc_un_pool_whitelisted_pool(
        self,
        stream: "grpclib.server.Stream[MsgUnPoolWhitelistedPool, MsgUnPoolWhitelistedPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.un_pool_whitelisted_pool(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.superfluid.Msg/SuperfluidDelegate": grpclib.const.Handler(
                self.__rpc_superfluid_delegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSuperfluidDelegate,
                MsgSuperfluidDelegateResponse,
            ),
            "/osmosis.superfluid.Msg/SuperfluidUndelegate": grpclib.const.Handler(
                self.__rpc_superfluid_undelegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSuperfluidUndelegate,
                MsgSuperfluidUndelegateResponse,
            ),
            "/osmosis.superfluid.Msg/SuperfluidUnbondLock": grpclib.const.Handler(
                self.__rpc_superfluid_unbond_lock,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSuperfluidUnbondLock,
                MsgSuperfluidUnbondLockResponse,
            ),
            "/osmosis.superfluid.Msg/LockAndSuperfluidDelegate": grpclib.const.Handler(
                self.__rpc_lock_and_superfluid_delegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgLockAndSuperfluidDelegate,
                MsgLockAndSuperfluidDelegateResponse,
            ),
            "/osmosis.superfluid.Msg/UnPoolWhitelistedPool": grpclib.const.Handler(
                self.__rpc_un_pool_whitelisted_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUnPoolWhitelistedPool,
                MsgUnPoolWhitelistedPoolResponse,
            ),
        }
