# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: event.proto, genesis.proto, params.proto, query.proto, state.proto, tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
from ...cosmos.base.query import v1beta1 as ___cosmos_base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class EventCreateSale(betterproto.Message):
    id: int = betterproto.uint64_field(1)
    creator: str = betterproto.string_field(2)
    token_in: str = betterproto.string_field(3)
    token_out: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class EventSubscribe(betterproto.Message):
    sender: str = betterproto.string_field(1)
    sale_id: int = betterproto.uint64_field(2)
    amount: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class EventWithdraw(betterproto.Message):
    sender: str = betterproto.string_field(1)
    sale_id: int = betterproto.uint64_field(2)
    amount: str = betterproto.string_field(3)
    """amount of staked token_in withdrawn by user."""


@dataclass(eq=False, repr=False)
class EventExit(betterproto.Message):
    sender: str = betterproto.string_field(1)
    sale_id: int = betterproto.uint64_field(2)
    purchased: str = betterproto.string_field(3)
    """amount of purchased token_out sent to the user"""


@dataclass(eq=False, repr=False)
class EventFinalizeSale(betterproto.Message):
    sale_id: int = betterproto.uint64_field(1)
    income: str = betterproto.string_field(3)
    """amount of earned tokens_in"""


@dataclass(eq=False, repr=False)
class Sale(betterproto.Message):
    treasury: str = betterproto.string_field(1)
    """Destination for the earned token_in"""

    id: int = betterproto.uint64_field(2)
    token_out: str = betterproto.string_field(3)
    """
    token_out is a token denom to be bootstraped. May be referred as base
    currency, or a sale token.
    """

    token_in: str = betterproto.string_field(4)
    """
    token_in is a token denom used to buy sale tokens (`token_out`). May be
    referred as quote_currency or payment token.
    """

    token_out_supply: str = betterproto.string_field(5)
    """total number of `tokens_out` to be sold during the continuous sale."""

    start_time: datetime = betterproto.message_field(6)
    """start time when the token emission starts."""

    end_time: datetime = betterproto.message_field(7)
    """
    end time when the token emission ends. Can't be bigger than start +
    139years (to avoid round overflow)
    """

    round: int = betterproto.int64_field(8)
    """Round number when the sale was last time updated."""

    end_round: int = betterproto.int64_field(9)
    """Last round of the Sale;"""

    out_remaining: str = betterproto.string_field(10)
    """amout of remaining token_out to sell"""

    out_sold: str = betterproto.string_field(11)
    """amount of token_out sold"""

    out_per_share: str = betterproto.string_field(12)
    """out token per share"""

    staked: str = betterproto.string_field(13)
    """
    total amount of currently staked coins (token_in) but not spent coins.
    """

    income: str = betterproto.string_field(14)
    """total amount of earned coins (token_in)"""

    shares: str = betterproto.string_field(15)
    """total amount of shares"""

    name: str = betterproto.string_field(20)
    """Name for the sale."""

    url: str = betterproto.string_field(21)
    """URL with sale and project details."""


@dataclass(eq=False, repr=False)
class UserPosition(betterproto.Message):
    """UserPosition represents user account in a sale"""

    shares: str = betterproto.string_field(1)
    staked: str = betterproto.string_field(2)
    """total number of currently staked tokens"""

    out_per_share: str = betterproto.string_field(3)
    """last token/share ratio"""

    spent: str = betterproto.string_field(4)
    """amount of token_in spent"""

    purchased: str = betterproto.string_field(5)
    """Amount of accumulated, not withdrawn, purchased tokens (token_out)"""


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params holds parameters for the streamswap module"""

    sale_creation_fee: List[
        "___cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(1)
    """
    fee charged when creating a new sale. The fee will go to the
    sale_fee_recipient unless it is not defined (empty).
    """

    sale_creation_fee_recipient: str = betterproto.string_field(2)
    """bech32 address of the fee recipient"""

    min_duration_until_start_time: timedelta = betterproto.message_field(3)
    """
    minimum amount duration of time between the sale creation and the sale
    start time.
    """

    min_sale_duration: timedelta = betterproto.message_field(4)
    """minimum duration for every new sale."""


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the streamswap module's genesis state."""

    sales: List["Sale"] = betterproto.message_field(1)
    user_positions: List["UserPositionKv"] = betterproto.message_field(2)
    next_sale_id: int = betterproto.uint64_field(3)
    params: "Params" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class UserPositionKv(betterproto.Message):
    """
    UserPositionKV is a record in genesis representing acc_address user
    position of a sale_id sale.
    """

    acc_address: str = betterproto.string_field(1)
    """user account address"""

    sale_id: int = betterproto.uint64_field(2)
    user_position: "UserPosition" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QuerySales(betterproto.Message):
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    """pagination defines an pagination for the request."""


@dataclass(eq=False, repr=False)
class QuerySalesResponse(betterproto.Message):
    sales: List["Sale"] = betterproto.message_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )


@dataclass(eq=False, repr=False)
class QuerySale(betterproto.Message):
    """Request type for Query/Sale"""

    sale_id: int = betterproto.uint64_field(1)
    """Sale ID"""


@dataclass(eq=False, repr=False)
class QuerySaleResponse(betterproto.Message):
    sale: "Sale" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryUserPosition(betterproto.Message):
    """Request type for Query/Sale"""

    sale_id: int = betterproto.uint64_field(1)
    """ID of the Sale"""

    user: str = betterproto.string_field(2)
    """user account address"""


@dataclass(eq=False, repr=False)
class QueryUserPositionResponse(betterproto.Message):
    user_position: "UserPosition" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MsgCreateSale(betterproto.Message):
    creator: str = betterproto.string_field(1)
    """
    Sale creator and the account which provides token (token_out) to the sale.
    When processing this message, token_out
    """

    token_in: str = betterproto.string_field(2)
    """
    token_in is a denom used to buy `token_out`. May be referred as a "quote
    currency".
    """

    token_out: "___cosmos_base_v1_beta1__.Coin" = betterproto.message_field(3)
    """
    token_out is a coin supply (denom + amount) to sell. May be referred as
    "base currency". The whole supply will be transferred from the creator to
    the module and will be sold during the sale.
    """

    max_fee: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(4)
    """
    Maximum fee the creator is going to pay for creating a sale. The creator
    will be charged params.SaleCreationFee. Transaction will fail if max_fee is
    smaller than params.SaleCreationFee. If empty, the creator doesn't accept
    any fee.
    """

    start_time: datetime = betterproto.message_field(5)
    """start time when the token sale starts."""

    duration: timedelta = betterproto.message_field(6)
    """duration time that the sale takes place over"""

    recipient: str = betterproto.string_field(7)
    """
    Recipient is the account which receives earned `token_in` from when the
    sale is finalized. If not defined (empty) the creator account will be used.
    """

    name: str = betterproto.string_field(8)
    """Name for the sale, max 40 characters, min 4. Required."""

    url: str = betterproto.string_field(9)
    """
    URL with sale and project details. Can be a link a link to IPFS, hackmd,
    project page, blog post... Max 120 characters. Must be valid agains Go
    url.ParseRequestURI. Required.
    """


@dataclass(eq=False, repr=False)
class MsgCreateSaleResponse(betterproto.Message):
    sale_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgSubscribe(betterproto.Message):
    sender: str = betterproto.string_field(1)
    """sender is an account address adding a deposit"""

    sale_id: int = betterproto.uint64_field(2)
    """ID of an existing sale."""

    amount: str = betterproto.string_field(3)
    """number of sale.token_in staked by a user."""


@dataclass(eq=False, repr=False)
class MsgWithdraw(betterproto.Message):
    sender: str = betterproto.string_field(1)
    """sender is an account address subscribed to the sale_id"""

    sale_id: int = betterproto.uint64_field(2)
    """ID of a sale."""

    amount: str = betterproto.string_field(3)
    """
    amount of tokens_in to withdraw. Must be at most the amount of not spent
    tokens, unless set to null - then all remaining balance will be withdrawn.
    """


@dataclass(eq=False, repr=False)
class MsgExitSale(betterproto.Message):
    sender: str = betterproto.string_field(1)
    """sender is an account address exiting a sale"""

    sale_id: int = betterproto.uint64_field(2)
    """ID of an existing sale."""


@dataclass(eq=False, repr=False)
class MsgExitSaleResponse(betterproto.Message):
    purchased: str = betterproto.string_field(1)
    """Purchased amount of "out" tokens withdrawn to the user."""


@dataclass(eq=False, repr=False)
class MsgFinalizeSale(betterproto.Message):
    sender: str = betterproto.string_field(1)
    """
    sender is an account signing the message and triggering the finalization.
    """

    sale_id: int = betterproto.uint64_field(2)
    """ID of an existing sale."""


@dataclass(eq=False, repr=False)
class MsgFinalizeSaleResponse(betterproto.Message):
    income: str = betterproto.string_field(1)
    """Income amount of token_in sent to the sale recipient."""


class QueryStub(betterproto.ServiceStub):
    async def sales(
        self,
        query_sales: "QuerySales",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QuerySalesResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Query/Sales",
            query_sales,
            QuerySalesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def sale(
        self,
        query_sale: "QuerySale",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QuerySaleResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Query/Sale",
            query_sale,
            QuerySaleResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def user_position(
        self,
        query_user_position: "QueryUserPosition",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUserPositionResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Query/UserPosition",
            query_user_position,
            QueryUserPositionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgStub(betterproto.ServiceStub):
    async def create_sale(
        self,
        msg_create_sale: "MsgCreateSale",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateSaleResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Msg/CreateSale",
            msg_create_sale,
            MsgCreateSaleResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def subscribe(
        self,
        msg_subscribe: "MsgSubscribe",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "betterproto_lib_google_protobuf.Empty":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Msg/Subscribe",
            msg_subscribe,
            betterproto_lib_google_protobuf.Empty,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def withdraw(
        self,
        msg_withdraw: "MsgWithdraw",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "betterproto_lib_google_protobuf.Empty":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Msg/Withdraw",
            msg_withdraw,
            betterproto_lib_google_protobuf.Empty,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def exit_sale(
        self,
        msg_exit_sale: "MsgExitSale",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgExitSaleResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Msg/ExitSale",
            msg_exit_sale,
            MsgExitSaleResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def finalize_sale(
        self,
        msg_finalize_sale: "MsgFinalizeSale",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgFinalizeSaleResponse":
        return await self._unary_unary(
            "/osmosis.streamswap.v1.Msg/FinalizeSale",
            msg_finalize_sale,
            MsgFinalizeSaleResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def sales(self, query_sales: "QuerySales") -> "QuerySalesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def sale(self, query_sale: "QuerySale") -> "QuerySaleResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def user_position(
        self, query_user_position: "QueryUserPosition"
    ) -> "QueryUserPositionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_sales(
        self, stream: "grpclib.server.Stream[QuerySales, QuerySalesResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.sales(request)
        await stream.send_message(response)

    async def __rpc_sale(
        self, stream: "grpclib.server.Stream[QuerySale, QuerySaleResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.sale(request)
        await stream.send_message(response)

    async def __rpc_user_position(
        self,
        stream: "grpclib.server.Stream[QueryUserPosition, QueryUserPositionResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.user_position(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.streamswap.v1.Query/Sales": grpclib.const.Handler(
                self.__rpc_sales,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySales,
                QuerySalesResponse,
            ),
            "/osmosis.streamswap.v1.Query/Sale": grpclib.const.Handler(
                self.__rpc_sale,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySale,
                QuerySaleResponse,
            ),
            "/osmosis.streamswap.v1.Query/UserPosition": grpclib.const.Handler(
                self.__rpc_user_position,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUserPosition,
                QueryUserPositionResponse,
            ),
        }


class MsgBase(ServiceBase):
    async def create_sale(
        self, msg_create_sale: "MsgCreateSale"
    ) -> "MsgCreateSaleResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def subscribe(
        self, msg_subscribe: "MsgSubscribe"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def withdraw(
        self, msg_withdraw: "MsgWithdraw"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def exit_sale(self, msg_exit_sale: "MsgExitSale") -> "MsgExitSaleResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def finalize_sale(
        self, msg_finalize_sale: "MsgFinalizeSale"
    ) -> "MsgFinalizeSaleResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_sale(
        self, stream: "grpclib.server.Stream[MsgCreateSale, MsgCreateSaleResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_sale(request)
        await stream.send_message(response)

    async def __rpc_subscribe(
        self,
        stream: "grpclib.server.Stream[MsgSubscribe, betterproto_lib_google_protobuf.Empty]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.subscribe(request)
        await stream.send_message(response)

    async def __rpc_withdraw(
        self,
        stream: "grpclib.server.Stream[MsgWithdraw, betterproto_lib_google_protobuf.Empty]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.withdraw(request)
        await stream.send_message(response)

    async def __rpc_exit_sale(
        self, stream: "grpclib.server.Stream[MsgExitSale, MsgExitSaleResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.exit_sale(request)
        await stream.send_message(response)

    async def __rpc_finalize_sale(
        self, stream: "grpclib.server.Stream[MsgFinalizeSale, MsgFinalizeSaleResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.finalize_sale(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.streamswap.v1.Msg/CreateSale": grpclib.const.Handler(
                self.__rpc_create_sale,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateSale,
                MsgCreateSaleResponse,
            ),
            "/osmosis.streamswap.v1.Msg/Subscribe": grpclib.const.Handler(
                self.__rpc_subscribe,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSubscribe,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/osmosis.streamswap.v1.Msg/Withdraw": grpclib.const.Handler(
                self.__rpc_withdraw,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgWithdraw,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/osmosis.streamswap.v1.Msg/ExitSale": grpclib.const.Handler(
                self.__rpc_exit_sale,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgExitSale,
                MsgExitSaleResponse,
            ),
            "/osmosis.streamswap.v1.Msg/FinalizeSale": grpclib.const.Handler(
                self.__rpc_finalize_sale,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgFinalizeSale,
                MsgFinalizeSaleResponse,
            ),
        }
