# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: lock.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import List

import betterproto

from ..cosmos.base import v1beta1 as __cosmos_base_v1_beta1__


class LockQueryType(betterproto.Enum):
    """
    LockQueryType defines the type of the lock query that can either be by
    duration or start time of the lock.
    """

    ByDuration = 0
    ByTime = 1


@dataclass(eq=False, repr=False)
class QueryCondition(betterproto.Message):
    """
    QueryCondition is a struct used for querying locks upon different
    conditions. Duration field and timestamp fields could be optional,
    depending on the LockQueryType.
    """

    lock_query_type: "LockQueryType" = betterproto.enum_field(1)
    """LockQueryType is a type of lock query, ByLockDuration | ByLockTime"""

    denom: str = betterproto.string_field(2)
    """Denom represents the token denomination we are looking to lock up"""

    duration: timedelta = betterproto.message_field(3)
    """
    Duration is used to query locks with longer duration than the specified
    duration. Duration field must not be nil when the lock query type is
    `ByLockDuration`.
    """

    timestamp: datetime = betterproto.message_field(4)
    """
    Timestamp is used by locks started before the specified duration. Timestamp
    field must not be nil when the lock query type is `ByLockTime`. Querying
    locks with timestamp is currently not implemented.
    """


@dataclass(eq=False, repr=False)
class SyntheticLock(betterproto.Message):
    """
    SyntheticLock is creating virtual lockup where new denom is combination of
    original denom and synthetic suffix. At the time of synthetic lockup
    creation and deletion, accumulation store is also being updated and on
    querier side, they can query as freely as native lockup.
    """

    underlying_lock_id: int = betterproto.uint64_field(1)
    """
    Underlying Lock ID is the underlying native lock's id for this synthetic
    lockup. A synthetic lock MUST have an underlying lock.
    """

    synth_denom: str = betterproto.string_field(2)
    """
    SynthDenom is the synthetic denom that is a combination of gamm share +
    bonding status + validator address.
    """

    end_time: datetime = betterproto.message_field(3)
    """
    used for unbonding synthetic lockups, for active synthetic lockups, this
    value is set to uninitialized value
    """

    duration: timedelta = betterproto.message_field(4)
    """
    Duration is the duration for a synthetic lock to mature at the point of
    unbonding has started.
    """
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: genesis.proto, lock.proto, query.proto, tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...cosmos.base import v1beta1 as __cosmos_base_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class LockQueryType(betterproto.Enum):
    """
    LockQueryType defines the type of the lock query that can either be by
    duration or start time of the lock.
    """

    ByDuration = 0
    ByTime = 1


@dataclass(eq=False, repr=False)
class PeriodLock(betterproto.Message):
    """
    PeriodLock is a single lock unit by period defined by the x/lockup module.
    It's a record of a locked coin at a specific time. It stores owner,
    duration, unlock time and the number of coins locked. A state of a period
    lock is created upon lock creation, and deleted once the lock has been
    matured after the `duration` has passed since unbonding started.
    """

    id: int = betterproto.uint64_field(1)
    """
    ID is the unique id of the lock. The ID of the lock is decided upon lock
    creation, incrementing by 1 for every lock.
    """

    owner: str = betterproto.string_field(2)
    """
    Owner is the account address of the lock owner. Only the owner can modify
    the state of the lock.
    """

    duration: timedelta = betterproto.message_field(3)
    """
    Duration is the time needed for a lock to mature after unlocking has
    started.
    """

    end_time: datetime = betterproto.message_field(4)
    """
    EndTime refers to the time at which the lock would mature and get deleted.
    This value is first initialized when an unlock has started for the lock,
    end time being block time + duration.
    """

    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)
    """
    Coins are the tokens locked within the lock, kept in the module account.
    """


@dataclass(eq=False, repr=False)
class QueryCondition(betterproto.Message):
    """
    QueryCondition is a struct used for querying locks upon different
    conditions. Duration field and timestamp fields could be optional,
    depending on the LockQueryType.
    """

    lock_query_type: "LockQueryType" = betterproto.enum_field(1)
    """LockQueryType is a type of lock query, ByLockDuration | ByLockTime"""

    denom: str = betterproto.string_field(2)
    """Denom represents the token denomination we are looking to lock up"""

    duration: timedelta = betterproto.message_field(3)
    """
    Duration is used to query locks with longer duration than the specified
    duration. Duration field must not be nil when the lock query type is
    `ByLockDuration`.
    """

    timestamp: datetime = betterproto.message_field(4)
    """
    Timestamp is used by locks started before the specified duration. Timestamp
    field must not be nil when the lock query type is `ByLockTime`. Querying
    locks with timestamp is currently not implemented.
    """


@dataclass(eq=False, repr=False)
class SyntheticLock(betterproto.Message):
    """
    SyntheticLock is creating virtual lockup where new denom is combination of
    original denom and synthetic suffix. At the time of synthetic lockup
    creation and deletion, accumulation store is also being updated and on
    querier side, they can query as freely as native lockup.
    """

    underlying_lock_id: int = betterproto.uint64_field(1)
    """
    Underlying Lock ID is the underlying native lock's id for this synthetic
    lockup. A synthetic lock MUST have an underlying lock.
    """

    synth_denom: str = betterproto.string_field(2)
    """
    SynthDenom is the synthetic denom that is a combination of gamm share +
    bonding status + validator address.
    """

    end_time: datetime = betterproto.message_field(3)
    """
    used for unbonding synthetic lockups, for active synthetic lockups, this
    value is set to uninitialized value
    """

    duration: timedelta = betterproto.message_field(4)
    """
    Duration is the duration for a synthetic lock to mature at the point of
    unbonding has started.
    """


@dataclass(eq=False, repr=False)
class ModuleBalanceRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ModuleBalanceResponse(betterproto.Message):
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ModuleLockedAmountRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ModuleLockedAmountResponse(betterproto.Message):
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountUnlockableCoinsRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AccountUnlockableCoinsResponse(betterproto.Message):
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountUnlockingCoinsRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AccountUnlockingCoinsResponse(betterproto.Message):
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedCoinsRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedCoinsResponse(betterproto.Message):
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    timestamp: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeNotUnlockingOnlyRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    timestamp: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeNotUnlockingOnlyResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountUnlockedBeforeTimeRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    timestamp: datetime = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountUnlockedBeforeTimeResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeDenomRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    timestamp: datetime = betterproto.message_field(2)
    denom: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class AccountLockedPastTimeDenomResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class LockedDenomRequest(betterproto.Message):
    denom: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class LockedDenomResponse(betterproto.Message):
    amount: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class LockedRequest(betterproto.Message):
    lock_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class LockedResponse(betterproto.Message):
    lock: "PeriodLock" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SyntheticLockupsByLockupIdRequest(betterproto.Message):
    lock_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class SyntheticLockupsByLockupIdResponse(betterproto.Message):
    synthetic_locks: List["SyntheticLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedDurationRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountLockedDurationResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationNotUnlockingOnlyRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationNotUnlockingOnlyResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationDenomRequest(betterproto.Message):
    owner: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)
    denom: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class AccountLockedLongerDurationDenomResponse(betterproto.Message):
    locks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MsgLockTokens(betterproto.Message):
    owner: str = betterproto.string_field(1)
    duration: timedelta = betterproto.message_field(2)
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgLockTokensResponse(betterproto.Message):
    id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgBeginUnlockingAll(betterproto.Message):
    owner: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgBeginUnlockingAllResponse(betterproto.Message):
    unlocks: List["PeriodLock"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MsgBeginUnlocking(betterproto.Message):
    owner: str = betterproto.string_field(1)
    id: int = betterproto.uint64_field(2)
    coins: List["__cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(3)
    """Amount of unlocking coins. Unlock all if not set."""


@dataclass(eq=False, repr=False)
class MsgBeginUnlockingResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class MsgExtendLockup(betterproto.Message):
    """
    MsgExtendLockup extends the existing lockup's duration. The new duration is
    longer than the original.
    """

    owner: str = betterproto.string_field(1)
    id: int = betterproto.uint64_field(2)
    duration: timedelta = betterproto.message_field(3)
    """
    duration to be set. fails if lower than the current duration, or is
    unlocking
    """


@dataclass(eq=False, repr=False)
class MsgExtendLockupResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the lockup module's genesis state."""

    last_lock_id: int = betterproto.uint64_field(1)
    locks: List["PeriodLock"] = betterproto.message_field(2)
    synthetic_locks: List["SyntheticLock"] = betterproto.message_field(3)


class QueryStub(betterproto.ServiceStub):
    async def module_balance(
        self,
        module_balance_request: "ModuleBalanceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ModuleBalanceResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/ModuleBalance",
            module_balance_request,
            ModuleBalanceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def module_locked_amount(
        self,
        module_locked_amount_request: "ModuleLockedAmountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ModuleLockedAmountResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/ModuleLockedAmount",
            module_locked_amount_request,
            ModuleLockedAmountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_unlockable_coins(
        self,
        account_unlockable_coins_request: "AccountUnlockableCoinsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountUnlockableCoinsResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountUnlockableCoins",
            account_unlockable_coins_request,
            AccountUnlockableCoinsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_unlocking_coins(
        self,
        account_unlocking_coins_request: "AccountUnlockingCoinsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountUnlockingCoinsResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountUnlockingCoins",
            account_unlocking_coins_request,
            AccountUnlockingCoinsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_coins(
        self,
        account_locked_coins_request: "AccountLockedCoinsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedCoinsResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedCoins",
            account_locked_coins_request,
            AccountLockedCoinsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_past_time(
        self,
        account_locked_past_time_request: "AccountLockedPastTimeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedPastTimeResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedPastTime",
            account_locked_past_time_request,
            AccountLockedPastTimeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_past_time_not_unlocking_only(
        self,
        account_locked_past_time_not_unlocking_only_request: "AccountLockedPastTimeNotUnlockingOnlyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedPastTimeNotUnlockingOnlyResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedPastTimeNotUnlockingOnly",
            account_locked_past_time_not_unlocking_only_request,
            AccountLockedPastTimeNotUnlockingOnlyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_unlocked_before_time(
        self,
        account_unlocked_before_time_request: "AccountUnlockedBeforeTimeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountUnlockedBeforeTimeResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountUnlockedBeforeTime",
            account_unlocked_before_time_request,
            AccountUnlockedBeforeTimeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_past_time_denom(
        self,
        account_locked_past_time_denom_request: "AccountLockedPastTimeDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedPastTimeDenomResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedPastTimeDenom",
            account_locked_past_time_denom_request,
            AccountLockedPastTimeDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def locked_denom(
        self,
        locked_denom_request: "LockedDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "LockedDenomResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/LockedDenom",
            locked_denom_request,
            LockedDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def locked_by_id(
        self,
        locked_request: "LockedRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "LockedResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/LockedByID",
            locked_request,
            LockedResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def synthetic_lockups_by_lockup_id(
        self,
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SyntheticLockupsByLockupIdResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/SyntheticLockupsByLockupID",
            synthetic_lockups_by_lockup_id_request,
            SyntheticLockupsByLockupIdResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_longer_duration(
        self,
        account_locked_longer_duration_request: "AccountLockedLongerDurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedLongerDurationResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedLongerDuration",
            account_locked_longer_duration_request,
            AccountLockedLongerDurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_duration(
        self,
        account_locked_duration_request: "AccountLockedDurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedDurationResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedDuration",
            account_locked_duration_request,
            AccountLockedDurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_longer_duration_not_unlocking_only(
        self,
        account_locked_longer_duration_not_unlocking_only_request: "AccountLockedLongerDurationNotUnlockingOnlyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedLongerDurationNotUnlockingOnlyResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedLongerDurationNotUnlockingOnly",
            account_locked_longer_duration_not_unlocking_only_request,
            AccountLockedLongerDurationNotUnlockingOnlyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def account_locked_longer_duration_denom(
        self,
        account_locked_longer_duration_denom_request: "AccountLockedLongerDurationDenomRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AccountLockedLongerDurationDenomResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Query/AccountLockedLongerDurationDenom",
            account_locked_longer_duration_denom_request,
            AccountLockedLongerDurationDenomResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgStub(betterproto.ServiceStub):
    async def lock_tokens(
        self,
        msg_lock_tokens: "MsgLockTokens",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgLockTokensResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Msg/LockTokens",
            msg_lock_tokens,
            MsgLockTokensResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def begin_unlocking_all(
        self,
        msg_begin_unlocking_all: "MsgBeginUnlockingAll",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgBeginUnlockingAllResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Msg/BeginUnlockingAll",
            msg_begin_unlocking_all,
            MsgBeginUnlockingAllResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def begin_unlocking(
        self,
        msg_begin_unlocking: "MsgBeginUnlocking",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgBeginUnlockingResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Msg/BeginUnlocking",
            msg_begin_unlocking,
            MsgBeginUnlockingResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def extend_lockup(
        self,
        msg_extend_lockup: "MsgExtendLockup",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgExtendLockupResponse":
        return await self._unary_unary(
            "/osmosis.lockup.Msg/ExtendLockup",
            msg_extend_lockup,
            MsgExtendLockupResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def module_balance(
        self, module_balance_request: "ModuleBalanceRequest"
    ) -> "ModuleBalanceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def module_locked_amount(
        self, module_locked_amount_request: "ModuleLockedAmountRequest"
    ) -> "ModuleLockedAmountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_unlockable_coins(
        self, account_unlockable_coins_request: "AccountUnlockableCoinsRequest"
    ) -> "AccountUnlockableCoinsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_unlocking_coins(
        self, account_unlocking_coins_request: "AccountUnlockingCoinsRequest"
    ) -> "AccountUnlockingCoinsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_coins(
        self, account_locked_coins_request: "AccountLockedCoinsRequest"
    ) -> "AccountLockedCoinsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_past_time(
        self, account_locked_past_time_request: "AccountLockedPastTimeRequest"
    ) -> "AccountLockedPastTimeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_past_time_not_unlocking_only(
        self,
        account_locked_past_time_not_unlocking_only_request: "AccountLockedPastTimeNotUnlockingOnlyRequest",
    ) -> "AccountLockedPastTimeNotUnlockingOnlyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_unlocked_before_time(
        self, account_unlocked_before_time_request: "AccountUnlockedBeforeTimeRequest"
    ) -> "AccountUnlockedBeforeTimeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_past_time_denom(
        self,
        account_locked_past_time_denom_request: "AccountLockedPastTimeDenomRequest",
    ) -> "AccountLockedPastTimeDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def locked_denom(
        self, locked_denom_request: "LockedDenomRequest"
    ) -> "LockedDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def locked_by_id(self, locked_request: "LockedRequest") -> "LockedResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def synthetic_lockups_by_lockup_id(
        self,
    ) -> "SyntheticLockupsByLockupIdResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_longer_duration(
        self,
        account_locked_longer_duration_request: "AccountLockedLongerDurationRequest",
    ) -> "AccountLockedLongerDurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_duration(
        self, account_locked_duration_request: "AccountLockedDurationRequest"
    ) -> "AccountLockedDurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_longer_duration_not_unlocking_only(
        self,
        account_locked_longer_duration_not_unlocking_only_request: "AccountLockedLongerDurationNotUnlockingOnlyRequest",
    ) -> "AccountLockedLongerDurationNotUnlockingOnlyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def account_locked_longer_duration_denom(
        self,
        account_locked_longer_duration_denom_request: "AccountLockedLongerDurationDenomRequest",
    ) -> "AccountLockedLongerDurationDenomResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_module_balance(
        self,
        stream: "grpclib.server.Stream[ModuleBalanceRequest, ModuleBalanceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.module_balance(request)
        await stream.send_message(response)

    async def __rpc_module_locked_amount(
        self,
        stream: "grpclib.server.Stream[ModuleLockedAmountRequest, ModuleLockedAmountResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.module_locked_amount(request)
        await stream.send_message(response)

    async def __rpc_account_unlockable_coins(
        self,
        stream: "grpclib.server.Stream[AccountUnlockableCoinsRequest, AccountUnlockableCoinsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_unlockable_coins(request)
        await stream.send_message(response)

    async def __rpc_account_unlocking_coins(
        self,
        stream: "grpclib.server.Stream[AccountUnlockingCoinsRequest, AccountUnlockingCoinsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_unlocking_coins(request)
        await stream.send_message(response)

    async def __rpc_account_locked_coins(
        self,
        stream: "grpclib.server.Stream[AccountLockedCoinsRequest, AccountLockedCoinsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_coins(request)
        await stream.send_message(response)

    async def __rpc_account_locked_past_time(
        self,
        stream: "grpclib.server.Stream[AccountLockedPastTimeRequest, AccountLockedPastTimeResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_past_time(request)
        await stream.send_message(response)

    async def __rpc_account_locked_past_time_not_unlocking_only(
        self,
        stream: "grpclib.server.Stream[AccountLockedPastTimeNotUnlockingOnlyRequest, AccountLockedPastTimeNotUnlockingOnlyResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_past_time_not_unlocking_only(request)
        await stream.send_message(response)

    async def __rpc_account_unlocked_before_time(
        self,
        stream: "grpclib.server.Stream[AccountUnlockedBeforeTimeRequest, AccountUnlockedBeforeTimeResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_unlocked_before_time(request)
        await stream.send_message(response)

    async def __rpc_account_locked_past_time_denom(
        self,
        stream: "grpclib.server.Stream[AccountLockedPastTimeDenomRequest, AccountLockedPastTimeDenomResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_past_time_denom(request)
        await stream.send_message(response)

    async def __rpc_locked_denom(
        self, stream: "grpclib.server.Stream[LockedDenomRequest, LockedDenomResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.locked_denom(request)
        await stream.send_message(response)

    async def __rpc_locked_by_id(
        self, stream: "grpclib.server.Stream[LockedRequest, LockedResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.locked_by_id(request)
        await stream.send_message(response)

    async def __rpc_synthetic_lockups_by_lockup_id(
        self,
        stream: "grpclib.server.Stream[SyntheticLockupsByLockupIdRequest, SyntheticLockupsByLockupIdResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.synthetic_lockups_by_lockup_id(request)
        await stream.send_message(response)

    async def __rpc_account_locked_longer_duration(
        self,
        stream: "grpclib.server.Stream[AccountLockedLongerDurationRequest, AccountLockedLongerDurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_longer_duration(request)
        await stream.send_message(response)

    async def __rpc_account_locked_duration(
        self,
        stream: "grpclib.server.Stream[AccountLockedDurationRequest, AccountLockedDurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_duration(request)
        await stream.send_message(response)

    async def __rpc_account_locked_longer_duration_not_unlocking_only(
        self,
        stream: "grpclib.server.Stream[AccountLockedLongerDurationNotUnlockingOnlyRequest, AccountLockedLongerDurationNotUnlockingOnlyResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_longer_duration_not_unlocking_only(request)
        await stream.send_message(response)

    async def __rpc_account_locked_longer_duration_denom(
        self,
        stream: "grpclib.server.Stream[AccountLockedLongerDurationDenomRequest, AccountLockedLongerDurationDenomResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.account_locked_longer_duration_denom(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.lockup.Query/ModuleBalance": grpclib.const.Handler(
                self.__rpc_module_balance,
                grpclib.const.Cardinality.UNARY_UNARY,
                ModuleBalanceRequest,
                ModuleBalanceResponse,
            ),
            "/osmosis.lockup.Query/ModuleLockedAmount": grpclib.const.Handler(
                self.__rpc_module_locked_amount,
                grpclib.const.Cardinality.UNARY_UNARY,
                ModuleLockedAmountRequest,
                ModuleLockedAmountResponse,
            ),
            "/osmosis.lockup.Query/AccountUnlockableCoins": grpclib.const.Handler(
                self.__rpc_account_unlockable_coins,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountUnlockableCoinsRequest,
                AccountUnlockableCoinsResponse,
            ),
            "/osmosis.lockup.Query/AccountUnlockingCoins": grpclib.const.Handler(
                self.__rpc_account_unlocking_coins,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountUnlockingCoinsRequest,
                AccountUnlockingCoinsResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedCoins": grpclib.const.Handler(
                self.__rpc_account_locked_coins,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedCoinsRequest,
                AccountLockedCoinsResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedPastTime": grpclib.const.Handler(
                self.__rpc_account_locked_past_time,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedPastTimeRequest,
                AccountLockedPastTimeResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedPastTimeNotUnlockingOnly": grpclib.const.Handler(
                self.__rpc_account_locked_past_time_not_unlocking_only,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedPastTimeNotUnlockingOnlyRequest,
                AccountLockedPastTimeNotUnlockingOnlyResponse,
            ),
            "/osmosis.lockup.Query/AccountUnlockedBeforeTime": grpclib.const.Handler(
                self.__rpc_account_unlocked_before_time,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountUnlockedBeforeTimeRequest,
                AccountUnlockedBeforeTimeResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedPastTimeDenom": grpclib.const.Handler(
                self.__rpc_account_locked_past_time_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedPastTimeDenomRequest,
                AccountLockedPastTimeDenomResponse,
            ),
            "/osmosis.lockup.Query/LockedDenom": grpclib.const.Handler(
                self.__rpc_locked_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                LockedDenomRequest,
                LockedDenomResponse,
            ),
            "/osmosis.lockup.Query/LockedByID": grpclib.const.Handler(
                self.__rpc_locked_by_id,
                grpclib.const.Cardinality.UNARY_UNARY,
                LockedRequest,
                LockedResponse,
            ),
            "/osmosis.lockup.Query/SyntheticLockupsByLockupID": grpclib.const.Handler(
                self.__rpc_synthetic_lockups_by_lockup_id,
                grpclib.const.Cardinality.UNARY_UNARY,
                SyntheticLockupsByLockupIdRequest,
                SyntheticLockupsByLockupIdResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedLongerDuration": grpclib.const.Handler(
                self.__rpc_account_locked_longer_duration,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedLongerDurationRequest,
                AccountLockedLongerDurationResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedDuration": grpclib.const.Handler(
                self.__rpc_account_locked_duration,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedDurationRequest,
                AccountLockedDurationResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedLongerDurationNotUnlockingOnly": grpclib.const.Handler(
                self.__rpc_account_locked_longer_duration_not_unlocking_only,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedLongerDurationNotUnlockingOnlyRequest,
                AccountLockedLongerDurationNotUnlockingOnlyResponse,
            ),
            "/osmosis.lockup.Query/AccountLockedLongerDurationDenom": grpclib.const.Handler(
                self.__rpc_account_locked_longer_duration_denom,
                grpclib.const.Cardinality.UNARY_UNARY,
                AccountLockedLongerDurationDenomRequest,
                AccountLockedLongerDurationDenomResponse,
            ),
        }


class MsgBase(ServiceBase):
    async def lock_tokens(
        self, msg_lock_tokens: "MsgLockTokens"
    ) -> "MsgLockTokensResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def begin_unlocking_all(
        self, msg_begin_unlocking_all: "MsgBeginUnlockingAll"
    ) -> "MsgBeginUnlockingAllResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def begin_unlocking(
        self, msg_begin_unlocking: "MsgBeginUnlocking"
    ) -> "MsgBeginUnlockingResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def extend_lockup(
        self, msg_extend_lockup: "MsgExtendLockup"
    ) -> "MsgExtendLockupResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_lock_tokens(
        self, stream: "grpclib.server.Stream[MsgLockTokens, MsgLockTokensResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.lock_tokens(request)
        await stream.send_message(response)

    async def __rpc_begin_unlocking_all(
        self,
        stream: "grpclib.server.Stream[MsgBeginUnlockingAll, MsgBeginUnlockingAllResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.begin_unlocking_all(request)
        await stream.send_message(response)

    async def __rpc_begin_unlocking(
        self,
        stream: "grpclib.server.Stream[MsgBeginUnlocking, MsgBeginUnlockingResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.begin_unlocking(request)
        await stream.send_message(response)

    async def __rpc_extend_lockup(
        self, stream: "grpclib.server.Stream[MsgExtendLockup, MsgExtendLockupResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.extend_lockup(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.lockup.Msg/LockTokens": grpclib.const.Handler(
                self.__rpc_lock_tokens,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgLockTokens,
                MsgLockTokensResponse,
            ),
            "/osmosis.lockup.Msg/BeginUnlockingAll": grpclib.const.Handler(
                self.__rpc_begin_unlocking_all,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgBeginUnlockingAll,
                MsgBeginUnlockingAllResponse,
            ),
            "/osmosis.lockup.Msg/BeginUnlocking": grpclib.const.Handler(
                self.__rpc_begin_unlocking,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgBeginUnlocking,
                MsgBeginUnlockingResponse,
            ),
            "/osmosis.lockup.Msg/ExtendLockup": grpclib.const.Handler(
                self.__rpc_extend_lockup,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgExtendLockup,
                MsgExtendLockupResponse,
            ),
        }
