# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: stableswap_pool.proto, tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....cosmos.base import v1beta1 as _____cosmos_base_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class PoolParams(betterproto.Message):
    """
    PoolParams defined the parameters that will be managed by the pool
    governance in the future. This params are not managed by the chain
    governance. Instead they will be managed by the token holders of the pool.
    The pool's token holders are specified in future_pool_governor.
    """

    swap_fee: str = betterproto.string_field(1)
    exit_fee: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    """Pool is the stableswap Pool struct"""

    address: str = betterproto.string_field(1)
    id: int = betterproto.uint64_field(2)
    pool_params: "PoolParams" = betterproto.message_field(3)
    future_pool_governor: str = betterproto.string_field(4)
    """
    This string specifies who will govern the pool in the future. Valid forms
    of this are: {token name},{duration} {duration} where {token name} if
    specified is the token which determines the governor, and if not specified
    is the LP token for this pool.duration is a time specified as 0w,1w,2w,
    etc. which specifies how long the token would need to be locked up to count
    in governance. 0w means no lockup.
    """

    total_shares: "_____cosmos_base_v1_beta1__.Coin" = betterproto.message_field(5)
    """sum of all LP shares"""

    pool_liquidity: List[
        "_____cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(6)
    """assets in the pool"""

    scaling_factor: List[int] = betterproto.uint64_field(7)
    """for calculation amognst assets with different precisions"""

    scaling_factor_governor: str = betterproto.string_field(8)
    """
    scaling_factor_governor is the address can adjust pool scaling factors
    """


@dataclass(eq=False, repr=False)
class MsgCreateStableswapPool(betterproto.Message):
    """===================== MsgCreatePool"""

    sender: str = betterproto.string_field(1)
    pool_params: "PoolParams" = betterproto.message_field(2)
    initial_pool_liquidity: List[
        "_____cosmos_base_v1_beta1__.Coin"
    ] = betterproto.message_field(3)
    scaling_factors: List[int] = betterproto.uint64_field(4)
    future_pool_governor: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgCreateStableswapPoolResponse(betterproto.Message):
    """Returns a poolID with custom poolName."""

    pool_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class MsgStableSwapAdjustScalingFactors(betterproto.Message):
    """
    Sender must be the pool's scaling_factor_governor in order for the tx to
    succeed. Adjusts stableswap scaling factors.
    """

    sender: str = betterproto.string_field(1)
    pool_id: int = betterproto.uint64_field(2)
    scaling_factors: List[int] = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class MsgStableSwapAdjustScalingFactorsResponse(betterproto.Message):
    pass


class MsgStub(betterproto.ServiceStub):
    async def create_stableswap_pool(
        self,
        msg_create_stableswap_pool: "MsgCreateStableswapPool",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateStableswapPoolResponse":
        return await self._unary_unary(
            "/osmosis.gamm.poolmodels.stableswap.v1beta1.Msg/CreateStableswapPool",
            msg_create_stableswap_pool,
            MsgCreateStableswapPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def stable_swap_adjust_scaling_factors(
        self,
        msg_stable_swap_adjust_scaling_factors: "MsgStableSwapAdjustScalingFactors",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgStableSwapAdjustScalingFactorsResponse":
        return await self._unary_unary(
            "/osmosis.gamm.poolmodels.stableswap.v1beta1.Msg/StableSwapAdjustScalingFactors",
            msg_stable_swap_adjust_scaling_factors,
            MsgStableSwapAdjustScalingFactorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def create_stableswap_pool(
        self, msg_create_stableswap_pool: "MsgCreateStableswapPool"
    ) -> "MsgCreateStableswapPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stable_swap_adjust_scaling_factors(
        self,
        msg_stable_swap_adjust_scaling_factors: "MsgStableSwapAdjustScalingFactors",
    ) -> "MsgStableSwapAdjustScalingFactorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_stableswap_pool(
        self,
        stream: "grpclib.server.Stream[MsgCreateStableswapPool, MsgCreateStableswapPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_stableswap_pool(request)
        await stream.send_message(response)

    async def __rpc_stable_swap_adjust_scaling_factors(
        self,
        stream: "grpclib.server.Stream[MsgStableSwapAdjustScalingFactors, MsgStableSwapAdjustScalingFactorsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.stable_swap_adjust_scaling_factors(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.gamm.poolmodels.stableswap.v1beta1.Msg/CreateStableswapPool": grpclib.const.Handler(
                self.__rpc_create_stableswap_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateStableswapPool,
                MsgCreateStableswapPoolResponse,
            ),
            "/osmosis.gamm.poolmodels.stableswap.v1beta1.Msg/StableSwapAdjustScalingFactors": grpclib.const.Handler(
                self.__rpc_stable_swap_adjust_scaling_factors,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgStableSwapAdjustScalingFactors,
                MsgStableSwapAdjustScalingFactorsResponse,
            ),
        }
