# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: genesis.proto, query.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class EpochInfo(betterproto.Message):
    """
    EpochInfo is a struct that describes the data going into a timer defined by
    the x/epochs module.
    """

    identifier: str = betterproto.string_field(1)
    """identifier is a unique reference to this particular timer."""

    start_time: datetime = betterproto.message_field(2)
    """
    start_time is the time at which the timer first ever ticks. If start_time
    is in the future, the epoch will not begin until the start time.
    """

    duration: timedelta = betterproto.message_field(3)
    """
    duration is the time in between epoch ticks. In order for intended behavior
    to be met, duration should be greater than the chains expected block time.
    Duration must be non-zero.
    """

    current_epoch: int = betterproto.int64_field(4)
    """
    current_epoch is the current epoch number, or in other words, how many
    times has the timer 'ticked'. The first tick (current_epoch=1) is defined
    as the first block whose blocktime is greater than the EpochInfo
    start_time.
    """

    current_epoch_start_time: datetime = betterproto.message_field(5)
    """
    current_epoch_start_time describes the start time of the current timer
    interval. The interval is (current_epoch_start_time,
    current_epoch_start_time + duration] When the timer ticks, this is set to
    current_epoch_start_time = last_epoch_start_time + duration only one timer
    tick for a given identifier can occur per block. NOTE! The
    current_epoch_start_time may diverge significantly from the wall-clock time
    the epoch began at. Wall-clock time of epoch start may be >>
    current_epoch_start_time. Suppose current_epoch_start_time = 10, duration =
    5. Suppose the chain goes offline at t=14, and comes back online at t=30,
    and produces blocks at every successive time. (t=31, 32, etc.) * The t=30
    block will start the epoch for (10, 15] * The t=31 block will start the
    epoch for (15, 20] * The t=32 block will start the epoch for (20, 25] * The
    t=33 block will start the epoch for (25, 30] * The t=34 block will start
    the epoch for (30, 35] * The **t=36** block will start the epoch for (35,
    40]
    """

    epoch_counting_started: bool = betterproto.bool_field(6)
    """
    epoch_counting_started is a boolean, that indicates whether this epoch
    timer has began yet.
    """

    current_epoch_start_height: int = betterproto.int64_field(8)
    """
    current_epoch_start_height is the block height at which the current epoch
    started. (The block height at which the timer last ticked)
    """


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the epochs module's genesis state."""

    epochs: List["EpochInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryEpochsInfoRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class QueryEpochsInfoResponse(betterproto.Message):
    epochs: List["EpochInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryCurrentEpochRequest(betterproto.Message):
    identifier: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryCurrentEpochResponse(betterproto.Message):
    current_epoch: int = betterproto.int64_field(1)


class QueryStub(betterproto.ServiceStub):
    async def epoch_infos(
        self,
        query_epochs_info_request: "QueryEpochsInfoRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryEpochsInfoResponse":
        return await self._unary_unary(
            "/osmosis.epochs.v1beta1.Query/EpochInfos",
            query_epochs_info_request,
            QueryEpochsInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def current_epoch(
        self,
        query_current_epoch_request: "QueryCurrentEpochRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCurrentEpochResponse":
        return await self._unary_unary(
            "/osmosis.epochs.v1beta1.Query/CurrentEpoch",
            query_current_epoch_request,
            QueryCurrentEpochResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):
    async def epoch_infos(
        self, query_epochs_info_request: "QueryEpochsInfoRequest"
    ) -> "QueryEpochsInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def current_epoch(
        self, query_current_epoch_request: "QueryCurrentEpochRequest"
    ) -> "QueryCurrentEpochResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_epoch_infos(
        self,
        stream: "grpclib.server.Stream[QueryEpochsInfoRequest, QueryEpochsInfoResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.epoch_infos(request)
        await stream.send_message(response)

    async def __rpc_current_epoch(
        self,
        stream: "grpclib.server.Stream[QueryCurrentEpochRequest, QueryCurrentEpochResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.current_epoch(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/osmosis.epochs.v1beta1.Query/EpochInfos": grpclib.const.Handler(
                self.__rpc_epoch_infos,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryEpochsInfoRequest,
                QueryEpochsInfoResponse,
            ),
            "/osmosis.epochs.v1beta1.Query/CurrentEpoch": grpclib.const.Handler(
                self.__rpc_current_epoch,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCurrentEpochRequest,
                QueryCurrentEpochResponse,
            ),
        }
