# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/tx/v1beta1/service.proto, cosmos/tx/v1beta1/tx.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class OrderBy(betterproto.Enum):
    """OrderBy defines the sorting order"""

    # ORDER_BY_UNSPECIFIED specifies an unknown sorting order. OrderBy defaults
    # to ASC in this case.
    ORDER_BY_UNSPECIFIED = 0
    # ORDER_BY_ASC defines ascending order
    ORDER_BY_ASC = 1
    # ORDER_BY_DESC defines descending order
    ORDER_BY_DESC = 2


class BroadcastMode(betterproto.Enum):
    """
    BroadcastMode specifies the broadcast mode for the TxService.Broadcast RPC
    method.
    """

    # zero-value for mode ordering
    BROADCAST_MODE_UNSPECIFIED = 0
    # BROADCAST_MODE_BLOCK defines a tx broadcasting mode where the client waits
    # for the tx to be committed in a block.
    BROADCAST_MODE_BLOCK = 1
    # BROADCAST_MODE_SYNC defines a tx broadcasting mode where the client waits
    # for a CheckTx execution response only.
    BROADCAST_MODE_SYNC = 2
    # BROADCAST_MODE_ASYNC defines a tx broadcasting mode where the client
    # returns immediately.
    BROADCAST_MODE_ASYNC = 3


@dataclass(eq=False, repr=False)
class Tx(betterproto.Message):
    """Tx is the standard type used for broadcasting transactions."""

    # body is the processable content of the transaction
    body: "TxBody" = betterproto.message_field(1)
    # auth_info is the authorization related content of the transaction,
    # specifically signers, signer modes and fee
    auth_info: "AuthInfo" = betterproto.message_field(2)
    # signatures is a list of signatures that matches the length and order of
    # AuthInfo's signer_infos to allow connecting signature meta information like
    # public key and signing mode by position.
    signatures: List[bytes] = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class TxRaw(betterproto.Message):
    """
    TxRaw is a variant of Tx that pins the signer's exact binary representation
    of body and auth_info. This is used for signing, broadcasting and
    verification. The binary `serialize(tx: TxRaw)` is stored in Tendermint and
    the hash `sha256(serialize(tx: TxRaw))` becomes the "txhash", commonly used
    as the transaction ID.
    """

    # body_bytes is a protobuf serialization of a TxBody that matches the
    # representation in SignDoc.
    body_bytes: bytes = betterproto.bytes_field(1)
    # auth_info_bytes is a protobuf serialization of an AuthInfo that matches the
    # representation in SignDoc.
    auth_info_bytes: bytes = betterproto.bytes_field(2)
    # signatures is a list of signatures that matches the length and order of
    # AuthInfo's signer_infos to allow connecting signature meta information like
    # public key and signing mode by position.
    signatures: List[bytes] = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class SignDoc(betterproto.Message):
    """
    SignDoc is the type used for generating sign bytes for SIGN_MODE_DIRECT.
    """

    # body_bytes is protobuf serialization of a TxBody that matches the
    # representation in TxRaw.
    body_bytes: bytes = betterproto.bytes_field(1)
    # auth_info_bytes is a protobuf serialization of an AuthInfo that matches the
    # representation in TxRaw.
    auth_info_bytes: bytes = betterproto.bytes_field(2)
    # chain_id is the unique identifier of the chain this transaction targets. It
    # prevents signed transactions from being used on another chain by an
    # attacker
    chain_id: str = betterproto.string_field(3)
    # account_number is the account number of the account in state
    account_number: int = betterproto.uint64_field(4)


@dataclass(eq=False, repr=False)
class TxBody(betterproto.Message):
    """TxBody is the body of a transaction that all signers sign over."""

    # messages is a list of messages to be executed. The required signers of
    # those messages define the number and order of elements in AuthInfo's
    # signer_infos and Tx's signatures. Each required signer address is added to
    # the list only the first time it occurs. By convention, the first required
    # signer (usually from the first message) is referred to as the primary
    # signer and pays the fee for the whole transaction.
    messages: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(1)
    # memo is any arbitrary note/comment to be added to the transaction. WARNING:
    # in clients, any publicly exposed text should not be called memo, but should
    # be called `note` instead (see https://github.com/cosmos/cosmos-
    # sdk/issues/9122).
    memo: str = betterproto.string_field(2)
    # timeout is the block height after which this transaction will not be
    # processed by the chain
    timeout_height: int = betterproto.uint64_field(3)
    # extension_options are arbitrary options that can be added by chains when
    # the default options are not sufficient. If any of these are present and
    # can't be handled, the transaction will be rejected
    extension_options: List[
        "betterproto_lib_google_protobuf.Any"
    ] = betterproto.message_field(1023)
    # extension_options are arbitrary options that can be added by chains when
    # the default options are not sufficient. If any of these are present and
    # can't be handled, they will be ignored
    non_critical_extension_options: List[
        "betterproto_lib_google_protobuf.Any"
    ] = betterproto.message_field(2047)


@dataclass(eq=False, repr=False)
class AuthInfo(betterproto.Message):
    """
    AuthInfo describes the fee and signer modes that are used to sign a
    transaction.
    """

    # signer_infos defines the signing modes for the required signers. The number
    # and order of elements must match the required signers from TxBody's
    # messages. The first element is the primary signer and the one which pays
    # the fee.
    signer_infos: List["SignerInfo"] = betterproto.message_field(1)
    # Fee is the fee and gas limit for the transaction. The first signer is the
    # primary signer and the one which pays the fee. The fee can be calculated
    # based on the cost of evaluating the body and doing signature verification
    # of the signers. This can be estimated via simulation.
    fee: "Fee" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class SignerInfo(betterproto.Message):
    """
    SignerInfo describes the public key and signing mode of a single top-level
    signer.
    """

    # public_key is the public key of the signer. It is optional for accounts
    # that already exist in state. If unset, the verifier can use the required \
    # signer address for this position and lookup the public key.
    public_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    # mode_info describes the signing mode of the signer and is a nested
    # structure to support nested multisig pubkey's
    mode_info: "ModeInfo" = betterproto.message_field(2)
    # sequence is the sequence of the account, which describes the number of
    # committed transactions signed by a given address. It is used to prevent
    # replay attacks.
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class ModeInfo(betterproto.Message):
    """
    ModeInfo describes the signing mode of a single or nested multisig signer.
    """

    # single represents a single signer
    single: "ModeInfoSingle" = betterproto.message_field(1, group="sum")
    # multi represents a nested multisig signer
    multi: "ModeInfoMulti" = betterproto.message_field(2, group="sum")


@dataclass(eq=False, repr=False)
class ModeInfoSingle(betterproto.Message):
    """
    Single is the mode info for a single signer. It is structured as a message
    to allow for additional fields such as locale for SIGN_MODE_TEXTUAL in the
    future
    """

    # mode is the signing mode of the single signer
    mode: "_signing_v1_beta1__.SignMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ModeInfoMulti(betterproto.Message):
    """Multi is the mode info for a multisig public key"""

    # bitarray specifies which keys within the multisig are signing
    bitarray: "__crypto_multisig_v1_beta1__.CompactBitArray" = (
        betterproto.message_field(1)
    )
    # mode_infos is the corresponding modes of the signers of the multisig which
    # could include nested multisig public keys
    mode_infos: List["ModeInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Fee(betterproto.Message):
    """
    Fee includes the amount of coins paid in fees and the maximum gas to be
    used by the transaction. The ratio yields an effective "gasprice", which
    must be above some miminum to be accepted into the mempool.
    """

    # amount is the amount of coins to be paid as a fee
    amount: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)
    # gas_limit is the maximum gas that can be used in transaction processing
    # before an out of gas error occurs
    gas_limit: int = betterproto.uint64_field(2)
    # if unset, the first signer is responsible for paying the fees. If set, the
    # specified account must pay the fees. the payer must be a tx signer (and
    # thus have signed this field in AuthInfo). setting this field does *not*
    # change the ordering of required signers for the transaction.
    payer: str = betterproto.string_field(3)
    # if set, the fee payer (either the first signer or the value of the payer
    # field) requests that a fee grant be used to pay fees instead of the fee
    # payer's own balance. If an appropriate fee grant does not exist or the
    # chain does not support fee grants, this will fail
    granter: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GetTxsEventRequest(betterproto.Message):
    """
    GetTxsEventRequest is the request type for the Service.TxsByEvents RPC
    method.
    """

    # events is the list of transaction event type.
    events: List[str] = betterproto.string_field(1)
    # pagination defines a pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    order_by: "OrderBy" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class GetTxsEventResponse(betterproto.Message):
    """
    GetTxsEventResponse is the response type for the Service.TxsByEvents RPC
    method.
    """

    # txs is the list of queried transactions.
    txs: List["Tx"] = betterproto.message_field(1)
    # tx_responses is the list of queried TxResponses.
    tx_responses: List["__base_abci_v1_beta1__.TxResponse"] = betterproto.message_field(
        2
    )
    # pagination defines a pagination for the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class BroadcastTxRequest(betterproto.Message):
    """
    BroadcastTxRequest is the request type for the Service.BroadcastTxRequest
    RPC method.
    """

    # tx_bytes is the raw transaction.
    tx_bytes: bytes = betterproto.bytes_field(1)
    mode: "BroadcastMode" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class BroadcastTxResponse(betterproto.Message):
    """
    BroadcastTxResponse is the response type for the Service.BroadcastTx
    method.
    """

    # tx_response is the queried TxResponses.
    tx_response: "__base_abci_v1_beta1__.TxResponse" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SimulateRequest(betterproto.Message):
    """
    SimulateRequest is the request type for the Service.Simulate RPC method.
    """

    # tx is the transaction to simulate. Deprecated. Send raw tx bytes instead.
    tx: "Tx" = betterproto.message_field(1)
    # tx_bytes is the raw transaction. Since: cosmos-sdk 0.43
    tx_bytes: bytes = betterproto.bytes_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.tx:
            warnings.warn("SimulateRequest.tx is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class SimulateResponse(betterproto.Message):
    """
    SimulateResponse is the response type for the Service.SimulateRPC method.
    """

    # gas_info is the information about gas used in the simulation.
    gas_info: "__base_abci_v1_beta1__.GasInfo" = betterproto.message_field(1)
    # result is the result of the simulation.
    result: "__base_abci_v1_beta1__.Result" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetTxRequest(betterproto.Message):
    """GetTxRequest is the request type for the Service.GetTx RPC method."""

    # hash is the tx hash to query, encoded as a hex string.
    hash: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetTxResponse(betterproto.Message):
    """GetTxResponse is the response type for the Service.GetTx method."""

    # tx is the queried transaction.
    tx: "Tx" = betterproto.message_field(1)
    # tx_response is the queried TxResponses.
    tx_response: "__base_abci_v1_beta1__.TxResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetBlockWithTxsRequest(betterproto.Message):
    """
    GetBlockWithTxsRequest is the request type for the Service.GetBlockWithTxs
    RPC method. Since: cosmos-sdk 0.45.2
    """

    # height is the height of the block to query.
    height: int = betterproto.int64_field(1)
    # pagination defines a pagination for the request.
    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetBlockWithTxsResponse(betterproto.Message):
    """
    GetBlockWithTxsResponse is the response type for the
    Service.GetBlockWithTxs method. Since: cosmos-sdk 0.45.2
    """

    # txs are the transactions in the block.
    txs: List["Tx"] = betterproto.message_field(1)
    block_id: "___tendermint_types__.BlockId" = betterproto.message_field(2)
    block: "___tendermint_types__.Block" = betterproto.message_field(3)
    # pagination defines a pagination for the response.
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(4)


class ServiceStub(betterproto.ServiceStub):
    async def simulate(
        self, *, tx: "Tx" = None, tx_bytes: bytes = b""
    ) -> "SimulateResponse":

        request = SimulateRequest()
        if tx is not None:
            request.tx = tx
        request.tx_bytes = tx_bytes

        return await self._unary_unary(
            "/cosmos.tx.v1beta1.Service/Simulate", request, SimulateResponse
        )

    async def get_tx(self, *, hash: str = "") -> "GetTxResponse":

        request = GetTxRequest()
        request.hash = hash

        return await self._unary_unary(
            "/cosmos.tx.v1beta1.Service/GetTx", request, GetTxResponse
        )

    async def broadcast_tx(
        self, *, tx_bytes: bytes = b"", mode: "BroadcastMode" = 0
    ) -> "BroadcastTxResponse":

        request = BroadcastTxRequest()
        request.tx_bytes = tx_bytes
        request.mode = mode

        return await self._unary_unary(
            "/cosmos.tx.v1beta1.Service/BroadcastTx", request, BroadcastTxResponse
        )

    async def get_txs_event(
        self,
        *,
        events: Optional[List[str]] = None,
        pagination: "__base_query_v1_beta1__.PageRequest" = None,
        order_by: "OrderBy" = 0
    ) -> "GetTxsEventResponse":
        events = events or []

        request = GetTxsEventRequest()
        request.events = events
        if pagination is not None:
            request.pagination = pagination
        request.order_by = order_by

        return await self._unary_unary(
            "/cosmos.tx.v1beta1.Service/GetTxsEvent", request, GetTxsEventResponse
        )

    async def get_block_with_txs(
        self,
        *,
        height: int = 0,
        pagination: "__base_query_v1_beta1__.PageRequest" = None
    ) -> "GetBlockWithTxsResponse":

        request = GetBlockWithTxsRequest()
        request.height = height
        if pagination is not None:
            request.pagination = pagination

        return await self._unary_unary(
            "/cosmos.tx.v1beta1.Service/GetBlockWithTxs",
            request,
            GetBlockWithTxsResponse,
        )


class ServiceBase(ServiceBase):
    async def simulate(self, tx: "Tx", tx_bytes: bytes) -> "SimulateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_tx(self, hash: str) -> "GetTxResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def broadcast_tx(
        self, tx_bytes: bytes, mode: "BroadcastMode"
    ) -> "BroadcastTxResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_txs_event(
        self,
        events: Optional[List[str]],
        pagination: "__base_query_v1_beta1__.PageRequest",
        order_by: "OrderBy",
    ) -> "GetTxsEventResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_block_with_txs(
        self, height: int, pagination: "__base_query_v1_beta1__.PageRequest"
    ) -> "GetBlockWithTxsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_simulate(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "tx": request.tx,
            "tx_bytes": request.tx_bytes,
        }

        response = await self.simulate(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_tx(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "hash": request.hash,
        }

        response = await self.get_tx(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_broadcast_tx(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "tx_bytes": request.tx_bytes,
            "mode": request.mode,
        }

        response = await self.broadcast_tx(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_txs_event(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "events": request.events,
            "pagination": request.pagination,
            "order_by": request.order_by,
        }

        response = await self.get_txs_event(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_block_with_txs(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "height": request.height,
            "pagination": request.pagination,
        }

        response = await self.get_block_with_txs(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.tx.v1beta1.Service/Simulate": grpclib.const.Handler(
                self.__rpc_simulate,
                grpclib.const.Cardinality.UNARY_UNARY,
                SimulateRequest,
                SimulateResponse,
            ),
            "/cosmos.tx.v1beta1.Service/GetTx": grpclib.const.Handler(
                self.__rpc_get_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTxRequest,
                GetTxResponse,
            ),
            "/cosmos.tx.v1beta1.Service/BroadcastTx": grpclib.const.Handler(
                self.__rpc_broadcast_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                BroadcastTxRequest,
                BroadcastTxResponse,
            ),
            "/cosmos.tx.v1beta1.Service/GetTxsEvent": grpclib.const.Handler(
                self.__rpc_get_txs_event,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTxsEventRequest,
                GetTxsEventResponse,
            ),
            "/cosmos.tx.v1beta1.Service/GetBlockWithTxs": grpclib.const.Handler(
                self.__rpc_get_block_with_txs,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetBlockWithTxsRequest,
                GetBlockWithTxsResponse,
            ),
        }


from ....tendermint import types as ___tendermint_types__
from ...base import v1beta1 as __base_v1_beta1__
from ...base.abci import v1beta1 as __base_abci_v1_beta1__
from ...base.query import v1beta1 as __base_query_v1_beta1__
from ...crypto.multisig import v1beta1 as __crypto_multisig_v1_beta1__
from ..signing import v1beta1 as _signing_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
