import importlib
import shutil
import site
import sys
from pathlib import Path
from textwrap import dedent

import click


@click.group()
def summ():
    pass


@summ.command()
@click.option("--template", "-t", default="otter", type=click.Choice(["otter"]))
@click.argument(
    "destination", type=click.Path(exists=False, writable=True, path_type=Path)
)
def init(template: str, destination: Path):
    example = importlib.import_module(f"summ.examples.{template}")
    shutil.copytree(Path(example.__file__).parent, destination)

    (destination / "__init__.py").unlink()
    shutil.rmtree(destination / "__pycache__")

    impl_init = destination / "implementation" / "__init__.py"
    impl_init.write_text(
        dedent(
            f"""
    # generated by summ init {template}
    import site; site.addsitedir("{site.getsitepackages()[0]}")
    """
        )
        + "\n"
        + impl_init.read_text()
    )

    click.echo(f"Created example project in {destination}")
