# epiGeEC Analysis #

The **epiGenomic Efficient Correlator (epiGeEC) Analysis** is a suite of tools to process, annotate and analyse correlation matrices generated by [**epiGeEC**](https://bitbucket.org/labjacquespe/epigeec/src/master/). A galaxy implementation featuring these tools and including thousands of pre-computed public epigenomic datasets is availalble at <http://epigeec.genap.ca/galaxy/>.

### Installation

Linux/x64 is the only OS currently supported, but it can work on any platform with python and pip installed.

#### Dependencies

You will need pip to install the python package, use the following command if not already installed

	sudo apt-get install python-pip

Pip will attempt to install all dependencies but most likely will fail

See documentation on how to install [pandas](https://github.com/svaksha/PyData-Workshop-Sprint/wiki/linux-install-pandas).

You might have more success with

	sudo apt-get install python-pandas

#### Install epiGeEC Analysis

    sudo pip install epigeec-analysis

### How To Use

This tool suite provide multiple analysis program.

For more info on each parameter use the help flag

	epigeec-analysis [tool] --help

#### Annotate matrix

Essentialy, this tool apply a hierachical cluster method on a correlation matrix to
regroup datasets in clusters associated with their metadatas.

![Hierarchical clustering](images/img5.jpg)



    epigeec-analysis annotate --pdf output.pdf --tsv output.tsv epiGeEC_Correlate.mat epiGeEC_Datasets.json assay cell_type timepoint

#### Evaluate clusters

    epigeec-analysis evaluate epiGeEC_Correlate.mat epiGeEC_Datasets.json -b assay cell_type timepoint -r assay cell_type timepoint > output.ari

### License

[GNU General Public License v3](LICENSE)