## Welcome

Resistics is a native Python 3 package for the processing of magnetotelluric (MT) data. It incorporates standard robust processing methods and adopts a modular approach to processing which allows for customisation and future improvements to be quickly adopted.

## About

Resistics began as a set of python classes to help analyse noisy MT timeseries data acquired in northern Switzerland through increased use of statistics and time window based features. Since then, it has grown into a MT data processing package. The name is an amalgamation of resistivty and statistics...resistics!

## Audience

Resistics is intended for people who use magnetotelluric methods to estimate the subsurface resistivity. This may be for the purposes of furthering geological understanding, for geothermal prospecting or for other purposes.

## Getting started

Resistics can be installed using pip,

```
python -m pip install --user resistics
```

or possibly,

```
python3 -m pip install --user resistics
```

depending on how your Python 3 install is named.

The next step after installing is to visit www.resistics.io and read the documentation. For those unfamiliar with resistics, the features, conventions and tutorial sections are a good way to become more comfortable using the package.

## Open-source

Resistics is available for free under the MIT licence. The resistics source code can be found in the [GitHub repository](https://github.com/resistics/resistics). Contributors are welcome.

## Support and feature requests

Support and feature requests can be submitted on the in the [GitHub repository](https://github.com/resistics/resistics) page.
