/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.androlib.AndrolibException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ResXmlPatcher {
    private static final Logger LOGGER = Logger.getLogger(ResXmlPatcher.class.getName());

    public static void removeApplicationDebugTag(File file) throws AndrolibException {
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                Node application = doc.getElementsByTagName("application").item(0);
                NamedNodeMap attr = application.getAttributes();
                Node debugAttr = attr.getNamedItem("android:debuggable");
                if (debugAttr != null) {
                    attr.removeNamedItem("android:debuggable");
                }
                ResXmlPatcher.saveDocument(file, doc);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public static void setApplicationDebugTagTrue(File file) {
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                Node application = doc.getElementsByTagName("application").item(0);
                NamedNodeMap attr = application.getAttributes();
                Node debugAttr = attr.getNamedItem("android:debuggable");
                if (debugAttr == null) {
                    debugAttr = doc.createAttribute("android:debuggable");
                    attr.setNamedItem(debugAttr);
                }
                debugAttr.setNodeValue("true");
                ResXmlPatcher.saveDocument(file, doc);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public static void setNetworkSecurityConfig(File file) {
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                Node application = doc.getElementsByTagName("application").item(0);
                NamedNodeMap attr = application.getAttributes();
                Node netSecConfAttr = attr.getNamedItem("android:networkSecurityConfig");
                if (netSecConfAttr == null) {
                    netSecConfAttr = doc.createAttribute("android:networkSecurityConfig");
                    attr.setNamedItem(netSecConfAttr);
                }
                netSecConfAttr.setNodeValue("@xml/network_security_config");
                ResXmlPatcher.saveDocument(file, doc);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public static void modNetworkSecurityConfig(File file) throws ParserConfigurationException, TransformerException, IOException, SAXException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element root = document.createElement("network-security-config");
        document.appendChild(root);
        Element baseConfig = document.createElement("base-config");
        root.appendChild(baseConfig);
        Element trustAnchors = document.createElement("trust-anchors");
        baseConfig.appendChild(trustAnchors);
        Element certSystem = document.createElement("certificates");
        Attr attrSystem = document.createAttribute("src");
        attrSystem.setValue("system");
        certSystem.setAttributeNode(attrSystem);
        trustAnchors.appendChild(certSystem);
        Element certUser = document.createElement("certificates");
        Attr attrUser = document.createAttribute("src");
        attrUser.setValue("user");
        certUser.setAttributeNode(attrUser);
        trustAnchors.appendChild(certUser);
        ResXmlPatcher.saveDocument(file, document);
    }

    public static void fixingPublicAttrsInProviderAttributes(File file) {
        boolean saved = false;
        if (file.exists()) {
            try {
                Node provider;
                NamedNodeMap attrs;
                Node node;
                int i;
                Document doc = ResXmlPatcher.loadDocument(file);
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expression = xPath.compile("/manifest/application/provider");
                Object result = expression.evaluate(doc, XPathConstants.NODESET);
                NodeList nodes = (NodeList)result;
                for (i = 0; i < nodes.getLength(); ++i) {
                    node = nodes.item(i);
                    attrs = node.getAttributes();
                    if (attrs == null || (provider = attrs.getNamedItem("android:authorities")) == null) continue;
                    saved = ResXmlPatcher.isSaved(file, saved, provider);
                }
                xPath = XPathFactory.newInstance().newXPath();
                expression = xPath.compile("/manifest/application/activity/intent-filter/data");
                result = expression.evaluate(doc, XPathConstants.NODESET);
                nodes = (NodeList)result;
                for (i = 0; i < nodes.getLength(); ++i) {
                    node = nodes.item(i);
                    attrs = node.getAttributes();
                    if (attrs == null || (provider = attrs.getNamedItem("android:scheme")) == null) continue;
                    saved = ResXmlPatcher.isSaved(file, saved, provider);
                }
                if (saved) {
                    ResXmlPatcher.saveDocument(file, doc);
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException exception) {
                // empty catch block
            }
        }
    }

    private static boolean isSaved(File file, boolean saved, Node provider) {
        String reference = provider.getNodeValue();
        String replacement = ResXmlPatcher.pullValueFromStrings(file.getParentFile(), reference);
        if (replacement != null) {
            provider.setNodeValue(replacement);
            saved = true;
        }
        return saved;
    }

    public static String pullValueFromStrings(File directory, String key) {
        if (key == null || !key.contains("@")) {
            return null;
        }
        File file = new File(directory, "/res/values/strings.xml");
        key = key.replace("@string/", "");
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expression = xPath.compile("/resources/string[@name=\"" + key + "\"]/text()");
                Object result = expression.evaluate(doc, XPathConstants.STRING);
                if (result != null) {
                    return (String)result;
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String pullValueFromIntegers(File directory, String key) {
        if (key == null || !key.contains("@")) {
            return null;
        }
        File file = new File(directory, "/res/values/integers.xml");
        key = key.replace("@integer/", "");
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expression = xPath.compile("/resources/integer[@name=\"" + key + "\"]/text()");
                Object result = expression.evaluate(doc, XPathConstants.STRING);
                if (result != null) {
                    return (String)result;
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void removeManifestVersions(File file) {
        if (file.exists()) {
            try {
                Document doc = ResXmlPatcher.loadDocument(file);
                Node manifest = doc.getFirstChild();
                NamedNodeMap attr = manifest.getAttributes();
                Node vCode = attr.getNamedItem("android:versionCode");
                Node vName = attr.getNamedItem("android:versionName");
                if (vCode != null) {
                    attr.removeNamedItem("android:versionCode");
                }
                if (vName != null) {
                    attr.removeNamedItem("android:versionName");
                }
                ResXmlPatcher.saveDocument(file, doc);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public static void renameManifestPackage(File file, String packageOriginal) {
        try {
            Document doc = ResXmlPatcher.loadDocument(file);
            Node manifest = doc.getFirstChild();
            NamedNodeMap attr = manifest.getAttributes();
            Node nodeAttr = attr.getNamedItem("package");
            nodeAttr.setNodeValue(packageOriginal);
            ResXmlPatcher.saveDocument(file, doc);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    private static Document loadDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            docFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", " ");
            docFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", " ");
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warning("JAXP 1.5 Support is required to validate XML");
        }
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document document = docBuilder.parse(inputStream);
            return document;
        }
    }

    private static void saveDocument(File file, Document doc) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }
}

