# sample-sheet

[![Testing Status](https://travis-ci.org/clintval/sample-sheet.svg?branch=master)](https://travis-ci.org/clintval/sample-sheet)
[![Documentation Build Status](https://readthedocs.org/projects/sample-sheet/badge/?version=latest)](https://sample-sheet.readthedocs.io/en/latest/?badge=latest)
[![Code Coverage](https://codecov.io/gh/clintval/sample-sheet/branch/master/graph/badge.svg)](https://codecov.io/gh/clintval/sample-sheet)
[![PyPI Release](https://badge.fury.io/py/sample-sheet.svg)](https://badge.fury.io/py/sample-sheet)
[![install with bioconda](https://img.shields.io/badge/install%20with-bioconda-brightgreen.svg)](http://bioconda.github.io/recipes/sample-sheet/README.html)
[![Python Versions](https://img.shields.io/pypi/pyversions/sample-sheet.svg)](https://pypi.python.org/pypi/sample-sheet/)
[![MyPy Checked](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)

A permissively licensed library designed to replace [Illumina's Experiment Manager](https://support.illumina.com/sequencing/sequencing_software/experiment_manager.html).

```bash
❯ pip install sample-sheet
```

Or install with the Conda package manager after setting up your [Bioconda channels](https://bioconda.github.io/user/install.html#set-up-channels):

```bash
❯ conda install sample-sheet
```

Which should be equivalent to:

```bash
❯ conda install -c bioconda -c conda-forge -c defaults sample-sheet
```

Features:

- Roundtrip reading, editing, and writing of Sample Sheets
- _de novo_ creation creation of Sample Sheets
- Exporting Sample Sheets to JSON

Read the documentation at: [sample-sheet.readthedocs.io](http://sample-sheet.readthedocs.io/)
