import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

class charts():
    def __init__(self, chart_type):
        self.chart_type = chart_type

    def line(self, nparray):
        if self.chart_type != "line":
            raise TypeError("Chart type must be a Line")
        if type(nparray).__module__ != np.__name__:
            raise ValueError("Array must be a type of Numpy Array")

        def generate_html(nparray):
            if type(nparray).__module__ != np.__name__:
                raise ValueError("Array must be a type of Numpy Array")

            datapoints = ["{{y: {} }}".format(integer) for integer in nparray.tolist()]

            file=open("homepage.html", "wt")
            file.write("""
            <!DOCTYPE HTML>
            <html>
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Radix - Demo</title>

                <!-- Since this is an open-source, we give ability to get whole HTML <3 -->

                <link rel="stylesheet" href="style.css">
            </head> 
            <script>
            window.onload = function () {

            var chart = new CanvasJS.Chart("chartContainer", {
                animationEnabled: true,
                theme: "light1",
                title:{
                    text: "Simple LineChart Generated by Radix"
                },
                data: [{        
                    type: "line",
                    indexLabelFontSize: 16,
                    dataPoints: """+f"""
                        {'[%s]' % ', '.join(map(str, datapoints))}


                """+"""
                }]
            });
            chart.render();

            }
            </script>
            </head>
            <body>
            <div id="chartContainer" style="height: 100vh; width: 100%;"></div>
                <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
            </body>
            </html>""")
            file.close()

        def generate_css():
            file=open("style.css", "wt")
            file.write("""
            body{
                background-color:#0a1232
            }
            """)
            file.close()

        generate_html(nparray)
        generate_css()