# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from asktable import Asktable, AsyncAsktable

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestCaches:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_delete(self, client: Asktable) -> None:
        cach = client.caches.delete(
            "cache_id",
        )
        assert cach is None

    @parametrize
    def test_raw_response_delete(self, client: Asktable) -> None:
        response = client.caches.with_raw_response.delete(
            "cache_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        cach = response.parse()
        assert cach is None

    @parametrize
    def test_streaming_response_delete(self, client: Asktable) -> None:
        with client.caches.with_streaming_response.delete(
            "cache_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            cach = response.parse()
            assert cach is None

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_delete(self, client: Asktable) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `cache_id` but received ''"):
            client.caches.with_raw_response.delete(
                "",
            )


class TestAsyncCaches:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_delete(self, async_client: AsyncAsktable) -> None:
        cach = await async_client.caches.delete(
            "cache_id",
        )
        assert cach is None

    @parametrize
    async def test_raw_response_delete(self, async_client: AsyncAsktable) -> None:
        response = await async_client.caches.with_raw_response.delete(
            "cache_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        cach = await response.parse()
        assert cach is None

    @parametrize
    async def test_streaming_response_delete(self, async_client: AsyncAsktable) -> None:
        async with async_client.caches.with_streaming_response.delete(
            "cache_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            cach = await response.parse()
            assert cach is None

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_delete(self, async_client: AsyncAsktable) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `cache_id` but received ''"):
            await async_client.caches.with_raw_response.delete(
                "",
            )
