"""
    Slurm Rest API

    API to access and control Slurm.  # noqa: E501

    The version of the OpenAPI document: 0.0.37
    Contact: sales@schedmd.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from slurm_rest.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from slurm_rest.exceptions import ApiAttributeError



class V0036Partition(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'flags': ([str],),  # noqa: E501
            'preemption_mode': (str,),  # noqa: E501
            'allowed_allocation_nodes': (str,),  # noqa: E501
            'allowed_accounts': (str,),  # noqa: E501
            'allowed_groups': (str,),  # noqa: E501
            'allowed_qos': (str,),  # noqa: E501
            'alternative': (str,),  # noqa: E501
            'billing_weights': (str,),  # noqa: E501
            'default_memory_per_cpu': (int,),  # noqa: E501
            'default_time_limit': (int,),  # noqa: E501
            'denied_accounts': (str,),  # noqa: E501
            'denied_qos': (str,),  # noqa: E501
            'preemption_grace_time': (int,),  # noqa: E501
            'maximum_cpus_per_node': (int,),  # noqa: E501
            'maximum_memory_per_node': (int,),  # noqa: E501
            'maximum_nodes_per_job': (int,),  # noqa: E501
            'max_time_limit': (int,),  # noqa: E501
            'min_nodes_per_job': (int,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'nodes': (str,),  # noqa: E501
            'over_time_limit': (int,),  # noqa: E501
            'priority_job_factor': (int,),  # noqa: E501
            'priority_tier': (int,),  # noqa: E501
            'qos': (str,),  # noqa: E501
            'nodes_online': (int,),  # noqa: E501
            'total_cpus': (int,),  # noqa: E501
            'total_nodes': (int,),  # noqa: E501
            'tres': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'flags': 'flags',  # noqa: E501
        'preemption_mode': 'preemption_mode',  # noqa: E501
        'allowed_allocation_nodes': 'allowed_allocation_nodes',  # noqa: E501
        'allowed_accounts': 'allowed_accounts',  # noqa: E501
        'allowed_groups': 'allowed_groups',  # noqa: E501
        'allowed_qos': 'allowed_qos',  # noqa: E501
        'alternative': 'alternative',  # noqa: E501
        'billing_weights': 'billing_weights',  # noqa: E501
        'default_memory_per_cpu': 'default_memory_per_cpu',  # noqa: E501
        'default_time_limit': 'default_time_limit',  # noqa: E501
        'denied_accounts': 'denied_accounts',  # noqa: E501
        'denied_qos': 'denied_qos',  # noqa: E501
        'preemption_grace_time': 'preemption_grace_time',  # noqa: E501
        'maximum_cpus_per_node': 'maximum_cpus_per_node',  # noqa: E501
        'maximum_memory_per_node': 'maximum_memory_per_node',  # noqa: E501
        'maximum_nodes_per_job': 'maximum_nodes_per_job',  # noqa: E501
        'max_time_limit': 'max_time_limit',  # noqa: E501
        'min_nodes_per_job': 'min_nodes_per_job',  # noqa: E501
        'name': 'name',  # noqa: E501
        'nodes': 'nodes',  # noqa: E501
        'over_time_limit': 'over_time_limit',  # noqa: E501
        'priority_job_factor': 'priority_job_factor',  # noqa: E501
        'priority_tier': 'priority_tier',  # noqa: E501
        'qos': 'qos',  # noqa: E501
        'nodes_online': 'nodes_online',  # noqa: E501
        'total_cpus': 'total_cpus',  # noqa: E501
        'total_nodes': 'total_nodes',  # noqa: E501
        'tres': 'tres',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """V0036Partition - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            flags ([str]): partition options. [optional]  # noqa: E501
            preemption_mode (str): preemption type. [optional]  # noqa: E501
            allowed_allocation_nodes (str): list names of allowed allocating nodes. [optional]  # noqa: E501
            allowed_accounts (str): comma delimited list of accounts. [optional]  # noqa: E501
            allowed_groups (str): comma delimited list of groups. [optional]  # noqa: E501
            allowed_qos (str): comma delimited list of qos. [optional]  # noqa: E501
            alternative (str): name of alternate partition. [optional]  # noqa: E501
            billing_weights (str): TRES billing weights. [optional]  # noqa: E501
            default_memory_per_cpu (int): default MB memory per allocated CPU. [optional]  # noqa: E501
            default_time_limit (int): default time limit (minutes). [optional]  # noqa: E501
            denied_accounts (str): comma delimited list of denied accounts. [optional]  # noqa: E501
            denied_qos (str): comma delimited list of denied qos. [optional]  # noqa: E501
            preemption_grace_time (int): preemption grace time (seconds). [optional]  # noqa: E501
            maximum_cpus_per_node (int): maximum allocated CPUs per node. [optional]  # noqa: E501
            maximum_memory_per_node (int): maximum memory per allocated CPU (MiB). [optional]  # noqa: E501
            maximum_nodes_per_job (int): Max nodes per job. [optional]  # noqa: E501
            max_time_limit (int): Max time limit per job. [optional]  # noqa: E501
            min_nodes_per_job (int): Min number of nodes per job. [optional]  # noqa: E501
            name (str): Partition name. [optional]  # noqa: E501
            nodes (str): list names of nodes in partition. [optional]  # noqa: E501
            over_time_limit (int): job's time limit can be exceeded by this number of minutes before cancellation. [optional]  # noqa: E501
            priority_job_factor (int): job priority weight factor. [optional]  # noqa: E501
            priority_tier (int): tier for scheduling and preemption. [optional]  # noqa: E501
            qos (str): partition QOS name. [optional]  # noqa: E501
            nodes_online (int): Nodes online (ready for jobs). [optional]  # noqa: E501
            total_cpus (int): Total cpus in partition. [optional]  # noqa: E501
            total_nodes (int): Total number of nodes in partition. [optional]  # noqa: E501
            tres (str): configured TRES in partition. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """V0036Partition - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            flags ([str]): partition options. [optional]  # noqa: E501
            preemption_mode (str): preemption type. [optional]  # noqa: E501
            allowed_allocation_nodes (str): list names of allowed allocating nodes. [optional]  # noqa: E501
            allowed_accounts (str): comma delimited list of accounts. [optional]  # noqa: E501
            allowed_groups (str): comma delimited list of groups. [optional]  # noqa: E501
            allowed_qos (str): comma delimited list of qos. [optional]  # noqa: E501
            alternative (str): name of alternate partition. [optional]  # noqa: E501
            billing_weights (str): TRES billing weights. [optional]  # noqa: E501
            default_memory_per_cpu (int): default MB memory per allocated CPU. [optional]  # noqa: E501
            default_time_limit (int): default time limit (minutes). [optional]  # noqa: E501
            denied_accounts (str): comma delimited list of denied accounts. [optional]  # noqa: E501
            denied_qos (str): comma delimited list of denied qos. [optional]  # noqa: E501
            preemption_grace_time (int): preemption grace time (seconds). [optional]  # noqa: E501
            maximum_cpus_per_node (int): maximum allocated CPUs per node. [optional]  # noqa: E501
            maximum_memory_per_node (int): maximum memory per allocated CPU (MiB). [optional]  # noqa: E501
            maximum_nodes_per_job (int): Max nodes per job. [optional]  # noqa: E501
            max_time_limit (int): Max time limit per job. [optional]  # noqa: E501
            min_nodes_per_job (int): Min number of nodes per job. [optional]  # noqa: E501
            name (str): Partition name. [optional]  # noqa: E501
            nodes (str): list names of nodes in partition. [optional]  # noqa: E501
            over_time_limit (int): job's time limit can be exceeded by this number of minutes before cancellation. [optional]  # noqa: E501
            priority_job_factor (int): job priority weight factor. [optional]  # noqa: E501
            priority_tier (int): tier for scheduling and preemption. [optional]  # noqa: E501
            qos (str): partition QOS name. [optional]  # noqa: E501
            nodes_online (int): Nodes online (ready for jobs). [optional]  # noqa: E501
            total_cpus (int): Total cpus in partition. [optional]  # noqa: E501
            total_nodes (int): Total number of nodes in partition. [optional]  # noqa: E501
            tres (str): configured TRES in partition. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
