"""
    Slurm Rest API

    API to access and control Slurm.  # noqa: E501

    The version of the OpenAPI document: 0.0.37
    Contact: sales@schedmd.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from slurm_rest.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from slurm_rest.exceptions import ApiAttributeError


def lazy_import():
    from slurm_rest.model.dbv0036_job_array import Dbv0036JobArray
    from slurm_rest.model.dbv0036_job_comment import Dbv0036JobComment
    from slurm_rest.model.dbv0036_job_het import Dbv0036JobHet
    from slurm_rest.model.dbv0036_job_mcs import Dbv0036JobMcs
    from slurm_rest.model.dbv0036_job_required import Dbv0036JobRequired
    from slurm_rest.model.dbv0036_job_reservation import Dbv0036JobReservation
    from slurm_rest.model.dbv0036_job_time import Dbv0036JobTime
    from slurm_rest.model.dbv0036_job_wckey import Dbv0036JobWckey
    from slurm_rest.model.dbv0037_association_short_info import Dbv0037AssociationShortInfo
    from slurm_rest.model.dbv0037_job_exit_code import Dbv0037JobExitCode
    from slurm_rest.model.dbv0037_job_state import Dbv0037JobState
    from slurm_rest.model.dbv0037_job_step import Dbv0037JobStep
    from slurm_rest.model.dbv0037_job_tres import Dbv0037JobTres
    globals()['Dbv0036JobArray'] = Dbv0036JobArray
    globals()['Dbv0036JobComment'] = Dbv0036JobComment
    globals()['Dbv0036JobHet'] = Dbv0036JobHet
    globals()['Dbv0036JobMcs'] = Dbv0036JobMcs
    globals()['Dbv0036JobRequired'] = Dbv0036JobRequired
    globals()['Dbv0036JobReservation'] = Dbv0036JobReservation
    globals()['Dbv0036JobTime'] = Dbv0036JobTime
    globals()['Dbv0036JobWckey'] = Dbv0036JobWckey
    globals()['Dbv0037AssociationShortInfo'] = Dbv0037AssociationShortInfo
    globals()['Dbv0037JobExitCode'] = Dbv0037JobExitCode
    globals()['Dbv0037JobState'] = Dbv0037JobState
    globals()['Dbv0037JobStep'] = Dbv0037JobStep
    globals()['Dbv0037JobTres'] = Dbv0037JobTres


class Dbv0037Job(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'account': (str,),  # noqa: E501
            'comment': (Dbv0036JobComment,),  # noqa: E501
            'allocation_nodes': (str,),  # noqa: E501
            'array': (Dbv0036JobArray,),  # noqa: E501
            'time': (Dbv0036JobTime,),  # noqa: E501
            'association': (Dbv0037AssociationShortInfo,),  # noqa: E501
            'cluster': (str,),  # noqa: E501
            'constraints': (str,),  # noqa: E501
            'derived_exit_code': (Dbv0037JobExitCode,),  # noqa: E501
            'exit_code': (Dbv0037JobExitCode,),  # noqa: E501
            'flags': ([str],),  # noqa: E501
            'group': (str,),  # noqa: E501
            'het': (Dbv0036JobHet,),  # noqa: E501
            'job_id': (int,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'mcs': (Dbv0036JobMcs,),  # noqa: E501
            'nodes': (str,),  # noqa: E501
            'partition': (str,),  # noqa: E501
            'priority': (int,),  # noqa: E501
            'qos': (str,),  # noqa: E501
            'required': (Dbv0036JobRequired,),  # noqa: E501
            'kill_request_user': (str,),  # noqa: E501
            'reservation': (Dbv0036JobReservation,),  # noqa: E501
            'state': (Dbv0037JobState,),  # noqa: E501
            'steps': ([Dbv0037JobStep],),  # noqa: E501
            'tres': (Dbv0037JobTres,),  # noqa: E501
            'user': (str,),  # noqa: E501
            'wckey': (Dbv0036JobWckey,),  # noqa: E501
            'working_directory': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account': 'account',  # noqa: E501
        'comment': 'comment',  # noqa: E501
        'allocation_nodes': 'allocation_nodes',  # noqa: E501
        'array': 'array',  # noqa: E501
        'time': 'time',  # noqa: E501
        'association': 'association',  # noqa: E501
        'cluster': 'cluster',  # noqa: E501
        'constraints': 'constraints',  # noqa: E501
        'derived_exit_code': 'derived_exit_code',  # noqa: E501
        'exit_code': 'exit_code',  # noqa: E501
        'flags': 'flags',  # noqa: E501
        'group': 'group',  # noqa: E501
        'het': 'het',  # noqa: E501
        'job_id': 'job_id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'mcs': 'mcs',  # noqa: E501
        'nodes': 'nodes',  # noqa: E501
        'partition': 'partition',  # noqa: E501
        'priority': 'priority',  # noqa: E501
        'qos': 'qos',  # noqa: E501
        'required': 'required',  # noqa: E501
        'kill_request_user': 'kill_request_user',  # noqa: E501
        'reservation': 'reservation',  # noqa: E501
        'state': 'state',  # noqa: E501
        'steps': 'steps',  # noqa: E501
        'tres': 'tres',  # noqa: E501
        'user': 'user',  # noqa: E501
        'wckey': 'wckey',  # noqa: E501
        'working_directory': 'working_directory',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Dbv0037Job - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account (str): Account charged by job. [optional]  # noqa: E501
            comment (Dbv0036JobComment): [optional]  # noqa: E501
            allocation_nodes (str): Nodes allocated to job. [optional]  # noqa: E501
            array (Dbv0036JobArray): [optional]  # noqa: E501
            time (Dbv0036JobTime): [optional]  # noqa: E501
            association (Dbv0037AssociationShortInfo): [optional]  # noqa: E501
            cluster (str): Assigned cluster. [optional]  # noqa: E501
            constraints (str): Constraints on job. [optional]  # noqa: E501
            derived_exit_code (Dbv0037JobExitCode): [optional]  # noqa: E501
            exit_code (Dbv0037JobExitCode): [optional]  # noqa: E501
            flags ([str]): List of properties of job. [optional]  # noqa: E501
            group (str): User's group to run job. [optional]  # noqa: E501
            het (Dbv0036JobHet): [optional]  # noqa: E501
            job_id (int): Job id. [optional]  # noqa: E501
            name (str): Assigned job name. [optional]  # noqa: E501
            mcs (Dbv0036JobMcs): [optional]  # noqa: E501
            nodes (str): List of nodes allocated for job. [optional]  # noqa: E501
            partition (str): Assigned job's partition. [optional]  # noqa: E501
            priority (int): Priority. [optional]  # noqa: E501
            qos (str): Assigned qos name. [optional]  # noqa: E501
            required (Dbv0036JobRequired): [optional]  # noqa: E501
            kill_request_user (str): User who requested job killed. [optional]  # noqa: E501
            reservation (Dbv0036JobReservation): [optional]  # noqa: E501
            state (Dbv0037JobState): [optional]  # noqa: E501
            steps ([Dbv0037JobStep]): Job step description. [optional]  # noqa: E501
            tres (Dbv0037JobTres): [optional]  # noqa: E501
            user (str): Job user. [optional]  # noqa: E501
            wckey (Dbv0036JobWckey): [optional]  # noqa: E501
            working_directory (str): Directory where job was initially started. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Dbv0037Job - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account (str): Account charged by job. [optional]  # noqa: E501
            comment (Dbv0036JobComment): [optional]  # noqa: E501
            allocation_nodes (str): Nodes allocated to job. [optional]  # noqa: E501
            array (Dbv0036JobArray): [optional]  # noqa: E501
            time (Dbv0036JobTime): [optional]  # noqa: E501
            association (Dbv0037AssociationShortInfo): [optional]  # noqa: E501
            cluster (str): Assigned cluster. [optional]  # noqa: E501
            constraints (str): Constraints on job. [optional]  # noqa: E501
            derived_exit_code (Dbv0037JobExitCode): [optional]  # noqa: E501
            exit_code (Dbv0037JobExitCode): [optional]  # noqa: E501
            flags ([str]): List of properties of job. [optional]  # noqa: E501
            group (str): User's group to run job. [optional]  # noqa: E501
            het (Dbv0036JobHet): [optional]  # noqa: E501
            job_id (int): Job id. [optional]  # noqa: E501
            name (str): Assigned job name. [optional]  # noqa: E501
            mcs (Dbv0036JobMcs): [optional]  # noqa: E501
            nodes (str): List of nodes allocated for job. [optional]  # noqa: E501
            partition (str): Assigned job's partition. [optional]  # noqa: E501
            priority (int): Priority. [optional]  # noqa: E501
            qos (str): Assigned qos name. [optional]  # noqa: E501
            required (Dbv0036JobRequired): [optional]  # noqa: E501
            kill_request_user (str): User who requested job killed. [optional]  # noqa: E501
            reservation (Dbv0036JobReservation): [optional]  # noqa: E501
            state (Dbv0037JobState): [optional]  # noqa: E501
            steps ([Dbv0037JobStep]): Job step description. [optional]  # noqa: E501
            tres (Dbv0037JobTres): [optional]  # noqa: E501
            user (str): Job user. [optional]  # noqa: E501
            wckey (Dbv0036JobWckey): [optional]  # noqa: E501
            working_directory (str): Directory where job was initially started. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
