"""
    Slurm Rest API

    API to access and control Slurm.  # noqa: E501

    The version of the OpenAPI document: 0.0.37
    Contact: sales@schedmd.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from slurm_rest.api_client import ApiClient, Endpoint as _Endpoint
from slurm_rest.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from slurm_rest.model.dbv0036_account_info import Dbv0036AccountInfo
from slurm_rest.model.dbv0036_account_response import Dbv0036AccountResponse
from slurm_rest.model.dbv0036_associations_info import Dbv0036AssociationsInfo
from slurm_rest.model.dbv0036_cluster_info import Dbv0036ClusterInfo
from slurm_rest.model.dbv0036_config_info import Dbv0036ConfigInfo
from slurm_rest.model.dbv0036_config_response import Dbv0036ConfigResponse
from slurm_rest.model.dbv0036_diag import Dbv0036Diag
from slurm_rest.model.dbv0036_job_info import Dbv0036JobInfo
from slurm_rest.model.dbv0036_qos_info import Dbv0036QosInfo
from slurm_rest.model.dbv0036_response_account_delete import Dbv0036ResponseAccountDelete
from slurm_rest.model.dbv0036_response_association_delete import Dbv0036ResponseAssociationDelete
from slurm_rest.model.dbv0036_response_cluster_add import Dbv0036ResponseClusterAdd
from slurm_rest.model.dbv0036_response_cluster_delete import Dbv0036ResponseClusterDelete
from slurm_rest.model.dbv0036_response_qos_delete import Dbv0036ResponseQosDelete
from slurm_rest.model.dbv0036_response_tres import Dbv0036ResponseTres
from slurm_rest.model.dbv0036_response_user_delete import Dbv0036ResponseUserDelete
from slurm_rest.model.dbv0036_response_user_update import Dbv0036ResponseUserUpdate
from slurm_rest.model.dbv0036_response_wckey_add import Dbv0036ResponseWckeyAdd
from slurm_rest.model.dbv0036_response_wckey_delete import Dbv0036ResponseWckeyDelete
from slurm_rest.model.dbv0036_tres_info import Dbv0036TresInfo
from slurm_rest.model.dbv0036_user_info import Dbv0036UserInfo
from slurm_rest.model.dbv0036_wckey_info import Dbv0036WckeyInfo
from slurm_rest.model.dbv0037_account_info import Dbv0037AccountInfo
from slurm_rest.model.dbv0037_account_response import Dbv0037AccountResponse
from slurm_rest.model.dbv0037_associations_info import Dbv0037AssociationsInfo
from slurm_rest.model.dbv0037_cluster_info import Dbv0037ClusterInfo
from slurm_rest.model.dbv0037_config_info import Dbv0037ConfigInfo
from slurm_rest.model.dbv0037_config_response import Dbv0037ConfigResponse
from slurm_rest.model.dbv0037_diag import Dbv0037Diag
from slurm_rest.model.dbv0037_job_info import Dbv0037JobInfo
from slurm_rest.model.dbv0037_qos_info import Dbv0037QosInfo
from slurm_rest.model.dbv0037_response_account_delete import Dbv0037ResponseAccountDelete
from slurm_rest.model.dbv0037_response_association_delete import Dbv0037ResponseAssociationDelete
from slurm_rest.model.dbv0037_response_cluster_add import Dbv0037ResponseClusterAdd
from slurm_rest.model.dbv0037_response_cluster_delete import Dbv0037ResponseClusterDelete
from slurm_rest.model.dbv0037_response_qos_delete import Dbv0037ResponseQosDelete
from slurm_rest.model.dbv0037_response_tres import Dbv0037ResponseTres
from slurm_rest.model.dbv0037_response_user_delete import Dbv0037ResponseUserDelete
from slurm_rest.model.dbv0037_response_user_update import Dbv0037ResponseUserUpdate
from slurm_rest.model.dbv0037_response_wckey_add import Dbv0037ResponseWckeyAdd
from slurm_rest.model.dbv0037_response_wckey_delete import Dbv0037ResponseWckeyDelete
from slurm_rest.model.dbv0037_tres_info import Dbv0037TresInfo
from slurm_rest.model.dbv0037_user_info import Dbv0037UserInfo
from slurm_rest.model.dbv0037_wckey_info import Dbv0037WckeyInfo
from slurm_rest.model.v0036_diag import V0036Diag
from slurm_rest.model.v0036_job_properties import V0036JobProperties
from slurm_rest.model.v0036_job_submission import V0036JobSubmission
from slurm_rest.model.v0036_job_submission_response import V0036JobSubmissionResponse
from slurm_rest.model.v0036_jobs_response import V0036JobsResponse
from slurm_rest.model.v0036_nodes_response import V0036NodesResponse
from slurm_rest.model.v0036_partitions_response import V0036PartitionsResponse
from slurm_rest.model.v0036_pings import V0036Pings
from slurm_rest.model.v0036_signal import V0036Signal
from slurm_rest.model.v0037_diag import V0037Diag
from slurm_rest.model.v0037_job_properties import V0037JobProperties
from slurm_rest.model.v0037_job_submission import V0037JobSubmission
from slurm_rest.model.v0037_job_submission_response import V0037JobSubmissionResponse
from slurm_rest.model.v0037_jobs_response import V0037JobsResponse
from slurm_rest.model.v0037_nodes_response import V0037NodesResponse
from slurm_rest.model.v0037_partitions_response import V0037PartitionsResponse
from slurm_rest.model.v0037_pings import V0037Pings
from slurm_rest.model.v0037_reservations_response import V0037ReservationsResponse
from slurm_rest.model.v0037_signal import V0037Signal


class SlurmApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.slurmctld_cancel_job_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/job/{job_id}',
                'operation_id': 'slurmctld_cancel_job',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'signal',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                    'signal':
                        (V0037Signal,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                    'signal': 'signal',
                },
                'location_map': {
                    'job_id': 'path',
                    'signal': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_cancel_job_0_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/job/{job_id}',
                'operation_id': 'slurmctld_cancel_job_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'signal',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                    'signal':
                        (V0036Signal,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                    'signal': 'signal',
                },
                'location_map': {
                    'job_id': 'path',
                    'signal': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_diag_endpoint = _Endpoint(
            settings={
                'response_type': (V0037Diag,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/diag',
                'operation_id': 'slurmctld_diag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_diag_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036Diag,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/diag',
                'operation_id': 'slurmctld_diag_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_job_endpoint = _Endpoint(
            settings={
                'response_type': (V0037JobsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/job/{job_id}',
                'operation_id': 'slurmctld_get_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_job_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036JobsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/job/{job_id}',
                'operation_id': 'slurmctld_get_job_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_jobs_endpoint = _Endpoint(
            settings={
                'response_type': (V0037JobsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/jobs',
                'operation_id': 'slurmctld_get_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'update_time': 'update_time',
                },
                'location_map': {
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_jobs_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036JobsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/jobs',
                'operation_id': 'slurmctld_get_jobs_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_node_endpoint = _Endpoint(
            settings={
                'response_type': (V0037NodesResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/node/{node_name}',
                'operation_id': 'slurmctld_get_node',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                ],
                'required': [
                    'node_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                },
                'attribute_map': {
                    'node_name': 'node_name',
                },
                'location_map': {
                    'node_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_node_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036NodesResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/node/{node_name}',
                'operation_id': 'slurmctld_get_node_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                ],
                'required': [
                    'node_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                },
                'attribute_map': {
                    'node_name': 'node_name',
                },
                'location_map': {
                    'node_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_nodes_endpoint = _Endpoint(
            settings={
                'response_type': (V0037NodesResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/nodes',
                'operation_id': 'slurmctld_get_nodes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'update_time': 'update_time',
                },
                'location_map': {
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_nodes_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036NodesResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/nodes',
                'operation_id': 'slurmctld_get_nodes_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_partition_endpoint = _Endpoint(
            settings={
                'response_type': (V0037PartitionsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/partition/{partition_name}',
                'operation_id': 'slurmctld_get_partition',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'partition_name',
                    'update_time',
                ],
                'required': [
                    'partition_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'partition_name':
                        (str,),
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'partition_name': 'partition_name',
                    'update_time': 'update_time',
                },
                'location_map': {
                    'partition_name': 'path',
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_partition_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036PartitionsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/partition/{partition_name}',
                'operation_id': 'slurmctld_get_partition_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'partition_name',
                ],
                'required': [
                    'partition_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'partition_name':
                        (str,),
                },
                'attribute_map': {
                    'partition_name': 'partition_name',
                },
                'location_map': {
                    'partition_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_partitions_endpoint = _Endpoint(
            settings={
                'response_type': (V0037PartitionsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/partitions',
                'operation_id': 'slurmctld_get_partitions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'update_time': 'update_time',
                },
                'location_map': {
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_partitions_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036PartitionsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/partitions',
                'operation_id': 'slurmctld_get_partitions_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_reservation_endpoint = _Endpoint(
            settings={
                'response_type': (V0037ReservationsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/reservation/{reservation_name}',
                'operation_id': 'slurmctld_get_reservation',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'reservation_name',
                    'update_time',
                ],
                'required': [
                    'reservation_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reservation_name':
                        (str,),
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'reservation_name': 'reservation_name',
                    'update_time': 'update_time',
                },
                'location_map': {
                    'reservation_name': 'path',
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_get_reservations_endpoint = _Endpoint(
            settings={
                'response_type': (V0037ReservationsResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/reservations',
                'operation_id': 'slurmctld_get_reservations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'update_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'update_time':
                        (int,),
                },
                'attribute_map': {
                    'update_time': 'update_time',
                },
                'location_map': {
                    'update_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_ping_endpoint = _Endpoint(
            settings={
                'response_type': (V0037Pings,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/ping',
                'operation_id': 'slurmctld_ping',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_ping_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036Pings,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/ping',
                'operation_id': 'slurmctld_ping_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmctld_submit_job_endpoint = _Endpoint(
            settings={
                'response_type': (V0037JobSubmissionResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/job/submit',
                'operation_id': 'slurmctld_submit_job',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v0037_job_submission',
                ],
                'required': [
                    'v0037_job_submission',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v0037_job_submission':
                        (V0037JobSubmission,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v0037_job_submission': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [
                    'application/json',
                    'application/x-yaml'
                ]
            },
            api_client=api_client
        )
        self.slurmctld_submit_job_0_endpoint = _Endpoint(
            settings={
                'response_type': (V0036JobSubmissionResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/job/submit',
                'operation_id': 'slurmctld_submit_job_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v0036_job_submission',
                ],
                'required': [
                    'v0036_job_submission',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v0036_job_submission':
                        (V0036JobSubmission,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v0036_job_submission': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [
                    'application/json',
                    'application/x-yaml'
                ]
            },
            api_client=api_client
        )
        self.slurmctld_update_job_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.37/job/{job_id}',
                'operation_id': 'slurmctld_update_job',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'v0037_job_properties',
                ],
                'required': [
                    'job_id',
                    'v0037_job_properties',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                    'v0037_job_properties':
                        (V0037JobProperties,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                    'v0037_job_properties': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-yaml'
                ]
            },
            api_client=api_client
        )
        self.slurmctld_update_job_0_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurm/v0.0.36/job/{job_id}',
                'operation_id': 'slurmctld_update_job_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'v0036_job_properties',
                ],
                'required': [
                    'job_id',
                    'v0036_job_properties',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                    'v0036_job_properties':
                        (V0036JobProperties,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                    'v0036_job_properties': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-yaml'
                ]
            },
            api_client=api_client
        )
        self.slurmdbd_add_clusters_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseClusterAdd,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/clusters',
                'operation_id': 'slurmdbd_add_clusters',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_add_clusters_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseClusterAdd,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/clusters',
                'operation_id': 'slurmdbd_add_clusters_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_add_wckeys_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseWckeyAdd,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/wckeys',
                'operation_id': 'slurmdbd_add_wckeys',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_add_wckeys_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseWckeyAdd,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/wckeys',
                'operation_id': 'slurmdbd_add_wckeys_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_account_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseAccountDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/account/{account_name}',
                'operation_id': 'slurmdbd_delete_account',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_name',
                ],
                'required': [
                    'account_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_name':
                        (str,),
                },
                'attribute_map': {
                    'account_name': 'account_name',
                },
                'location_map': {
                    'account_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_account_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseAccountDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/account/{account_name}',
                'operation_id': 'slurmdbd_delete_account_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_name',
                ],
                'required': [
                    'account_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_name':
                        (str,),
                },
                'attribute_map': {
                    'account_name': 'account_name',
                },
                'location_map': {
                    'account_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_association_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseAssociationDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/association',
                'operation_id': 'slurmdbd_delete_association',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account',
                    'user',
                    'cluster',
                    'partition',
                ],
                'required': [
                    'account',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account':
                        (str,),
                    'user':
                        (str,),
                    'cluster':
                        (str,),
                    'partition':
                        (str,),
                },
                'attribute_map': {
                    'account': 'account',
                    'user': 'user',
                    'cluster': 'cluster',
                    'partition': 'partition',
                },
                'location_map': {
                    'account': 'query',
                    'user': 'query',
                    'cluster': 'query',
                    'partition': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_association_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseAssociationDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/association',
                'operation_id': 'slurmdbd_delete_association_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account',
                    'user',
                    'cluster',
                    'partition',
                ],
                'required': [
                    'account',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account':
                        (str,),
                    'user':
                        (str,),
                    'cluster':
                        (str,),
                    'partition':
                        (str,),
                },
                'attribute_map': {
                    'account': 'account',
                    'user': 'user',
                    'cluster': 'cluster',
                    'partition': 'partition',
                },
                'location_map': {
                    'account': 'query',
                    'user': 'query',
                    'cluster': 'query',
                    'partition': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_cluster_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseClusterDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/cluster/{cluster_name}',
                'operation_id': 'slurmdbd_delete_cluster',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster_name',
                ],
                'required': [
                    'cluster_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster_name':
                        (str,),
                },
                'attribute_map': {
                    'cluster_name': 'cluster_name',
                },
                'location_map': {
                    'cluster_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_cluster_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseClusterDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/cluster/{cluster_name}',
                'operation_id': 'slurmdbd_delete_cluster_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster_name',
                ],
                'required': [
                    'cluster_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster_name':
                        (str,),
                },
                'attribute_map': {
                    'cluster_name': 'cluster_name',
                },
                'location_map': {
                    'cluster_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_qos_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseQosDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/qos/{qos_name}',
                'operation_id': 'slurmdbd_delete_qos',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'qos_name',
                ],
                'required': [
                    'qos_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'qos_name':
                        (str,),
                },
                'attribute_map': {
                    'qos_name': 'qos_name',
                },
                'location_map': {
                    'qos_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_qos_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseQosDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/qos/{qos_name}',
                'operation_id': 'slurmdbd_delete_qos_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'qos_name',
                ],
                'required': [
                    'qos_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'qos_name':
                        (str,),
                },
                'attribute_map': {
                    'qos_name': 'qos_name',
                },
                'location_map': {
                    'qos_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_user_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseUserDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/user/{user_name}',
                'operation_id': 'slurmdbd_delete_user',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_name',
                ],
                'required': [
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'user_name': 'user_name',
                },
                'location_map': {
                    'user_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_user_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseUserDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/user/{user_name}',
                'operation_id': 'slurmdbd_delete_user_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_name',
                ],
                'required': [
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'user_name': 'user_name',
                },
                'location_map': {
                    'user_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_wckey_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseWckeyDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/wckey/{wckey}',
                'operation_id': 'slurmdbd_delete_wckey',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'wckey',
                ],
                'required': [
                    'wckey',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'wckey': 'wckey',
                },
                'location_map': {
                    'wckey': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_delete_wckey_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseWckeyDelete,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/wckey/{wckey}',
                'operation_id': 'slurmdbd_delete_wckey_0',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'wckey',
                ],
                'required': [
                    'wckey',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'wckey': 'wckey',
                },
                'location_map': {
                    'wckey': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_diag_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036Diag,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/diag',
                'operation_id': 'slurmdbd_diag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_diag_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037Diag,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/diag',
                'operation_id': 'slurmdbd_diag_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_account_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036AccountInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/account/{account_name}',
                'operation_id': 'slurmdbd_get_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_name',
                ],
                'required': [
                    'account_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_name':
                        (str,),
                },
                'attribute_map': {
                    'account_name': 'account_name',
                },
                'location_map': {
                    'account_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_account_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037AccountInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/account/{account_name}',
                'operation_id': 'slurmdbd_get_account_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_name',
                ],
                'required': [
                    'account_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_name':
                        (str,),
                },
                'attribute_map': {
                    'account_name': 'account_name',
                },
                'location_map': {
                    'account_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036AccountInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/accounts',
                'operation_id': 'slurmdbd_get_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_accounts_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037AccountInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/accounts',
                'operation_id': 'slurmdbd_get_accounts_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_association_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036AssociationsInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/association',
                'operation_id': 'slurmdbd_get_association',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster',
                    'account',
                    'user',
                    'partition',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster':
                        (str,),
                    'account':
                        (str,),
                    'user':
                        (str,),
                    'partition':
                        (str,),
                },
                'attribute_map': {
                    'cluster': 'cluster',
                    'account': 'account',
                    'user': 'user',
                    'partition': 'partition',
                },
                'location_map': {
                    'cluster': 'query',
                    'account': 'query',
                    'user': 'query',
                    'partition': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_association_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037AssociationsInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/association',
                'operation_id': 'slurmdbd_get_association_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster',
                    'account',
                    'user',
                    'partition',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster':
                        (str,),
                    'account':
                        (str,),
                    'user':
                        (str,),
                    'partition':
                        (str,),
                },
                'attribute_map': {
                    'cluster': 'cluster',
                    'account': 'account',
                    'user': 'user',
                    'partition': 'partition',
                },
                'location_map': {
                    'cluster': 'query',
                    'account': 'query',
                    'user': 'query',
                    'partition': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_associations_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036AssociationsInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/associations',
                'operation_id': 'slurmdbd_get_associations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_associations_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037AssociationsInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/associations',
                'operation_id': 'slurmdbd_get_associations_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_cluster_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ClusterInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/cluster/{cluster_name}',
                'operation_id': 'slurmdbd_get_cluster',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster_name',
                ],
                'required': [
                    'cluster_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster_name':
                        (str,),
                },
                'attribute_map': {
                    'cluster_name': 'cluster_name',
                },
                'location_map': {
                    'cluster_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_cluster_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ClusterInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/cluster/{cluster_name}',
                'operation_id': 'slurmdbd_get_cluster_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cluster_name',
                ],
                'required': [
                    'cluster_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cluster_name':
                        (str,),
                },
                'attribute_map': {
                    'cluster_name': 'cluster_name',
                },
                'location_map': {
                    'cluster_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_clusters_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ClusterInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/clusters',
                'operation_id': 'slurmdbd_get_clusters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_clusters_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ClusterInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/clusters',
                'operation_id': 'slurmdbd_get_clusters_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_db_config_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ConfigInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/config',
                'operation_id': 'slurmdbd_get_db_config',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_db_config_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ConfigInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/config',
                'operation_id': 'slurmdbd_get_db_config_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_job_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036JobInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/job/{job_id}',
                'operation_id': 'slurmdbd_get_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_job_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037JobInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/job/{job_id}',
                'operation_id': 'slurmdbd_get_job_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'job_id',
                },
                'location_map': {
                    'job_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_jobs_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036JobInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/jobs',
                'operation_id': 'slurmdbd_get_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'submit_time',
                    'start_time',
                    'end_time',
                    'account',
                    'association',
                    'cluster',
                    'constraints',
                    'cpus_max',
                    'cpus_min',
                    'skip_steps',
                    'disable_wait_for_result',
                    'exit_code',
                    'format',
                    'group',
                    'job_name',
                    'nodes_max',
                    'nodes_min',
                    'partition',
                    'qos',
                    'reason',
                    'reservation',
                    'state',
                    'step',
                    'node',
                    'wckey',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'submit_time':
                        (str,),
                    'start_time':
                        (str,),
                    'end_time':
                        (str,),
                    'account':
                        (str,),
                    'association':
                        (str,),
                    'cluster':
                        (str,),
                    'constraints':
                        (str,),
                    'cpus_max':
                        (str,),
                    'cpus_min':
                        (str,),
                    'skip_steps':
                        (bool,),
                    'disable_wait_for_result':
                        (bool,),
                    'exit_code':
                        (str,),
                    'format':
                        (str,),
                    'group':
                        (str,),
                    'job_name':
                        (str,),
                    'nodes_max':
                        (str,),
                    'nodes_min':
                        (str,),
                    'partition':
                        (str,),
                    'qos':
                        (str,),
                    'reason':
                        (str,),
                    'reservation':
                        (str,),
                    'state':
                        (str,),
                    'step':
                        (str,),
                    'node':
                        (str,),
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'submit_time': 'submit_time',
                    'start_time': 'start_time',
                    'end_time': 'end_time',
                    'account': 'account',
                    'association': 'association',
                    'cluster': 'cluster',
                    'constraints': 'constraints',
                    'cpus_max': 'cpus_max',
                    'cpus_min': 'cpus_min',
                    'skip_steps': 'skip_steps',
                    'disable_wait_for_result': 'disable_wait_for_result',
                    'exit_code': 'exit_code',
                    'format': 'format',
                    'group': 'group',
                    'job_name': 'job_name',
                    'nodes_max': 'nodes_max',
                    'nodes_min': 'nodes_min',
                    'partition': 'partition',
                    'qos': 'qos',
                    'reason': 'reason',
                    'reservation': 'reservation',
                    'state': 'state',
                    'step': 'step',
                    'node': 'node',
                    'wckey': 'wckey',
                },
                'location_map': {
                    'submit_time': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                    'account': 'query',
                    'association': 'query',
                    'cluster': 'query',
                    'constraints': 'query',
                    'cpus_max': 'query',
                    'cpus_min': 'query',
                    'skip_steps': 'query',
                    'disable_wait_for_result': 'query',
                    'exit_code': 'query',
                    'format': 'query',
                    'group': 'query',
                    'job_name': 'query',
                    'nodes_max': 'query',
                    'nodes_min': 'query',
                    'partition': 'query',
                    'qos': 'query',
                    'reason': 'query',
                    'reservation': 'query',
                    'state': 'query',
                    'step': 'query',
                    'node': 'query',
                    'wckey': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_jobs_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037JobInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/jobs',
                'operation_id': 'slurmdbd_get_jobs_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'submit_time',
                    'start_time',
                    'end_time',
                    'account',
                    'association',
                    'cluster',
                    'constraints',
                    'cpus_max',
                    'cpus_min',
                    'skip_steps',
                    'disable_wait_for_result',
                    'exit_code',
                    'format',
                    'group',
                    'job_name',
                    'nodes_max',
                    'nodes_min',
                    'partition',
                    'qos',
                    'reason',
                    'reservation',
                    'state',
                    'step',
                    'node',
                    'wckey',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'submit_time':
                        (str,),
                    'start_time':
                        (str,),
                    'end_time':
                        (str,),
                    'account':
                        (str,),
                    'association':
                        (str,),
                    'cluster':
                        (str,),
                    'constraints':
                        (str,),
                    'cpus_max':
                        (str,),
                    'cpus_min':
                        (str,),
                    'skip_steps':
                        (bool,),
                    'disable_wait_for_result':
                        (bool,),
                    'exit_code':
                        (str,),
                    'format':
                        (str,),
                    'group':
                        (str,),
                    'job_name':
                        (str,),
                    'nodes_max':
                        (str,),
                    'nodes_min':
                        (str,),
                    'partition':
                        (str,),
                    'qos':
                        (str,),
                    'reason':
                        (str,),
                    'reservation':
                        (str,),
                    'state':
                        (str,),
                    'step':
                        (str,),
                    'node':
                        (str,),
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'submit_time': 'submit_time',
                    'start_time': 'start_time',
                    'end_time': 'end_time',
                    'account': 'account',
                    'association': 'association',
                    'cluster': 'cluster',
                    'constraints': 'constraints',
                    'cpus_max': 'cpus_max',
                    'cpus_min': 'cpus_min',
                    'skip_steps': 'skip_steps',
                    'disable_wait_for_result': 'disable_wait_for_result',
                    'exit_code': 'exit_code',
                    'format': 'format',
                    'group': 'group',
                    'job_name': 'job_name',
                    'nodes_max': 'nodes_max',
                    'nodes_min': 'nodes_min',
                    'partition': 'partition',
                    'qos': 'qos',
                    'reason': 'reason',
                    'reservation': 'reservation',
                    'state': 'state',
                    'step': 'step',
                    'node': 'node',
                    'wckey': 'wckey',
                },
                'location_map': {
                    'submit_time': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                    'account': 'query',
                    'association': 'query',
                    'cluster': 'query',
                    'constraints': 'query',
                    'cpus_max': 'query',
                    'cpus_min': 'query',
                    'skip_steps': 'query',
                    'disable_wait_for_result': 'query',
                    'exit_code': 'query',
                    'format': 'query',
                    'group': 'query',
                    'job_name': 'query',
                    'nodes_max': 'query',
                    'nodes_min': 'query',
                    'partition': 'query',
                    'qos': 'query',
                    'reason': 'query',
                    'reservation': 'query',
                    'state': 'query',
                    'step': 'query',
                    'node': 'query',
                    'wckey': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_qos_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036QosInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/qos',
                'operation_id': 'slurmdbd_get_qos',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_qos_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037QosInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/qos',
                'operation_id': 'slurmdbd_get_qos_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_single_qos_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036QosInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/qos/{qos_name}',
                'operation_id': 'slurmdbd_get_single_qos',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'qos_name',
                ],
                'required': [
                    'qos_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'qos_name':
                        (str,),
                },
                'attribute_map': {
                    'qos_name': 'qos_name',
                },
                'location_map': {
                    'qos_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_single_qos_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037QosInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/qos/{qos_name}',
                'operation_id': 'slurmdbd_get_single_qos_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'qos_name',
                ],
                'required': [
                    'qos_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'qos_name':
                        (str,),
                },
                'attribute_map': {
                    'qos_name': 'qos_name',
                },
                'location_map': {
                    'qos_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_tres_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036TresInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/tres',
                'operation_id': 'slurmdbd_get_tres',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_tres_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037TresInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/tres',
                'operation_id': 'slurmdbd_get_tres_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_user_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036UserInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/user/{user_name}',
                'operation_id': 'slurmdbd_get_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_name',
                ],
                'required': [
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'user_name': 'user_name',
                },
                'location_map': {
                    'user_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_user_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037UserInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/user/{user_name}',
                'operation_id': 'slurmdbd_get_user_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_name',
                ],
                'required': [
                    'user_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_name':
                        (str,),
                },
                'attribute_map': {
                    'user_name': 'user_name',
                },
                'location_map': {
                    'user_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_users_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036UserInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/users',
                'operation_id': 'slurmdbd_get_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_users_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037UserInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/users',
                'operation_id': 'slurmdbd_get_users_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_wckey_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036WckeyInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/wckey/{wckey}',
                'operation_id': 'slurmdbd_get_wckey',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'wckey',
                ],
                'required': [
                    'wckey',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'wckey': 'wckey',
                },
                'location_map': {
                    'wckey': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_wckey_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037WckeyInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/wckey/{wckey}',
                'operation_id': 'slurmdbd_get_wckey_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'wckey',
                ],
                'required': [
                    'wckey',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wckey':
                        (str,),
                },
                'attribute_map': {
                    'wckey': 'wckey',
                },
                'location_map': {
                    'wckey': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_wckeys_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036WckeyInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/wckeys',
                'operation_id': 'slurmdbd_get_wckeys',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_get_wckeys_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037WckeyInfo,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/wckeys',
                'operation_id': 'slurmdbd_get_wckeys_0',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_set_db_config_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ConfigResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/config',
                'operation_id': 'slurmdbd_set_db_config',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_set_db_config_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ConfigResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/config',
                'operation_id': 'slurmdbd_set_db_config_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_account_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036AccountResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/accounts',
                'operation_id': 'slurmdbd_update_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_account_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037AccountResponse,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/accounts',
                'operation_id': 'slurmdbd_update_account_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_tres_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseTres,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/tres',
                'operation_id': 'slurmdbd_update_tres',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_tres_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseTres,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/tres',
                'operation_id': 'slurmdbd_update_tres_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_users_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0036ResponseUserUpdate,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.36/users',
                'operation_id': 'slurmdbd_update_users',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.slurmdbd_update_users_0_endpoint = _Endpoint(
            settings={
                'response_type': (Dbv0037ResponseUserUpdate,),
                'auth': [
                    'token',
                    'user'
                ],
                'endpoint_path': '/slurmdb/v0.0.37/users',
                'operation_id': 'slurmdbd_update_users_0',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/x-yaml'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def slurmctld_cancel_job(
        self,
        job_id,
        **kwargs
    ):
        """cancel or signal job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_cancel_job(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            signal (V0037Signal): signal to send to job. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmctld_cancel_job_endpoint.call_with_http_info(**kwargs)

    def slurmctld_cancel_job_0(
        self,
        job_id,
        **kwargs
    ):
        """cancel or signal job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_cancel_job_0(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            signal (V0036Signal): signal to send to job. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmctld_cancel_job_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_diag(
        self,
        **kwargs
    ):
        """get diagnostics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_diag(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037Diag
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_diag_endpoint.call_with_http_info(**kwargs)

    def slurmctld_diag_0(
        self,
        **kwargs
    ):
        """get diagnostics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_diag_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036Diag
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_diag_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_job(
        self,
        job_id,
        **kwargs
    ):
        """get job info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_job(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037JobsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmctld_get_job_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_job_0(
        self,
        job_id,
        **kwargs
    ):
        """get job info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_job_0(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036JobsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmctld_get_job_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_jobs(
        self,
        **kwargs
    ):
        """get list of jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_jobs(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            update_time (int): Filter if changed since update_time. Use of this parameter can result in faster replies.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037JobsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_jobs_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_jobs_0(
        self,
        **kwargs
    ):
        """get list of jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_jobs_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036JobsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_jobs_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_node(
        self,
        node_name,
        **kwargs
    ):
        """get node info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_node(node_name, async_req=True)
        >>> result = thread.get()

        Args:
            node_name (str): Slurm Node Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037NodesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['node_name'] = \
            node_name
        return self.slurmctld_get_node_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_node_0(
        self,
        node_name,
        **kwargs
    ):
        """get node info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_node_0(node_name, async_req=True)
        >>> result = thread.get()

        Args:
            node_name (str): Slurm Node Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036NodesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['node_name'] = \
            node_name
        return self.slurmctld_get_node_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_nodes(
        self,
        **kwargs
    ):
        """get all node info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_nodes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            update_time (int): Filter if changed since update_time. Use of this parameter can result in faster replies.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037NodesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_nodes_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_nodes_0(
        self,
        **kwargs
    ):
        """get all node info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_nodes_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036NodesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_nodes_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_partition(
        self,
        partition_name,
        **kwargs
    ):
        """get partition info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_partition(partition_name, async_req=True)
        >>> result = thread.get()

        Args:
            partition_name (str): Slurm Partition Name

        Keyword Args:
            update_time (int): Filter if there were no partition changes (not limited to partition in URL endpoint) since update_time.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037PartitionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['partition_name'] = \
            partition_name
        return self.slurmctld_get_partition_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_partition_0(
        self,
        partition_name,
        **kwargs
    ):
        """get partition info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_partition_0(partition_name, async_req=True)
        >>> result = thread.get()

        Args:
            partition_name (str): Slurm Partition Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036PartitionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['partition_name'] = \
            partition_name
        return self.slurmctld_get_partition_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_partitions(
        self,
        **kwargs
    ):
        """get all partition info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_partitions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            update_time (int): Filter if changed since update_time. Use of this parameter can result in faster replies.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037PartitionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_partitions_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_partitions_0(
        self,
        **kwargs
    ):
        """get all partition info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_partitions_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036PartitionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_partitions_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_reservation(
        self,
        reservation_name,
        **kwargs
    ):
        """get reservation info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_reservation(reservation_name, async_req=True)
        >>> result = thread.get()

        Args:
            reservation_name (str): Slurm Reservation Name

        Keyword Args:
            update_time (int): Filter if no reservation (not limited to reservation in URL) changed since update_time.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037ReservationsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['reservation_name'] = \
            reservation_name
        return self.slurmctld_get_reservation_endpoint.call_with_http_info(**kwargs)

    def slurmctld_get_reservations(
        self,
        **kwargs
    ):
        """get all reservation info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_get_reservations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            update_time (int): Filter if changed since update_time. Use of this parameter can result in faster replies.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037ReservationsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_get_reservations_endpoint.call_with_http_info(**kwargs)

    def slurmctld_ping(
        self,
        **kwargs
    ):
        """ping test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_ping(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037Pings
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_ping_endpoint.call_with_http_info(**kwargs)

    def slurmctld_ping_0(
        self,
        **kwargs
    ):
        """ping test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_ping_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036Pings
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmctld_ping_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_submit_job(
        self,
        v0037_job_submission,
        **kwargs
    ):
        """submit new job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_submit_job(v0037_job_submission, async_req=True)
        >>> result = thread.get()

        Args:
            v0037_job_submission (V0037JobSubmission): submit new job

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0037JobSubmissionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v0037_job_submission'] = \
            v0037_job_submission
        return self.slurmctld_submit_job_endpoint.call_with_http_info(**kwargs)

    def slurmctld_submit_job_0(
        self,
        v0036_job_submission,
        **kwargs
    ):
        """submit new job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_submit_job_0(v0036_job_submission, async_req=True)
        >>> result = thread.get()

        Args:
            v0036_job_submission (V0036JobSubmission): submit new job

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V0036JobSubmissionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v0036_job_submission'] = \
            v0036_job_submission
        return self.slurmctld_submit_job_0_endpoint.call_with_http_info(**kwargs)

    def slurmctld_update_job(
        self,
        job_id,
        v0037_job_properties,
        **kwargs
    ):
        """update job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_update_job(job_id, v0037_job_properties, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID
            v0037_job_properties (V0037JobProperties): update job

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        kwargs['v0037_job_properties'] = \
            v0037_job_properties
        return self.slurmctld_update_job_endpoint.call_with_http_info(**kwargs)

    def slurmctld_update_job_0(
        self,
        job_id,
        v0036_job_properties,
        **kwargs
    ):
        """update job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmctld_update_job_0(job_id, v0036_job_properties, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID
            v0036_job_properties (V0036JobProperties): update job

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        kwargs['v0036_job_properties'] = \
            v0036_job_properties
        return self.slurmctld_update_job_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_add_clusters(
        self,
        **kwargs
    ):
        """Add clusters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_add_clusters(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseClusterAdd
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_add_clusters_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_add_clusters_0(
        self,
        **kwargs
    ):
        """Add clusters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_add_clusters_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseClusterAdd
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_add_clusters_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_add_wckeys(
        self,
        **kwargs
    ):
        """Add wckeys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_add_wckeys(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseWckeyAdd
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_add_wckeys_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_add_wckeys_0(
        self,
        **kwargs
    ):
        """Add wckeys  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_add_wckeys_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseWckeyAdd
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_add_wckeys_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_account(
        self,
        account_name,
        **kwargs
    ):
        """Delete account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_account(account_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Slurm Account Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseAccountDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_name'] = \
            account_name
        return self.slurmdbd_delete_account_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_account_0(
        self,
        account_name,
        **kwargs
    ):
        """Delete account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_account_0(account_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Slurm Account Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseAccountDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_name'] = \
            account_name
        return self.slurmdbd_delete_account_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_association(
        self,
        account,
        user,
        **kwargs
    ):
        """Delete association  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_association(account, user, async_req=True)
        >>> result = thread.get()

        Args:
            account (str): Account name
            user (str): User name

        Keyword Args:
            cluster (str): Cluster name. [optional]
            partition (str): Partition Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseAssociationDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account'] = \
            account
        kwargs['user'] = \
            user
        return self.slurmdbd_delete_association_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_association_0(
        self,
        account,
        user,
        **kwargs
    ):
        """Delete association  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_association_0(account, user, async_req=True)
        >>> result = thread.get()

        Args:
            account (str): Account name
            user (str): User name

        Keyword Args:
            cluster (str): Cluster name. [optional]
            partition (str): Partition Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseAssociationDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account'] = \
            account
        kwargs['user'] = \
            user
        return self.slurmdbd_delete_association_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_cluster(
        self,
        cluster_name,
        **kwargs
    ):
        """Delete cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_cluster(cluster_name, async_req=True)
        >>> result = thread.get()

        Args:
            cluster_name (str): Slurm cluster name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseClusterDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['cluster_name'] = \
            cluster_name
        return self.slurmdbd_delete_cluster_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_cluster_0(
        self,
        cluster_name,
        **kwargs
    ):
        """Delete cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_cluster_0(cluster_name, async_req=True)
        >>> result = thread.get()

        Args:
            cluster_name (str): Slurm cluster name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseClusterDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['cluster_name'] = \
            cluster_name
        return self.slurmdbd_delete_cluster_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_qos(
        self,
        qos_name,
        **kwargs
    ):
        """Delete QOS  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_qos(qos_name, async_req=True)
        >>> result = thread.get()

        Args:
            qos_name (str): Slurm QOS Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseQosDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['qos_name'] = \
            qos_name
        return self.slurmdbd_delete_qos_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_qos_0(
        self,
        qos_name,
        **kwargs
    ):
        """Delete QOS  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_qos_0(qos_name, async_req=True)
        >>> result = thread.get()

        Args:
            qos_name (str): Slurm QOS Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseQosDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['qos_name'] = \
            qos_name
        return self.slurmdbd_delete_qos_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_user(
        self,
        user_name,
        **kwargs
    ):
        """Delete user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_user(user_name, async_req=True)
        >>> result = thread.get()

        Args:
            user_name (str): Slurm User Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseUserDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_name'] = \
            user_name
        return self.slurmdbd_delete_user_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_user_0(
        self,
        user_name,
        **kwargs
    ):
        """Delete user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_user_0(user_name, async_req=True)
        >>> result = thread.get()

        Args:
            user_name (str): Slurm User Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseUserDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_name'] = \
            user_name
        return self.slurmdbd_delete_user_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_wckey(
        self,
        wckey,
        **kwargs
    ):
        """Delete wckey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_wckey(wckey, async_req=True)
        >>> result = thread.get()

        Args:
            wckey (str): Slurm wckey name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseWckeyDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wckey'] = \
            wckey
        return self.slurmdbd_delete_wckey_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_delete_wckey_0(
        self,
        wckey,
        **kwargs
    ):
        """Delete wckey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_delete_wckey_0(wckey, async_req=True)
        >>> result = thread.get()

        Args:
            wckey (str): Slurm wckey name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseWckeyDelete
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wckey'] = \
            wckey
        return self.slurmdbd_delete_wckey_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_diag(
        self,
        **kwargs
    ):
        """Get slurmdb diagnostics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_diag(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036Diag
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_diag_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_diag_0(
        self,
        **kwargs
    ):
        """Get slurmdb diagnostics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_diag_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037Diag
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_diag_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_account(
        self,
        account_name,
        **kwargs
    ):
        """Get account info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_account(account_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Slurm Account Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036AccountInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_name'] = \
            account_name
        return self.slurmdbd_get_account_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_account_0(
        self,
        account_name,
        **kwargs
    ):
        """Get account info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_account_0(account_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Slurm Account Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037AccountInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_name'] = \
            account_name
        return self.slurmdbd_get_account_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_accounts(
        self,
        **kwargs
    ):
        """Get account list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036AccountInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_accounts_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_accounts_0(
        self,
        **kwargs
    ):
        """Get account list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_accounts_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037AccountInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_accounts_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_association(
        self,
        **kwargs
    ):
        """Get association info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_association(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cluster (str): Cluster name. [optional]
            account (str): Account name. [optional]
            user (str): User name. [optional]
            partition (str): Partition Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036AssociationsInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_association_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_association_0(
        self,
        **kwargs
    ):
        """Get association info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_association_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            cluster (str): Cluster name. [optional]
            account (str): Account name. [optional]
            user (str): User name. [optional]
            partition (str): Partition Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037AssociationsInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_association_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_associations(
        self,
        **kwargs
    ):
        """Get association list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_associations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036AssociationsInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_associations_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_associations_0(
        self,
        **kwargs
    ):
        """Get association list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_associations_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037AssociationsInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_associations_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_cluster(
        self,
        cluster_name,
        **kwargs
    ):
        """Get cluster info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_cluster(cluster_name, async_req=True)
        >>> result = thread.get()

        Args:
            cluster_name (str): Slurm cluster name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ClusterInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['cluster_name'] = \
            cluster_name
        return self.slurmdbd_get_cluster_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_cluster_0(
        self,
        cluster_name,
        **kwargs
    ):
        """Get cluster info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_cluster_0(cluster_name, async_req=True)
        >>> result = thread.get()

        Args:
            cluster_name (str): Slurm cluster name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ClusterInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['cluster_name'] = \
            cluster_name
        return self.slurmdbd_get_cluster_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_clusters(
        self,
        **kwargs
    ):
        """Get cluster list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_clusters(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ClusterInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_clusters_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_clusters_0(
        self,
        **kwargs
    ):
        """Get cluster list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_clusters_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ClusterInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_clusters_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_db_config(
        self,
        **kwargs
    ):
        """Dump all configuration information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_db_config(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ConfigInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_db_config_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_db_config_0(
        self,
        **kwargs
    ):
        """Dump all configuration information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_db_config_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ConfigInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_db_config_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_job(
        self,
        job_id,
        **kwargs
    ):
        """Get job info  # noqa: E501

        This endpoint may return multiple job entries since job_id is not a unique key - only the tuple (cluster, job_id, start_time) is unique. If the requested job_id is a component of a heterogeneous job all components are returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_job(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036JobInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmdbd_get_job_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_job_0(
        self,
        job_id,
        **kwargs
    ):
        """Get job info  # noqa: E501

        This endpoint may return multiple job entries since job_id is not a unique key - only the tuple (cluster, job_id, start_time) is unique. If the requested job_id is a component of a heterogeneous job all components are returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_job_0(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (int): Slurm Job ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037JobInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['job_id'] = \
            job_id
        return self.slurmdbd_get_job_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_jobs(
        self,
        **kwargs
    ):
        """Get job list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_jobs(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            submit_time (str): Filter by submission time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            start_time (str): Filter by start time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            end_time (str): Filter by end time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            account (str): Comma delimited list of accounts to match. [optional]
            association (str): Comma delimited list of associations to match. [optional]
            cluster (str): Comma delimited list of cluster to match. [optional]
            constraints (str): Comma delimited list of constraints to match. [optional]
            cpus_max (str): Number of CPUs high range. [optional]
            cpus_min (str): Number of CPUs low range. [optional]
            skip_steps (bool): Report job step information. [optional]
            disable_wait_for_result (bool): Disable waiting for result from slurmdbd. [optional]
            exit_code (str): Exit code of job. [optional]
            format (str): Comma delimited list of formats to match. [optional]
            group (str): Comma delimited list of groups to match. [optional]
            job_name (str): Comma delimited list of job names to match. [optional]
            nodes_max (str): Number of nodes high range. [optional]
            nodes_min (str): Number of nodes low range. [optional]
            partition (str): Comma delimited list of partitions to match. [optional]
            qos (str): Comma delimited list of QOS to match. [optional]
            reason (str): Comma delimited list of job reasons to match. [optional]
            reservation (str): Comma delimited list of reservations to match. [optional]
            state (str): Comma delimited list of states to match. [optional]
            step (str): Comma delimited list of job steps to match. [optional]
            node (str): Comma delimited list of used nodes to match. [optional]
            wckey (str): Comma delimited list of wckeys to match. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036JobInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_jobs_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_jobs_0(
        self,
        **kwargs
    ):
        """Get job list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_jobs_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            submit_time (str): Filter by submission time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            start_time (str): Filter by start time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            end_time (str): Filter by end time  Accepted formats:  HH:MM[:SS] [AM|PM]  MMDD[YY] or MM/DD[/YY] or MM.DD[.YY]  MM/DD[/YY]-HH:MM[:SS]  YYYY-MM-DD[THH:MM[:SS]]. [optional]
            account (str): Comma delimited list of accounts to match. [optional]
            association (str): Comma delimited list of associations to match. [optional]
            cluster (str): Comma delimited list of cluster to match. [optional]
            constraints (str): Comma delimited list of constraints to match. [optional]
            cpus_max (str): Number of CPUs high range. [optional]
            cpus_min (str): Number of CPUs low range. [optional]
            skip_steps (bool): Report job step information. [optional]
            disable_wait_for_result (bool): Disable waiting for result from slurmdbd. [optional]
            exit_code (str): Exit code of job. [optional]
            format (str): Comma delimited list of formats to match. [optional]
            group (str): Comma delimited list of groups to match. [optional]
            job_name (str): Comma delimited list of job names to match. [optional]
            nodes_max (str): Number of nodes high range. [optional]
            nodes_min (str): Number of nodes low range. [optional]
            partition (str): Comma delimited list of partitions to match. [optional]
            qos (str): Comma delimited list of QOS to match. [optional]
            reason (str): Comma delimited list of job reasons to match. [optional]
            reservation (str): Comma delimited list of reservations to match. [optional]
            state (str): Comma delimited list of states to match. [optional]
            step (str): Comma delimited list of job steps to match. [optional]
            node (str): Comma delimited list of used nodes to match. [optional]
            wckey (str): Comma delimited list of wckeys to match. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037JobInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_jobs_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_qos(
        self,
        **kwargs
    ):
        """Get QOS list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_qos(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036QosInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_qos_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_qos_0(
        self,
        **kwargs
    ):
        """Get QOS list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_qos_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037QosInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_qos_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_single_qos(
        self,
        qos_name,
        **kwargs
    ):
        """Get QOS info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_single_qos(qos_name, async_req=True)
        >>> result = thread.get()

        Args:
            qos_name (str): Slurm QOS Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036QosInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['qos_name'] = \
            qos_name
        return self.slurmdbd_get_single_qos_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_single_qos_0(
        self,
        qos_name,
        **kwargs
    ):
        """Get QOS info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_single_qos_0(qos_name, async_req=True)
        >>> result = thread.get()

        Args:
            qos_name (str): Slurm QOS Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037QosInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['qos_name'] = \
            qos_name
        return self.slurmdbd_get_single_qos_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_tres(
        self,
        **kwargs
    ):
        """Get TRES info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_tres(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036TresInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_tres_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_tres_0(
        self,
        **kwargs
    ):
        """Get TRES info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_tres_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037TresInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_tres_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_user(
        self,
        user_name,
        **kwargs
    ):
        """Get user info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_user(user_name, async_req=True)
        >>> result = thread.get()

        Args:
            user_name (str): Slurm User Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036UserInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_name'] = \
            user_name
        return self.slurmdbd_get_user_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_user_0(
        self,
        user_name,
        **kwargs
    ):
        """Get user info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_user_0(user_name, async_req=True)
        >>> result = thread.get()

        Args:
            user_name (str): Slurm User Name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037UserInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_name'] = \
            user_name
        return self.slurmdbd_get_user_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_users(
        self,
        **kwargs
    ):
        """Get user list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_users(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036UserInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_users_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_users_0(
        self,
        **kwargs
    ):
        """Get user list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_users_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037UserInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_users_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_wckey(
        self,
        wckey,
        **kwargs
    ):
        """Get wckey info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_wckey(wckey, async_req=True)
        >>> result = thread.get()

        Args:
            wckey (str): Slurm wckey name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036WckeyInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wckey'] = \
            wckey
        return self.slurmdbd_get_wckey_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_wckey_0(
        self,
        wckey,
        **kwargs
    ):
        """Get wckey info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_wckey_0(wckey, async_req=True)
        >>> result = thread.get()

        Args:
            wckey (str): Slurm wckey name

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037WckeyInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wckey'] = \
            wckey
        return self.slurmdbd_get_wckey_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_wckeys(
        self,
        **kwargs
    ):
        """Get wckey list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_wckeys(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036WckeyInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_wckeys_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_get_wckeys_0(
        self,
        **kwargs
    ):
        """Get wckey list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_get_wckeys_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037WckeyInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_get_wckeys_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_set_db_config(
        self,
        **kwargs
    ):
        """Load all configuration information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_set_db_config(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ConfigResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_set_db_config_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_set_db_config_0(
        self,
        **kwargs
    ):
        """Load all configuration information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_set_db_config_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ConfigResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_set_db_config_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_account(
        self,
        **kwargs
    ):
        """Update accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_account(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036AccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_account_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_account_0(
        self,
        **kwargs
    ):
        """Update accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_account_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037AccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_account_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_tres(
        self,
        **kwargs
    ):
        """Set TRES info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_tres(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseTres
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_tres_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_tres_0(
        self,
        **kwargs
    ):
        """Set TRES info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_tres_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseTres
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_tres_0_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_users(
        self,
        **kwargs
    ):
        """Update user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_users(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0036ResponseUserUpdate
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_users_endpoint.call_with_http_info(**kwargs)

    def slurmdbd_update_users_0(
        self,
        **kwargs
    ):
        """Update user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.slurmdbd_update_users_0(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Dbv0037ResponseUserUpdate
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.slurmdbd_update_users_0_endpoint.call_with_http_info(**kwargs)

