from SimConnect import *


class EventHelper:
	def __init__(self, _sm):
		self.sm = _sm

	def __getattr__(self, _name):
		for key in self.list:
			if _name == key[0].decode():
				ne = Event(key[0], self.sm, _dec=key[1])
				setattr(self, _name, ne)
				return ne
		return None

	def get(self, _name):
		return getattr(self, _name)

	def set(self, _name, _value=0):
		setattr(self, _name, _value)


class AircraftEvents():
	def __init__(self, _sm):
		self.sm = _sm
		self.list = []
		self.Engine = self.__Engine(_sm)
		self.list.append(self.Engine)
		self.Flight_Controls = self.__Flight_Controls(_sm)
		self.list.append(self.Flight_Controls)
		self.Autopilot = self.__Autopilot(_sm)
		self.list.append(self.Autopilot)
		self.Fuel_System = self.__Fuel_System(_sm)
		self.list.append(self.Fuel_System)
		self.Fuel_Selection_Keys = self.__Fuel_Selection_Keys(_sm)
		self.list.append(self.Fuel_Selection_Keys)
		self.Avionics = self.__Avionics(_sm)
		self.list.append(self.Avionics)
		self.Instruments = self.__Instruments(_sm)
		self.list.append(self.Instruments)
		self.Lights = self.__Lights(_sm)
		self.list.append(self.Lights)
		self.Failures = self.__Failures(_sm)
		self.list.append(self.Failures)
		self.Miscellaneous_Systems = self.__Miscellaneous_Systems(_sm)
		self.list.append(self.Miscellaneous_Systems)
		self.Nose_wheel_steering = self.__Nose_wheel_steering(_sm)
		self.list.append(self.Nose_wheel_steering)
		self.Cabin_pressurization = self.__Cabin_pressurization(_sm)
		self.list.append(self.Cabin_pressurization)
		self.Catapult_Launches = self.__Catapult_Launches(_sm)
		self.list.append(self.Catapult_Launches)
		self.Helicopter_Specific_Systems = self.__Helicopter_Specific_Systems(_sm)
		self.list.append(self.Helicopter_Specific_Systems)
		self.Slings_and_Hoists = self.__Slings_and_Hoists(_sm)
		self.list.append(self.Slings_and_Hoists)
		self.Slew_System = self.__Slew_System(_sm)
		self.list.append(self.Slew_System)
		self.View_System = self.__View_System(_sm)
		self.list.append(self.View_System)
		self.Miscellaneous_Events = self.__Miscellaneous_Events(_sm)
		self.list.append(self.Miscellaneous_Events)
		self.Freezing_position = self.__Freezing_position(_sm)
		self.list.append(self.Freezing_position)
		self.Mission_Keys = self.__Mission_Keys(_sm)
		self.list.append(self.Mission_Keys)
		self.ATC = self.__ATC(_sm)
		self.list.append(self.ATC)
		self.Multiplayer = self.__Multiplayer(_sm)
		self.list.append(self.Multiplayer)

	def find(self, key):
		for clas in self.list:
			for test in clas.list:
				if key == test[0].decode():
					return getattr(clas, key)
		return None

	class __Engine(EventHelper):
		list = [
			(b' THROTTLE_FULL', "Set throttles max", "Shared Cockpit"),
			(b' THROTTLE_INCR', "Increment throttles", "Shared Cockpit"),
			(b' THROTTLE_INCR_SMALL', "Increment throttles small", "Shared Cockpit"),
			(b'THROTTLE_DECR', "Decrement throttles", "Shared Cockpit"),
			(b'THROTTLE_DECR_SMALL', "Decrease throttles small", "Shared Cockpit"),
			(b'THROTTLE_CUT', "Set throttles to idle", "Shared Cockpit"),
			(b'INCREASE_THROTTLE', "Increment throttles", "Shared Cockpit"),
			(b'DECREASE_THROTTLE', "Decrement throttles", "Shared Cockpit"),
			(b'THROTTLE_SET', "Set throttles exactly (0- 16383),", "Shared Cockpit"),
			(b'AXIS_THROTTLE_SET', "Set throttles (0- 16383),", "Shared Cockpit (Pilot only, transmitted to Co-pilot if in a helicopter, not-transmitted otherwise)."),
			(b'THROTTLE1_SET', "Set throttle 1 exactly (0 to 16383),", "Shared Cockpit"),
			(b'THROTTLE2_SET', "Set throttle 2 exactly (0 to 16383),", "Shared Cockpit"),
			(b'THROTTLE3_SET', "Set throttle 3 exactly (0 to 16383),", "Shared Cockpit"),
			(b'THROTTLE4_SET', "Set throttle 4 exactly (0 to 16383),", "Shared Cockpit"),
			(b'THROTTLE1_FULL', "Set throttle 1 max", "Shared Cockpit"),
			(b'THROTTLE1_INCR', "Increment throttle 1", "Shared Cockpit"),
			(b'THROTTLE1_INCR_SMALL', "Increment throttle 1 small", "Shared Cockpit"),
			(b'THROTTLE1_DECR', "Decrement throttle 1", "Shared Cockpit"),
			(b'THROTTLE1_CUT', "Set throttle 1 to idle", "Shared Cockpit"),
			(b'THROTTLE2_FULL', "Set throttle 2 max", "Shared Cockpit"),
			(b'THROTTLE2_INCR', "Increment throttle 2", "Shared Cockpit"),
			(b'THROTTLE2_INCR_SMALL', "Increment throttle 2 small", "Shared Cockpit"),
			(b'THROTTLE2_DECR', "Decrement throttle 2", "Shared Cockpit"),
			(b'THROTTLE2_CUT', "Set throttle 2 to idle", "Shared Cockpit"),
			(b'THROTTLE3_FULL', "Set throttle 3 max", "Shared Cockpit"),
			(b'THROTTLE3_INCR', "Increment throttle 3", "Shared Cockpit"),
			(b'THROTTLE3_INCR_SMALL', "Increment throttle 3 small", "Shared Cockpit"),
			(b'THROTTLE3_DECR', "Decrement throttle 3", "Shared Cockpit"),
			(b'THROTTLE3_CUT', "Set throttle 3 to idle", "Shared Cockpit"),
			(b'THROTTLE4_FULL', "Set throttle 1 max", "Shared Cockpit"),
			(b'THROTTLE4_INCR', "Increment throttle 4", "Shared Cockpit"),
			(b'THROTTLE4_INCR_SMALL', "Increment throttle 4 small", "Shared Cockpit"),
			(b'THROTTLE4_DECR', "Decrement throttle 4", "Shared Cockpit"),
			(b'THROTTLE4_CUT', "Set throttle 4 to idle", "Shared Cockpit"),
			(b'THROTTLE_10', "Set throttles to 10%", "Shared Cockpit"),
			(b'THROTTLE_20', "Set throttles to 20%", "Shared Cockpit"),
			(b'THROTTLE_30', "Set throttles to 30%", "Shared Cockpit"),
			(b'THROTTLE_40', "Set throttles to 40%", "Shared Cockpit"),
			(b'THROTTLE_50', "Set throttles to 50%", "Shared Cockpit"),
			(b'THROTTLE_60', "Set throttles to 60%", "Shared Cockpit"),
			(b'THROTTLE_70', "Set throttles to 70%", "Shared Cockpit"),
			(b'THROTTLE_80', "Set throttles to 80%", "Shared Cockpit"),
			(b'THROTTLE_90', "Set throttles to 90%", "Shared Cockpit"),
			(b'AXIS_THROTTLE1_SET', "Set throttle 1 exactly (-16383 - +16383),", "Shared Cockpit"),
			(b'AXIS_THROTTLE2_SET', "Set throttle 2 exactly (-16383 - +16383),", "Shared Cockpit"),
			(b'AXIS_THROTTLE3_SET', "Set throttle 3 exactly (-16383 - +16383),", "Shared Cockpit"),
			(b'AXIS_THROTTLE4_SET', "Set throttle 4 exactly (-16383 - +16383),", "Shared Cockpit"),
			(b'THROTTLE1_DECR_SMALL', "Decrease throttle 1 small", "Shared Cockpit"),
			(b'THROTTLE2_DECR_SMALL', "Decrease throttle 2 small", "Shared Cockpit"),
			(b'THROTTLE3_DECR_SMALL', "Decrease throttle 3 small", "Shared Cockpit"),
			(b'THROTTLE4_DECR_SMALL', "Decrease throttle 4 small", "Shared Cockpit"),
			(b'PROP_PITCH_DECR_SMALL', "Decrease prop levers small", "Shared Cockpit"),
			(b'PROP_PITCH1_DECR_SMALL', "Decrease prop lever 1 small", "Shared Cockpit"),
			(b'PROP_PITCH2_DECR_SMALL', "Decrease prop lever 2 small", "Shared Cockpit"),
			(b'PROP_PITCH3_DECR_SMALL', "Decrease prop lever 3 small", "Shared Cockpit"),
			(b'PROP_PITCH4_DECR_SMALL', "Decrease prop lever 4 small", "Shared Cockpit"),
			(b'MIXTURE1_RICH', "Set mixture lever 1 to max rich", "Shared Cockpit"),
			(b'MIXTURE1_INCR', "Increment mixture lever 1", "Shared Cockpit"),
			(b'MIXTURE1_INCR_SMALL', "Increment mixture lever 1 small", "Shared Cockpit"),
			(b'MIXTURE1_DECR', "Decrement mixture lever 1", "Shared Cockpit"),
			(b'MIXTURE1_LEAN', "Set mixture lever 1 to max lean", "Shared Cockpit"),
			(b'MIXTURE2_RICH', "Set mixture lever 2 to max rich", "Shared Cockpit"),
			(b'MIXTURE2_INCR', "Increment mixture lever 2", "Shared Cockpit"),
			(b'MIXTURE2_INCR_SMALL', "Increment mixture lever 2 small", "Shared Cockpit"),
			(b'MIXTURE2_DECR', "Decrement mixture lever 2", "Shared Cockpit"),
			(b'MIXTURE2_LEAN', "Set mixture lever 2 to max lean", "Shared Cockpit"),
			(b'MIXTURE3_RICH', "Set mixture lever 3 to max rich", "Shared Cockpit"),
			(b'MIXTURE3_INCR', "Increment mixture lever 3", "Shared Cockpit"),
			(b'MIXTURE3_INCR_SMALL', "Increment mixture lever 3 small", "Shared Cockpit"),
			(b'MIXTURE3_DECR', "Decrement mixture lever 3", "Shared Cockpit"),
			(b'MIXTURE3_LEAN', "Set mixture lever 3 to max lean", "Shared Cockpit"),
			(b'MIXTURE4_RICH', "Set mixture lever 4 to max rich", "Shared Cockpit"),
			(b'MIXTURE4_INCR', "Increment mixture lever 4", "Shared Cockpit"),
			(b'MIXTURE4_INCR_SMALL', "Increment mixture lever 4 small", "Shared Cockpit"),
			(b'MIXTURE4_DECR', "Decrement mixture lever 4", "Shared Cockpit"),
			(b'MIXTURE4_LEAN', "Set mixture lever 4 to max lean", "Shared Cockpit"),
			(b'MIXTURE_SET', "Set mixture levers to exact value (0 to 16383),", "Shared Cockpit"),
			(b'MIXTURE_RICH', "Set mixture levers to max rich", "Shared Cockpit"),
			(b'MIXTURE_INCR', "Increment mixture levers", "Shared Cockpit"),
			(b'MIXTURE_INCR_SMALL', "Increment mixture levers small", "Shared Cockpit"),
			(b'MIXTURE_DECR', "Decrement mixture levers", "Shared Cockpit"),
			(b'MIXTURE_LEAN', "Set mixture levers to max lean", "Shared Cockpit"),
			(b'MIXTURE1_SET', "Set mixture lever 1 exact value (0 to 16383),", "Shared Cockpit"),
			(b'MIXTURE2_SET', "Set mixture lever 2 exact value (0 to 16383),", "Shared Cockpit"),
			(b'MIXTURE3_SET', "Set mixture lever 3 exact value (0 to 16383),", "Shared Cockpit"),
			(b'MIXTURE4_SET', "Set mixture lever 4 exact value (0 to 16383),", "Shared Cockpit"),
			(b'AXIS_MIXTURE_SET', "Set mixture lever 1 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_MIXTURE1_SET', "Set mixture lever 1 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_MIXTURE2_SET', "Set mixture lever 2 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_MIXTURE3_SET', "Set mixture lever 3 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_MIXTURE4_SET', "Set mixture lever 4 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'MIXTURE_SET_BEST', "Set mixture levers to current best power setting", "Shared Cockpit"),
			(b'MIXTURE_DECR_SMALL', "Decrement mixture levers small", "Shared Cockpit"),
			(b'MIXTURE1_DECR_SMALL', "Decrement mixture lever 1 small", "Shared Cockpit"),
			(b'MIXTURE2_DECR_SMALL', "Decrement mixture lever 4 small", "Shared Cockpit"),
			(b'MIXTURE3_DECR_SMALL', "Decrement mixture lever 4 small", "Shared Cockpit"),
			(b'MIXTURE4_DECR_SMALL', "Decrement mixture lever 4 small", "Shared Cockpit"),
			(b'PROP_PITCH_SET', "Set prop pitch levers (0 to 16383),", "Shared Cockpit"),
			(b'PROP_PITCH_LO', "Set prop pitch levers max (lo pitch),", "Shared Cockpit"),
			(b'PROP_PITCH_INCR', "Increment prop pitch levers", "Shared Cockpit"),
			(b'PROP_PITCH_INCR_SMALL', "Increment prop pitch levers small", "Shared Cockpit"),
			(b'PROP_PITCH_DECR', "Decrement prop pitch levers", "Shared Cockpit"),
			(b'PROP_PITCH_HI', "Set prop pitch levers min (hi pitch),", "Shared Cockpit"),
			(b'PROP_PITCH1_SET', "Set prop pitch lever 1 exact value (0 to 16383),", "Shared Cockpit"),
			(b'PROP_PITCH2_SET', "Set prop pitch lever 2 exact value (0 to 16383),", "Shared Cockpit"),
			(b'PROP_PITCH3_SET', "Set prop pitch lever 3 exact value (0 to 16383),", "Shared Cockpit"),
			(b'PROP_PITCH4_SET', "Set prop pitch lever 4 exact value (0 to 16383),", "Shared Cockpit"),
			(b'PROP_PITCH1_LO', "Set prop pitch lever 1 max (lo pitch),", "Shared Cockpit"),
			(b'PROP_PITCH1_INCR', "Increment prop pitch lever 1", "Shared Cockpit"),
			(b'PROP_PITCH1_INCR_SMALL', "Increment prop pitch lever 1 small", "Shared Cockpit"),
			(b'PROP_PITCH1_DECR', "Decrement prop pitch lever 1", "Shared Cockpit"),
			(b'PROP_PITCH1_HI', "Set prop pitch lever 1 min (hi pitch),", "Shared Cockpit"),
			(b'PROP_PITCH2_LO', "Set prop pitch lever 2 max (lo pitch),", "Shared Cockpit"),
			(b'PROP_PITCH2_INCR', "Increment prop pitch lever 2", "Shared Cockpit"),
			(b'PROP_PITCH2_INCR_SMALL', "Increment prop pitch lever 2 small", "Shared Cockpit"),
			(b'PROP_PITCH2_DECR', "Decrement prop pitch lever 2", "Shared Cockpit"),
			(b'PROP_PITCH2_HI', "Set prop pitch lever 2 min (hi pitch),", "Shared Cockpit"),
			(b'PROP_PITCH3_LO', "Set prop pitch lever 3 max (lo pitch),", "Shared Cockpit"),
			(b'PROP_PITCH3_INCR', "Increment prop pitch lever 3", "Shared Cockpit"),
			(b'PROP_PITCH3_INCR_SMALL', "Increment prop pitch lever 3 small", "Shared Cockpit"),
			(b'PROP_PITCH3_DECR', "Decrement prop pitch lever 3", "Shared Cockpit"),
			(b'PROP_PITCH3_HI', "Set prop pitch lever 3 min (hi pitch),", "Shared Cockpit"),
			(b'PROP_PITCH4_LO', "Set prop pitch lever 4 max (lo pitch),", "Shared Cockpit"),
			(b'PROP_PITCH4_INCR', "Increment prop pitch lever 4", "Shared Cockpit"),
			(b'PROP_PITCH4_INCR_SMALL', "Increment prop pitch lever 4 small", "Shared Cockpit"),
			(b'PROP_PITCH4_DECR', "Decrement prop pitch lever 4", "Shared Cockpit"),
			(b'PROP_PITCH4_HI', "Set prop pitch lever 4 min (hi pitch),", "Shared Cockpit"),
			(b'AXIS_PROPELLER_SET', "Set propeller levers exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_PROPELLER1_SET', "Set propeller lever 1 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_PROPELLER2_SET', "Set propeller lever 2 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_PROPELLER3_SET', "Set propeller lever 3 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'AXIS_PROPELLER4_SET', "Set propeller lever 4 exact value (-16383 to +16383),", "Shared Cockpit"),
			(b'JET_STARTER', "Selects jet engine starter (for +/- sequence),", "Shared Cockpit"),
			(b'MAGNETO_SET', "Sets magnetos (0,1),", "Shared Cockpit"),
			(b'TOGGLE_STARTER1', "Toggle starter 1", "Shared Cockpit"),
			(b'TOGGLE_STARTER2', "Toggle starter 2", "Shared Cockpit"),
			(b'TOGGLE_STARTER3', "Toggle starter 3", "Shared Cockpit"),
			(b'TOGGLE_STARTER4', "Toggle starter 4", "Shared Cockpit"),
			(b'TOGGLE_ALL_STARTERS', "Toggle starters", "Shared Cockpit"),
			(b'ENGINE_AUTO_START', "Triggers auto-start", "Shared Cockpit"),
			(b'ENGINE_AUTO_SHUTDOWN', "Triggers auto-shutdown", "Shared Cockpit"),
			(b'MAGNETO', "Selects magnetos (for +/- sequence),", "Shared Cockpit"),
			(b'MAGNETO_DECR', "Decrease magneto switches positions", "Shared Cockpit"),
			(b'MAGNETO_INCR', "Increase magneto switches positions", "Shared Cockpit"),
			(b'MAGNETO1_OFF', "Set engine 1 magnetos off", "Shared Cockpit"),
			(b'MAGNETO1_RIGHT', "Toggle engine 1 right magneto", "All aircraft"),
			(b'MAGNETO1_LEFT', "Toggle engine 1 left magneto", "All aircraft"),
			(b'MAGNETO1_BOTH', "Set engine 1 magnetos on", "Shared Cockpit"),
			(b'MAGNETO1_START', "Set engine 1 magnetos on and toggle starter", "Shared Cockpit"),
			(b'MAGNETO2_OFF', "Set engine 2 magnetos off", "Shared Cockpit"),
			(b'MAGNETO2_RIGHT', "Toggle engine 2 right magneto", "All aircraft"),
			(b'MAGNETO2_LEFT', "Toggle engine 2 left magneto", "All aircraft"),
			(b'MAGNETO2_BOTH', "Set engine 2 magnetos on", "Shared Cockpit"),
			(b'MAGNETO2_START', "Set engine 2 magnetos on and toggle starter", "Shared Cockpit"),
			(b'MAGNETO3_OFF', "Set engine 3 magnetos off", "Shared Cockpit"),
			(b'MAGNETO3_RIGHT', "Toggle engine 3 right magneto", "All aircraft"),
			(b'MAGNETO3_LEFT', "Toggle engine 3 left magneto", "All aircraft"),
			(b'MAGNETO3_BOTH', "Set engine 3 magnetos on", "Shared Cockpit"),
			(b'MAGNETO3_START', "Set engine 3 magnetos on and toggle starter", "Shared Cockpit"),
			(b'MAGNETO4_OFF', "Set engine 4 magnetos off", "Shared Cockpit"),
			(b'MAGNETO4_RIGHT', "Toggle engine 4 right magneto", "All aircraft"),
			(b'MAGNETO4_LEFT', "Toggle engine 4 left magneto", "All aircraft"),
			(b'MAGNETO4_BOTH', "Set engine 4 magnetos on", "Shared Cockpit"),
			(b'MAGNETO4_START', "Set engine 4 magnetos on and toggle starter", "Shared Cockpit"),
			(b'MAGNETO_OFF', "Set engine magnetos off", "Shared Cockpit"),
			(b'MAGNETO_RIGHT', "Set engine right magnetos on", "Shared Cockpit"),
			(b'MAGNETO_LEFT', "Set engine left magnetos on", "Shared Cockpit"),
			(b'MAGNETO_BOTH', "Set engine magnetos on", "Shared Cockpit"),
			(b'MAGNETO_START', "Set engine magnetos on and toggle starters", "Shared Cockpit"),
			(b'MAGNETO1_DECR', "Decrease engine 1 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO1_INCR', "Increase engine 1 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO2_DECR', "Decrease engine 2 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO2_INCR', "Increase engine 2 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO3_DECR', "Decrease engine 3 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO3_INCR', "Increase engine 3 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO4_DECR', "Decrease engine 4 magneto switch position", "Shared Cockpit"),
			(b'MAGNETO4_INCR', "Increase engine 4 magneto switch position", "Shared Cockpit"),
			(b'Not supported', "Set engine magneto switches", "Shared Cockpit"),
			(b'MAGNETO1_SET', "Set engine 1 magneto switch", "Shared Cockpit"),
			(b'MAGNETO2_SET', "Set engine 2 magneto switch", "Shared Cockpit"),
			(b'MAGNETO3_SET', "Set engine 3 magneto switch", "Shared Cockpit"),
			(b'MAGNETO4_SET', "Set engine 4 magneto switch", "Shared Cockpit"),
			(b'ANTI_ICE_ON', "Sets anti-ice switches on", "Shared Cockpit"),
			(b'ANTI_ICE_OFF', "Sets anti-ice switches off", "Shared Cockpit"),
			(b'ANTI_ICE_SET', "Sets anti-ice switches from argument (0,1),", "Shared Cockpit"),
			(b'ANTI_ICE_TOGGLE', "Toggle anti-ice switches", "Shared Cockpit"),
			(b'ANTI_ICE_TOGGLE_ENG1', "Toggle engine 1 anti-ice switch", "Shared Cockpit"),
			(b'ANTI_ICE_TOGGLE_ENG2', "Toggle engine 2 anti-ice switch", "Shared Cockpit"),
			(b'ANTI_ICE_TOGGLE_ENG3', "Toggle engine 3 anti-ice switch", "Shared Cockpit"),
			(b'ANTI_ICE_TOGGLE_ENG4', "Toggle engine 4 anti-ice switch", "Shared Cockpit"),
			(b'ANTI_ICE_SET_ENG1', "Sets engine 1 anti-ice switch (0,1),", "Shared Cockpit"),
			(b'ANTI_ICE_SET_ENG2', "Sets engine 2 anti-ice switch (0,1),", "Shared Cockpit"),
			(b'ANTI_ICE_SET_ENG3', "Sets engine 3 anti-ice switch (0,1),", "Shared Cockpit"),
			(b'ANTI_ICE_SET_ENG4', "Sets engine 4 anti-ice switch (0,1),", "Shared Cockpit"),
			(b'TOGGLE_FUEL_VALVE_ALL', "Toggle engine fuel valves", "Shared Cockpit"),
			(b'TOGGLE_FUEL_VALVE_ENG1', "Toggle engine 1 fuel valve", "All aircraft"),
			(b'TOGGLE_FUEL_VALVE_ENG2', "Toggle engine 2 fuel valve", "All aircraft"),
			(b'TOGGLE_FUEL_VALVE_ENG3', "Toggle engine 3 fuel valve", "All aircraft"),
			(b'TOGGLE_FUEL_VALVE_ENG4', "Toggle engine 4 fuel valve", "All aircraft"),
			(b'COWLFLAP1_SET', "Sets engine 1 cowl flap lever position (0 to 16383),", "Shared Cockpit"),
			(b'COWLFLAP2_SET', "Sets engine 2 cowl flap lever position (0 to 16383),", "Shared Cockpit"),
			(b'COWLFLAP3_SET', "Sets engine 3 cowl flap lever position (0 to 16383),", "Shared Cockpit"),
			(b'COWLFLAP4_SET', "Sets engine 4 cowl flap lever position (0 to 16383),", "Shared Cockpit"),
			(b'INC_COWL_FLAPS', "Increment cowl flap levers", "Shared Cockpit"),
			(b'DEC_COWL_FLAPS', "Decrement cowl flap levers", "Shared Cockpit"),
			(b'INC_COWL_FLAPS1', "Increment engine 1 cowl flap lever", "Shared Cockpit"),
			(b'DEC_COWL_FLAPS1', "Decrement engine 1 cowl flap lever", "Shared Cockpit"),
			(b'INC_COWL_FLAPS2', "Increment engine 2 cowl flap lever", "Shared Cockpit"),
			(b'DEC_COWL_FLAPS2', "Decrement engine 2 cowl flap lever", "Shared Cockpit"),
			(b'INC_COWL_FLAPS3', "Increment engine 3 cowl flap lever", "Shared Cockpit"),
			(b'DEC_COWL_FLAPS3', "Decrement engine 3 cowl flap lever", "Shared Cockpit"),
			(b'INC_COWL_FLAPS4', "Increment engine 4 cowl flap lever", "Shared Cockpit"),
			(b'DEC_COWL_FLAPS4', "Decrement engine 4 cowl flap lever", "Shared Cockpit"),
			(b'FUEL_PUMP', "Toggle electric fuel pumps", "Shared Cockpit"),
			(b'TOGGLE_ELECT_FUEL_PUMP', "Toggle electric fuel pumps", "Shared Cockpit"),
			(b'TOGGLE_ELECT_FUEL_PUMP1', "Toggle engine 1 electric fuel pump", "All aircraft"),
			(b'TOGGLE_ELECT_FUEL_PUMP2', "Toggle engine 2 electric fuel pump", "All aircraft"),
			(b'TOGGLE_ELECT_FUEL_PUMP3', "Toggle engine 3 electric fuel pump", "All aircraft"),
			(b'TOGGLE_ELECT_FUEL_PUMP4', "Toggle engine 4 electric fuel pump", "All aircraft"),
			(b'ENGINE_PRIMER', "Trigger engine primers", "Shared Cockpit"),
			(b'TOGGLE_PRIMER', "Trigger engine primers", "Shared Cockpit"),
			(b'TOGGLE_PRIMER1', "Trigger engine 1 primer", "Shared Cockpit"),
			(b'TOGGLE_PRIMER2', "Trigger engine 2 primer", "Shared Cockpit"),
			(b'TOGGLE_PRIMER3', "Trigger engine 3 primer", "Shared Cockpit"),
			(b'TOGGLE_PRIMER4', "Trigger engine 4 primer", "Shared Cockpit"),
			(b'TOGGLE_FEATHER_SWITCHES', "Trigger propeller switches", "Shared Cockpit"),
			(b'TOGGLE_FEATHER_SWITCH_1', "Trigger propeller 1 switch", "Shared Cockpit"),
			(b'TOGGLE_FEATHER_SWITCH_2', "Trigger propeller 2 switch", "Shared Cockpit"),
			(b'TOGGLE_FEATHER_SWITCH_3', "Trigger propeller 3 switch", "Shared Cockpit"),
			(b'TOGGLE_FEATHER_SWITCH_4', "Trigger propeller 4 switch", "Shared Cockpit"),
			(b'TOGGLE_PROPELLER_SYNC', "Turns propeller synchronization switch on", "Shared Cockpit"),
			(b'TOGGLE_AUTOFEATHER_ARM', "Turns auto-feather arming switch on.", "Shared Cockpit"),
			(b'TOGGLE_AFTERBURNER', "Toggles afterburners", "Shared Cockpit"),
			(b'TOGGLE_AFTERBURNER1', "Toggles engine 1 afterburner", "Shared Cockpit"),
			(b'TOGGLE_AFTERBURNER2', "Toggles engine 2 afterburner", "Shared Cockpit"),
			(b'TOGGLE_AFTERBURNER3', "Toggles engine 3 afterburner", "Shared Cockpit"),
			(b'TOGGLE_AFTERBURNER4', "Toggles engine 4 afterburner", "Shared Cockpit"),
			(b'ENGINE', "Sets engines for 1,2,3,4 selection (to be followed by SELECT_n),", "Shared Cockpit"),
		]

	class __Flight_Controls(EventHelper):
		list = [
			(b'SPOILERS_TOGGLE', "Toggles spoiler handle ", "All aircraft"),
			(b'FLAPS_UP', "Sets flap handle to full retract position", "All aircraft"),
			(b'FLAPS_1', "Sets flap handle to first extension position", "All aircraft"),
			(b'FLAPS_2', "Sets flap handle to second extension position", "All aircraft"),
			(b'FLAPS_3', "Sets flap handle to third extension position", "All aircraft"),
			(b'FLAPS_DOWN', "Sets flap handle to full extension position", "All aircraft"),
			(b'ELEV_TRIM_DN', "Increments elevator trim down", "Shared Cockpit"),
			(b'ELEV_DOWN', "Increments elevator down", "Shared Cockpit (Pilot only),."),
			(b'AILERONS_LEFT', "Increments ailerons left", "Shared Cockpit (Pilot only),."),
			(b'CENTER_AILER_RUDDER', "Centers aileron and rudder positions", "Shared Cockpit"),
			(b'AILERONS_RIGHT', "Increments ailerons right", "Shared Cockpit (Pilot only),."),
			(b'ELEV_TRIM_UP', "Increment elevator trim up", "Shared Cockpit"),
			(b'ELEV_UP', "Increments elevator up", "Shared Cockpit (Pilot only),."),
			(b'Unsupported', "Increments elevator down", "Shared Cockpit"),
			(b'Unsupported', "Increments elevator up", "Shared Cockpit"),
			(b'Unsupported', "Increments ailerons left", "Shared Cockpit"),
			(b'Unsupported', "Centers aileron position", "Shared Cockpit"),
			(b'Unsupported', "Increments ailerons right", "Shared Cockpit"),
			(b'RUDDER_LEFT', "Increments rudder left", "Shared Cockpit"),
			(b'RUDDER_CENTER', "Centers rudder position", "Shared Cockpit"),
			(b'RUDDER_RIGHT', "Increments rudder right", "Shared Cockpit"),
			(b'ELEVATOR_SET', "Sets elevator position (-16383 - +16383),", "Shared Cockpit"),
			(b'AILERON_SET', "Sets aileron position (-16383 - +16383),", "Shared Cockpit"),
			(b'RUDDER_SET', "Sets rudder position (-16383 - +16383),", "Shared Cockpit"),
			(b'FLAPS_INCR', "Increments flap handle position", "All aircraft"),
			(b'FLAPS_DECR', "Decrements flap handle position", "All aircraft"),
			(b'AXIS_ELEVATOR_SET', "Sets elevator position (-16383 - +16383),", "Shared Cockpit (Pilot only, and not transmitted to Co-pilot)"),
			(b'AXIS_AILERONS_SET', "Sets aileron position (-16383 - +16383),", "Shared Cockpit (Pilot only, and not transmitted to Co-pilot)"),
			(b'AXIS_RUDDER_SET', "Sets rudder position (-16383 - +16383),", "Shared Cockpit (Pilot only, and not transmitted to Co-pilot)"),
			(b'AXIS_ELEV_TRIM_SET', "Sets elevator trim position (-16383 - +16383),", "Shared Cockpit"),
			(b'SPOILERS_SET', "Sets spoiler handle position (0 to 16383),", "All aircraft"),
			(b'SPOILERS_ARM_TOGGLE', "Toggles arming of auto-spoilers", "All aircraft"),
			(b'SPOILERS_ON', "Sets spoiler handle to full extend position", "All aircraft"),
			(b'SPOILERS_OFF', "Sets spoiler handle to full retract position", "All aircraft"),
			(b'SPOILERS_ARM_ON', "Sets auto-spoiler arming on", "All aircraft"),
			(b'SPOILERS_ARM_OFF', "Sets auto-spoiler arming off", "All aircraft"),
			(b'SPOILERS_ARM_SET', "Sets auto-spoiler arming (0,1),", "All aircraft"),
			(b'AILERON_TRIM_LEFT', "Increments aileron trim left", "Shared Cockpit"),
			(b'AILERON_TRIM_RIGHT', "Increments aileron trim right", "Shared Cockpit"),
			(b'RUDDER_TRIM_LEFT', "Increments rudder trim left", "Shared Cockpit"),
			(b'RUDDER_TRIM_RIGHT', "Increments aileron trim right", "Shared Cockpit"),
			(b'AXIS_SPOILER_SET', "Sets spoiler handle position (-16383 - +16383),", "All aircraft"),
			(b'FLAPS_SET', "Sets flap handle to closest increment (0 to 16383),", "All aircraft"),
			(b'ELEVATOR_TRIM_SET', "Sets elevator trim position (0 to 16383),", "Shared Cockpit"),
			(b'AXIS_FLAPS_SET', "Sets flap handle to closest increment (-16383 - +16383),", "Shared Cockpit"),
		]

	class __Autopilot(EventHelper):
		list = [
			(b'AP_MASTER', "Toggles AP on/off", "Shared Cockpit"),
			(b'AUTOPILOT_OFF', "Turns AP off", "Shared Cockpit"),
			(b'AUTOPILOT_ON', "Turns AP on", "Shared Cockpit"),
			(b'YAW_DAMPER_TOGGLE', "Toggles yaw damper on/off", "Shared Cockpit"),
			(b'AP_PANEL_HEADING_HOLD', "Toggles heading hold mode on/off", "Shared Cockpit"),
			(b'AP_PANEL_ALTITUDE_HOLD', "Toggles altitude hold mode on/off", "Shared Cockpit"),
			(b'AP_ATT_HOLD_ON', "Turns on AP wing leveler and pitch hold mode", "Shared Cockpit"),
			(b'AP_LOC_HOLD_ON', "Turns AP localizer hold on/armed and glide-slope hold mode off", "Shared Cockpit"),
			(b'AP_APR_HOLD_ON', "Turns both AP localizer and glide-slope modes on/armed", "Shared Cockpit"),
			(b'AP_HDG_HOLD_ON', "Turns heading hold mode on", "Shared Cockpit"),
			(b'AP_ALT_HOLD_ON', "Turns altitude hold mode on", "Shared Cockpit"),
			(b'AP_WING_LEVELER_ON', "Turns wing leveler mode on", "Shared Cockpit"),
			(b'AP_BC_HOLD_ON', "Turns localizer back course hold mode on/armed", "Shared Cockpit"),
			(b'AP_NAV1_HOLD_ON', "Turns lateral hold mode on", "Shared Cockpit"),
			(b'AP_ATT_HOLD_OFF', "Turns off attitude hold mode", "Shared Cockpit"),
			(b'AP_LOC_HOLD_OFF', "Turns off localizer hold mode", "Shared Cockpit"),
			(b'AP_APR_HOLD_OFF', "Turns off approach hold mode", "Shared Cockpit"),
			(b'AP_HDG_HOLD_OFF', "Turns off heading hold mode", "Shared Cockpit"),
			(b'AP_ALT_HOLD_OFF', "Turns off altitude hold mode", "Shared Cockpit"),
			(b'AP_WING_LEVELER_OFF', "Turns off wing leveler mode", "Shared Cockpit"),
			(b'AP_BC_HOLD_OFF', "Turns off backcourse mode for localizer hold", "Shared Cockpit"),
			(b'AP_NAV1_HOLD_OFF', "Turns off nav hold mode", "Shared Cockpit"),
			(b'AP_AIRSPEED_HOLD', "Toggles airspeed hold mode", "Shared Cockpit"),
			(b'AUTO_THROTTLE_ARM', "Toggles autothrottle arming mode", "Shared Cockpit"),
			(b'AUTO_THROTTLE_TO_GA', "Toggles Takeoff/Go Around mode", "Shared Cockpit"),
			(b'HEADING_BUG_INC', "Increments heading hold reference bug", "Shared Cockpit"),
			(b'HEADING_BUG_DEC', "Decrements heading hold reference bug", "Shared Cockpit"),
			(b'HEADING_BUG_SET', "Set heading hold reference bug (degrees),", "Shared Cockpit"),
			(b'AP_PANEL_SPEED_HOLD', "Toggles airspeed hold mode", "Shared Cockpit"),
			(b'AP_ALT_VAR_INC', "Increments reference altitude", "Shared Cockpit"),
			(b'AP_ALT_VAR_DEC', "Decrements reference altitude", "Shared Cockpit"),
			(b'AP_VS_VAR_INC', "Increments vertical speed reference", "Shared Cockpit"),
			(b'AP_VS_VAR_DEC', "Decrements vertical speed reference", "Shared Cockpit"),
			(b'AP_SPD_VAR_INC', "Increments airspeed hold reference", "Shared Cockpit"),
			(b'AP_SPD_VAR_DEC', "Decrements airspeed hold reference", "Shared Cockpit"),
			(b'AP_PANEL_MACH_HOLD', "Toggles mach hold", "Shared Cockpit"),
			(b'AP_MACH_VAR_INC', "Increments reference mach", "Shared Cockpit"),
			(b'AP_MACH_VAR_DEC', "Decrements reference mach", "Shared Cockpit"),
			(b'AP_MACH_HOLD', "Toggles mach hold", "Shared Cockpit"),
			(b'AP_ALT_VAR_SET_METRIC', "Sets reference altitude in meters", "Shared Cockpit"),
			(b'AP_VS_VAR_SET_ENGLISH', "Sets reference vertical speed in feet per minute", "Shared Cockpit"),
			(b'AP_SPD_VAR_SET', "Sets airspeed reference in knots", "Shared Cockpit"),
			(b'AP_MACH_VAR_SET', "Sets mach reference", "Shared Cockpit"),
			(b'YAW_DAMPER_ON', "Turns yaw damper on", "Shared Cockpit"),
			(b'YAW_DAMPER_OFF', "Turns yaw damper off", "Shared Cockpit"),
			(b'YAW_DAMPER_SET', "Sets yaw damper on/off (1,0),", "Shared Cockpit"),
			(b'AP_AIRSPEED_ON', "Turns airspeed hold on", "Shared Cockpit"),
			(b'AP_AIRSPEED_OFF', "Turns airspeed hold off", "Shared Cockpit"),
			(b'AP_AIRSPEED_SET', "Sets airspeed hold on/off (1,0),", "Shared Cockpit"),
			(b'AP_MACH_ON', "Turns mach hold on", "Shared Cockpit"),
			(b'AP_MACH_OFF', "Turns mach hold off", "Shared Cockpit"),
			(b'AP_MACH_SET', "Sets mach hold on/off (1,0),", "Shared Cockpit"),
			(b'AP_PANEL_ALTITUDE_ON', "Turns altitude hold mode on (without capturing current altitude),", "Shared Cockpit"),
			(b'AP_PANEL_ALTITUDE_OFF', "Turns altitude hold mode off", "Shared Cockpit"),
			(b'AP_PANEL_ALTITUDE_SET', "Sets altitude hold mode on/off (1,0),", "Shared Cockpit"),
			(b'AP_PANEL_HEADING_ON', "Turns heading mode on (without capturing current heading),", "Shared Cockpit"),
			(b'AP_PANEL_HEADING_OFF', "Turns heading mode off", "Shared Cockpit"),
			(b'AP_PANEL_HEADING_SET', "Set heading mode on/off (1,0),", "Shared Cockpit"),
			(b'AP_PANEL_MACH_ON', "Turns on mach hold", "Shared Cockpit"),
			(b'AP_PANEL_MACH_OFF', "Turns off mach hold", "Shared Cockpit"),
			(b'AP_PANEL_MACH_SET', "Sets mach hold on/off (1,0),", "Shared Cockpit"),
			(b'AP_PANEL_SPEED_ON', "Turns on speed hold mode", "Shared Cockpit"),
			(b'AP_PANEL_SPEED_OFF', "Turns off speed hold mode", "Shared Cockpit"),
			(b'AP_PANEL_SPEED_SET', "Set speed hold mode on/off (1,0),", "Shared Cockpit"),
			(b'AP_ALT_VAR_SET_ENGLISH', "Sets altitude reference in feet", "Shared Cockpit"),
			(b'AP_VS_VAR_SET_METRIC', "Sets vertical speed reference in meters per minute", "Shared Cockpit"),
			(b'TOGGLE_FLIGHT_DIRECTOR', "Toggles flight director on/off", "Shared Cockpit"),
			(b'SYNC_FLIGHT_DIRECTOR_PITCH', "Synchronizes flight director pitch with current aircraft pitch", "Shared Cockpit"),
			(b'INCREASE_AUTOBRAKE_CONTROL', "Increments autobrake level", "Shared Cockpit"),
			(b'DECREASE_AUTOBRAKE_CONTROL', "Decrements autobrake level", "Shared Cockpit"),
			(b'AP_PANEL_SPEED_HOLD_TOGGLE', "Turns airspeed hold mode on with current airspeed", "Shared Cockpit"),
			(b'Unsupported', "Sets airspeed reference to current airspeed", "Shared Cockpit"),
			(b'AP_PANEL_MACH_HOLD_TOGGLE', "Sets mach hold reference to current mach", "Shared Cockpit"),
			(b'AP_NAV_SELECT_SET', "Sets the nav (1 or 2), which is used by the Nav hold modes", "Shared Cockpit"),
			(b'HEADING_BUG_SELECT', "Selects the heading bug for use with +/-", "Shared Cockpit"),
			(b'ALTITUDE_BUG_SELECT', "Selects the altitude reference for use with +/-", "Shared Cockpit"),
			(b'VSI_BUG_SELECT', "Selects the vertical speed reference for use with +/-", "Shared Cockpit"),
			(b'AIRSPEED_BUG_SELECT', "Selects the airspeed reference for use with +/-", "Shared Cockpit"),
			(b'AP_PITCH_REF_INC_UP', "Increments the pitch reference for pitch hold mode", "Shared Cockpit"),
			(b'AP_PITCH_REF_INC_DN', "Decrements the pitch reference for pitch hold mode", "Shared Cockpit"),
			(b'AP_PITCH_REF_SELECT', "Selects pitch reference for use with +/-", "Shared Cockpit"),
			(b'AP_ATT_HOLD', "Toggle attitude hold mode", "Shared Cockpit"),
			(b'AP_LOC_HOLD', "Toggles localizer (only), hold mode", "Shared Cockpit"),
			(b'AP_APR_HOLD', "Toggles approach hold (localizer and glide-slope),", "Shared Cockpit"),
			(b'AP_HDG_HOLD', "Toggles heading hold mode", "Shared Cockpit"),
			(b'AP_ALT_HOLD', "Toggles altitude hold mode", "Shared Cockpit"),
			(b'AP_WING_LEVELER', "Toggles wing leveler mode", "Shared Cockpit"),
			(b'AP_BC_HOLD', "Toggles the backcourse mode for the localizer hold", "Shared Cockpit"),
			(b'AP_NAV1_HOLD', "Toggles the nav hold mode", "Shared Cockpit"),
			(b'AP_MAX_BANK_INC', "Autopilot max bank angle increment.", "Shared Cockpit"),
			(b'AP_MAX_BANK_DEC', "Autopilot max bank angle decrement.", "Shared Cockpit"),
			(b'AP_N1_HOLD', "Autopilot, hold the N1 percentage at its current level.", "Shared Cockpit"),
			(b'AP_N1_REF_INC', "Increment the autopilot N1 reference.", "Shared Cockpit"),
			(b'AP_N1_REF_DEC', "Decrement the autopilot N1 reference.", "Shared Cockpit"),
			(b'AP_N1_REF_SET', "Sets the autopilot N1 reference.", "Shared Cockpit"),
			(b'FLY_BY_WIRE_ELAC_TOGGLE', "Turn on or off the fly by wire Elevators and Ailerons computer.", "Shared Cockpit"),
			(b'FLY_BY_WIRE_FAC_TOGGLE', "Turn on or off the fly by wire Flight Augmentation computer.", "Shared Cockpit"),
			(b'FLY_BY_WIRE_SEC_TOGGLE', "Turn on or off the fly by wire Spoilers and Elevators computer.", "Shared Cockpit"),
		]

	class __Fuel_System(EventHelper):
		list = [
			(b'FUEL_SELECTOR_OFF', "Turns selector 1 to OFF position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_ALL', "Turns selector 1 to ALL position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_LEFT', "Turns selector 1 to LEFT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_RIGHT', "Turns selector 1 to RIGHT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_LEFT_AUX', "Turns selector 1 to LEFT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_RIGHT_AUX', "Turns selector 1 to RIGHT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_CENTER', "Turns selector 1 to CENTER position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_SET', '''Sets selector 1 position (see code list below),
				FUEL_TANK_SELECTOR_OFF = 0
				FUEL_TANK_SELECTOR_ALL = 1
				FUEL_TANK_SELECTOR_LEFT = 2
				FUEL_TANK_SELECTOR_RIGHT = 3
				FUEL_TANK_SELECTOR_LEFT_AUX = 4
				FUEL_TANK_SELECTOR_RIGHT_AUX = 5
				FUEL_TANK_SELECTOR_CENTER = 6
				FUEL_TANK_SELECTOR_CENTER2 = 7
				FUEL_TANK_SELECTOR_CENTER3 = 8
				FUEL_TANK_SELECTOR_EXTERNAL1 = 9
				FUEL_TANK_SELECTOR_EXTERNAL2 = 10
				FUEL_TANK_SELECTOR_RIGHT_TIP = 11
				FUEL_TANK_SELECTOR_LEFT_TIP = 12
				FUEL_TANK_SELECTOR_CROSSFEED = 13
				FUEL_TANK_SELECTOR_CROSSFEED_L2R = 14
				FUEL_TANK_SELECTOR_CROSSFEED_R2L = 15
				FUEL_TANK_SELECTOR_BOTH = 16
				FUEL_TANK_SELECTOR_EXTERNAL_ALL = 17
				FUEL_TANK_SELECTOR_ISOLATE = 18''', "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_OFF', "Turns selector 2 to OFF position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_ALL', "Turns selector 2 to ALL position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_LEFT', "Turns selector 2 to LEFT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_RIGHT', "Turns selector 2 to RIGHT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_LEFT_AUX', "Turns selector 2 to LEFT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_RIGHT_AUX', "Turns selector 2 to RIGHT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_CENTER', "Turns selector 2 to CENTER position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_SET', "Sets selector 2 position (see code list below),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_OFF', "Turns selector 3 to OFF position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_ALL', "Turns selector 3 to ALL position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_LEFT', "Turns selector 3 to LEFT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_RIGHT', "Turns selector 3 to RIGHT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_LEFT_AUX', "Turns selector 3 to LEFT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_RIGHT_AUX', "Turns selector 3 to RIGHT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_CENTER', "Turns selector 3 to CENTER position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_SET', "Sets selector 3 position (see code list below),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_OFF', "Turns selector 4 to OFF position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_ALL', "Turns selector 4 to ALL position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_LEFT', "Turns selector 4 to LEFT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_RIGHT', "Turns selector 4 to RIGHT position (burns from tip then aux then main),", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_LEFT_AUX', "Turns selector 4 to LEFT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_RIGHT_AUX', "Turns selector 4 to RIGHT AUX position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_CENTER', "Turns selector 4 to CENTER position", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_SET', "Sets selector 4 position (see code list below),", "Shared Cockpit"),
			(b'CROSS_FEED_OPEN', "Opens cross feed valve (when used in conjunction with \"isolate\" tank),", "Shared Cockpit"),
			(b'CROSS_FEED_TOGGLE', "Toggles crossfeed valve (when used in conjunction with \"isolate\" tank),", "Shared Cockpit"),
			(b'CROSS_FEED_OFF', "Closes crossfeed valve (when used in conjunction with \"isolate\" tank),", "Shared Cockpit"),
			(b'FUEL_DUMP_SWITCH_SET', "Set to True or False. The switch can only be set to True if fuel_dump_rate is specified in the aircraft configuration file, which indicates that a fuel dump system exists.", "Shared Cockpit"),
			(b'ANTIDETONATION_TANK_VALVE_TOGGLE', "Toggle the antidetonation valve. Pass a value to determine which tank, if there are multiple tanks, to use. Tanks are indexed from 1. Refer to the document Notes on Aircraft Systems.", "Shared Cockpit"),
			(b'NITROUS_TANK_VALVE_TOGGLE', "Toggle the nitrous valve. Pass a value to determine which tank, if there are multiple tanks, to use. Tanks are indexed from 1.", "Shared Cockpit"),
			(b'REPAIR_AND_REFUEL', "Fully repair and refuel the user aircraft. Ignored if flight realism is enforced.", "Shared Cockpit"),
			(b'FUEL_DUMP_TOGGLE', "Turns on or off the fuel dump switch.", "Shared Cockpit"),
			(b'REQUEST_FUEL_KEY', "Request a fuel truck. The aircraft must be in a parking spot for this to be successful.", "Shared Cockpit"),
		]

	class __Fuel_Selection_Keys(EventHelper):
		list = [
			(b'FUEL_SELECTOR_LEFT_MAIN', "Sets the fuel selector. Fuel will be taken in the order left tip, left aux, then main fuel tanks.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_LEFT_MAIN', "Sets the fuel selector for engine 2.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_LEFT_MAIN', "Sets the fuel selector for engine 3.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_LEFT_MAIN', "Sets the fuel selector for engine 4.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_RIGHT_MAIN', "Sets the fuel selector. Fuel will be taken in the order right tip, right aux, then main fuel tanks.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_2_RIGHT_MAIN', "Sets the fuel selector for engine 2.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_3_RIGHT_MAIN', "Sets the fuel selector for engine 3.", "Shared Cockpit"),
			(b'FUEL_SELECTOR_4_RIGHT_MAIN', "Sets the fuel selector for engine 4.", "Shared Cockpit"),
		]

	class __Avionics(EventHelper):
		list = [
			(b'XPNDR', "Sequentially selects the transponder digits for use with +/-.", "Shared Cockpit"),
			(b'ADF', "Sequentially selects the ADF tuner digits for use with +/-. Follow by KEY_SELECT_2 for ADF 2.", "Shared Cockpit"),
			(b'DME', "Selects the DME for use with +/-", "Shared Cockpit"),
			(b'COM_RADIO', "Sequentially selects the COM tuner digits for use with +/-. Follow by KEY_SELECT_2 for COM 2.", "All aircraft"),
			(b'VOR_OBS', "Sequentially selects the VOR OBS for use with +/-. Follow by KEY_SELECT_2 for VOR 2.", "Shared Cockpit"),
			(b'NAV_RADIO', "Sequentially selects the NAV tuner digits for use with +/-. Follow by KEY_SELECT_2 for NAV 2.", "Shared Cockpit"),
			(b'COM_RADIO_WHOLE_DEC', "Decrements COM by one MHz", "All aircraft"),
			(b'COM_RADIO_WHOLE_INC', "Increments COM by one MHz", "All aircraft"),
			(b'COM_RADIO_FRACT_DEC', "Decrements COM by 25 KHz", "All aircraft"),
			(b'COM_RADIO_FRACT_INC', "Increments COM by 25 KHz", "All aircraft"),
			(b'NAV1_RADIO_WHOLE_DEC', "Decrements Nav 1 by one MHz", "Shared Cockpit"),
			(b'NAV1_RADIO_WHOLE_INC', "Increments Nav 1 by one MHz", "Shared Cockpit"),
			(b'NAV1_RADIO_FRACT_DEC', "Decrements Nav 1 by 25 KHz", "Shared Cockpit"),
			(b'NAV1_RADIO_FRACT_INC', "Increments Nav 1 by 25 KHz", "Shared Cockpit"),
			(b'NAV2_RADIO_WHOLE_DEC', "Decrements Nav 2 by one MHz", "Shared Cockpit"),
			(b'NAV2_RADIO_WHOLE_INC', "Increments Nav 2 by one MHz", "Shared Cockpit"),
			(b'NAV2_RADIO_FRACT_DEC', "Decrements Nav 2 by 25 KHz", "Shared Cockpit"),
			(b'NAV2_RADIO_FRACT_INC', "Increments Nav 2 by 25 KHz", "Shared Cockpit"),
			(b'ADF_100_INC', "Increments ADF by 100 KHz", "Shared Cockpit"),
			(b'ADF_10_INC', "Increments ADF by 10 KHz", "Shared Cockpit"),
			(b'ADF_1_INC', "Increments ADF by 1 KHz", "Shared Cockpit"),
			(b'XPNDR_1000_INC', "Increments first digit of transponder", "Shared Cockpit"),
			(b'XPNDR_100_INC', "Increments second digit of transponder", "Shared Cockpit"),
			(b'XPNDR_10_INC', "Increments third digit of transponder", "Shared Cockpit"),
			(b'XPNDR_1_INC', "Increments fourth digit of transponder", "Shared Cockpit"),
			(b'VOR1_OBI_DEC', "Decrements the VOR 1 OBS setting", "Shared Cockpit"),
			(b'VOR1_OBI_INC', "Increments the VOR 1 OBS setting", "Shared Cockpit"),
			(b'VOR2_OBI_DEC', "Decrements the VOR 2 OBS setting", "Shared Cockpit"),
			(b'VOR2_OBI_INC', "Increments the VOR 2 OBS setting", "Shared Cockpit"),
			(b'ADF_100_DEC', "Decrements ADF by 100 KHz", "Shared Cockpit"),
			(b'ADF_10_DEC', "Decrements ADF by 10 KHz", "Shared Cockpit"),
			(b'ADF_1_DEC', "Decrements ADF by 1 KHz", "Shared Cockpit"),
			(b'COM_RADIO_SET', "Sets COM frequency (BCD Hz),", "All aircraft"),
			(b'NAV1_RADIO_SET', "Sets NAV 1 frequency (BCD Hz),", "Shared Cockpit"),
			(b'NAV2_RADIO_SET', "Sets NAV 2 frequency (BCD Hz),", "Shared Cockpit"),
			(b'ADF_SET', "Sets ADF frequency (BCD Hz),", "Shared Cockpit"),
			(b'XPNDR_SET', "Sets transponder code (BCD),", "All aircraft"),
			(b'VOR1_SET', "Sets OBS 1 (0 to 360),", "Shared Cockpit"),
			(b'VOR2_SET', "Sets OBS 2 (0 to 360),", "Shared Cockpit"),
			(b'DME1_TOGGLE', "Sets DME display to Nav 1", "Shared Cockpit"),
			(b'DME2_TOGGLE', "Sets DME display to Nav 2", "Shared Cockpit"),
			(b'RADIO_VOR1_IDENT_DISABLE', "Turns NAV 1 ID off", "Shared Cockpit"),
			(b'RADIO_VOR2_IDENT_DISABLE', "Turns NAV 2 ID off", "Shared Cockpit"),
			(b'RADIO_DME1_IDENT_DISABLE', "Turns DME 1 ID off", "Shared Cockpit"),
			(b'RADIO_DME2_IDENT_DISABLE', "Turns DME 2 ID off", "Shared Cockpit"),
			(b'RADIO_ADF_IDENT_DISABLE', "Turns ADF 1 ID off", "Shared Cockpit"),
			(b'RADIO_VOR1_IDENT_ENABLE', "Turns NAV 1 ID on", "Shared Cockpit"),
			(b'RADIO_VOR2_IDENT_ENABLE', "Turns NAV 2 ID on", "Shared Cockpit"),
			(b'RADIO_DME1_IDENT_ENABLE', "Turns DME 1 ID on", "Shared Cockpit"),
			(b'RADIO_DME2_IDENT_ENABLE', "Turns DME 2 ID on", "Shared Cockpit"),
			(b'RADIO_ADF_IDENT_ENABLE', "Turns ADF 1 ID on", "Shared Cockpit"),
			(b'RADIO_VOR1_IDENT_TOGGLE', "Toggles NAV 1 ID", "Shared Cockpit"),
			(b'RADIO_VOR2_IDENT_TOGGLE', "Toggles NAV 2 ID", "Shared Cockpit"),
			(b'RADIO_DME1_IDENT_TOGGLE', "Toggles DME 1 ID", "Shared Cockpit"),
			(b'RADIO_DME2_IDENT_TOGGLE', "Toggles DME 2 ID", "Shared Cockpit"),
			(b'RADIO_ADF_IDENT_TOGGLE', "Toggles ADF 1 ID", "Shared Cockpit"),
			(b'RADIO_VOR1_IDENT_SET', "Sets NAV 1 ID (on/off),", "Shared Cockpit"),
			(b'RADIO_VOR2_IDENT_SET', "Sets NAV 2 ID (on/off),", "Shared Cockpit"),
			(b'RADIO_DME1_IDENT_SET', "Sets DME 1 ID (on/off),", "Shared Cockpit"),
			(b'RADIO_DME2_IDENT_SET', "Sets DME 2 ID (on/off),", "Shared Cockpit"),
			(b'RADIO_ADF_IDENT_SET', "Sets ADF 1 ID (on/off),", "Shared Cockpit"),
			(b'ADF_CARD_INC', "Increments ADF card", "Shared Cockpit"),
			(b'ADF_CARD_DEC', "Decrements ADF card", "Shared Cockpit"),
			(b'ADF_CARD_SET', "Sets ADF card (0-360),", "Shared Cockpit"),
			(b'TOGGLE_DME', "Toggles between NAV 1 and NAV 2", "Shared Cockpit"),
			(b'AVIONICS_MASTER_SET', "Sets the avionics master switch", "All aircraft"),
			(b'TOGGLE_AVIONICS_MASTER', "Toggles the avionics master switch", "All aircraft"),
			(b'COM_STBY_RADIO_SET', "Sets COM 1 standby frequency (BCD Hz),", "All aircraft"),
			(b'COM_STBY_RADIO_SWAP', "Swaps COM 1 frequency with standby", "All aircraft"),
			(b'COM_RADIO_FRACT_DEC_CARRY', "Decrement COM 1 frequency by 25 KHz, and carry when digit wraps", "All aircraft"),
			(b'COM_RADIO_FRACT_INC_CARRY', "Increment COM 1 frequency by 25 KHz, and carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_WHOLE_DEC', "Decrement COM 2 frequency by 1 MHz, with no carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_WHOLE_INC', "Increment COM 2 frequency by 1 MHz, with no carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_FRACT_DEC', "Decrement COM 2 frequency by 25 KHz, with no carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_FRACT_DEC_CARRY', "Decrement COM 2 frequency by 25 KHz, and carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_FRACT_INC', "Increment COM 2 frequency by 25 KHz, with no carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_FRACT_INC_CARRY', "Increment COM 2 frequency by 25 KHz, and carry when digit wraps", "All aircraft"),
			(b'COM2_RADIO_SET', "Sets COM 2 frequency (BCD Hz),", "All aircraft"),
			(b'COM2_STBY_RADIO_SET', "Sets COM 2 standby frequency (BCD Hz),", "All aircraft"),
			(b'COM2_RADIO_SWAP', "Swaps COM 2 frequency with standby", "All aircraft"),
			(b'NAV1_RADIO_FRACT_DEC_CARRY', "Decrement NAV 1 frequency by 50 KHz, and carry when digit wraps", "Shared Cockpit"),
			(b'NAV1_RADIO_FRACT_INC_CARRY', "Increment NAV 1 frequency by 50 KHz, and carry when digit wraps", "Shared Cockpit"),
			(b'NAV1_STBY_SET', "Sets NAV 1 standby frequency (BCD Hz),", "Shared Cockpit"),
			(b'NAV1_RADIO_SWAP', "Swaps NAV 1 frequency with standby", "Shared Cockpit"),
			(b'NAV2_RADIO_FRACT_DEC_CARRY', "Decrement NAV 2 frequency by 50 KHz, and carry when digit wraps", "Shared Cockpit"),
			(b'NAV2_RADIO_FRACT_INC_CARRY', "Increment NAV 2 frequency by 50 KHz, and carry when digit wraps", "Shared Cockpit"),
			(b'NAV2_STBY_SET', "Sets NAV 2 standby frequency (BCD Hz),", "Shared Cockpit"),
			(b'NAV2_RADIO_SWAP', "Swaps NAV 2 frequency with standby", "Shared Cockpit"),
			(b'ADF1_RADIO_TENTHS_DEC', "Decrements ADF 1 by 0.1 KHz.", "Shared Cockpit"),
			(b'ADF1_RADIO_TENTHS_INC', "Increments ADF 1 by 0.1 KHz.", "Shared Cockpit"),
			(b'XPNDR_1000_DEC', "Decrements first digit of transponder", "Shared Cockpit"),
			(b'XPNDR_100_DEC', "Decrements second digit of transponder", "Shared Cockpit"),
			(b'XPNDR_10_DEC', "Decrements third digit of transponder", "Shared Cockpit"),
			(b'XPNDR_1_DEC', "Decrements fourth digit of transponder", "Shared Cockpit"),
			(b'XPNDR_DEC_CARRY', "Decrements fourth digit of transponder, and with carry.", "Shared Cockpit"),
			(b'XPNDR_INC_CARRY', "Increments fourth digit of transponder, and with carry.", "Shared Cockpit"),
			(b'ADF_FRACT_DEC_CARRY', "Decrements ADF 1 frequency by 0.1 KHz, with carry", "Shared Cockpit"),
			(b'ADF_FRACT_INC_CARRY', "Increments ADF 1 frequency by 0.1 KHz, with carry", "Shared Cockpit"),
			(b'COM1_TRANSMIT_SELECT', "Selects COM 1 to transmit", "All aircraft"),
			(b'COM2_TRANSMIT_SELECT', "Selects COM 2 to transmit", "All aircraft"),
			(b'COM_RECEIVE_ALL_TOGGLE', "Toggles all COM radios to receive on", "All aircraft"),
			(b'COM_RECEIVE_ALL_SET', "Sets whether to receive on all COM radios (1,0),", "All aircraft"),
			(b'MARKER_SOUND_TOGGLE', "Toggles marker beacon sound on/off", "Shared Cockpit"),
			(b'Unsupported', "Sets marker beacon sound (1, 0),", "Shared Cockpit"),
			(b'ADF_COMPLETE_SET', "Sets ADF 1 frequency (BCD Hz),", "Shared Cockpit"),
			(b'ADF1_WHOLE_INC', "Increments ADF 1 by 1 KHz, with carry as digits wrap.", "Shared Cockpit"),
			(b'ADF1_WHOLE_DEC', "Decrements ADF 1 by 1 KHz, with carry as digits wrap.", "Shared Cockpit"),
			(b'ADF2_100_INC', "Increments the ADF 2 frequency 100 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_10_INC', "Increments the ADF 2 frequency 10 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_1_INC', "Increments the ADF 2 frequency 1 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_RADIO_TENTHS_INC', "Increments ADF 2 frequency 1/10 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_100_DEC', "Decrements the ADF 2 frequency 100 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_10_DEC', "Decrements the ADF 2 frequency 10 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_1_DEC', "Decrements the ADF 2 frequency 1 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_RADIO_TENTHS_DEC', "Decrements ADF 2 frequency 1/10 digit, with wrapping", "Shared Cockpit"),
			(b'ADF2_WHOLE_INC', "Increments ADF 2 by 1 KHz, with carry as digits wrap.", "Shared Cockpit"),
			(b'ADF2_WHOLE_DEC', "Decrements ADF 2 by 1 KHz, with carry as digits wrap.", "Shared Cockpit"),
			(b'ADF2_FRACT_DEC_CARRY', "Decrements ADF 2 frequency by 0.1 KHz, with carry", "Shared Cockpit"),
			(b'ADF2_FRACT_INC_CARRY', "Increments ADF 2 frequency by 0.1 KHz, with carry", "Shared Cockpit"),
			(b'ADF2_COMPLETE_SET', "Sets ADF 1 frequency (BCD Hz),", "Shared Cockpit"),
			(b'RADIO_ADF2_IDENT_DISABLE', "Turns ADF 2 ID off", "Shared Cockpit"),
			(b'RADIO_ADF2_IDENT_ENABLE', "Turns ADF 2 ID on", "Shared Cockpit"),
			(b'RADIO_ADF2_IDENT_TOGGLE', "Toggles ADF 2 ID", "Shared Cockpit"),
			(b'RADIO_ADF2_IDENT_SET', "Sets ADF 2 ID on/off (1,0),", "Shared Cockpit"),
			(b'FREQUENCY_SWAP', "Swaps frequency with standby on whichever NAV or COM radio is selected.", "Shared Cockpit"),
			(b'TOGGLE_GPS_DRIVES_NAV1', "Toggles between GPS and NAV 1 driving NAV 1 OBS display (and AP),", "Shared Cockpit"),
			(b'GPS_POWER_BUTTON', "Toggles power button", "Shared Cockpit"),
			(b'GPS_NEAREST_BUTTON', "Selects Nearest Airport Page", "Shared Cockpit"),
			(b'GPS_OBS_BUTTON', "Toggles automatic sequencing of waypoints", "Shared Cockpit"),
			(b'GPS_MSG_BUTTON', "Toggles the Message Page", "Shared Cockpit"),
			(b'GPS_MSG_BUTTON_DOWN', "Triggers the pressing of the message button.", "Shared Cockpit"),
			(b'GPS_MSG_BUTTON_UP', "Triggers the release of the message button", "Shared Cockpit"),
			(b'GPS_FLIGHTPLAN_BUTTON', "Displays the programmed flightplan.", "Shared Cockpit"),
			(b'GPS_TERRAIN_BUTTON', "Displays terrain information on default display", "Shared Cockpit"),
			(b'GPS_PROCEDURE_BUTTON', "Displays the approach procedure page.", "Shared Cockpit"),
			(b'GPS_ZOOMIN_BUTTON', "Zooms in default display", "Shared Cockpit"),
			(b'GPS_ZOOMOUT_BUTTON', "Zooms out default display", "Shared Cockpit"),
			(b'GPS_DIRECTTO_BUTTON', "Brings up the \"Direct To\" page", "Shared Cockpit"),
			(b'GPS_MENU_BUTTON', "Brings up page to select active legs in a flightplan.", "Shared Cockpit"),
			(b'GPS_CLEAR_BUTTON', "Clears entered data on a page", "Shared Cockpit"),
			(b'GPS_CLEAR_ALL_BUTTON', "Clears all data immediately", "Shared Cockpit"),
			(b'GPS_CLEAR_BUTTON_DOWN', "Triggers the pressing of the Clear button", "Shared Cockpit"),
			(b'GPS_CLEAR_BUTTON_UP', "Triggers the release of the Clear button.", "Shared Cockpit"),
			(b'GPS_ENTER_BUTTON', "Approves entered data.", "Shared Cockpit"),
			(b'GPS_CURSOR_BUTTON', "Selects GPS cursor", "Shared Cockpit"),
			(b'GPS_GROUP_KNOB_INC', "Increments cursor", "Shared Cockpit"),
			(b'GPS_GROUP_KNOB_DEC', "Decrements cursor", "Shared Cockpit"),
			(b'GPS_PAGE_KNOB_INC', "Increments through pages", "Shared Cockpit"),
			(b'GPS_PAGE_KNOB_DEC', "Decrements through pages", "Shared Cockpit"),
			(b'DME_SELECT', "Selects one of the two DME systems (1,2),.", "Shared Cockpit"),
			(b'RADIO_SELECTED_DME_IDENT_ENABLE', "Turns on the identification sound for the selected DME.", "Shared Cockpit"),
			(b'RADIO_SELECTED_DME_IDENT_DISABLE', "Turns off the identification sound for the selected DME.", "Shared Cockpit"),
			(b'RADIO_SELECTED_DME_IDENT_SET', "Sets the DME identification sound to the given filename.", "Shared Cockpit"),
			(b'RADIO_SELECTED_DME_IDENT_TOGGLE', "Turns on or off the identification sound for the selected DME.", "Shared Cockpit"),
		]

	class __Instruments(EventHelper):
		list = [
			(b'EGT', "Selects EGT bug for +/-", "Shared Cockpit"),
			(b'EGT_INC', "Increments EGT bugs", "Shared Cockpit"),
			(b'EGT_DEC', "Decrements EGT bugs", "Shared Cockpit"),
			(b'EGT_SET', "Sets EGT bugs (0 to 32767),", "Shared Cockpit"),
			(b'BAROMETRIC', "Syncs altimeter setting to sea level pressure, or 29.92 if above 18000 feet", "Shared Cockpit"),
			(b'GYRO_DRIFT_INC', "Increments heading indicator", "Shared Cockpit"),
			(b'GYRO_DRIFT_DEC', "Decrements heading indicator", "Shared Cockpit"),
			(b'KOHLSMAN_INC', "Increments altimeter setting", "Shared Cockpit"),
			(b'KOHLSMAN_DEC', "Decrements altimeter setting", "Shared Cockpit"),
			(b'KOHLSMAN_SET', "Sets altimeter setting (Millibars * 16),", "Shared Cockpit"),
			(b'TRUE_AIRSPEED_CAL_INC', "Increments airspeed indicators true airspeed reference card", "Shared Cockpit"),
			(b'TRUE_AIRSPEED_CAL_DEC', "Decrements airspeed indicators true airspeed reference card", "Shared Cockpit"),
			(b'TRUE_AIRSPEED_CAL_SET', "Sets airspeed indicators true airspeed reference card (degrees, where 0 is standard sea level conditions),", "Shared Cockpit"),
			(b'EGT1_INC', "Increments EGT bug 1", "Shared Cockpit"),
			(b'EGT1_DEC', "Decrements EGT bug 1", "Shared Cockpit"),
			(b'EGT1_SET', "Sets EGT bug 1 (0 to 32767),", "Shared Cockpit"),
			(b'EGT2_INC', "Increments EGT bug 2", "Shared Cockpit"),
			(b'EGT2_DEC', "Decrements EGT bug 2", "Shared Cockpit"),
			(b'EGT2_SET', "Sets EGT bug 2 (0 to 32767),", "Shared Cockpit"),
			(b'EGT3_INC', "Increments EGT bug 3", "Shared Cockpit"),
			(b'EGT3_DEC', "Decrements EGT bug 3", "Shared Cockpit"),
			(b'EGT3_SET', "Sets EGT bug 3 (0 to 32767),", "Shared Cockpit"),
			(b'EGT4_INC', "Increments EGT bug 4", "Shared Cockpit"),
			(b'EGT4_DEC', "Decrements EGT bug 4", "Shared Cockpit"),
			(b'EGT4_SET', "Sets EGT bug 4 (0 to 32767),", "Shared Cockpit"),
			(b'ATTITUDE_BARS_POSITION_UP', "Increments attitude indicator pitch reference bars", "Shared Cockpit"),
			(b'ATTITUDE_BARS_POSITION_DOWN', "Decrements attitude indicator pitch reference bars", "Shared Cockpit"),
			(b'ATTITUDE_CAGE_BUTTON', "Cages attitude indicator at 0 pitch and bank", "Shared Cockpit"),
			(b'RESET_G_FORCE_INDICATOR', "Resets max/min indicated G force to 1.0.", "Shared Cockpit"),
			(b'RESET_MAX_RPM_INDICATOR', "Reset max indicated engine rpm to 0.", "Shared Cockpit"),
			(b'HEADING_GYRO_SET', "Sets heading indicator to 0 drift error.", "Shared Cockpit"),
			(b'GYRO_DRIFT_SET', "Sets heading indicator drift angle (degrees),.", "Shared Cockpit"),
		]

	class __Lights(EventHelper):
		list = [
			(b'STROBES_TOGGLE', "Toggle strobe lights ", "All aircraft"),
			(b'ALL_LIGHTS_TOGGLE', "Toggle all lights", "Shared Cockpit"),
			(b'PANEL_LIGHTS_TOGGLE', "Toggle panel lights", "All aircraft"),
			(b'LANDING_LIGHTS_TOGGLE', "Toggle landing lights", "All aircraft"),
			(b'LANDING_LIGHT_UP', "Rotate landing light up", "Shared Cockpit"),
			(b'LANDING_LIGHT_DOWN', "Rotate landing light down", "Shared Cockpit"),
			(b'LANDING_LIGHT_LEFT', "Rotate landing light left", "Shared Cockpit"),
			(b'LANDING_LIGHT_RIGHT', "Rotate landing light right", "Shared Cockpit"),
			(b'LANDING_LIGHT_HOME', "Return landing light to default position", "Shared Cockpit"),
			(b'STROBES_ON', "Turn strobe lights on", "All aircraft"),
			(b'STROBES_OFF', "Turn strobe light off", "All aircraft"),
			(b'STROBES_SET', "Set strobe lights on/off (1,0),", "All aircraft"),
			(b'PANEL_LIGHTS_ON', "Turn panel lights on", "All aircraft"),
			(b'PANEL_LIGHTS_OFF', "Turn panel lights off", "All aircraft"),
			(b'PANEL_LIGHTS_SET', "Set panel lights on/off (1,0),", "All aircraft"),
			(b'LANDING_LIGHTS_ON', "Turn landing lights on", "All aircraft"),
			(b'LANDING_LIGHTS_OFF', "Turn landing lights off", "All aircraft"),
			(b'LANDING_LIGHTS_SET', "Set landing lights on/off (1,0),", "All aircraft"),
			(b'TOGGLE_BEACON_LIGHTS', "Toggle beacon lights", "All aircraft"),
			(b'TOGGLE_TAXI_LIGHTS', "Toggle taxi lights", "All aircraft"),
			(b'TOGGLE_LOGO_LIGHTS', "Toggle logo lights", "All aircraft"),
			(b'TOGGLE_RECOGNITION_LIGHTS', "Toggle recognition lights", "All aircraft"),
			(b'TOGGLE_WING_LIGHTS', "Toggle wing lights", "All aircraft"),
			(b'TOGGLE_NAV_LIGHTS', "Toggle navigation lights", "All aircraft"),
			(b'TOGGLE_CABIN_LIGHTS', "Toggle cockpit/cabin lights", "All aircraft"),
		]

	class __Failures(EventHelper):
		list = [
			(b'TOGGLE_VACUUM_FAILURE', "Toggle vacuum system failure", "Shared Cockpit"),
			(b'TOGGLE_ELECTRICAL_FAILURE', "Toggle electrical system failure", "Shared Cockpit"),
			(b'TOGGLE_PITOT_BLOCKAGE', "Toggles blocked pitot tube", "Shared Cockpit"),
			(b'TOGGLE_STATIC_PORT_BLOCKAGE', " Toggles blocked static port", "Shared Cockpit"),
			(b'TOGGLE_HYDRAULIC_FAILURE', "Toggles hydraulic system failure", "Shared Cockpit"),
			(b'TOGGLE_TOTAL_BRAKE_FAILURE', "Toggles brake failure (both),", "Shared Cockpit"),
			(b'TOGGLE_LEFT_BRAKE_FAILURE', "Toggles left brake failure", "Shared Cockpit"),
			(b'TOGGLE_RIGHT_BRAKE_FAILURE', "Toggles right brake failure", "Shared Cockpit"),
			(b'TOGGLE_ENGINE1_FAILURE', "Toggle engine 1 failure", "Shared Cockpit"),
			(b'TOGGLE_ENGINE2_FAILURE', "Toggle engine 2 failure", "Shared Cockpit"),
			(b'TOGGLE_ENGINE3_FAILURE', "Toggle engine 3 failure", "Shared Cockpit"),
			(b'TOGGLE_ENGINE4_FAILURE', "Toggle engine 4 failure", "Shared Cockpit"),
		]

	class __Miscellaneous_Systems(EventHelper):
		list = [
			(b'SMOKE_TOGGLE', "Toggle smoke system switch", "All aircraft"),
			(b'GEAR_TOGGLE', "Toggle gear handle", "All aircraft"),
			(b'BRAKES', "Increment brake pressure ", "Shared Cockpit"),
			(b'GEAR_SET', "Sets gear handle position up/down (0,1),", "All aircraft"),
			(b'BRAKES_LEFT', "Increments left brake pressure", "Shared Cockpit"),
			(b'BRAKES_RIGHT', "Increments right brake pressure", "Shared Cockpit"),
			(b'PARKING_BRAKES', "Toggles parking brake on/off", "Shared Cockpit"),
			(b'GEAR_PUMP', "Increments emergency gear extension", "Shared Cockpit"),
			(b'PITOT_HEAT_TOGGLE', "Toggles pitot heat switch", "All aircraft"),
			(b'SMOKE_ON', "Turns smoke system on", "All aircraft"),
			(b'SMOKE_OFF', "Turns smoke system off", "All aircraft"),
			(b'SMOKE_SET', "Sets smoke system on/off (1,0),", "All aircraft"),
			(b'PITOT_HEAT_ON', "Turns pitot heat switch on", "Shared Cockpit"),
			(b'PITOT_HEAT_OFF', "Turns pitot heat switch off", "Shared Cockpit"),
			(b'PITOT_HEAT_SET', "Sets pitot heat switch on/off (1,0),", "Shared Cockpit"),
			(b'GEAR_UP', "Sets gear handle in UP position", "All aircraft"),
			(b'GEAR_DOWN', "Sets gear handle in DOWN position", "All aircraft"),
			(b'TOGGLE_MASTER_BATTERY', "Toggles main battery switch", "All aircraft"),
			(b'TOGGLE_MASTER_ALTERNATOR', "Toggles main alternator/generator switch", "All aircraft"),
			(b'TOGGLE_ELECTRIC_VACUUM_PUMP', "Toggles backup electric vacuum pump", "Shared Cockpit"),
			(b'TOGGLE_ALTERNATE_STATIC', "Toggles alternate static pressure port", "All aircraft"),
			(b'DECREASE_DECISION_HEIGHT', "Decrements decision height reference", "Shared Cockpit"),
			(b'INCREASE_DECISION_HEIGHT', "Increments decision height reference", "Shared Cockpit"),
			(b'TOGGLE_STRUCTURAL_DEICE', "Toggles structural deice switch", "Shared Cockpit"),
			(b'TOGGLE_PROPELLER_DEICE', "Toggles propeller deice switch", "Shared Cockpit"),
			(b'TOGGLE_ALTERNATOR1', "Toggles alternator/generator 1 switch", "All aircraft"),
			(b'TOGGLE_ALTERNATOR2', "Toggles alternator/generator 2 switch", "All aircraft"),
			(b'TOGGLE_ALTERNATOR3', "Toggles alternator/generator 3 switch", "All aircraft"),
			(b'TOGGLE_ALTERNATOR4', "Toggles alternator/generator 4 switch", "All aircraft"),
			(b'TOGGLE_MASTER_BATTERY_ALTERNATOR', "Toggles master battery and alternator switch", "Shared Cockpit"),
			(b'AXIS_LEFT_BRAKE_SET', "Sets left brake position from axis controller (e.g. joystick),. -16383 (0 brakes) to +16383 (max brakes)", "Shared Cockpit"),
			(b'AXIS_RIGHT_BRAKE_SET', "Sets right brake position from axis controller (e.g. joystick),. -16383 (0 brakes) to +16383 (max brakes)", "Shared Cockpit"),
			(b'TOGGLE_AIRCRAFT_EXIT', "Toggles primary door open/close. Follow by KEY_SELECT_2, etc for subsequent doors.", "Shared Cockpit"),
			(b'TOGGLE_WING_FOLD', "Toggles wing folding", "Shared Cockpit"),
			(b'SET_WING_FOLD', '''Sets the wings into the folded position suitable for storage, typically on a carrier. Takes a value:
				1 - fold wings,
				0 - unfold wings''', "Shared Cockpit"),
			(b'TOGGLE_TAIL_HOOK_HANDLE', "Toggles tail hook", "Shared Cockpit"),
			(b'SET_TAIL_HOOK_HANDLE', '''Sets the tail hook handle. Takes a value:
				1 - set tail hook,
				0 - retract tail hook''', "Shared Cockpit"),
			(b'TOGGLE_WATER_RUDDER', "Toggles water rudders", "Shared Cockpit"),
			(b'TOGGLE_PUSHBACK', "Toggles pushback.", "Shared Cockpit"),
			(b'KEY_TUG_HEADING', "Triggers tug and sets the desired heading. The units are a 32 bit integer (0 to 4294967295), which represent 0 to 360 degrees. To set a 45 degree angle, for example, set the value to 4294967295 / 8.", "Shared Cockpit"),
			(b'KEY_TUG_SPEED', "Triggers tug, and sets desired speed, in feet per second. The speed can be both positive (forward movement), and negative (backward movement).", "Shared Cockpit"),
			(b'TUG_DISABLE', "Disables tug", "Shared Cockpit"),
			(b'TOGGLE_MASTER_IGNITION_SWITCH', "Toggles master ignition switch", "Shared Cockpit"),
			(b'TOGGLE_TAILWHEEL_LOCK', "Toggles tail wheel lock", "Shared Cockpit"),
			(b'ADD_FUEL_QUANTITY', "Adds fuel to the aircraft, 25% of capacity by default. 0 to 65535 (max fuel), can be passed.", "Shared Cockpit"),
			(b'TOW_PLANE_RELEASE', "Release a towed aircraft, usually a glider.", "Shared Cockpit"),
			(b'TOW_PLANE_REQUEST', "Request a tow plane. The user aircraft must be tow-able, stationary, on the ground and not already attached for this to succeed.", "Shared Cockpit"),
			(b'RELEASE_DROPPABLE_OBJECTS', "Release one droppable object. Multiple key events will release multiple objects.", "Shared Cockpit"),
			(b'RETRACT_FLOAT_SWITCH_DEC', "If the plane has retractable floats, moves the retract position from Extend to Neutral, or Neutral to Retract.", "Shared Cockpit"),
			(b'RETRACT_FLOAT_SWITCH_INC', "If the plane has retractable floats, moves the retract position from Retract to Neutral, or Neutral to Extend.", "Shared Cockpit"),
			(b'TOGGLE_WATER_BALLAST_VALVE', "Turn the water ballast valve on or off.", "Shared Cockpit"),
			(b'TOGGLE_VARIOMETER_SWITCH', "Turn the variometer on or off.", "Shared Cockpit"),
			(b'TOGGLE_TURN_INDICATOR_SWITCH', "Turn the turn indicator on or off.", "Shared Cockpit"),
			(b'APU_STARTER', "Start up the auxiliary power unit (APU),.", "Shared Cockpit"),
			(b'APU_OFF_SWITCH', "Turn the APU off.", "Shared Cockpit"),
			(b'APU_GENERATOR_SWITCH_TOGGLE', "Turn the auxiliary generator on or off.", "Shared Cockpit"),
			(b'APU_GENERATOR_SWITCH_SET', "Set the auxiliary generator switch (0,1),.", "Shared Cockpit"),
			(b'EXTINGUISH_ENGINE_FIRE', "Takes a two digit argument.  The first digit represents the fire extinguisher index, and the second represents the engine index.  For example,  11 would represent using bottle 1 on engine 1.  21 would represent using bottle 2 on engine 1.  Typical entries for a twin engine aircraft would be 11 and 22.", "Shared Cockpit"),
			(b'HYDRAULIC_SWITCH_TOGGLE', "Turn the hydraulic switch on or off.", "Shared Cockpit"),
			(b'BLEED_AIR_SOURCE_CONTROL_INC', "Increases the bleed air source control.", "Shared Cockpit"),
			(b'BLEED_AIR_SOURCE_CONTROL_DEC', "Decreases the bleed air source control.", "Shared Cockpit"),
			(b'BLEED_AIR_SOURCE_CONTROL_SET', '''Set to one of:
				0: auto
				1: off
				2: apu
				3: engines''', "Shared Cockpit"),
			(b'TURBINE_IGNITION_SWITCH_TOGGLE', "Turn the turbine ignition switch on or off.", "Shared Cockpit"),
			(b'CABIN_NO_SMOKING_ALERT_SWITCH_TOGGLE', "Turn the \"No smoking\" alert on or off.", "Shared Cockpit"),
			(b'CABIN_SEATBELTS_ALERT_SWITCH_TOGGLE', "Turn the \"Fasten seatbelts\" alert on or off.", "Shared Cockpit"),
			(b'ANTISKID_BRAKES_TOGGLE', "Turn the anti-skid braking system on or off.", "Shared Cockpit"),
			(b'GPWS_SWITCH_TOGGLE', "Turn the g round proximity warning system (GPWS), on or off.", "Shared Cockpit"),
			(b'MANUAL_FUEL_PRESSURE_PUMP', "Activate the manual fuel pressure pump.", "Shared Cockpit"),
		]

	class __Nose_wheel_steering(EventHelper):
		list = [
			(b'STEERING_INC', "Increments the nose wheel steering position by 5 percent.", "Shared Cockpit"),
			(b'STEERING_DEC', "Decrements the nose wheel steering position by 5 percent.", "Shared Cockpit"),
			(b'STEERING_SET', "Sets the value of the nose wheel steering position. Zero is straight ahead (-16383, far left +16383, far right),.", "Shared Cockpit"),
		]

	class __Cabin_pressurization(EventHelper):
		list = [
			(b'KEY_PRESSURIZATION_PRESSURE_ALT_INC', "Increases the altitude that the cabin is pressurized to.", "Shared Cockpit"),
			(b'KEY_PRESSURIZATION_PRESSURE_ALT_DEC', "Decreases the altitude that the cabin is pressurized to.", "Shared Cockpit"),
			(b'PRESSURIZATION_CLIMB_RATE_INC', "Sets the rate at which cabin pressurization is increased.", "Shared Cockpit"),
			(b'PRESSURIZATION_CLIMB_RATE_DEC', "Sets the rate at which cabin pressurization is decreased.", "Shared Cockpit"),
			(b'PRESSURIZATION_PRESSURE_DUMP_SWTICH', '''Sets the cabin pressure to the outside air pressure.''', "Shared Cockpit"),
		]

	class __Catapult_Launches(EventHelper):
		list = [
			(b'TAKEOFF_ASSIST_ARM_TOGGLE', "Deploy or remove the assist arm. Refer to the document Notes on Aircraft Systems.", "Shared Cockpit"),
			(b'TAKEOFF_ASSIST_ARM_SET', '''Value:
				TRUE request set
				FALSE request unset''', "Shared Cockpit"),
			(b'TAKEOFF_ASSIST_FIRE', "If everything is set up correctly. Launch from the catapult.", "Shared Cockpit"),
			(b'TOGGLE_LAUNCH_BAR_SWITCH', "Toggle the request for the launch bar to be installed or removed.", "Shared Cockpit"),
			(b'SET_LAUNCH_BAR_SWITCH', '''Value:
				TRUE request set
				FALSE request unset''', "Shared Cockpit"),
		]

	class __Helicopter_Specific_Systems(EventHelper):
		list = [
			(b'ROTOR_BRAKE', " Triggers rotor braking input", "Shared Cockpit"),
			(b'ROTOR_CLUTCH_SWITCH_TOGGLE', "Toggles on electric rotor clutch switch", "Shared Cockpit"),
			(b'ROTOR_CLUTCH_SWITCH_SET', "Sets electric rotor clutch switch on/off (1,0),", "Shared Cockpit"),
			(b'ROTOR_GOV_SWITCH_TOGGLE', "Toggles the electric rotor governor switch", "Shared Cockpit"),
			(b'ROTOR_GOV_SWITCH_SET', "Sets the electric rotor governor switch on/off (1,0),", "Shared Cockpit"),
			(b'ROTOR_LATERAL_TRIM_INC', "Increments the lateral (right), rotor trim", "Shared Cockpit"),
			(b'ROTOR_LATERAL_TRIM_DEC', "Decrements the lateral (right), rotor trim", "Shared Cockpit"),
			(b'ROTOR_LATERAL_TRIM_SET', "Sets the lateral (right), rotor trim (0 to 16383)", "Shared Cockpit"),
		]

	class __Slings_and_Hoists(EventHelper):
		list = [
			(b'SLING_PICKUP_RELEASE', "Toggle between pickup and release mode. Hold mode is automatic and cannot be selected. Refer to the document Notes on Aircraft Systems.", "Shared Cockpit"),
			(b'HOIST_SWITCH_EXTEND', "The rate at which a hoist cable extends is set in the Aircraft Configuration File.", "Shared Cockpit"),
			(b'HOIST_SWITCH_RETRACT', "The rate at which a hoist cable retracts is set in the Aircraft Configuration File.", "Shared Cockpit"),
			(b'HOIST_SWITCH_SET', '''The data value should be set to one of:
				<0 up
				=0 off
				>0 down''', "Shared Cockpit"),
			(b'HOIST_DEPLOY_TOGGLE', "Toggles the hoist arm switch, extend or retract.", "Shared Cockpit"),
			(b'HOIST_DEPLOY_SET', '''The data value should be set to:
				0 - set hoist switch to retract the arm
				1 - set hoist switch to extend the arm''', "Shared Cockpit"),
		]

	class __Slew_System(EventHelper):
		list = [
			(b'SLEW_TOGGLE', "Toggles slew on/off", "Shared Cockpit (Pilot only),"),
			(b'SLEW_OFF', "Turns slew off", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ON', "Turns slew on", "Shared Cockpit (Pilot only),"),
			(b'SLEW_SET', "Sets slew on/off (1,0),", "Shared Cockpit (Pilot only)"),
			(b'SLEW_RESET', "Stop slew and reset pitch, bank, and heading all to zero.", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_UP_FAST', "Slew upward fast", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_UP_SLOW', "Slew upward slow", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_FREEZE', "Stop vertical slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_DN_SLOW', "Slew downward slow", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_DN_FAST', "Slew downward fast", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_PLUS', "Increase upward slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_ALTIT_MINUS', "Decrease upward slew ", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_DN_FAST', "Slew pitch downward fast", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_DN_SLOW', "Slew pitch downward slow", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_FREEZE', "Stop pitch slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_UP_SLOW', "Slew pitch up slow", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_UP_FAST', "Slew pitch upward fast", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_PLUS', "Increase pitch up slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_PITCH_MINUS', "Decrease pitch up slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_BANK_MINUS', "Increase left bank slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_AHEAD_PLUS', "Increase forward slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_BANK_PLUS', "Increase right bank slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_LEFT', "Slew to the left", "Shared Cockpit (Pilot only),"),
			(b'SLEW_FREEZE', "Stop all slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_RIGHT', "Slew to the right", "Shared Cockpit (Pilot only),"),
			(b'SLEW_HEADING_MINUS', "Increase slew heading to the left", "Shared Cockpit (Pilot only),"),
			(b'SLEW_AHEAD_MINUS', "Decrease forward slew", "Shared Cockpit (Pilot only),"),
			(b'SLEW_HEADING_PLUS', "Increase slew heading to the right", "Shared Cockpit (Pilot only),"),
			(b'AXIS_SLEW_AHEAD_SET', "Sets forward slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
			(b'AXIS_SLEW_SIDEWAYS_SET', "Sets sideways slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
			(b'AXIS_SLEW_HEADING_SET', "Sets heading slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
			(b'AXIS_SLEW_ALT_SET', "Sets vertical slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
			(b'AXIS_SLEW_BANK_SET', "Sets roll slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
			(b'AXIS_SLEW_PITCH_SET', "Sets pitch slew (+/- 16383),", "Shared Cockpit (Pilot only)"),
		]

	class __View_System(EventHelper):
		list = [
			(b'VIEW_MODE', "Selects next view", "Shared Cockpit"),
			(b'VIEW_WINDOW_TO_FRONT', "Sets active window to front", "Shared Cockpit"),
			(b'VIEW_RESET', "Resets the view to the default", "Shared Cockpit"),
			(b'VIEW_ALWAYS_PAN_UP', " ", "Shared Cockpit"),
			(b'VIEW_ALWAYS_PAN_DOWN', " ", "Shared Cockpit"),
			(b'NEXT_SUB_VIEW', " ", "Shared Cockpit"),
			(b'PREV_SUB_VIEW', " ", "Shared Cockpit"),
			(b'VIEW_TRACK_PAN_TOGGLE', " ", "Shared Cockpit"),
			(b'VIEW_PREVIOUS_TOGGLE', " ", "Shared Cockpit"),
			(b'VIEW_CAMERA_SELECT_START', " ", "Shared Cockpit"),
			(b'PANEL_HUD_NEXT', " ", "Shared Cockpit"),
			(b'PANEL_HUD_PREVIOUS', " ", "Shared Cockpit"),
			(b'ZOOM_IN', "Zooms view in", "Shared Cockpit"),
			(b'ZOOM_OUT', "Zooms view out", "Shared Cockpit"),
			(b'MAP_ZOOM_FINE_IN', "Fine zoom in map view", "Shared Cockpit"),
			(b'PAN_LEFT', "Pans view left", "Shared Cockpit"),
			(b'PAN_RIGHT', "Pans view right", "Shared Cockpit"),
			(b'MAP_ZOOM_FINE_OUT', "Fine zoom out in map view", "Shared Cockpit"),
			(b'VIEW_FORWARD', "Sets view direction forward", "Shared Cockpit"),
			(b'VIEW_FORWARD_RIGHT', "Sets view direction forward and right", "Shared Cockpit"),
			(b'VIEW_RIGHT', "Sets view direction to the right", "Shared Cockpit"),
			(b'VIEW_REAR_RIGHT', "Sets view direction to the rear and right", "Shared Cockpit"),
			(b'VIEW_REAR', "Sets view direction to the rear", "Shared Cockpit"),
			(b'VIEW_REAR_LEFT', "Sets view direction to the rear and left", "Shared Cockpit"),
			(b'VIEW_LEFT', "Sets view direction to the left", "Shared Cockpit"),
			(b'VIEW_FORWARD_LEFT', "Sets view direction forward and left", "Shared Cockpit"),
			(b'VIEW_DOWN', "Sets view direction down", "Shared Cockpit"),
			(b'ZOOM_MINUS', "Decreases zoom", "Shared Cockpit"),
			(b'ZOOM_PLUS', "Increase zoom", "Shared Cockpit"),
			(b'PAN_UP', "Pan view up", "Shared Cockpit"),
			(b'PAN_DOWN', "Pan view down", "Shared Cockpit"),
			(b'VIEW_MODE_REV', "Reverse view cycle", "Shared Cockpit"),
			(b'ZOOM_IN_FINE', "Zoom in fine", "Shared Cockpit"),
			(b'ZOOM_OUT_FINE', "Zoom out fine", "Shared Cockpit"),
			(b'CLOSE_VIEW', "Close current view", "Shared Cockpit"),
			(b'NEW_VIEW', "Open new view", "Shared Cockpit"),
			(b'NEXT_VIEW', "Select next view", "Shared Cockpit"),
			(b'PREV_VIEW', "Select previous view", "Shared Cockpit"),
			(b'PAN_LEFT_UP', "Pan view left", "Shared Cockpit"),
			(b'PAN_LEFT_DOWN', "Pan view left and down", "Shared Cockpit"),
			(b'PAN_RIGHT_UP', "Pan view right and up", "Shared Cockpit"),
			(b'PAN_RIGHT_DOWN', "Pan view right and down", "Shared Cockpit"),
			(b'PAN_TILT_LEFT', "Tilt view left", "Shared Cockpit"),
			(b'PAN_TILT_RIGHT', "Tilt view right", "Shared Cockpit"),
			(b'PAN_RESET', "Reset view to forward", "Shared Cockpit"),
			(b'VIEW_FORWARD_UP', "Sets view forward and up", "Shared Cockpit"),
			(b'VIEW_FORWARD_RIGHT_UP', "Sets view forward, right, and up", "Shared Cockpit"),
			(b'VIEW_RIGHT_UP', "Sets view right and up", "Shared Cockpit"),
			(b'VIEW_REAR_RIGHT_UP', "Sets view rear, right, and up", "Shared Cockpit"),
			(b'VIEW_REAR_UP', "Sets view rear and up", "Shared Cockpit"),
			(b'VIEW_REAR_LEFT_UP', "Sets view rear left and up", "Shared Cockpit"),
			(b'VIEW_LEFT_UP', "Sets view left and up", "Shared Cockpit"),
			(b'VIEW_FORWARD_LEFT_UP', "Sets view forward left and up", "Shared Cockpit"),
			(b'VIEW_UP', "Sets view up", "Shared Cockpit"),
			(b'VIEW_RESET', "Reset view forward", "Shared Cockpit"),
			(b'PAN_RESET_COCKPIT', "Reset panning to forward, if in cockpit view", "Shared Cockpit"),
			(b'KEY_CHASE_VIEW_NEXT', "Cycle view to next target", "Shared Cockpit"),
			(b'KEY_CHASE_VIEW_PREV', "Cycle view to previous target", "Shared Cockpit"),
			(b'CHASE_VIEW_TOGGLE', "Toggles chase view on/off", "Shared Cockpit"),
			(b'EYEPOINT_UP', "Move eyepoint up", "Shared Cockpit"),
			(b'EYEPOINT_DOWN', "Move eyepoint down", "Shared Cockpit"),
			(b'EYEPOINT_RIGHT', "Move eyepoint right", "Shared Cockpit"),
			(b'EYEPOINT_LEFT', "Move eyepoint left", "Shared Cockpit"),
			(b'EYEPOINT_FORWARD', "Move eyepoint forward", "Shared Cockpit"),
			(b'EYEPOINT_BACK', "Move eyepoint backward", "Shared Cockpit"),
			(b'EYEPOINT_RESET', "Move eyepoint to default position", "Shared Cockpit"),
			(b'NEW_MAP', "Opens new map view", "Shared Cockpit"),
			(b'VIEW_COCKPIT_FORWARD', "Switch immediately to the forward view, in 2D mode.", "Shared Cockpit"),
			(b'VIEW_VIRTUAL_COCKPIT_FORWARD', "Switch immediately to the forward view, in virtual cockpit mode.", "Shared Cockpit"),
			(b'VIEW_PANEL_ALPHA_SET', "Sets the alpha-blending value for the panel. Takes a parameter in the range 0 to 255. The alpha-blending can be changed from the keyboard using Ctrl-Shift-T, and the plus and minus keys.", "Shared Cockpit"),
			(b'VIEW_PANEL_ALPHA_SELECT', "Sets the mode to change the alpha-blending, so the keys KEY_PLUS and KEY_MINUS increment and decrement the value.", "Shared Cockpit"),
			(b'VIEW_PANEL_ALPHA_INC', "Increment alpha-blending for the panel.", "Shared Cockpit"),
			(b'VIEW_PANEL_ALPHA_DEC', "Decrement alpha-blending for the panel.", "Shared Cockpit"),
			(b'VIEW_LINKING_SET', "Links all the views from one camera together, so that panning the view will change the view of all the linked cameras.", "Shared Cockpit"),
			(b'VIEW_LINKING_TOGGLE', "Turns view linking on or off.", "Shared Cockpit"),
			(b'VIEW_CHASE_DISTANCE_ADD', "Increments the distance of the view camera from the chase object (such as in Spot Plane view, or viewing an AI controlled aircraft),.", "Shared Cockpit"),
			(b'VIEW_CHASE_DISTANCE_SUB', "Decrements the distance of the view camera from the chase object.", "Shared Cockpit"),
		]

	class __Miscellaneous_Events(EventHelper):
		list = [
			(b'PAUSE_TOGGLE', "Toggles pause on/off", "Disabled"),
			(b'PAUSE_ON', "Turns pause on", "Disabled"),
			(b'PAUSE_OFF', "Turns pause off", "Disabled"),
			(b'PAUSE_SET', "Sets pause on/off (1,0),", "Disabled"),
			(b'DEMO_STOP', "Stops demo system playback", "Shared Cockpit"),
			(b'SELECT_1', "Sets \"selected\" index (for other events), to 1", "Shared Cockpit"),
			(b'SELECT_2', "Sets \"selected\" index (for other events), to 2", "Shared Cockpit"),
			(b'SELECT_3', "Sets \"selected\" index (for other events), to 3", "Shared Cockpit"),
			(b'SELECT_4', "Sets \"selected\" index (for other events), to 4", "Shared Cockpit"),
			(b'MINUS', "Used in conjunction with \"selected\" parameters to decrease their value (e.g., radio frequency),", "Shared Cockpit"),
			(b'PLUS', "Used in conjunction with \"selected\" parameters to increase their value (e.g., radio frequency),", "Shared Cockpit"),
			(b'ZOOM_1X', "Sets zoom level to 1", "Shared Cockpit"),
			(b'SOUND_TOGGLE', "Toggles sound on/off", "Shared Cockpit"),
			(b'SIM_RATE', "Selects simulation rate (use KEY_MINUS, KEY_PLUS to change),", "Shared Cockpit"),
			(b'JOYSTICK_CALIBRATE', "Toggles joystick on/off", "Shared Cockpit"),
			(b'SITUATION_SAVE', "Saves flight situation", "Shared Cockpit"),
			(b'SITUATION_RESET', "Resets flight situation", "Shared Cockpit"),
			(b'SOUND_SET', "Sets sound on/off (1,0),", "Shared Cockpit"),
			(b'EXIT', "Quit ESP with a message", "Shared Cockpit"),
			(b'ABORT', "Quit ESP without a message", "Shared Cockpit"),
			(b'READOUTS_SLEW', "Cycle through information readouts while in slew", "Shared Cockpit"),
			(b'READOUTS_FLIGHT', "Cycle through information readouts", "Shared Cockpit"),
			(b'MINUS_SHIFT', "Used with other events", "Shared Cockpit"),
			(b'PLUS_SHIFT', "Used with other events", "Shared Cockpit"),
			(b'SIM_RATE_INCR', "Increase sim rate", "Shared Cockpit"),
			(b'SIM_RATE_DECR', "Decrease sim rate", "Shared Cockpit"),
			(b'KNEEBOARD_VIEW', "Toggles kneeboard", "Shared Cockpit"),
			(b'PANEL_1', "Toggles panel 1", "Shared Cockpit"),
			(b'PANEL_2', "Toggles panel 2", "Shared Cockpit"),
			(b'PANEL_3', "Toggles panel 3", "Shared Cockpit"),
			(b'PANEL_4', "Toggles panel 4", "Shared Cockpit"),
			(b'PANEL_5', "Toggles panel 5", "Shared Cockpit"),
			(b'PANEL_6', "Toggles panel 6", "Shared Cockpit"),
			(b'PANEL_7', "Toggles panel 7", "Shared Cockpit"),
			(b'PANEL_8', "Toggles panel 8", "Shared Cockpit"),
			(b'PANEL_9', "Toggles panel 9", "Shared Cockpit"),
			(b'SOUND_ON', "Turns sound on", "Shared Cockpit"),
			(b'SOUND_OFF', "Turns sound off", "Shared Cockpit"),
			(b'INVOKE_HELP', "Brings up Help system", "Shared Cockpit"),
			(b'TOGGLE_AIRCRAFT_LABELS', "Toggles aircraft labels", "Shared Cockpit"),
			(b'FLIGHT_MAP', "Brings up flight map", "Shared Cockpit"),
			(b'RELOAD_PANELS', "Reload panel data", "Shared Cockpit"),
			(b'PANEL_ID_TOGGLE', "Toggles indexed panel (1 to 9),", "Shared Cockpit"),
			(b'PANEL_ID_OPEN', "Opens indexed panel (1 to 9),", "Shared Cockpit"),
			(b'PANEL_ID_CLOSE', "Closes indexed panel (1 to 9),", "Shared Cockpit"),
			(b'RELOAD_USER_AIRCRAFT', "Reloads the user aircraft data (from cache if same type loaded as an AI, otherwise from disk),", "Shared Cockpit"),
			(b'SIM_RESET', "Resets aircraft state", "Shared Cockpit"),
			(b'VIRTUAL_COPILOT_TOGGLE', "Turns Flying Tips on/off", "Shared Cockpit"),
			(b'VIRTUAL_COPILOT_SET', "Sets Flying Tips on/off (1,0),", "Shared Cockpit"),
			(b'VIRTUAL_COPILOT_ACTION', "Triggers action noted in Flying Tips", "Shared Cockpit"),
			(b'REFRESH_SCENERY', "Reloads scenery", "Shared Cockpit"),
			(b'CLOCK_HOURS_DEC', "Decrements time by hours", "Shared Cockpit"),
			(b'CLOCK_HOURS_INC', "Increments time by hours", "Shared Cockpit"),
			(b'CLOCK_MINUTES_DEC', "Decrements time by minutes", "Shared Cockpit"),
			(b'CLOCK_MINUTES_INC', "Increments time by minutes", "Shared Cockpit"),
			(b'CLOCK_SECONDS_ZERO', "Zeros seconds", "Shared Cockpit"),
			(b'CLOCK_HOURS_SET', "Sets hour of day", "Shared Cockpit"),
			(b'CLOCK_MINUTES_SET', "Sets minutes of the hour", "Shared Cockpit"),
			(b'ZULU_HOURS_SET', "Sets hours, zulu time", "Shared Cockpit"),
			(b'ZULU_MINUTES_SET', "Sets minutes, in zulu time", "Shared Cockpit"),
			(b'ZULU_DAY_SET', "Sets day, in zulu time", "Shared Cockpit"),
			(b'ZULU_YEAR_SET', "Sets year, in zulu time", "Shared Cockpit"),
			(b'GAUGE_KEYSTROKE', "Enables a keystroke to be sent to a gauge that is in focus. The keystrokes can only be in the range 0 to 9, A to Z, and the four keys: plus, minus, comma and period. This is typically used to allow some keyboard entry to a complex device such as a GPS to enter such things as ICAO codes using the keyboard, rather than turning dials.", "Shared Cockpit"),
			(b'SIMUI_WINDOW_HIDESHOW', "Display the ATC window.", "Shared Cockpit"),
			(b'VIEW_WINDOW_TITLES_TOGGLE', "Turn window titles on or off.", "Shared Cockpit"),
			(b'AXIS_PAN_PITCH', "Sets the pitch of the axis. Requires an angle.", "Shared Cockpit"),
			(b'AXIS_PAN_HEADING', "Sets the heading of the axis. Requires an angle.", "Shared Cockpit"),
			(b'AXIS_PAN_TILT', "Sets the tilt of the axis. Requires an angle.", "Shared Cockpit"),
			(b'VIEW_AXIS_INDICATOR_CYCLE', "Step through the view axes.", "Shared Cockpit"),
			(b'VIEW_MAP_ORIENTATION_CYCLE', "Step through the map orientations.", "Shared Cockpit"),
			(b'TOGGLE_JETWAY', "Requests a jetway, which will only be answered if the aircraft is at a parking spot.", "Shared Cockpit"),
			(b'VIDEO_RECORD_TOGGLE', '''Turn on or off the video recording feature. This records uncompressed AVI format files to:
				My Documents\\My Videos\\''', "Shared Cockpit"),
			(b'TOGGLE_AIRPORT_NAME_DISPLAY', "Turn on or off the airport name.", "Shared Cockpit"),
			(b'CAPTURE_SCREENSHOT', '''Capture the current view as a screenshot. Which will be saved to a bmp file in:
				My Documents\\My Pictures\\''', "Shared Cockpit"),
			(b'MOUSE_LOOK_TOGGLE', "Switch Mouse Look mode on or off. Mouse Look mode enables a user to control their view using the mouse, and holding down the space bar.", "Shared Cockpit"),
			(b'YAXIS_INVERT_TOGGLE', "Switch inversion of Y axis controls on or off.", "Shared Cockpit"),
			(b'AUTORUDDER_TOGGLE', "Turn the automatic rudder control feature on or off.", "Shared Cockpit"),
		]

	class __Freezing_position(EventHelper):
		list = [
			(b'FREEZE_LATITUDE_LONGITUDE_TOGGLE', '''Turns the freezing of the lat/lon position of the aircraft (either user or AI controlled), on or off. If this key event is set, it means that the latitude and longitude of the aircraft are not being controlled by ESP, so enabling, for example, a SimConnect client to control the position of the aircraft. This can also apply to altitude and attitude. Refer to the simulation variables:
				IS LATITUDE LONGITUDE FREEZE ON,
				IS ALTITUDE FREEZE ON, and
				IS ATTITUDE FREEZE ON
				Refer also to the SimConnect_AIReleaseControl function.	''', "Shared Cockpit"),
			(b'FREEZE_LATITUDE_LONGITUDE_SET', "Freezes the lat/lon position of the aircraft.", "Shared Cockpit"),
			(b'FREEZE_ALTITUDE_TOGGLE', "Turns the freezing of the altitude of the aircraft on or off.", "Shared Cockpit"),
			(b'FREEZE_ALTITUDE_SET', "Freezes the altitude of the aircraft..", "Shared Cockpit"),
			(b'FREEZE_ATTITUDE_TOGGLE', "Turns the freezing of the attitude (pitch, bank and heading), of the aircraft on or off.", "Shared Cockpit"),
			(b'FREEZE_ATTITUDE_SET', "Freezes the attitude (pitch, bank and heading), of the aircraft.", "Shared Cockpit"),
		]

	class __Mission_Keys(EventHelper):
		list = [
			(b'POINT_OF_INTEREST_TOGGLE_POINTER', "Turn the point-of-interest indicator (often a light beam), on or off. Refer to the Missions system documentation.", "Shared Cockpit"),
			(b'POINT_OF_INTEREST_CYCLE_PREVIOUS', "Change the current point-of-interest to the previous point-of-interest.", "Shared Cockpit"),
			(b'POINT_OF_INTEREST_CYCLE_NEXT', "Change the current point-of-interest to the next point-of-interest.", "Shared Cockpit"),
		]

	class __ATC(EventHelper):
		list = [
			(b'ATC', "Activates ATC window", "Shared Cockpit"),
			(b'ATC_MENU_1', "Selects ATC option 1", "Shared Cockpit"),
			(b'ATC_MENU_2', "Selects ATC option 2", "Shared Cockpit"),
			(b'ATC_MENU_3', "Selects ATC option 3", "Shared Cockpit"),
			(b'ATC_MENU_4', "Selects ATC option 4", "Shared Cockpit"),
			(b'ATC_MENU_5', "Selects ATC option 5", "Shared Cockpit"),
			(b'ATC_MENU_6', "Selects ATC option 6", "Shared Cockpit"),
			(b'ATC_MENU_7', "Selects ATC option 7", "Shared Cockpit"),
			(b'ATC_MENU_8', "Selects ATC option 8", "Shared Cockpit"),
			(b'ATC_MENU_9', "Selects ATC option 9", "Shared Cockpit"),
			(b'ATC_MENU_0', "Selects ATC option 10", "Shared Cockpit"),
		]

	class __Multiplayer(EventHelper):
		list = [
			(b'MP_TRANSFER_CONTROL', "Toggle to the next player to track", "-"),
			(b'MP_PLAYER_CYCLE', "Cycle through the current user aircraft.", "Shared Cockpit"),
			(b'MP_PLAYER_FOLLOW', "Set the view to follow the selected user aircraft.", "Shared Cockpit"),
			(b'MP_CHAT', "Toggles chat window visible/invisible", "Shared Cockpit"),
			(b'MP_ACTIVATE_CHAT', "Activates chat window", "Shared Cockpit"),
			(b'MP_VOICE_CAPTURE_START', "Start capturing audio from the users computer and transmitting it to all other players in the multiplayer session who are turned to the same radio frequency.", "Shared Cockpit"),
			(b'MP_VOICE_CAPTURE_STOP', "Stop capturing radio audio.", "Shared Cockpit"),
			(b'MP_BROADCAST_VOICE_CAPTURE_START', "Start capturing audio from the users computer and transmitting it to all other players in the multiplayer session.", "Shared Cockpit"),
			(b'MP_BROADCAST_VOICE_CAPTURE_STOP', "Stop capturing broadcast audio.", "Shared Cockpit"),
			(b'TOGGLE_RACERESULTS_WINDOW', "Show or hide multi-player race results.", "Disabled"),
		]

	class __G1000_PFD(EventHelper):
		list = [
			(b'G1000_PFD_FLIGHTPLAN_BUTTON', "The primary flight display (PFD) should display its current flight plan.", "Shared Cockpit"),
			(b'G1000_PFD_PROCEDURE_BUTTON', "Turn to the Procedure page.", "Shared Cockpit"),
			(b'G1000_PFD_ZOOMIN_BUTTON', "Zoom in on the current map.", "Shared Cockpit"),
			(b'G1000_PFD_ZOOMOUT_BUTTON', "Zoom out on the current map.", "Shared Cockpit"),
			(b'G1000_PFD_DIRECTTO_BUTTON', "Turn to the Direct To page.", "Shared Cockpit"),
			(b'G1000_PFD_MENU_BUTTON', "If a segmented flight plan is highlighted, activates the associated menu.", "Shared Cockpit"),
			(b'G1000_PFD_CLEAR_BUTTON', "Clears the current input.", "Shared Cockpit"),
			(b'G1000_PFD_ENTER_BUTTON', "Enters the current input.", "Shared Cockpit"),
			(b'G1000_PFD_CURSOR_BUTTON', "Turns on or off a screen cursor.", "Shared Cockpit"),
			(b'G1000_PFD_GROUP_KNOB_INC', "Step up through the page groups.", "Shared Cockpit"),
			(b'G1000_PFD_GROUP_KNOB_DEC', "Step down through the page groups.", "Shared Cockpit"),
			(b'G1000_PFD_PAGE_KNOB_INC', "Step up through the individual pages.", "Shared Cockpit"),
			(b'G1000_PFD_PAGE_KNOB_DEC', "Step down through the individual pages.", "Shared Cockpit"),
		]
		# G1000_PFD_SOFTKEY1, G1000_PFD_SOFTKEY12	Initiate the action for the icon displayed in the softkey position.	Shared Cockpit

	class __G1000_MFD(EventHelper):
		list = [
			(b'G1000_MFD_FLIGHTPLAN_BUTTON', "The multifunction display (MFD) should display its current flight plan.", "Shared Cockpit"),
			(b'G1000_MFD_PROCEDURE_BUTTON', "Turn to the Procedure page.", "Shared Cockpit"),
			(b'G1000_MFD_ZOOMIN_BUTTON', "Zoom in on the current map.", "Shared Cockpit"),
			(b'G1000_MFD_ZOOMOUT_BUTTON', "Zoom out on the current map.", "Shared Cockpit"),
			(b'G1000_MFD_DIRECTTO_BUTTON', "Turn to the Direct To page.", "Shared Cockpit"),
			(b'G1000_MFD_MENU_BUTTON', "If a segmented flight plan is highlighted, activates the associated menu.", "Shared Cockpit"),
			(b'G1000_MFD_CLEAR_BUTTON', "Clears the current input.", "Shared Cockpit"),
			(b'G1000_MFD_ENTER_BUTTON', "Enters the current input.", "Shared Cockpit"),
			(b'G1000_MFD_CURSOR_BUTTON', "Turns on or off a screen cursor.", "Shared Cockpit"),
			(b'G1000_MFD_GROUP_KNOB_INC', "Step up through the page groups.", "Shared Cockpit"),
			(b'G1000_MFD_GROUP_KNOB_DEC', "Step down through the page groups.", "Shared Cockpit"),
			(b'G1000_MFD_PAGE_KNOB_INC', "Step up through the individual pages.", "Shared Cockpit"),
			(b'G1000_MFD_PAGE_KNOB_DEC', "Step down through the individual pages.", "Shared Cockpit"),
		]
		# G1000_MFD_SOFTKEY1, G1000_MFD_SOFTKEY12	Initiate the action for the icon displayed in the softkey position.	Shared Cockpit